/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissing;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.engine.archive.ImporterInformationMissingSetter;
import org.openspcoop2.protocol.information_missing.AccordoCooperazione;
import org.openspcoop2.protocol.information_missing.AccordoServizioParteComune;
import org.openspcoop2.protocol.information_missing.AccordoServizioParteSpecifica;
import org.openspcoop2.protocol.information_missing.ConditionType;
import org.openspcoop2.protocol.information_missing.ConditionsType;
import org.openspcoop2.protocol.information_missing.Input;
import org.openspcoop2.protocol.information_missing.Openspcoop2;
import org.openspcoop2.protocol.information_missing.Operazione;
import org.openspcoop2.protocol.information_missing.PortaApplicativa;
import org.openspcoop2.protocol.information_missing.ProprietaRequisitoInput;
import org.openspcoop2.protocol.information_missing.Soggetto;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.validator.IValidazioneDocumenti;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.w3c.dom.Document;

public class ImporterInformationMissingUtils {
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();
    private ImportInformationMissingCollection importInformationMissingCollection = null;
    private boolean validateDocuments = false;
    private IProtocolFactory<?> protocolFactory;
    private IValidazioneDocumenti validatoreDocumenti;
    private AbstractXMLUtils xmlUtils;
    private IRegistryReader registryReader;
    private Archive archive;
    private ProtocolFactoryManager protocolFactoryManager;

    public ImporterInformationMissingUtils(ImportInformationMissingCollection importInformationMissingCollection, IRegistryReader registryReader, boolean validateDocuments, IProtocolFactory<?> protocolFactory, String userLogin, Archive archive) throws Exception {
        this.importInformationMissingCollection = importInformationMissingCollection;
        this.validateDocuments = validateDocuments;
        this.protocolFactory = protocolFactory;
        this.validatoreDocumenti = this.protocolFactory.createValidazioneDocumenti();
        this.xmlUtils = MessageXMLUtils.DEFAULT;
        this.registryReader = registryReader;
        this.archive = archive;
        this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
    }

    public void validateAndFillInformationMissing(Openspcoop2 archiveInformationMissingWizard, boolean delete) throws Exception {
        ImportInformationMissingException infoException = null;
        Object objectId = null;
        String objectIdDescription = null;
        ImportInformationMissing importInformationMissing = null;
        boolean throwException = false;
        try {
            ImportInformationMissing miss;
            if (!throwException && archiveInformationMissingWizard.getWizard() != null && archiveInformationMissingWizard.getWizard().getRequisiti() != null && archiveInformationMissingWizard.getWizard().getRequisiti().getInput() != null && archiveInformationMissingWizard.getWizard().getRequisiti().getInput().sizeProprietaList() > 0) {
                boolean existsRequisitiInput = false;
                for (ProprietaRequisitoInput pInput : archiveInformationMissingWizard.getWizard().getRequisiti().getInput().getProprietaList()) {
                    if (delete && !pInput.isUseInDelete()) continue;
                    existsRequisitiInput = true;
                    break;
                }
                if (existsRequisitiInput) {
                    importInformationMissing = null;
                    objectId = "[[InformationMissingRequisiti]]";
                    objectIdDescription = archiveInformationMissingWizard.getWizard().getRequisiti().getInput().getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                    }
                    if (importInformationMissing == null || importInformationMissing.getRequisitiInput() == null || importInformationMissing.getRequisitiInput().isEmpty()) {
                        infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                        infoException.setMissingRequisitiInfoInput(true);
                        infoException.setMissingRequisitiInfoInputObject(archiveInformationMissingWizard.getWizard().getRequisiti().getInput());
                        throwException = true;
                    }
                    if (throwException) {
                        throw infoException;
                    }
                }
            }
            HashMap<String, String> requisitiInput = null;
            if (this.importInformationMissingCollection != null && this.importInformationMissingCollection.exists("[[InformationMissingRequisiti]]") && (miss = this.importInformationMissingCollection.get("[[InformationMissingRequisiti]]")) != null) {
                requisitiInput = miss.getRequisitiInput();
            }
            int indexInputPage = 0;
            block40: for (Operazione archiveInformationMissing : archiveInformationMissingWizard.getOperazioneList()) {
                org.openspcoop2.protocol.information_missing.PortaDelegata portaMissingInfo;
                AccordoServizioParteComune asMissingInfo;
                boolean updateInfo;
                int i;
                ++indexInputPage;
                if (throwException) break;
                ImporterInformationMissingSetter.setInformationMissingReferenteAPI(this.archive, this.registryReader);
                if (!throwException && archiveInformationMissing.sizeSoggettoList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeSoggettoList(); ++i) {
                        Soggetto soggettoMissingInfo = archiveInformationMissing.getSoggetto(i);
                        if (soggettoMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(soggettoMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingSoggetto-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = soggettoMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (soggettoMissingInfo.getTipo()) {
                            case RIFERIMENTO: {
                                if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                                    if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                                        boolean found = false;
                                        if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                            for (int j = 0; j < this.archive.getSoggetti().size(); ++j) {
                                                ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(j);
                                                if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                                found = true;
                                                break;
                                            }
                                        }
                                        if (!found) {
                                            throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                                        }
                                    }
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoSoggetto(true);
                                if (soggettoMissingInfo.getTipoPdd() != null) {
                                    infoException.setMissingInfoSoggetto_tipoPdD(soggettoMissingInfo.getTipoPdd().getValue());
                                }
                                throwException = true;
                                break;
                            }
                            case CONNETTORE: {
                                if (delete) break;
                                if (importInformationMissing != null && importInformationMissing.getInvocazioneServizio() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoInvocazioneServizio(true);
                                if (soggettoMissingInfo.getTipoPdd() != null) {
                                    infoException.setMissingInfoSoggetto_tipoPdD(soggettoMissingInfo.getTipoPdd().getValue());
                                }
                                throwException = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(soggettoMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(soggettoMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(soggettoMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(soggettoMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        IDSoggetto importInformationMissing_soggetto = null;
                        Connettore importInformationMissing_connettore = null;
                        if (importInformationMissing != null) {
                            importInformationMissing_soggetto = importInformationMissing.getSoggetto();
                            importInformationMissing_connettore = importInformationMissing.getConnettore();
                        }
                        ImporterInformationMissingSetter.setInformationMissingSoggetto(this.archive, soggettoMissingInfo, importInformationMissing_soggetto, importInformationMissing_connettore);
                    }
                }
                if (!throwException && archiveInformationMissing.sizeInputList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeInputList(); ++i) {
                        Input inputMissingInfo = archiveInformationMissing.getInput(i);
                        if (delete) {
                            boolean foundPropertyUseInDelete = false;
                            for (int j = 0; j < inputMissingInfo.sizeProprietaList(); ++j) {
                                if (!inputMissingInfo.getProprieta(j).isUseInDelete()) continue;
                                foundPropertyUseInDelete = true;
                                break;
                            }
                            if (!foundPropertyUseInDelete) continue;
                        }
                        if (inputMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(inputMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingInput-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = inputMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        if (importInformationMissing == null || importInformationMissing.getInputPlaceholder() == null) {
                            infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                            infoException.setMissingInfoInput(true);
                            infoException.setMissingInfoInputObject(inputMissingInfo);
                            throwException = true;
                        }
                        if (throwException) break;
                    }
                }
                if (!throwException && archiveInformationMissing.sizeServizioApplicativoList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeServizioApplicativoList(); ++i) {
                        org.openspcoop2.protocol.information_missing.ServizioApplicativo saMissingInfo = archiveInformationMissing.getServizioApplicativo(i);
                        if (saMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(saMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingServizioApplicativo-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = saMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (saMissingInfo.getTipo()) {
                            case RIFERIMENTO: {
                                break;
                            }
                            case CONNETTORE: {
                                if (delete) break;
                                if (importInformationMissing != null && importInformationMissing.getInvocazioneServizio() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoInvocazioneServizio(true);
                                throwException = true;
                                break;
                            }
                            case CREDENZIALI_ACCESSO_PDD: {
                                if (delete) break;
                                if (importInformationMissing != null && importInformationMissing.getCredenziali() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoCredenziali(true);
                                throwException = true;
                                break;
                            }
                            case ALLINEA_CREDENZIALI_PD: {
                                if (delete) break;
                                updateInfo = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(saMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(saMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(saMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(saMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        InvocazioneServizio importInformationMissing_invocazioneServizio = null;
                        Credenziali importInformationMissing_credenziali = null;
                        if (importInformationMissing != null) {
                            importInformationMissing_invocazioneServizio = importInformationMissing.getInvocazioneServizio();
                            importInformationMissing_credenziali = importInformationMissing.getCredenziali();
                        }
                        ImporterInformationMissingSetter.setInformationMissingServizioApplicativo(this.archive, saMissingInfo, importInformationMissing_invocazioneServizio, importInformationMissing_credenziali);
                    }
                }
                if (!throwException && archiveInformationMissing.sizeAccordoCooperazioneList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeAccordoCooperazioneList(); ++i) {
                        AccordoCooperazione acMissingInfo = archiveInformationMissing.getAccordoCooperazione(i);
                        if (acMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(acMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingAccordoCooperazione-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = acMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (acMissingInfo.getTipo()) {
                            case RIFERIMENTO: {
                                if (importInformationMissing != null && importInformationMissing.getIdAccordoCooperazione() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoAccordoCooperazione(true);
                                throwException = true;
                                break;
                            }
                            case STATO_ARCHIVIO: {
                                if (delete) break;
                                updateInfo = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(acMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(acMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(acMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(acMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        IDAccordoCooperazione importInformationMissing_idAccordoCooperazione = null;
                        if (importInformationMissing != null) {
                            importInformationMissing_idAccordoCooperazione = importInformationMissing.getIdAccordoCooperazione();
                        }
                        ImporterInformationMissingSetter.setInformationMissingAccordoCooperazione(this.archive, acMissingInfo, importInformationMissing_idAccordoCooperazione);
                    }
                }
                if (!throwException && archiveInformationMissing.sizeAccordoServizioParteComuneList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeAccordoServizioParteComuneList(); ++i) {
                        asMissingInfo = archiveInformationMissing.getAccordoServizioParteComune(i);
                        if (asMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(asMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingAccordoServizioParteComune-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = asMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (asMissingInfo.getTipo()) {
                            case RIFERIMENTO: {
                                if (importInformationMissing != null && importInformationMissing.getIdAccordoServizioParteComune() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoAccordoServizioParteComune(true);
                                throwException = true;
                                break;
                            }
                            case STATO_ARCHIVIO: {
                                if (delete) break;
                                updateInfo = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(asMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(asMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(asMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(asMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        IDAccordo importInformationMissing_idAccordo = null;
                        if (importInformationMissing != null) {
                            importInformationMissing_idAccordo = importInformationMissing.getIdAccordoServizioParteComune();
                        }
                        ImporterInformationMissingSetter.setInformationMissingAccordoServizioParteComune(this.archive, asMissingInfo, importInformationMissing_idAccordo);
                    }
                }
                if (!throwException && archiveInformationMissing.sizeAccordoServizioParteSpecificaList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeAccordoServizioParteSpecificaList(); ++i) {
                        AccordoServizioParteSpecifica aspsMissingInfo = archiveInformationMissing.getAccordoServizioParteSpecifica(i);
                        if (aspsMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(aspsMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingAPS-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = aspsMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (aspsMissingInfo.getTipo()) {
                            case CONNETTORE: {
                                if (delete) break;
                                if (importInformationMissing != null && importInformationMissing.getConnettore() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoConnettore(true);
                                throwException = true;
                                break;
                            }
                            case STATO_ARCHIVIO: {
                                if (delete) break;
                                updateInfo = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(aspsMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(aspsMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(aspsMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(aspsMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        Connettore importInformationMissing_connettore = null;
                        if (importInformationMissing != null) {
                            importInformationMissing_connettore = importInformationMissing.getConnettore();
                        }
                        ImporterInformationMissingSetter.setInformationMissingAccordoServizioParteSpecifica(this.archive, aspsMissingInfo, importInformationMissing_connettore);
                    }
                }
                if (!throwException && archiveInformationMissing.sizeAccordoServizioCompostoList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeAccordoServizioCompostoList(); ++i) {
                        asMissingInfo = archiveInformationMissing.getAccordoServizioComposto(i);
                        if (asMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(asMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingAccordoServizioComposto-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = asMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (asMissingInfo.getTipo()) {
                            case RIFERIMENTO: {
                                if (importInformationMissing != null && importInformationMissing.getIdAccordoServizioParteComune() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoAccordoServizioParteComune(true);
                                throwException = true;
                                break;
                            }
                            case STATO_ARCHIVIO: {
                                if (delete) break;
                                updateInfo = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(asMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(asMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(asMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(asMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        IDAccordo importInformationMissing_idAccordo = null;
                        if (importInformationMissing != null) {
                            importInformationMissing_idAccordo = importInformationMissing.getIdAccordoServizioParteComune();
                        }
                        ImporterInformationMissingSetter.setInformationMissingAccordoServizioComposto(this.archive, asMissingInfo, importInformationMissing_idAccordo);
                    }
                }
                if (!throwException && archiveInformationMissing.sizeFruitoreList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizeFruitoreList(); ++i) {
                        org.openspcoop2.protocol.information_missing.Fruitore fruitoreMissingInfo = archiveInformationMissing.getFruitore(i);
                        if (fruitoreMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(fruitoreMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingFruitore-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = fruitoreMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (fruitoreMissingInfo.getTipo()) {
                            case CONNETTORE: {
                                if (delete) break;
                                if (importInformationMissing != null && importInformationMissing.getConnettore() != null) {
                                    updateInfo = true;
                                    break;
                                }
                                infoException = new ImportInformationMissingException((String)objectId, objectIdDescription);
                                infoException.setMissingInfoConnettore(true);
                                throwException = true;
                                break;
                            }
                            case STATO_ARCHIVIO: {
                                if (delete) break;
                                updateInfo = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(fruitoreMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(fruitoreMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(fruitoreMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(fruitoreMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        Connettore importInformationMissing_connettore = null;
                        if (importInformationMissing != null) {
                            importInformationMissing_connettore = importInformationMissing.getConnettore();
                        }
                        ImporterInformationMissingSetter.setInformationMissingFruitore(this.archive, fruitoreMissingInfo, importInformationMissing_connettore);
                    }
                }
                if (!throwException && archiveInformationMissing.sizePortaDelegataList() > 0) {
                    for (i = 0; i < archiveInformationMissing.sizePortaDelegataList(); ++i) {
                        portaMissingInfo = archiveInformationMissing.getPortaDelegata(i);
                        if (portaMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(portaMissingInfo.getConditions(), requisitiInput)) continue;
                        importInformationMissing = null;
                        objectId = "[[InformationMissingPortaDelegata-" + indexInputPage + "-" + i + "]]";
                        objectIdDescription = portaMissingInfo.getDescrizione();
                        if (this.importInformationMissingCollection != null) {
                            importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                        }
                        updateInfo = false;
                        switch (portaMissingInfo.getTipo()) {
                            case STATO: {
                                if (delete) break;
                                updateInfo = true;
                            }
                        }
                        if (infoException != null) {
                            infoException.setMissingInfoProtocollo(portaMissingInfo.getProtocollo());
                            infoException.setMissingInfoHeader(portaMissingInfo.getHeader());
                            infoException.setMissingInfoFooter(portaMissingInfo.getFooter());
                            infoException.setMissingInfoDefault(portaMissingInfo.getDefault());
                        }
                        if (throwException || !updateInfo) break;
                        ImporterInformationMissingSetter.setInformationMissingPortaDelegata(this.archive, portaMissingInfo);
                    }
                }
                if (throwException || archiveInformationMissing.sizePortaApplicativaList() <= 0) continue;
                for (i = 0; i < archiveInformationMissing.sizePortaApplicativaList(); ++i) {
                    portaMissingInfo = archiveInformationMissing.getPortaApplicativa(i);
                    if (portaMissingInfo.getConditions() != null && !ImporterInformationMissingUtils.checkConditions(portaMissingInfo.getConditions(), requisitiInput)) continue;
                    importInformationMissing = null;
                    objectId = "[[InformationMissingPortaApplicativa-" + indexInputPage + "-" + i + "]]";
                    objectIdDescription = portaMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get((String)objectId);
                    }
                    updateInfo = false;
                    switch (portaMissingInfo.getTipo()) {
                        case STATO: {
                            if (delete) break;
                            updateInfo = true;
                        }
                    }
                    if (infoException != null) {
                        infoException.setMissingInfoProtocollo(portaMissingInfo.getProtocollo());
                        infoException.setMissingInfoHeader(portaMissingInfo.getHeader());
                        infoException.setMissingInfoFooter(portaMissingInfo.getFooter());
                        infoException.setMissingInfoDefault(portaMissingInfo.getDefault());
                    }
                    if (throwException || !updateInfo) continue block40;
                    ImporterInformationMissingSetter.setInformationMissingPortaApplicativa(this.archive, (PortaApplicativa)portaMissingInfo);
                }
            }
            if (throwException) {
                throw infoException;
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public static boolean checkConditions(ConditionsType conditions, HashMap<String, String> map) {
        if (conditions == null) {
            return false;
        }
        boolean result = ImporterInformationMissingUtils._checkConditions(conditions, map);
        if (conditions != null && conditions.isNot()) {
            return !result;
        }
        return result;
    }

    private static boolean _checkConditions(ConditionsType conditions, HashMap<String, String> map) {
        boolean and;
        boolean bl = and = conditions != null && conditions.isAnd();
        if (conditions != null && conditions.sizeProprietaList() > 0) {
            for (ConditionType cType : conditions.getProprietaList()) {
                if ((map == null || map.isEmpty() || !map.containsKey(cType.getNome())) && !cType.isNot() && and) {
                    return false;
                }
                String value = null;
                if (map != null) {
                    value = map.get(cType.getNome());
                }
                if (value == null) {
                    if (!and) continue;
                    return false;
                }
                if (cType.isNot()) {
                    if (cType.getValore().equals(value)) {
                        if (!and) continue;
                        return false;
                    }
                    if (and) continue;
                    return true;
                }
                if (!cType.getValore().equals(value)) {
                    if (!and) continue;
                    return false;
                }
                if (and) continue;
                return true;
            }
        }
        return and;
    }

    public void validateAndFillServizioApplicativo(ArchiveServizioApplicativo archiveServizioApplicativo) throws Exception {
        ServizioApplicativo sa = archiveServizioApplicativo.getServizioApplicativo();
        Object uri = sa.getNome();
        if (sa.getTipoSoggettoProprietario() != null && sa.getNomeSoggettoProprietario() != null) {
            uri = (String)uri + ":" + sa.getTipoSoggettoProprietario() + "/" + sa.getNomeSoggettoProprietario();
        }
        String objectId = "[[SA]]" + (String)uri;
        String objectIdDescription = "Servizio Applicativo [" + (String)uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            String tipoSoggettoProprietario = sa.getTipoSoggettoProprietario();
            String nomeSoggettoProprietario = sa.getNomeSoggettoProprietario();
            if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        sa.setTipoSoggettoProprietario(importInformationMissing.getSoggetto().getTipo());
                        sa.setNomeSoggettoProprietario(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillPortaDelegata(ArchivePortaDelegata archivePortaDelegata) throws Exception {
        PortaDelegata pd = archivePortaDelegata.getPortaDelegata();
        Object uri = pd.getNome();
        if (pd.getTipoSoggettoProprietario() != null && pd.getNomeSoggettoProprietario() != null) {
            uri = (String)uri + ":" + pd.getTipoSoggettoProprietario() + "/" + pd.getNomeSoggettoProprietario();
        }
        String objectId = "[[PD]]" + (String)uri;
        String objectIdDescription = "PortaDelegata [" + (String)uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            String tipoSoggettoProprietario = pd.getTipoSoggettoProprietario();
            String nomeSoggettoProprietario = pd.getNomeSoggettoProprietario();
            if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        pd.setTipoSoggettoProprietario(importInformationMissing.getSoggetto().getTipo());
                        pd.setNomeSoggettoProprietario(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillPortaApplicativa(ArchivePortaApplicativa archivePortaApplicativa) throws Exception {
        org.openspcoop2.core.config.PortaApplicativa pa = archivePortaApplicativa.getPortaApplicativa();
        Object uri = pa.getNome();
        if (pa.getTipoSoggettoProprietario() != null && pa.getNomeSoggettoProprietario() != null) {
            uri = (String)uri + ":" + pa.getTipoSoggettoProprietario() + "/" + pa.getNomeSoggettoProprietario();
        }
        String objectId = "[[PD]]" + (String)uri;
        String objectIdDescription = "PortaApplicativa [" + (String)uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            String tipoSoggettoProprietario = pa.getTipoSoggettoProprietario();
            String nomeSoggettoProprietario = pa.getNomeSoggettoProprietario();
            if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        pa.setTipoSoggettoProprietario(importInformationMissing.getSoggetto().getTipo());
                        pa.setNomeSoggettoProprietario(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillAccordoCooperazione(ArchiveAccordoCooperazione archiveAccordoCooperazione) throws Exception {
        org.openspcoop2.core.registry.AccordoCooperazione ac = archiveAccordoCooperazione.getAccordoCooperazione();
        String uri = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
        String objectId = "[[AC]]" + uri;
        String objectIdDescription = "Accordo di Cooperazione [" + uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            ValidazioneResult result;
            IdSoggetto acSoggettoReferente = ac.getSoggettoReferente();
            Integer versione = ac.getVersione();
            if (acSoggettoReferente == null || acSoggettoReferente.getTipo() == null || acSoggettoReferente.getNome() == null || versione == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (acSoggettoReferente == null || acSoggettoReferente.getTipo() == null || acSoggettoReferente.getNome() == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        IdSoggetto acSoggettoReferenteNew = new IdSoggetto();
                        acSoggettoReferenteNew.setTipo(importInformationMissing.getSoggetto().getTipo());
                        acSoggettoReferenteNew.setNome(importInformationMissing.getSoggetto().getNome());
                        ac.setSoggettoReferente(acSoggettoReferenteNew);
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (versione == null) {
                    if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                        ac.setVersione(importInformationMissing.getVersione());
                    } else {
                        infoException.setMissingInfoVersione(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
            if (this.validateDocuments && !(result = this.validatoreDocumenti.validaDocumenti(ac)).isEsito()) {
                if (result.getException() != null) {
                    throw new Exception(result.getMessaggioErrore(), result.getException());
                }
                throw new Exception(result.getMessaggioErrore());
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillAccordoServizioParteComune(ArchiveAccordoServizioParteComune archiveAspc, boolean checkCorrelazioneAsincrona) throws Exception {
        this.validateAndFillAccordoServizioEngine(archiveAspc.getAccordoServizioParteComune(), checkCorrelazioneAsincrona);
    }

    public void validateAndFillAccordoServizioParteComune(ArchiveAccordoServizioComposto archiveAsc, boolean checkCorrelazioneAsincrona) throws Exception {
        this.validateAndFillAccordoServizioEngine(archiveAsc.getAccordoServizioParteComune(), checkCorrelazioneAsincrona);
    }

    private void validateAndFillAccordoServizioEngine(org.openspcoop2.core.registry.AccordoServizioParteComune aspc, boolean checkCorrelazioneAsincrona) throws Exception {
        String uri = this.idAccordoFactory.getUriFromAccordo(aspc);
        String tipoAccordo = "[[ASPC]]";
        if (aspc.getServizioComposto() != null) {
            tipoAccordo = "[[ASC]]";
        }
        String objectId = tipoAccordo + uri;
        String objectIdDescription = "Accordo di Servizio Parte Comune [" + uri + "]";
        if (aspc.getServizioComposto() != null) {
            objectIdDescription = "Accordo di Servizio Composto [" + uri + "]";
            if (aspc.getServizioComposto().getAccordoCooperazione() != null && !"".equals(aspc.getServizioComposto().getAccordoCooperazione().trim())) {
                objectIdDescription = objectIdDescription + " (rifAccordo: " + aspc.getServizioComposto().getAccordoCooperazione() + ")";
            }
        }
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            IdSoggetto aspcSoggettoReferente = aspc.getSoggettoReferente();
            Integer versione = aspc.getVersione();
            boolean informazioniProfiloServiziPresenti = this.isInformazioniProfiloServiziPresenti(aspc, checkCorrelazioneAsincrona);
            String uriAccordoCooperazione = null;
            if (aspc.getServizioComposto() != null && aspc.getServizioComposto().getAccordoCooperazione() != null && !"".equals(aspc.getServizioComposto().getAccordoCooperazione().trim())) {
                uriAccordoCooperazione = aspc.getServizioComposto().getAccordoCooperazione();
            }
            if (aspcSoggettoReferente == null || aspcSoggettoReferente.getTipo() == null || aspcSoggettoReferente.getNome() == null || versione == null || !informazioniProfiloServiziPresenti || aspc.getServizioComposto() != null && uriAccordoCooperazione == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (aspcSoggettoReferente == null || aspcSoggettoReferente.getTipo() == null || aspcSoggettoReferente.getNome() == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        IdSoggetto aspcSoggettoReferenteNew = new IdSoggetto();
                        aspcSoggettoReferenteNew.setTipo(importInformationMissing.getSoggetto().getTipo());
                        aspcSoggettoReferenteNew.setNome(importInformationMissing.getSoggetto().getNome());
                        aspc.setSoggettoReferente(aspcSoggettoReferenteNew);
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (versione == null) {
                    if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                        aspc.setVersione(importInformationMissing.getVersione());
                    } else {
                        infoException.setMissingInfoVersione(true);
                        throwException = true;
                    }
                }
                if (!informazioniProfiloServiziPresenti) {
                    if (importInformationMissing != null && importInformationMissing.sizePortTypeList() > 0) {
                        for (int i = 0; i < importInformationMissing.sizePortTypeList(); ++i) {
                            aspc.addPortType(importInformationMissing.getPortType(i));
                        }
                    }
                    if (!(informazioniProfiloServiziPresenti = this.isInformazioniProfiloServiziPresenti(aspc, checkCorrelazioneAsincrona))) {
                        infoException.setMissingInfoProfiliServizi(true);
                        while (aspc.sizePortTypeList() > 0) {
                            aspc.removePortType(0);
                        }
                        infoException.setObject(aspc);
                        infoException.setClassObject(aspc.getClass());
                        throwException = true;
                    }
                }
                if (aspc.getServizioComposto() != null && uriAccordoCooperazione == null) {
                    if (importInformationMissing != null && importInformationMissing.getIdAccordoCooperazione() != null) {
                        aspc.getServizioComposto().setAccordoCooperazione(this.idAccordoCooperazioneFactory.getUriFromIDAccordo(importInformationMissing.getIdAccordoCooperazione()));
                    } else {
                        infoException.setMissingInfoAccordoCooperazione(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
            if (this.validateDocuments) {
                ValidazioneResult result = this.validatoreDocumenti.validaSpecificaInterfaccia(aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
                result = this.validatoreDocumenti.validaSpecificaConversazione(aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
                result = this.validatoreDocumenti.validaDocumenti(aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    private boolean isInformazioniProfiloServiziPresenti(org.openspcoop2.core.registry.AccordoServizioParteComune aspc, boolean checkCorrelazioneAsincrona) {
        if (aspc == null) {
            return false;
        }
        if (aspc.getProfiloCollaborazione() == null && aspc.sizePortTypeList() <= 0) {
            return false;
        }
        if (aspc.sizePortTypeList() > 0) {
            for (int i = 0; i < aspc.sizePortTypeList(); ++i) {
                PortType pt = aspc.getPortType(i);
                if (pt == null) {
                    return false;
                }
                if ("default".equals(pt.getProfiloPT()) ? aspc.getProfiloCollaborazione() == null : pt.getProfiloCollaborazione() == null && aspc.getProfiloCollaborazione() == null) {
                    return false;
                }
                for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                    Operation op = pt.getAzione(j);
                    if (!("default".equals(op.getProfAzione()) ? aspc.getProfiloCollaborazione() == null && pt.getProfiloCollaborazione() == null : op.getProfiloCollaborazione() == null && pt.getProfiloCollaborazione() == null && aspc.getProfiloCollaborazione() == null)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void validateAndFillAccordoServizioParteSpecifica(ArchiveAccordoServizioParteSpecifica archiveAsps, Map<String, IDSoggetto> mapIdSoggettoDefault, Map<String, Boolean> mapAPIconReferente) throws Exception {
        org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps = archiveAsps.getAccordoServizioParteSpecifica();
        Object uri = null;
        uri = asps.getTipoSoggettoErogatore() == null || asps.getNomeSoggettoErogatore() == null || asps.getVersione() == null ? asps.getTipo() + "/" + asps.getNome() : this.idServizioFactory.getUriFromAccordo(asps);
        String objectId = "[[ASPS]]" + (String)uri;
        String objectIdDescription = "Accordo di Servizio Parte Specifica [" + (String)uri + "]";
        if (asps.getAccordoServizioParteComune() != null && !"".equals(asps.getAccordoServizioParteComune().trim())) {
            objectIdDescription = objectIdDescription + " (rifParteComune: " + asps.getAccordoServizioParteComune() + ")";
        }
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            org.openspcoop2.core.registry.AccordoServizioParteComune aspc;
            block39: {
                aspc = null;
                if (asps.getAccordoServizioParteComune() != null && !"".equals(asps.getAccordoServizioParteComune().trim())) {
                    String uriAPC = asps.getAccordoServizioParteComune();
                    try {
                        if (uriAPC != null) {
                            uriAPC = ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(this.registryReader, uriAPC, asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
                            uriAPC = ImporterInformationMissingSetter.replaceSoggettoErogatore(uriAPC, asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
                        }
                        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(uriAPC);
                        IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(asps.getTipoSoggettoErogatore());
                        boolean APIconReferente = mapAPIconReferente.get(protocolFactory.getProtocol());
                        if (!APIconReferente) {
                            IDSoggetto soggettoDefaultProtocollo = mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                            if (!idAccordo.getSoggettoReferente().equals((Object)soggettoDefaultProtocollo)) {
                                idAccordo.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                                idAccordo.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                            }
                        }
                        if ((aspc = this.registryReader.getAccordoServizioParteComune(idAccordo)) == null) {
                            throw new Exception("getAccordoServizioParteComune return null");
                        }
                    }
                    catch (Exception notFound) {
                        IDAccordo idAccordo;
                        ArchiveAccordoServizioParteComune archiveAccordo;
                        int i;
                        boolean found = false;
                        if (this.archive.getAccordiServizioParteComune() != null && this.archive.getAccordiServizioParteComune().size() > 0) {
                            for (i = 0; i < this.archive.getAccordiServizioParteComune().size(); ++i) {
                                archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioParteComune().get(i);
                                idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                                if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(uriAPC))) continue;
                                found = true;
                                aspc = archiveAccordo.getAccordoServizioParteComune();
                                break;
                            }
                        }
                        if (!found && this.archive.getAccordiServizioComposto() != null && this.archive.getAccordiServizioComposto().size() > 0) {
                            for (i = 0; i < this.archive.getAccordiServizioComposto().size(); ++i) {
                                archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioComposto().get(i);
                                idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                                if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(uriAPC))) continue;
                                found = true;
                                aspc = archiveAccordo.getAccordoServizioParteComune();
                                break;
                            }
                        }
                        if (found) break block39;
                        throw new ProtocolException("Accordo di Servizio Parte Comune [" + uriAPC + "], riferito dall'archivio, non esiste", (Throwable)notFound);
                    }
                }
            }
            String tipoSoggettoErogatore = asps.getTipoSoggettoErogatore();
            String nomeSoggettoErogatore = asps.getNomeSoggettoErogatore();
            Integer versione = asps.getVersione();
            if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null || versione == null || aspc == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        asps.setTipoSoggettoErogatore(importInformationMissing.getSoggetto().getTipo());
                        asps.setNomeSoggettoErogatore(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (versione == null) {
                    if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                        asps.setVersione(importInformationMissing.getVersione());
                    } else {
                        infoException.setMissingInfoVersione(true);
                        throwException = true;
                    }
                }
                if (aspc == null) {
                    if (importInformationMissing != null && importInformationMissing.getIdAccordoServizioParteComune() != null) {
                        asps.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromIDAccordo(importInformationMissing.getIdAccordoServizioParteComune()));
                    } else {
                        infoException.setMissingInfoAccordoServizioParteComune(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
            if (aspc != null) {
                List<String> serviziIdentificatiNellaParteComune = this.letturaServiziDefinitiParteComune(asps, aspc);
                if (this.validateDocuments) {
                    ValidazioneResult result = this.validatoreDocumenti.validaSpecificaInterfaccia(asps, aspc);
                    if (!result.isEsito()) {
                        if (result.getException() != null) {
                            throw new Exception(result.getMessaggioErrore(), result.getException());
                        }
                        throw new Exception(result.getMessaggioErrore());
                    }
                    result = this.validatoreDocumenti.validaDocumenti(asps);
                    if (!result.isEsito()) {
                        if (result.getException() != null) {
                            throw new Exception(result.getMessaggioErrore(), result.getException());
                        }
                        throw new Exception(result.getMessaggioErrore());
                    }
                    this.verificaMappingPortTypeBindingInRiferimentoParteComune(asps, aspc, serviziIdentificatiNellaParteComune);
                }
                if (importInformationMissing != null && importInformationMissing.getPortTypeImplemented() != null) {
                    asps.setPortType(importInformationMissing.getPortTypeImplemented());
                }
                if (asps.getPortType() != null && !serviziIdentificatiNellaParteComune.contains(asps.getPortType())) {
                    ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                    infoException.setMismatchPortTypeRifServiziParteComune(true, asps.getPortType(), serviziIdentificatiNellaParteComune);
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    private List<String> letturaServiziDefinitiParteComune(Fruitore fruitore, org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc) {
        Boolean correlato = null;
        if (fruitore.getByteWsdlImplementativoErogatore() != null) {
            correlato = false;
        } else if (fruitore.getByteWsdlImplementativoFruitore() != null) {
            correlato = true;
        } else if (asps.getByteWsdlImplementativoErogatore() != null) {
            correlato = false;
        } else if (asps.getByteWsdlImplementativoFruitore() != null) {
            correlato = true;
        }
        if (correlato == null) {
            TipologiaServizio tipologiaServizio = TipologiaServizio.NORMALE;
            if (asps != null) {
                tipologiaServizio = asps.getTipologiaServizio();
            }
            correlato = TipologiaServizio.CORRELATO.equals((Object)tipologiaServizio);
        }
        return this.letturaServiziDefinitiParteComune(correlato, aspc);
    }

    private List<String> letturaServiziDefinitiParteComune(org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc) {
        Boolean correlato = null;
        if (asps != null && asps.getByteWsdlImplementativoErogatore() != null) {
            correlato = false;
        } else if (asps != null && asps.getByteWsdlImplementativoFruitore() != null) {
            correlato = true;
        }
        if (correlato == null) {
            TipologiaServizio tipologiaServizio = TipologiaServizio.NORMALE;
            if (asps != null) {
                tipologiaServizio = asps.getTipologiaServizio();
            }
            correlato = TipologiaServizio.CORRELATO.equals((Object)tipologiaServizio);
        }
        return this.letturaServiziDefinitiParteComune(correlato, aspc);
    }

    private List<String> letturaServiziDefinitiParteComune(boolean correlato, org.openspcoop2.core.registry.AccordoServizioParteComune aspc) {
        ArrayList<String> serviziIdentificatiNellaParteComune = new ArrayList<String>();
        for (int i = 0; i < aspc.sizePortTypeList(); ++i) {
            PortType pt = aspc.getPortType(i);
            boolean servizioCorrelato = false;
            for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                Operation op = pt.getAzione(j);
                if (op.getCorrelataServizio() == null || pt.getNome().equals(op.getCorrelataServizio()) || op.getCorrelata() == null) continue;
                servizioCorrelato = true;
                break;
            }
            if (correlato) {
                if (!servizioCorrelato) continue;
                serviziIdentificatiNellaParteComune.add(aspc.getPortType(i).getNome());
                continue;
            }
            if (servizioCorrelato) continue;
            serviziIdentificatiNellaParteComune.add(aspc.getPortType(i).getNome());
        }
        return serviziIdentificatiNellaParteComune;
    }

    private void verificaMappingPortTypeBindingInRiferimentoParteComune(Fruitore fruitore, org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc, List<String> serviziIdentificatiNellaParteComune) throws Exception {
        byte[] wsdlImplementativo = null;
        String tipoWSDL = "WSDL Implementativo";
        if (fruitore.getByteWsdlImplementativoErogatore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoErogatore();
            tipoWSDL = "WSDL Implementativo Erogatore";
        } else if (fruitore.getByteWsdlImplementativoFruitore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoFruitore();
            tipoWSDL = "WSDL Implementativo Fruitore";
        } else if (asps.getByteWsdlImplementativoErogatore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoErogatore();
            tipoWSDL = "WSDL Implementativo Erogatore";
        } else if (asps.getByteWsdlImplementativoFruitore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoFruitore();
            tipoWSDL = "WSDL Implementativo Fruitore";
        }
        if (wsdlImplementativo != null) {
            this.verificaMappingPortTypeBindingInRiferimentoParteComune(wsdlImplementativo, tipoWSDL, aspc, serviziIdentificatiNellaParteComune);
        }
    }

    private void verificaMappingPortTypeBindingInRiferimentoParteComune(org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc, List<String> serviziIdentificatiNellaParteComune) throws Exception {
        byte[] wsdlImplementativo = null;
        String tipoWSDL = "WSDL Implementativo";
        if (asps.getByteWsdlImplementativoErogatore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoErogatore();
            tipoWSDL = "WSDL Implementativo Erogatore";
        } else if (asps.getByteWsdlImplementativoFruitore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoFruitore();
            tipoWSDL = "WSDL Implementativo Fruitore";
        }
        if (wsdlImplementativo != null) {
            this.verificaMappingPortTypeBindingInRiferimentoParteComune(wsdlImplementativo, tipoWSDL, aspc, serviziIdentificatiNellaParteComune);
        }
    }

    private void verificaMappingPortTypeBindingInRiferimentoParteComune(byte[] wsdlImplementativo, String tipoWSDL, org.openspcoop2.core.registry.AccordoServizioParteComune aspc, List<String> serviziIdentificatiNellaParteComune) throws Exception {
        ArrayList<String> portTypesImplemented = new ArrayList<String>();
        try {
            Document d = this.xmlUtils.newDocument(wsdlImplementativo);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
            Map mapBindingToPortTypeImplemented = wsdl.getMapPortTypesImplementedBinding();
            for (QName binding : mapBindingToPortTypeImplemented.keySet()) {
                QName portType = (QName)mapBindingToPortTypeImplemented.get(binding);
                String portTypeName = portType.getLocalPart();
                if (portTypesImplemented.contains(portTypeName)) continue;
                portTypesImplemented.add(portTypeName);
            }
        }
        catch (Exception e) {
            String msgErrore = "La verifica dei port-types, implementati dai binding del " + tipoWSDL + ", rispetto ai servizi definiti nell'accordo di servizio parte comune, ha riscontrato un errore: " + e.getMessage();
            this.protocolFactory.getLogger().error(msgErrore, (Throwable)e);
            throw new Exception(msgErrore, e);
        }
        for (String pt : portTypesImplemented) {
            boolean trovato = false;
            for (String servizioOpenSPCoop : serviziIdentificatiNellaParteComune) {
                if (!pt.equals(servizioOpenSPCoop)) continue;
                trovato = true;
                break;
            }
            if (trovato) continue;
            throw new Exception("Il PortType " + pt + " implementato nei binding presenti nel " + tipoWSDL + " non \u00e8 uno dei servizi definiti nell'accordo di servizio parte comune");
        }
    }

    public void validateAndFillFruitore(ArchiveFruitore archiveFruitore) throws Exception {
        Fruitore fruitore = archiveFruitore.getFruitore();
        IDServizio asps = archiveFruitore.getIdAccordoServizioParteSpecifica();
        String uri = fruitore.getTipo() + "/" + fruitore.getNome() + "_" + this.idServizioFactory.getUriFromIDServizio(asps);
        String objectId = "[[Fruitore]]" + uri;
        String objectIdDescription = "Fruitore [" + fruitore.getTipo() + "/" + fruitore.getNome() + "] dell'Accordo di Servizio Parte Specifica [" + this.idServizioFactory.getUriFromIDServizio(asps) + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            org.openspcoop2.core.registry.AccordoServizioParteComune aspc;
            org.openspcoop2.core.registry.AccordoServizioParteSpecifica accordoAsps;
            block35: {
                block34: {
                    int i;
                    boolean found;
                    String tipoSoggettoErogatore = null;
                    String nomeSoggettoErogatore = null;
                    if (asps.getSoggettoErogatore() != null) {
                        tipoSoggettoErogatore = asps.getSoggettoErogatore().getTipo();
                        nomeSoggettoErogatore = asps.getSoggettoErogatore().getNome();
                    }
                    Integer versione = asps.getVersione();
                    if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null || versione == null) {
                        ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                        boolean throwException = false;
                        if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null) {
                            if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                                if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                                    found = false;
                                    if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                        for (i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                            if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                            found = true;
                                            break;
                                        }
                                    }
                                    if (!found) {
                                        throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                                    }
                                }
                                if (asps.getSoggettoErogatore() == null) {
                                    asps.setSoggettoErogatore(importInformationMissing.getSoggetto());
                                }
                            } else {
                                infoException.setMissingInfoSoggetto(true);
                                throwException = true;
                            }
                        }
                        if (versione == null) {
                            if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                                asps.setVersione(importInformationMissing.getVersione());
                            } else {
                                infoException.setMissingInfoVersione(true);
                                throwException = true;
                            }
                        }
                        if (throwException) {
                            throw infoException;
                        }
                    }
                    accordoAsps = null;
                    try {
                        accordoAsps = this.registryReader.getAccordoServizioParteSpecifica(asps);
                        if (accordoAsps == null) {
                            throw new Exception("getAccordoServizioParteSpecifica return null");
                        }
                    }
                    catch (Exception notFound) {
                        found = false;
                        if (this.archive.getAccordiServizioParteSpecifica() != null && this.archive.getAccordiServizioParteSpecifica().size() > 0) {
                            for (i = 0; i < this.archive.getAccordiServizioParteSpecifica().size(); ++i) {
                                ArchiveAccordoServizioParteSpecifica archiveAccordo = (ArchiveAccordoServizioParteSpecifica)this.archive.getAccordiServizioParteSpecifica().get(i);
                                IDServizio idAccordo = this.idServizioFactory.getIDServizioFromAccordo(archiveAccordo.getAccordoServizioParteSpecifica());
                                if (!idAccordo.equals((Object)asps)) continue;
                                found = true;
                                accordoAsps = archiveAccordo.getAccordoServizioParteSpecifica();
                                break;
                            }
                        }
                        if (found) break block34;
                        throw new ProtocolException("Accordo di Servizio Parte Specifica [" + String.valueOf(asps) + "], riferito dall'archivio fruitore, non esiste", (Throwable)notFound);
                    }
                }
                aspc = null;
                String uriAPC = null;
                try {
                    uriAPC = accordoAsps.getAccordoServizioParteComune();
                    if (uriAPC != null) {
                        uriAPC = ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(this.registryReader, uriAPC, asps.getSoggettoErogatore().getTipo(), asps.getSoggettoErogatore().getNome());
                        uriAPC = ImporterInformationMissingSetter.replaceSoggettoErogatore(uriAPC, asps.getSoggettoErogatore().getTipo(), asps.getSoggettoErogatore().getNome());
                    }
                    if ((aspc = this.registryReader.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(uriAPC))) == null) {
                        throw new Exception("getAccordoServizioParteComune return null");
                    }
                }
                catch (Exception notFound) {
                    IDAccordo idAccordo;
                    ArchiveAccordoServizioParteComune archiveAccordo;
                    boolean found = false;
                    if (this.archive.getAccordiServizioParteComune() != null && this.archive.getAccordiServizioParteComune().size() > 0) {
                        for (int i = 0; i < this.archive.getAccordiServizioParteComune().size(); ++i) {
                            archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioParteComune().get(i);
                            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                            if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(uriAPC))) continue;
                            found = true;
                            aspc = archiveAccordo.getAccordoServizioParteComune();
                            break;
                        }
                    }
                    if (!found && this.archive.getAccordiServizioComposto() != null && this.archive.getAccordiServizioComposto().size() > 0) {
                        for (int i = 0; i < this.archive.getAccordiServizioComposto().size(); ++i) {
                            archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioComposto().get(i);
                            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                            if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(uriAPC))) continue;
                            found = true;
                            aspc = archiveAccordo.getAccordoServizioParteComune();
                            break;
                        }
                    }
                    if (found) break block35;
                    throw new ProtocolException("Accordo di Servizio Parte Comune [" + uriAPC + "], riferito dall'accordo parte specifica dell'archivio fruitore, non esiste", (Throwable)notFound);
                }
            }
            List<String> serviziIdentificatiNellaParteComune = this.letturaServiziDefinitiParteComune(fruitore, accordoAsps, aspc);
            if (this.validateDocuments) {
                ValidazioneResult result = this.validatoreDocumenti.validaSpecificaInterfaccia(fruitore, accordoAsps, aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
                this.verificaMappingPortTypeBindingInRiferimentoParteComune(fruitore, accordoAsps, aspc, serviziIdentificatiNellaParteComune);
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }
}

