/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.builder;

import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class TracciaBuilder {
    protected Logger log = null;
    private IProtocolFactory<?> protocolFactory;
    private ITracciaSerializer tracciaProtocolBuilder;

    public TracciaBuilder(IProtocolFactory<?> protocolFactory) {
        this(Configurazione.getLibraryLog(), protocolFactory);
    }

    public TracciaBuilder(Logger aLog, IProtocolFactory<?> protocolFactory) {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(TracciaBuilder.class);
        this.protocolFactory = protocolFactory;
        try {
            this.tracciaProtocolBuilder = this.protocolFactory.createTracciaSerializer();
        }
        catch (Exception e) {
            this.log.error("Errore durante la creazione dell'XMLTracciaBuilder: " + e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public Element toElement(Traccia traccia) throws ProtocolException {
        return this.tracciaProtocolBuilder.toElement(traccia);
    }

    public byte[] toByteArray(Traccia traccia, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.tracciaProtocolBuilder.toByteArray(traccia, tipoSerializzazione);
    }

    public String toString(Traccia traccia, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.tracciaProtocolBuilder.toString(traccia, tipoSerializzazione);
    }
}

