/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class History {
    private Logger log = null;
    private IState state;
    private IGestoreRepository gestoreRepositoryBuste;

    public History(IState state) {
        this(state, Configurazione.getLibraryLog());
    }

    public History(IState state, Logger alog) {
        this.state = state;
        this.gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger((String)History.class.getName());
    }

    public void updateState(IState state) {
        this.state = state;
    }

    public void registraBustaInviata(String id) throws ProtocolException {
        this.registraBusta(id, "OUTBOX");
    }

    public void eliminaBustaInviata(String id) throws ProtocolException {
        this.eliminaBusta(id, "OUTBOX");
    }

    public void eliminaBustaInviataPerRiscontri(String id) throws ProtocolException {
        this.eliminaBustaPerRiscontri(id, "OUTBOX");
    }

    public void registraBustaRicevuta(String id) throws ProtocolException {
        this.registraBusta(id, "INBOX");
    }

    public void eliminaBustaRicevuta(String id) throws ProtocolException {
        this.eliminaBusta(id, "INBOX");
    }

    public void eliminaBustaRicevutaPerRiscontri(String id) throws ProtocolException {
        this.eliminaBustaPerRiscontri(id, "INBOX");
    }

    public boolean bustaRicevutaPrecedentemente(String id) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("select ID_MESSAGGIO from ");
            query.append("REPOSITORY_BUSTE");
            query.append(" WHERE ID_MESSAGGIO = ? AND TIPO=? AND ");
            query.append(this.gestoreRepositoryBuste.createSQLCondition_History(true));
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, "INBOX");
            rs = pstmt.executeQuery();
            if (rs != null) {
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "HISTORY_BUSTE, Errore durante il check bustaRicevutaPrecedentemente " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void registraBusta(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuilder queryUpdate = new StringBuilder();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_History(true));
            queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, id);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE saveBustaForHistory" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "HISTORY_BUSTE, Errore di registrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void eliminaBusta(String id, String tipoBusta) throws ProtocolException {
        this.eliminaBusta(id, tipoBusta, false);
    }

    public void eliminaBusta(String id, String tipoBusta, boolean forzaEliminazioneDb) throws ProtocolException {
        if (this.state instanceof StatefulMessage || forzaEliminazioneDb) {
            StateMessage state = (StateMessage)this.state;
            Connection connectionDB = state.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_History(false));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, tipoBusta);
                state.getPreparedStatement().put("UPDATE eliminaBustaForHistory" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "HISTORY_BUSTE, Errore di cancellazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new ProtocolException("Metodo non invocabile in modalita' stateless");
    }

    public void eliminaBustaPerRiscontri(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuilder queryUpdate = new StringBuilder();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_History(false));
            queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, id);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE eliminaBustaForHistory" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "HISTORY_BUSTE, Errore di cancellazione " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }
}

