/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver.repository.test;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryFactory;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class GestoreRepositoryTest {
    private static boolean systemOut = true;
    private static Logger log = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String driverJdbcCustom;
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        File logFile = File.createTempFile("runGestoreRepositoryTest_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration((Level)Level.ALL, (boolean)false, null, (File)logFile, (String)"%m %n");
        log = LoggerWrapperFactory.getLogger(GestoreRepositoryTest.class);
        DateManager.initializeDataManager((String)SystemDate.class.getName(), (Properties)new Properties(), (Logger)log);
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        TipiDatabase tipoDatabase = TipiDatabase.toEnumConstant((String)args[0].trim());
        switch (tipoDatabase) {
            case POSTGRESQL: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case MYSQL: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case ORACLE: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case HSQL: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case SQLSERVER: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case DB2: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        if (args.length > 4 && !"${driverJdbc}".equals(driverJdbcCustom = args[4].trim())) {
            driver = driverJdbcCustom;
        }
        System.out.println("URL:" + url);
        System.out.println("UserName:" + userName);
        System.out.println("Password:" + password);
        System.out.println("DriverJDBC:" + driver);
        ClassLoaderUtilities.newInstance((String)driver);
        Connection con = null;
        try {
            con = DriverManager.getConnection(url, userName, password);
            GestoreRepositoryTest.test(con, tipoDatabase);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void info(Logger log, boolean systemOut, String msg) {
        log.info(msg);
        if (systemOut) {
            System.out.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test(Connection con, TipiDatabase tipoDatabase) throws Exception {
        Statement stmtDelete = null;
        Statement stmtInsert = null;
        Statement stmtQuery = null;
        ResultSet rsQuery = null;
        try {
            String delete = "delete from prova_bytewise";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            IGestoreRepository gestoreRepository = GestoreRepositoryFactory.createRepositoryBuste(tipoDatabase);
            String tipo = GestoreRepositoryFactory.getTipoRepositoryBuste(tipoDatabase);
            GestoreRepositoryTest.info(log, systemOut, "Creato IGestoreRepository[" + tipo + "] di tipo " + gestoreRepository.getClass().getName());
            String colonna = gestoreRepository.createSQLFields();
            GestoreRepositoryTest.info(log, systemOut, "createSQLFields: " + colonna);
            if (!"REPOSITORY_ACCESS".equals(colonna)) {
                throw new Exception("createSQLFields ha ritornato un valore differente da quello atteso (REPOSITORY_ACCESS): " + colonna);
            }
            ISQLQueryObject sqlQuery = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDatabase);
            sqlQuery.addInsertTable("prova_bytewise");
            sqlQuery.addInsertField("descrizione", "?");
            stmtInsert = con.prepareStatement(sqlQuery.createSQLInsert());
            stmtInsert.setString(1, "descrizione di esempio");
            int row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "\n\ninserita riga: " + row);
            String query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(false);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 1. history=false)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 1. history=false). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = query + " and " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(false);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 2. history=false and profilo=false)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 2. history=false and profilo=false). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = query + " and " + gestoreRepository.createSQLCondition_PdD(false);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 3. history=false and profilo=false and pdd=false)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 3. history=false and profilo=false and pdd=false). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            String update = "UPDATE prova_bytewise set " + gestoreRepository.createSQLSet_History(true);
            stmtInsert = con.prepareStatement(update);
            GestoreRepositoryTest.info(log, systemOut, "\n\nUpdate [" + update + "]");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "aggiornata riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(false);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 4. history=false)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 4. history=false). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 5. history=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 5. history=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            update = "UPDATE prova_bytewise set " + gestoreRepository.createSQLSet_ProfiloCollaborazione(true);
            stmtInsert = con.prepareStatement(update);
            GestoreRepositoryTest.info(log, systemOut, "\n\nUpdate [" + update + "]");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "aggiornata riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 6. history=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 6. history=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true) + "and " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 7. history=true and profilo=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 7. history=true and profilo=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true) + "or " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 8. history=true or profilo=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 8. history=true or profilo=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            update = "UPDATE prova_bytewise set " + gestoreRepository.createSQLSet_PdD(true);
            stmtInsert = con.prepareStatement(update);
            GestoreRepositoryTest.info(log, systemOut, "\n\nUpdate [" + update + "]");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "aggiornata riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 9. history=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 9. history=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true) + "and " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 10. history=true and profilo=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 10. history=true and profilo=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true) + "or " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 11. history=true or profilo=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 1. history=true or profilo=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true) + "and " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true) + "and " + gestoreRepository.createSQLCondition_PdD(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 12. history=true and profilo=true and pdd=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 12. history=true and profilo=true and pdd=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true) + "or " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true) + "or " + gestoreRepository.createSQLCondition_PdD(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 13. history=true or profilo=true or pdd=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 13. history=true or profilo=true or pdd=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyHistory();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 14. onlyHistory)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 14. onlyHistory). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 15. onlyProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 15. onlyProfilo). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPdd();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 16. onlyPdd)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 16. onlyPdd). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPddAndProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 17. onlyPddAndProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 17. onlyPddAndProfilo). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_disabledAll();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 18. disableAll)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 18. disableAll). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            update = "UPDATE prova_bytewise set " + gestoreRepository.createSQLSet_History(false);
            stmtInsert = con.prepareStatement(update);
            GestoreRepositoryTest.info(log, systemOut, "\n\nUpdate [" + update + "]");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "aggiornata riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 19. history=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 19. history=true). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_PdD(true) + "or " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 20. pdd=true or profilo=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 20. pdd=true or profilo=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 21. onlyProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 21. onlyProfilo). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPdd();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 22. onlyPdd)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 22. onlyPdd). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPddAndProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 20. pddAndProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 23. pddAndProfilo). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_disabledAll();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 24. disableAll)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 24. disableAll). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            update = "UPDATE prova_bytewise set " + gestoreRepository.createSQLSet_PdD(false);
            stmtInsert = con.prepareStatement(update);
            GestoreRepositoryTest.info(log, systemOut, "\n\nUpdate [" + update + "]");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "aggiornata riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 25. history=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 25. history=true). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_PdD(true) + "or " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 26. pdd=true or profilo=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 26. pdd=true or profilo=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 27. onlyProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 27. profilo=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPdd();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 28. onlyPdd)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 28. onlyPdd). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPddAndProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 29. pddAndProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 29. pddAndProfilo). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_disabledAll();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 30. disableAll)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 30. disableAll). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            update = "UPDATE prova_bytewise set " + gestoreRepository.createSQLSet_ProfiloCollaborazione(false);
            stmtInsert = con.prepareStatement(update);
            GestoreRepositoryTest.info(log, systemOut, "\n\nUpdate [" + update + "]");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "aggiornata riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 31. history=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 31. history=true). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_PdD(true) + "or " + gestoreRepository.createSQLCondition_ProfiloCollaborazione(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 32. pdd=true or profilo=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 32. pdd=true or profilo=true). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 33. onlyProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 33. onlyProfilo). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPdd();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 34. onlyPdd)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 34. onlyPdd). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_enableOnlyPddAndProfilo();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (rsQuery.next()) {
                throw new Exception("trovata Riga non attesa (valore:" + GestoreRepositoryTest.toStringEngine(rsQuery, 1) + ") (test 35. pddAndProfilo)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 35. pddAndProfilo). Non e' stata trovata correttamente una entry");
            rsQuery.close();
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_disabledAll();
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 36. disableAll)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 36. disableAll). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            delete = "delete from prova_bytewise";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            sqlQuery = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDatabase);
            sqlQuery.addInsertTable("prova_bytewise");
            sqlQuery.addInsertField("descrizione", "?");
            sqlQuery.addInsertField(gestoreRepository.createSQLFieldHistory(), gestoreRepository.getSQLValueHistory(true));
            stmtInsert = con.prepareStatement(sqlQuery.createSQLInsert());
            stmtInsert.setString(1, "descrizione di esempio");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "\n\ninserita riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(true);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 37. history=true)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 37. history=true). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
            delete = "delete from prova_bytewise";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            sqlQuery = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDatabase);
            sqlQuery.addInsertTable("prova_bytewise");
            sqlQuery.addInsertField("descrizione", "?");
            sqlQuery.addInsertField(gestoreRepository.createSQLFieldHistory(), gestoreRepository.getSQLValueHistory(false));
            stmtInsert = con.prepareStatement(sqlQuery.createSQLInsert());
            stmtInsert.setString(1, "descrizione di esempio");
            row = stmtInsert.executeUpdate();
            GestoreRepositoryTest.info(log, systemOut, "\n\ninserita riga: " + row);
            query = "select " + colonna + " from prova_bytewise where " + gestoreRepository.createSQLCondition_History(false);
            stmtQuery = con.createStatement();
            GestoreRepositoryTest.info(log, systemOut, "\n\nQuery [" + query + "]");
            rsQuery = stmtQuery.executeQuery(query);
            if (!rsQuery.next()) {
                throw new Exception("Riga attesa non trovata (test 38. history=false)");
            }
            GestoreRepositoryTest.info(log, systemOut, "(test 38. history=false). Trovata entry con valore: " + GestoreRepositoryTest.toStringEngine(rsQuery, 1));
            rsQuery.close();
        }
        finally {
            try {
                if (stmtDelete != null) {
                    stmtDelete.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtInsert != null) {
                    stmtInsert.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rsQuery != null) {
                    rsQuery.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtQuery != null) {
                    stmtQuery.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String toStringEngine(ResultSet rs, int index) throws SQLException {
        String o = rs.getString(index);
        return o.toString();
    }
}

