/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_accordiCooperazione {
    protected static boolean isAccordoCooperazioneInUso(Connection con, String tipoDB, IDAccordoCooperazione idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        String nomeMetodo = "isAccordoCooperazioneInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        try {
            boolean isInUso = false;
            long idAccordoServizioParteComune = DBUtils.getIdAccordoCooperazione((IDAccordoCooperazione)idAccordo, (Connection)con, (String)tipoDB);
            if (idAccordoServizioParteComune <= 0L) {
                throw new UtilsException("Accordi di Cooperazione con id [" + idAccordo.toString() + "] non trovato");
            }
            List<String> accordi_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_ACCORDI);
            if (accordi_list == null) {
                accordi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_ACCORDI, accordi_list);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo_cooperazione = ?");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = accordi.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteComune);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                String nomeAccordo = risultato.getString("nome");
                int versione = risultato.getInt("versione");
                long idReferente = risultato.getLong("id_referente");
                IDSoggetto idReferenteObject = null;
                if (idReferente > 0L) {
                    ISQLQueryObject sqlQueryObjectReferente = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObjectReferente.addFromTable("soggetti");
                    sqlQueryObjectReferente.addSelectField("*");
                    sqlQueryObjectReferente.addWhereCondition("id=?");
                    sqlQueryObjectReferente.setANDLogicOperator(true);
                    String queryStringReferente = sqlQueryObjectReferente.createSQLQuery();
                    stmt2 = con.prepareStatement(queryStringReferente);
                    stmt2.setLong(1, idReferente);
                    risultato2 = stmt2.executeQuery();
                    if (risultato2.next()) {
                        idReferenteObject = new IDSoggetto();
                        idReferenteObject.setTipo(risultato2.getString("tipo_soggetto"));
                        idReferenteObject.setNome(risultato2.getString("nome_soggetto"));
                    }
                    risultato2.close();
                    risultato2 = null;
                    stmt2.close();
                    stmt2 = null;
                }
                if (normalizeObjectIds && idReferenteObject != null) {
                    String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idReferenteObject.getTipo());
                    IDAccordoCooperazione idAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromValues(nomeAccordo, idReferenteObject, versione);
                    accordi_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoCooperazione(protocollo, idAccordoCooperazione));
                    continue;
                }
                StringBuilder bf = new StringBuilder();
                bf.append(idReferenteObject != null ? idReferenteObject.getTipo() : "?");
                bf.append("/");
                bf.append(idReferenteObject != null ? idReferenteObject.getNome() : "?");
                bf.append(":");
                bf.append(nomeAccordo);
                if (idReferente > 0L) {
                    bf.append(":");
                    bf.append(versione);
                }
                accordi_list.add(bf.toString());
            }
            risultato.close();
            stmt.close();
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                JDBCUtilities.closeResources(risultato2, stmt2);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        JDBCUtilities.closeResources(risultato2, stmt2);
        return bl;
    }

    protected static String toString(IDAccordoCooperazione idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        StringBuilder bf = new StringBuilder();
        if (normalizeObjectIds && idAccordo.getSoggettoReferente() != null) {
            try {
                String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idAccordo.getSoggettoReferente().getTipo());
                String labelAccordo = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoCooperazione(protocollo, idAccordo);
                bf.append(labelAccordo);
            }
            catch (Exception e) {
                bf.append(idAccordo.toString());
            }
        } else {
            bf.append(idAccordo.toString());
        }
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        Object msg = "Accordo Cooperazione '" + bf.toString() + "' non eliminabile perch&egrave; :" + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block5: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case IN_USO_IN_ACCORDI: {
                    if (messages == null || messages.size() <= 0) continue block5;
                    msg = (String)msg + "riferito da API (Servizi Composti): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block5;
                }
            }
            msg = (String)msg + "utilizzato in oggetto non codificato (" + String.valueOf(key) + ")" + separator;
        }
        return msg;
    }
}

