/*
 * Decompiled with CFR 0.152.
 */
package com.kendelong.web.jmxconsole;

import com.kendelong.web.jmxconsole.CaseInsensitiveStringComparator;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;

public class LookupMBeansServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
        Set<ObjectInstance> beans = server.queryMBeans(null, null);
        TreeMap<String, ArrayList<String>> indexByDomains = new TreeMap<String, ArrayList<String>>(new CaseInsensitiveStringComparator());
        for (ObjectInstance bean : beans) {
            String domain = bean.getObjectName().getDomain();
            String keyPropertyListString = bean.getObjectName().getKeyPropertyListString();
            ArrayList<String> list = (ArrayList<String>)indexByDomains.get(domain);
            if (list == null) {
                list = new ArrayList<String>();
                indexByDomains.put(domain, list);
            }
            list.add(keyPropertyListString);
        }
        for (List propStringList : indexByDomains.values()) {
            Collections.sort(propStringList);
        }
        request.setAttribute("beans", indexByDomains);
        request.getRequestDispatcher("listBeans.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

