/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public abstract class DispatchCommand
implements Command {
    private Map methods = new WeakHashMap();
    private String method = null;
    private String methodKey = null;
    protected static final Class[] DEFAULT_SIGNATURE = new Class[]{Context.class};

    @Override
    public boolean execute(Context context) throws Exception {
        if (this.getMethod() == null && this.getMethodKey() == null) {
            throw new IllegalStateException("Neither 'method' nor 'methodKey' properties are defined ");
        }
        Method methodObject = this.extractMethod(context);
        try {
            return this.evaluateResult(methodObject.invoke((Object)this, this.getArguments(context)));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method extractMethod(Context context) throws NoSuchMethodException {
        String methodName = this.getMethod();
        if (methodName == null) {
            Object methodContextObj = context.get(this.getMethodKey());
            if (methodContextObj == null) {
                throw new NullPointerException("No value found in context under " + this.getMethodKey());
            }
            methodName = methodContextObj.toString();
        }
        Method theMethod = null;
        Map map = this.methods;
        synchronized (map) {
            theMethod = (Method)this.methods.get(methodName);
            if (theMethod == null) {
                theMethod = this.getClass().getMethod(methodName, this.getSignature());
                this.methods.put(methodName, theMethod);
            }
        }
        return theMethod;
    }

    protected boolean evaluateResult(Object o) {
        Boolean result = (Boolean)o;
        return result != null && result != false;
    }

    protected Class[] getSignature() {
        return DEFAULT_SIGNATURE;
    }

    protected Object[] getArguments(Context context) {
        return new Object[]{context};
    }

    public String getMethod() {
        return this.method;
    }

    public String getMethodKey() {
        return this.methodKey;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMethodKey(String methodKey) {
        this.methodKey = methodKey;
    }
}

