/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import jakarta.servlet.ServletContext;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ChainResources {
    ChainResources() {
    }

    static void parseClassResources(String resources, ConfigParser parser) {
        if (resources == null) {
            return;
        }
        Log log = LogFactory.getLog(ChainResources.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ChainResources.class.getClassLoader();
        }
        String[] paths = ChainResources.getResourcePaths(resources);
        String path = null;
        try {
            for (int i = 0; i < paths.length; ++i) {
                path = paths[i];
                URL url = loader.getResource(path);
                if (url == null) {
                    throw new IllegalStateException("Missing chain config resource '" + path + "'");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading chain config resource '" + path + "'"));
                }
                parser.parse(url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing chain config resource '" + path + "': " + e.getMessage());
        }
    }

    static void parseClassResources(Catalog catalog, String resources, ConfigParser parser) {
        if (resources == null) {
            return;
        }
        Log log = LogFactory.getLog(ChainResources.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ChainResources.class.getClassLoader();
        }
        String[] paths = ChainResources.getResourcePaths(resources);
        String path = null;
        try {
            for (int i = 0; i < paths.length; ++i) {
                path = paths[i];
                URL url = loader.getResource(path);
                if (url == null) {
                    throw new IllegalStateException("Missing chain config resource '" + path + "'");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading chain config resource '" + path + "'"));
                }
                parser.parse(catalog, url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing chain config resource '" + path + "': " + e.getMessage());
        }
    }

    static void parseWebResources(ServletContext context, String resources, ConfigParser parser) {
        if (resources == null) {
            return;
        }
        Log log = LogFactory.getLog(ChainResources.class);
        String[] paths = ChainResources.getResourcePaths(resources);
        String path = null;
        try {
            for (int i = 0; i < paths.length; ++i) {
                path = paths[i];
                URL url = context.getResource(path);
                if (url == null) {
                    throw new IllegalStateException("Missing chain config resource '" + path + "'");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading chain config resource '" + path + "'"));
                }
                parser.parse(url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing chain config resource '" + path + "': " + e.getMessage());
        }
    }

    static void parseWebResources(Catalog catalog, ServletContext context, String resources, ConfigParser parser) {
        if (resources == null) {
            return;
        }
        Log log = LogFactory.getLog(ChainResources.class);
        String[] paths = ChainResources.getResourcePaths(resources);
        String path = null;
        try {
            for (int i = 0; i < paths.length; ++i) {
                path = paths[i];
                URL url = context.getResource(path);
                if (url == null) {
                    throw new IllegalStateException("Missing chain config resource '" + path + "'");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading chain config resource '" + path + "'"));
                }
                parser.parse(catalog, url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing chain config resource '" + path + "': " + e.getMessage());
        }
    }

    static String[] getResourcePaths(String resources) {
        ArrayList<String> paths = new ArrayList<String>();
        if (resources != null) {
            int comma;
            while ((comma = resources.indexOf(44)) >= 0) {
                String path = resources.substring(0, comma).trim();
                if (path.length() > 0) {
                    paths.add(path);
                }
                resources = resources.substring(comma + 1);
            }
            if ((resources = resources.trim()).length() > 0) {
                paths.add(resources);
            }
        }
        return paths.toArray(new String[0]);
    }
}

