/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.chain.impl.CatalogBase;
import org.apache.commons.chain.web.ChainResources;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChainServlet
extends HttpServlet {
    public static final String CONFIG_ATTR = "org.apache.commons.chain.CONFIG_ATTR";
    public static final String CONFIG_CLASS_RESOURCE = "org.apache.commons.chain.CONFIG_CLASS_RESOURCE";
    public static final String CONFIG_WEB_RESOURCE = "org.apache.commons.chain.CONFIG_WEB_RESOURCE";
    public static final String RULE_SET = "org.apache.commons.chain.RULE_SET";

    public void destroy() {
        ServletConfig config = this.getServletConfig();
        ServletContext context = this.getServletContext();
        String attr = config.getInitParameter(CONFIG_ATTR);
        if (attr != null) {
            context.removeAttribute(attr);
        }
        CatalogFactory.clear();
    }

    public void init() throws ServletException {
        Log log = LogFactory.getLog(ChainServlet.class);
        ServletConfig config = this.getServletConfig();
        ServletContext context = this.getServletContext();
        if (log.isInfoEnabled()) {
            log.info((Object)("Initializing chain servlet '" + config.getServletName() + "'"));
        }
        String attr = config.getInitParameter(CONFIG_ATTR);
        String classResources = context.getInitParameter(CONFIG_CLASS_RESOURCE);
        String ruleSet = context.getInitParameter(RULE_SET);
        String webResources = context.getInitParameter(CONFIG_WEB_RESOURCE);
        Catalog catalog = null;
        if (attr != null && (catalog = (Catalog)context.getAttribute(attr)) == null) {
            catalog = new CatalogBase();
        }
        ConfigParser parser = new ConfigParser();
        if (ruleSet != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = ((Object)((Object)this)).getClass().getClassLoader();
                }
                Class<?> clazz = loader.loadClass(ruleSet);
                parser.setRuleSet((RuleSet)clazz.newInstance());
            }
            catch (Exception e) {
                throw new ServletException("Exception initalizing RuleSet '" + ruleSet + "' instance", (Throwable)e);
            }
        }
        if (attr == null) {
            ChainResources.parseClassResources(classResources, parser);
            ChainResources.parseWebResources(context, webResources, parser);
        } else {
            ChainResources.parseClassResources(catalog, classResources, parser);
            ChainResources.parseWebResources(catalog, context, webResources, parser);
        }
        if (attr != null) {
            context.setAttribute(attr, (Object)catalog);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

