/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.chain.web.MapEntry;

final class ServletHeaderValuesMap
implements Map {
    private HttpServletRequest request = null;

    public ServletHeaderValuesMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getHeader(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof String[])) {
            return false;
        }
        String[] test = (String[])value;
        for (String[] actual : this.values()) {
            if (test.length != actual.length) continue;
            boolean matched = true;
            for (int i = 0; i < test.length; ++i) {
                if (test[i].equals(actual[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<MapEntry> set = new HashSet<MapEntry>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add(new MapEntry(key, this.request.getHeaders(key), false));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this.request.equals(o);
    }

    public Object get(Object key) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration values = this.request.getHeaders(this.key(key));
        while (values.hasMoreElements()) {
            list.add((String)values.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public int hashCode() {
        return this.request.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    public Set keySet() {
        HashSet set = new HashSet();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            set.add(keys.nextElement());
        }
        return set;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    public Collection values() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ArrayList<String> list1 = new ArrayList<String>();
            Enumeration values = this.request.getHeaders(key);
            while (values.hasMoreElements()) {
                list1.add((String)values.nextElement());
            }
            list.add(list1.toArray(new String[list1.size()]));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

