/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.config;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionFormBean;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.govway.struts.action.ActionMessages;
import org.govway.struts.config.ConfigHelperInterface;
import org.govway.struts.upload.MultipartRequestWrapper;
import org.govway.struts.util.MessageResources;
import org.govway.struts.util.RequestUtils;

public class ConfigHelper
implements ConfigHelperInterface {
    private ServletContext application = null;
    private HttpSession session = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ActionForward forward = null;

    public ConfigHelper() {
    }

    public ConfigHelper(ServletContext application, HttpServletRequest request, HttpServletResponse response) {
        this.setResources(application, request, response);
    }

    public void setApplication(ServletContext application) {
        this.application = application;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        if (this.request == null) {
            this.setSession(null);
        } else {
            this.setSession(this.request.getSession());
        }
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setForward(ActionForward forward) {
        this.forward = forward;
    }

    public void setResources(ServletContext application, HttpServletRequest request, HttpServletResponse response) {
        this.setApplication(application);
        this.setRequest(request);
        this.setResponse(response);
    }

    @Override
    public ActionMessages getActionMessages() {
        if (this.application == null) {
            return null;
        }
        return (ActionMessages)this.application.getAttribute("org.govway.struts.action.ACTION_MESSAGE");
    }

    @Override
    public MessageResources getMessageResources() {
        if (this.application == null) {
            return null;
        }
        return (MessageResources)this.application.getAttribute("org.govway.struts.action.MESSAGE");
    }

    @Override
    public String getServletMapping() {
        if (this.application == null) {
            return null;
        }
        return (String)this.application.getAttribute("org.govway.struts.action.SERVLET_MAPPING");
    }

    @Override
    public String getToken() {
        if (this.session == null) {
            return null;
        }
        return (String)this.session.getAttribute("org.govway.struts.action.TOKEN");
    }

    @Override
    public Throwable getException() {
        if (this.request == null) {
            return null;
        }
        return (Throwable)this.request.getAttribute("org.govway.struts.action.EXCEPTION");
    }

    @Override
    public MultipartRequestWrapper getMultipartRequestWrapper() {
        if (this.request == null) {
            return null;
        }
        return (MultipartRequestWrapper)((Object)this.request.getAttribute("org.govway.struts.action.mapping.multipartclass"));
    }

    @Override
    public ActionMapping getMapping() {
        if (this.request == null) {
            return null;
        }
        return (ActionMapping)this.request.getAttribute("org.govway.struts.action.mapping.instance");
    }

    @Override
    public boolean isMessage(String key) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return false;
        }
        return resources.isPresent(RequestUtils.getUserLocale(this.request, null), key);
    }

    @Override
    public ActionForm getActionForm() {
        ActionMapping mapping = this.getMapping();
        if (mapping == null) {
            return null;
        }
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        ActionForm instance = "request".equals(mapping.getScope()) ? (ActionForm)this.request.getAttribute(attribute) : (ActionForm)this.session.getAttribute(attribute);
        return instance;
    }

    @Override
    public ActionFormBean getFormBean(String name) {
        return null;
    }

    @Override
    public ActionForward getActionForward(String name) {
        return null;
    }

    @Override
    public ActionMapping getActionMapping(String path) {
        return null;
    }

    @Override
    public String getActionMappingName(String action) {
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        if (value.startsWith("/")) {
            return value;
        }
        return "/" + value;
    }

    @Override
    public String getActionMappingURL(String action) {
        StringBuffer value = new StringBuffer(this.request.getContextPath());
        String servletMapping = this.getServletMapping();
        if (servletMapping != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = this.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    @Override
    public String getEncodeURL(String url) {
        if (this.session != null && this.response != null) {
            boolean redirect = false;
            if (this.forward != null) {
                redirect = this.forward.getRedirect();
            }
            if (redirect) {
                return this.response.encodeRedirectURL(url);
            }
            return this.response.encodeURL(url);
        }
        return url;
    }

    @Override
    public String getOrigRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer result = RequestUtils.requestToServerUriStringBuffer(this.request);
        return result.toString();
    }

    @Override
    public String getBaseRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer result = RequestUtils.requestToServerStringBuffer(this.request);
        Object path = this.forward == null ? this.request.getRequestURI() : this.request.getContextPath() + this.forward.getPath();
        result.append((String)path);
        return result.toString();
    }

    @Override
    public String getLink(String name) {
        ActionForward forward = this.getActionForward(name);
        if (forward == null) {
            return null;
        }
        StringBuffer path = new StringBuffer(this.request.getContextPath());
        path.append(forward.getPath());
        return this.getEncodeURL(path.toString());
    }

    @Override
    public String getMessage(String key) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return null;
        }
        return resources.getMessage(RequestUtils.getUserLocale(this.request, null), key);
    }

    @Override
    public String getMessage(String key, Object[] args) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return null;
        }
        if (args == null) {
            return resources.getMessage(RequestUtils.getUserLocale(this.request, null), key);
        }
        return resources.getMessage(RequestUtils.getUserLocale(this.request, null), key, args);
    }

    @Override
    public String getAction(String path) {
        return this.getEncodeURL(this.getActionMappingURL(path));
    }

    public String link(String name) {
        return this.getLink(name);
    }

    public String message(String key) {
        return this.getMessage(key);
    }

    public String message(String key, Object[] args) {
        return this.getMessage(key, args);
    }

    public String action(String path) {
        return this.getAction(path);
    }
}

