/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.upload;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.JakartaServletDiskFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.action.ActionMapping;
import org.govway.struts.action.ActionServlet;
import org.govway.struts.config.ModuleConfig;
import org.govway.struts.upload.FormFile;
import org.govway.struts.upload.MultipartRequestHandler;
import org.govway.struts.upload.MultipartRequestWrapper;

public class CommonsMultipartRequestHandler
implements MultipartRequestHandler {
    public static final long DEFAULT_SIZE_MAX = 0xFA00000L;
    public static final int DEFAULT_SIZE_THRESHOLD = 262144;
    protected static Log log = LogFactory.getLog(CommonsMultipartRequestHandler.class);
    private Hashtable elementsAll;
    private Hashtable elementsFile;
    private Hashtable elementsText;
    private ActionMapping mapping;
    private ActionServlet servlet;

    @Override
    public ActionServlet getServlet() {
        return this.servlet;
    }

    @Override
    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public ActionMapping getMapping() {
        return this.mapping;
    }

    @Override
    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public void handleRequest(HttpServletRequest request) throws ServletException {
        ModuleConfig ac = (ModuleConfig)request.getAttribute("org.govway.struts.action.MODULE");
        JakartaServletDiskFileUpload upload = new JakartaServletDiskFileUpload();
        if (request.getCharacterEncoding() != null) {
            upload.setHeaderCharset(Charset.forName(request.getCharacterEncoding()));
        }
        upload.setSizeMax(this.getSizeMax(ac));
        upload.setFileSizeMax((long)((int)this.getSizeMax(ac)));
        this.elementsText = new Hashtable();
        this.elementsFile = new Hashtable();
        this.elementsAll = new Hashtable();
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadByteCountLimitException e) {
            request.setAttribute("org.govway.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            return;
        }
        catch (FileUploadException e) {
            log.error((Object)"Failed to parse multipart request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                try {
                    this.addTextParameter(request, item);
                    continue;
                }
                catch (Exception e) {
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
            }
            this.addFileParameter(item);
        }
    }

    @Override
    public Hashtable getTextElements() {
        return this.elementsText;
    }

    @Override
    public Hashtable getFileElements() {
        return this.elementsFile;
    }

    @Override
    public Hashtable getAllElements() {
        return this.elementsAll;
    }

    @Override
    public void rollback() {
        for (Object o : this.elementsFile.values()) {
            if (o instanceof List) {
                Iterator i = ((List)o).iterator();
                while (i.hasNext()) {
                    ((FormFile)i.next()).destroy();
                }
                continue;
            }
            ((FormFile)o).destroy();
        }
    }

    @Override
    public void finish() {
        this.rollback();
    }

    protected long getSizeMax(ModuleConfig mc) {
        return this.convertSizeToBytes(mc.getControllerConfig().getMaxFileSize(), 0xFA00000L);
    }

    protected long getSizeThreshold(ModuleConfig mc) {
        return this.convertSizeToBytes(mc.getControllerConfig().getMemFileSize(), 262144L);
    }

    protected long convertSizeToBytes(String sizeString, long defaultSize) {
        int multiplier = 1;
        if (sizeString.endsWith("K")) {
            multiplier = 1024;
        } else if (sizeString.endsWith("M")) {
            multiplier = 0x100000;
        } else if (sizeString.endsWith("G")) {
            multiplier = 0x40000000;
        }
        if (multiplier != 1) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
        }
        long size = 0L;
        try {
            size = Long.parseLong(sizeString);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Invalid format for file size ('" + sizeString + "'). Using default."));
            size = defaultSize;
            multiplier = 1;
        }
        return size * (long)multiplier;
    }

    protected String getRepositoryPath(ModuleConfig mc) {
        String tempDir = mc.getControllerConfig().getTempDir();
        if (tempDir == null || tempDir.length() == 0) {
            if (this.servlet != null) {
                ServletContext context = this.servlet.getServletContext();
                File tempDirFile = (File)context.getAttribute("jakarta.servlet.context.tempdir");
                tempDir = tempDirFile.getAbsolutePath();
            }
            if (tempDir == null || tempDir.length() == 0) {
                tempDir = System.getProperty("java.io.tmpdir");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("File upload temp dir: " + tempDir));
        }
        return tempDir;
    }

    protected void addTextParameter(HttpServletRequest request, FileItem item) throws IOException {
        String[] newArray;
        String[] oldArray;
        String name = item.getFieldName();
        String value = null;
        boolean haveValue = false;
        String encoding = null;
        if (item instanceof DiskFileItem) {
            encoding = ((DiskFileItem)item).getCharset().name();
            if (log.isDebugEnabled()) {
                log.debug((Object)("DiskFileItem.getCharSet=[" + encoding + "]"));
            }
        }
        if (encoding == null) {
            encoding = request.getCharacterEncoding();
            if (log.isDebugEnabled()) {
                log.debug((Object)("request.getCharacterEncoding=[" + encoding + "]"));
            }
        }
        if (encoding != null) {
            try {
                value = item.getString(Charset.forName(encoding));
                haveValue = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!haveValue) {
            try {
                value = item.getString(Charset.forName("ISO-8859-1"));
            }
            catch (IOException uee) {
                value = item.getString();
            }
            haveValue = true;
        }
        if (request instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper wrapper = (MultipartRequestWrapper)request;
            wrapper.setParameter(name, value);
        }
        if ((oldArray = (String[])this.elementsText.get(name)) != null) {
            newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new String[]{value};
        }
        this.elementsText.put(name, newArray);
        this.elementsAll.put(name, newArray);
    }

    protected void addFileParameter(FileItem item) {
        CommonsFormFile formFile = new CommonsFormFile(item);
        String name = item.getFieldName();
        if (this.elementsFile.containsKey(name)) {
            Object o = this.elementsFile.get(name);
            if (o instanceof List) {
                ((List)o).add(formFile);
            } else {
                ArrayList<FormFile> list = new ArrayList<FormFile>();
                list.add((FormFile)o);
                list.add(formFile);
                this.elementsFile.put(name, list);
                this.elementsAll.put(name, list);
            }
        } else {
            this.elementsFile.put(name, formFile);
            this.elementsAll.put(name, formFile);
        }
    }

    static class CommonsFormFile
    implements FormFile,
    Serializable {
        FileItem fileItem;

        public CommonsFormFile(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        @Override
        public String getContentType() {
            return this.fileItem.getContentType();
        }

        @Override
        public void setContentType(String contentType) {
            throw new UnsupportedOperationException("The setContentType() method is not supported.");
        }

        @Override
        public int getFileSize() {
            return (int)this.fileItem.getSize();
        }

        @Override
        public void setFileSize(int filesize) {
            throw new UnsupportedOperationException("The setFileSize() method is not supported.");
        }

        @Override
        public String getFileName() {
            return this.getBaseFileName(this.fileItem.getName());
        }

        @Override
        public void setFileName(String fileName) {
            throw new UnsupportedOperationException("The setFileName() method is not supported.");
        }

        @Override
        public byte[] getFileData() throws FileNotFoundException, IOException {
            return this.fileItem.get();
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException, IOException {
            return this.fileItem.getInputStream();
        }

        @Override
        public void destroy() {
            try {
                this.fileItem.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected String getBaseFileName(String filePath) {
            String fileName = new File(filePath).getName();
            int colonIndex = fileName.indexOf(":");
            if (colonIndex == -1) {
                colonIndex = fileName.indexOf("\\\\");
            }
            int backslashIndex = fileName.lastIndexOf("\\");
            if (colonIndex > -1 && backslashIndex > -1) {
                fileName = fileName.substring(backslashIndex + 1);
            }
            return fileName;
        }

        public String toString() {
            return this.getFileName();
        }
    }
}

