/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.trasparente.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.trasparente.config.TrasparenteInstanceProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class TrasparenteProperties {
    private Logger log = null;
    private static TrasparenteProperties trasparenteProperties = null;
    private TrasparenteInstanceProperties reader;
    private Boolean generateIDasUUID = null;
    private Boolean isRiferimentoIDRichiesta_PD_Required = null;
    private Boolean isRiferimentoIDRichiesta_PD_RequiredRead = null;
    private Boolean isRiferimentoIDRichiesta_PA_Required = null;
    private Boolean isRiferimentoIDRichiesta_PA_RequiredRead = null;
    private Boolean isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
    private Boolean isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = null;
    private Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
    private Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolValidazione = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationServerError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationClientError = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
    private Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = null;
    private BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
    private Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = null;
    private Boolean utilizzaTestSuiteGenerazioneTracce = null;
    private Boolean utilizzaTestSuiteProtocolProperties = null;
    private Boolean useConfigStaticInstance = null;
    private Boolean useErroreApplicativoStaticInstance = null;
    private Boolean useEsitoStaticInstance = null;
    private BasicStaticInstanceConfig staticInstanceConfig = null;

    private TrasparenteProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger((String)"TrasparenteProperties");
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = TrasparenteProperties.class.getResourceAsStream("/trasparente.properties");
            if (properties == null) {
                throw new Exception("File '/trasparente.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'trasparente.properties': " + e.getMessage());
            throw new ProtocolException("TrasparenteProperties initialize error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            this.reader = new TrasparenteInstanceProperties(propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log) throws ProtocolException {
        if (trasparenteProperties == null) {
            trasparenteProperties = new TrasparenteProperties(confDir, log);
        }
    }

    public static TrasparenteProperties getInstance() throws ProtocolException {
        if (trasparenteProperties == null) {
            Class<TrasparenteProperties> clazz = TrasparenteProperties.class;
            synchronized (TrasparenteProperties.class) {
                throw new ProtocolException("TrasparenteProperties not initialized (use init method in factory)");
            }
        }
        return trasparenteProperties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            this.generateIDasUUID();
            this.isRiferimentoIDRichiesta_PD_Required();
            this.isRiferimentoIDRichiesta_PA_Required();
            this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
            this.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
            this.isGenerazioneDetailsSOAPFaultProtocolValidazione();
            this.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
            this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
            this.isGenerazioneDetailsSOAPFaultIntegrationServerError();
            this.isGenerazioneDetailsSOAPFaultIntegrationClientError();
            this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
            this.isPortaApplicativaBustaErrore_personalizzaElementiFault();
            this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo();
            this.isUtilizzaTestSuiteGenerazioneTracce();
            this.isUtilizzaTestSuiteProtocolProperties();
            this.useConfigStaticInstance();
            this.useErroreApplicativoStaticInstance();
            this.useEsitoStaticInstance();
            this.getStaticInstanceConfig();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' del protocollo trasparente, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, (Throwable)e);
        }
    }

    public Boolean generateIDasUUID() {
        if (this.generateIDasUUID == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.trasparente.id.uuid";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.generateIDasUUID = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.generateIDasUUID = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.generateIDasUUID = defaultValue;
            }
        }
        return this.generateIDasUUID;
    }

    public Boolean isRiferimentoIDRichiesta_PD_Required() {
        if (this.isRiferimentoIDRichiesta_PD_RequiredRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.pd.riferimentoIdRichiesta.required");
                if (value != null) {
                    value = value.trim();
                    this.isRiferimentoIDRichiesta_PD_Required = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pd.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true'");
                    this.isRiferimentoIDRichiesta_PD_Required = true;
                }
                this.isRiferimentoIDRichiesta_PD_RequiredRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pd.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true', errore:" + e.getMessage());
                this.isRiferimentoIDRichiesta_PD_Required = true;
                this.isRiferimentoIDRichiesta_PD_RequiredRead = true;
            }
        }
        return this.isRiferimentoIDRichiesta_PD_Required;
    }

    public Boolean isRiferimentoIDRichiesta_PA_Required() {
        if (this.isRiferimentoIDRichiesta_PA_RequiredRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.pa.riferimentoIdRichiesta.required");
                if (value != null) {
                    value = value.trim();
                    this.isRiferimentoIDRichiesta_PA_Required = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pa.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true'");
                    this.isRiferimentoIDRichiesta_PA_Required = true;
                }
                this.isRiferimentoIDRichiesta_PA_RequiredRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pa.riferimentoIdRichiesta.required' non impostata, viene utilizzato il default 'true', errore:" + e.getMessage());
                this.isRiferimentoIDRichiesta_PA_Required = true;
                this.isRiferimentoIDRichiesta_PA_RequiredRead = true;
            }
        }
        return this.isRiferimentoIDRichiesta_PA_Required;
    }

    public Boolean isPortaApplicativaBustaErrore_personalizzaElementiFault() {
        if (this.isPortaApplicativaBustaErrore_personalizzaElementiFaultRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.pa.bustaErrore.personalizzaElementiFault");
                if (value != null) {
                    value = value.trim();
                    this.isPortaApplicativaBustaErrore_personalizzaElementiFault = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
                }
                this.isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pa.bustaErrore.personalizzaElementiFault' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isPortaApplicativaBustaErrore_personalizzaElementiFault = null;
                this.isPortaApplicativaBustaErrore_personalizzaElementiFaultRead = true;
            }
        }
        return this.isPortaApplicativaBustaErrore_personalizzaElementiFault;
    }

    public Boolean isPortaApplicativaBustaErrore_aggiungiErroreApplicativo() {
        if (this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.pa.bustaErrore.aggiungiErroreApplicativo");
                if (value != null) {
                    value = value.trim();
                    this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
                }
                this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.pa.bustaErrore.aggiungiErroreApplicativo' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo = null;
                this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativoRead = true;
            }
        }
        return this.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolValidazione() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolValidazione == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneIntestazione");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolValidazione;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolProcessamento == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneProcessamento");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolProcessamento;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationServerError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationServerError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.serverError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true");
                    this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationServerError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationClientError() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationClientError == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.clientError");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationClientError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.stackTrace");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false");
                    this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace;
    }

    public Boolean isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche() {
        if (this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode)");
                    this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                }
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode), errore:" + e.getMessage());
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
        }
        return this.isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.erroreApplicativo.faultApplicativo.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo;
    }

    public BooleanNullable isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        if (this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead == null) {
            try {
                String value = this.reader.getValueConvertEnvProperties("org.openspcoop2.protocol.trasparente.erroreApplicativo.faultPdD.enrichDetails");
                if (value != null) {
                    Boolean b = Boolean.parseBoolean(value = value.trim());
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = b != false ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
                } else {
                    this.log.debug("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails)");
                    this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                }
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'org.openspcoop2.protocol.trasparente.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails), errore:" + e.getMessage());
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdD = BooleanNullable.NULL();
                this.isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
        }
        return this.isAggiungiDetailErroreApplicativo_SoapFaultPdD;
    }

    public Boolean isUtilizzaTestSuiteGenerazioneTracce() {
        if (this.utilizzaTestSuiteGenerazioneTracce == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.trasparente.generazioneTracce.testsuite.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.utilizzaTestSuiteGenerazioneTracce = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.utilizzaTestSuiteGenerazioneTracce = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.utilizzaTestSuiteGenerazioneTracce = defaultValue;
            }
        }
        return this.utilizzaTestSuiteGenerazioneTracce;
    }

    public Boolean isUtilizzaTestSuiteProtocolProperties() {
        if (this.utilizzaTestSuiteProtocolProperties == null) {
            Boolean defaultValue = false;
            String propertyName = "org.openspcoop2.protocol.trasparente.protocolProperties.testsuite.enabled";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.utilizzaTestSuiteProtocolProperties = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.utilizzaTestSuiteProtocolProperties = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.utilizzaTestSuiteProtocolProperties = defaultValue;
            }
        }
        return this.utilizzaTestSuiteProtocolProperties;
    }

    private Boolean useConfigStaticInstance() {
        if (this.useConfigStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.trasparente.factory.config.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useConfigStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useConfigStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useConfigStaticInstance = defaultValue;
            }
        }
        return this.useConfigStaticInstance;
    }

    private Boolean useErroreApplicativoStaticInstance() {
        if (this.useErroreApplicativoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.trasparente.factory.erroreApplicativo.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useErroreApplicativoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useErroreApplicativoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useErroreApplicativoStaticInstance = defaultValue;
            }
        }
        return this.useErroreApplicativoStaticInstance;
    }

    private Boolean useEsitoStaticInstance() {
        if (this.useEsitoStaticInstance == null) {
            Boolean defaultValue = true;
            String propertyName = "org.openspcoop2.protocol.trasparente.factory.esito.staticInstance";
            try {
                String value = this.reader.getValueConvertEnvProperties(propertyName);
                if (value != null) {
                    value = value.trim();
                    this.useEsitoStaticInstance = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue);
                    this.useEsitoStaticInstance = defaultValue;
                }
            }
            catch (Exception e) {
                this.log.debug("Proprieta' di openspcoop '" + propertyName + "' non impostata, viene utilizzato il default=" + defaultValue + ", errore:" + e.getMessage());
                this.useEsitoStaticInstance = defaultValue;
            }
        }
        return this.useEsitoStaticInstance;
    }

    public BasicStaticInstanceConfig getStaticInstanceConfig() {
        if (this.staticInstanceConfig == null) {
            this.staticInstanceConfig = new BasicStaticInstanceConfig();
            if (this.useConfigStaticInstance() != null) {
                this.staticInstanceConfig.setStaticConfig(this.useConfigStaticInstance().booleanValue());
            }
            if (this.useErroreApplicativoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticErrorBuilder(this.useErroreApplicativoStaticInstance().booleanValue());
            }
            if (this.useEsitoStaticInstance() != null) {
                this.staticInstanceConfig.setStaticEsitoBuilder(this.useEsitoStaticInstance().booleanValue());
            }
        }
        return this.staticInstanceConfig;
    }
}

