/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.trasparente.config;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.trasparente.config.InstanceVersioneManager;
import org.openspcoop2.protocol.trasparente.config.TrasparenteProperties;
import org.openspcoop2.protocol.trasparente.config.TrasparenteProtocolManager;

public class TrasparenteProtocolVersionManager
extends TrasparenteProtocolManager
implements IProtocolVersionManager {
    protected String versione;
    private InstanceVersioneManager basicVersionManager;

    public TrasparenteProtocolVersionManager(IProtocolFactory<?> protocolFactory, String versione) throws ProtocolException {
        super(protocolFactory);
        this.versione = versione;
        this.logger = this.getProtocolFactory().getLogger();
        this.trasparenteProperties = TrasparenteProperties.getInstance();
        this.basicVersionManager = new InstanceVersioneManager(protocolFactory);
    }

    public StatoFunzionalitaProtocollo getFiltroDuplicati(Busta busta) {
        return this.basicVersionManager.getFiltroDuplicati(busta);
    }

    public StatoFunzionalitaProtocollo getFiltroDuplicati(Servizio infoServizio) {
        return this.basicVersionManager.getFiltroDuplicati(infoServizio);
    }

    public StatoFunzionalitaProtocollo getConsegnaAffidabile(Busta busta) {
        return this.basicVersionManager.getConsegnaAffidabile(busta);
    }

    public StatoFunzionalitaProtocollo getConsegnaAffidabile(Servizio infoServizio) {
        return this.basicVersionManager.getConsegnaAffidabile(infoServizio);
    }

    public StatoFunzionalitaProtocollo getConsegnaInOrdine(Busta busta) {
        return this.basicVersionManager.getConsegnaInOrdine(busta);
    }

    public StatoFunzionalitaProtocollo getConsegnaInOrdine(Servizio infoServizio) {
        return this.basicVersionManager.getConsegnaInOrdine(infoServizio);
    }

    public StatoFunzionalitaProtocollo getCollaborazione(Busta busta) {
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getCollaborazione(Servizio infoServizio) {
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getIdRiferimentoRichiesta(Busta busta) {
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getIdRiferimentoRichiesta(Servizio infoServizio) {
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public boolean isCorrelazioneRichiestaPresenteRispostaAsincronaSimmetrica() {
        return this.basicVersionManager.isCorrelazioneRichiestaPresenteRispostaAsincronaSimmetrica();
    }

    public boolean isCorrelazioneRichiestaPresenteRichiestaStatoAsincronaAsimmetrica() {
        return this.basicVersionManager.isCorrelazioneRichiestaPresenteRichiestaStatoAsincronaAsimmetrica();
    }

    public boolean isGenerazioneInformazioniServizioCorrelatoAsincronoSimmetrico() {
        return this.basicVersionManager.isGenerazioneInformazioniServizioCorrelatoAsincronoSimmetrico();
    }

    public boolean isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico() {
        return this.basicVersionManager.isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico();
    }

    public String getIdCorrelazioneAsincrona(Busta richiesta) {
        return this.basicVersionManager.getIdCorrelazioneAsincrona(richiesta);
    }

    public String getIdCorrelazioneAsincrona(String rifMsg, String collaborazione) {
        return this.basicVersionManager.getIdCorrelazioneAsincrona(rifMsg, collaborazione);
    }

    public boolean isEccezioniLivelloInfoAbilitato() {
        return this.basicVersionManager.isEccezioniLivelloInfoAbilitato();
    }

    public boolean isIgnoraEccezioniLivelloNonGrave() {
        return this.basicVersionManager.isIgnoraEccezioniLivelloNonGrave();
    }

    public boolean isGenerazioneBusteErrore_strutturaMalformataHeaderProtocollo() {
        return this.basicVersionManager.isGenerazioneBusteErrore_strutturaMalformataHeaderProtocollo();
    }

    public boolean isGenerazioneErroreMessaggioOnewayDuplicato() {
        return this.basicVersionManager.isGenerazioneErroreMessaggioOnewayDuplicato();
    }

    public Connettore getStaticRoute(IDSoggetto idSoggettoMittente, IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException {
        return this.basicVersionManager.getStaticRoute(idSoggettoMittente, idServizio, registryReader);
    }

    public boolean isUtilizzoIndirizzoSoggettoPresenteBusta() {
        return this.basicVersionManager.isUtilizzoIndirizzoSoggettoPresenteBusta();
    }
}

