/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.eventi.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.core.eventi.dao.IDBEventoServiceSearch;
import org.openspcoop2.core.eventi.dao.IEventoServiceSearch;
import org.openspcoop2.core.eventi.dao.IServiceManager;
import org.openspcoop2.core.eventi.utils.ProjectInfo;
import org.openspcoop2.core.eventi.utils.SeveritaConverter;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.Index;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.thread.ThreadExecutorManager;
import org.openspcoop2.web.monitor.eventi.bean.EventiSearchForm;
import org.openspcoop2.web.monitor.eventi.bean.EventoBean;
import org.openspcoop2.web.monitor.eventi.dao.IEventiService;
import org.slf4j.Logger;

public class EventiService
implements IEventiService {
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private IServiceManager pluginsServiceManager = null;
    private IEventoServiceSearch eventiDao = null;
    private EventiSearchForm searchForm = null;
    private boolean timeoutEvent = false;
    private Integer timeoutRicerche = null;
    private List<Index> forceIndexFindAll;
    private List<Index> forceIndexCount;

    private void initForceIndex(PddMonitorProperties govwayMonitorProperties) throws Exception {
        Properties repositoryExternal = govwayMonitorProperties.getExternalForceIndexRepository();
        this.forceIndexFindAll = this.convertForceIndexList(govwayMonitorProperties.getEventiForceIndexFindAll(repositoryExternal));
        this.forceIndexCount = this.convertForceIndexList(govwayMonitorProperties.getEventiForceIndexCount(repositoryExternal));
    }

    private List<Index> convertForceIndexList(List<String> l) {
        if (l != null && l.size() > 0) {
            ArrayList<Index> li = new ArrayList<Index>();
            for (String index : l) {
                li.add(new Index((IModel)Evento.model(), index));
            }
            return li;
        }
        return null;
    }

    public EventiService() {
        try {
            this.pluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            this.eventiDao = this.pluginsServiceManager.getEventoServiceSearch();
            this.initForceIndex(PddMonitorProperties.getInstance((Logger)log));
            this.timeoutRicerche = PddMonitorProperties.getInstance((Logger)log).getIntervalloTimeoutRicercaEventi();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public EventiService(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public EventiService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public EventiService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public EventiService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.pluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.eventiDao = this.pluginsServiceManager.getEventoServiceSearch();
            this.initForceIndex(PddMonitorProperties.getInstance((Logger)EventiService.log));
            this.timeoutRicerche = PddMonitorProperties.getInstance((Logger)EventiService.log).getIntervalloTimeoutRicercaEventi();
        }
        catch (Exception e) {
            EventiService.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setSearch(EventiSearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public EventiSearchForm getSearch() {
        return this.searchForm;
    }

    public List<EventoBean> findAll(int start, int limit) {
        log.debug("Metodo FindAll: start[" + start + "], limit: [" + limit + "]");
        try {
            IExpression expr = this.getExpressionFromFilter(this.eventiDao);
            IPaginatedExpression pagExpr = this.eventiDao.toPaginatedExpression(expr);
            pagExpr.offset(start).limit(limit);
            pagExpr.sortOrder(SortOrder.DESC).addOrder(Evento.model().ORA_REGISTRAZIONE);
            List<Index> forceIndexFindAll = this.forceIndexFindAll;
            if (forceIndexFindAll != null && forceIndexFindAll.size() > 0) {
                for (Index index : forceIndexFindAll) {
                    pagExpr.addForceIndex(index);
                }
            }
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.eventiDao.findAll(pagExpr);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.eventiDao.findAll(pagExpr)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (list != null && list.size() > 0) {
                ArrayList<EventoBean> wrappedList = new ArrayList<EventoBean>();
                for (Evento evento : list) {
                    wrappedList.add(new EventoBean(evento));
                }
                return wrappedList;
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<EventoBean>();
    }

    public int totalCount() {
        log.debug("Metodo TotalCount");
        try {
            NonNegativeNumber nnn;
            IExpression expr = this.getExpressionFromFilter(this.eventiDao);
            List<Index> forceIndexFindAll = this.forceIndexCount;
            if (forceIndexFindAll != null && forceIndexFindAll.size() > 0) {
                for (Index index : forceIndexFindAll) {
                    expr.addForceIndex(index);
                }
            }
            if ((nnn = this.eventiDao.count(expr)) != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public void store(EventoBean evento) throws Exception {
    }

    public void deleteById(Long key) {
    }

    public void delete(EventoBean obj) throws Exception {
    }

    public void deleteAll() throws Exception {
    }

    public EventoBean findById(Long key) {
        EventoBean bean = null;
        try {
            bean = this.findById(key, false);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return bean;
    }

    public EventoBean findById(Long key, boolean throwNotFound) throws NotFoundException {
        log.debug("Metodo FindById: [" + key + "]");
        try {
            IDBEventoServiceSearch search = (IDBEventoServiceSearch)this.eventiDao;
            Evento evento = (Evento)search.get(key.longValue());
            if (evento != null) {
                return new EventoBean(evento);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            if (throwNotFound) {
                throw e;
            }
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public List<EventoBean> findAll() {
        log.debug("Metodo FindAll");
        try {
            IExpression expr = this.getExpressionFromFilter(this.eventiDao);
            IPaginatedExpression pagExpr = this.eventiDao.toPaginatedExpression(expr);
            pagExpr.sortOrder(SortOrder.DESC).addOrder(Evento.model().ORA_REGISTRAZIONE);
            List<Index> forceIndexFindAll = this.forceIndexFindAll;
            if (forceIndexFindAll != null && forceIndexFindAll.size() > 0) {
                for (Index index : forceIndexFindAll) {
                    pagExpr.addForceIndex(index);
                }
            }
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.eventiDao.findAll(pagExpr);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.eventiDao.findAll(pagExpr)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (list != null && list.size() > 0) {
                ArrayList<EventoBean> wrappedList = new ArrayList<EventoBean>();
                for (Evento evento : list) {
                    wrappedList.add(new EventoBean(evento));
                }
                return wrappedList;
            }
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<EventoBean>();
    }

    public IExpression getExpressionFromFilter(IEventoServiceSearch dao) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        TipoMatch match;
        CaseSensitiveMatch caseSensitiveMatch;
        TipoSeverita tipoSev;
        IExpression expr = dao.newExpression();
        if (this.searchForm == null) {
            return expr;
        }
        expr.and();
        if (this.searchForm.getDataInizio() != null) {
            expr.and().greaterEquals(Evento.model().ORA_REGISTRAZIONE, (Object)this.searchForm.getDataInizio());
        }
        if (this.searchForm.getDataFine() != null) {
            expr.and().lessEquals(Evento.model().ORA_REGISTRAZIONE, (Object)this.searchForm.getDataFine());
        }
        if (this.searchForm.getDataRicerca() != null) {
            expr.lessEquals(Evento.model().ORA_REGISTRAZIONE, (Object)this.searchForm.getDataRicerca());
        }
        if (this.searchForm.getSeverita() != null && (tipoSev = TipoSeverita.toEnumConstant((String)this.searchForm.getSeverita())) != null) {
            try {
                expr.lessEquals(Evento.model().SEVERITA, (Object)SeveritaConverter.toIntValue((TipoSeverita)tipoSev));
            }
            catch (Exception e) {
                throw new ExpressionException(e.getMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.searchForm.getTipo())) {
            expr.equals(Evento.model().TIPO, (Object)this.searchForm.getTipo().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.searchForm.getCodice())) {
            expr.equals(Evento.model().CODICE, (Object)this.searchForm.getCodice().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.searchForm.getIdConfigurazione())) {
            caseSensitiveMatch = CaseSensitiveMatch.valueOf((String)this.searchForm.getCaseSensitiveType());
            match = TipoMatch.valueOf((String)this.searchForm.getMatchingType());
            if (TipoMatch.LIKE.equals((Object)match)) {
                if (CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch)) {
                    expr.like(Evento.model().ID_CONFIGURAZIONE, this.searchForm.getIdConfigurazione().trim(), LikeMode.ANYWHERE);
                } else {
                    expr.ilike(Evento.model().ID_CONFIGURAZIONE, this.searchForm.getIdConfigurazione().trim(), LikeMode.ANYWHERE);
                }
            } else if (CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch)) {
                expr.equals(Evento.model().ID_CONFIGURAZIONE, (Object)this.searchForm.getIdConfigurazione().trim());
            } else {
                expr.ilike(Evento.model().ID_CONFIGURAZIONE, this.searchForm.getIdConfigurazione().trim(), LikeMode.EXACT);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.searchForm.getIdCluster())) {
            caseSensitiveMatch = CaseSensitiveMatch.valueOf((String)this.searchForm.getCaseSensitiveType());
            match = TipoMatch.valueOf((String)this.searchForm.getMatchingType());
            if (TipoMatch.LIKE.equals((Object)match)) {
                if (CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch)) {
                    expr.like(Evento.model().CLUSTER_ID, this.searchForm.getIdCluster().trim(), LikeMode.ANYWHERE);
                } else {
                    expr.ilike(Evento.model().CLUSTER_ID, this.searchForm.getIdCluster().trim(), LikeMode.ANYWHERE);
                }
            } else if (CaseSensitiveMatch.SENSITIVE.equals((Object)caseSensitiveMatch)) {
                expr.equals(Evento.model().CLUSTER_ID, (Object)this.searchForm.getIdCluster().trim());
            } else {
                expr.ilike(Evento.model().CLUSTER_ID, this.searchForm.getIdCluster().trim(), LikeMode.EXACT);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.searchForm.getCanale())) {
            List listId = Utility.getNodi((String)this.searchForm.getCanale());
            if (listId != null && !listId.isEmpty()) {
                expr.and().in(Evento.model().CLUSTER_ID, (Collection)listId);
            } else {
                expr.and().equals(Evento.model().CLUSTER_ID, (Object)"--");
            }
        }
        return expr;
    }

    @Override
    public boolean isTimeoutEvent() {
        return this.timeoutEvent;
    }
}

