/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.utils.Costanti;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.web.ctrlstat.costanti.CostantiUtilities;
import org.openspcoop2.web.ctrlstat.costanti.TipoProperties;
import org.slf4j.Logger;

public class ControlStationLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Logger logConsole, String rootDirectory, String confPropertyName, String confLocalPathPrefix, Properties objectProperties, boolean appendActualConfiguration) throws IOException, UtilsException {
        String value;
        String key;
        Enumeration<Object> ridefinito;
        Properties loggerProperties = new Properties();
        File loggerFile = null;
        loggerFile = rootDirectory != null ? new File(rootDirectory + "console.log4j2.properties") : new File("console.log4j2.properties");
        if (!loggerFile.exists()) {
            loggerProperties.load(OpenSPCoop2Logger.class.getResourceAsStream("/console.log4j2.properties"));
        } else {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(loggerFile);
                loggerProperties.load(fin);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        CollectionProperties loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)logConsole, (String)CostantiUtilities.get_PROPERTY_NAME(TipoProperties.LOGGER, confPropertyName), (String)CostantiUtilities.get_LOCAL_PATH(TipoProperties.LOGGER, confLocalPathPrefix), (String)rootDirectory);
        if (loggerPropertiesRidefinito != null && loggerPropertiesRidefinito.size() > 0) {
            ridefinito = loggerPropertiesRidefinito.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = loggerPropertiesRidefinito.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
        if (objectProperties != null && objectProperties.size() > 0) {
            ridefinito = objectProperties.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = (String)objectProperties.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
        LoggerWrapperFactory.patchLoggers((Properties)loggerProperties, (Map)Costanti.ENV_LOG_CONSOLE, Map.of("appName", "govwayConsole"));
        if (appendActualConfiguration) {
            System.out.println("[govwayConsole] Attendo inizializzazione GovWay prima di appender la configurazione Log4J ...");
            int i = 0;
            int limit = 60;
            while (!OpenSPCoop2Startup.initialize && i < limit) {
                Utilities.sleep((long)1000L);
                if (++i % 10 != 0) continue;
                System.out.println("[govwayConsole] Attendo inizializzazione GovWay ...");
            }
            if (!OpenSPCoop2Startup.initialize) {
                throw new UtilsException("[govwayConsole] Inizializzazione GovWay non rilevata");
            }
            System.out.println("[govwayConsole] Configurazione Log4J ...");
            LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties, (boolean)true);
            System.out.println("[govwayConsole] Configurazione Log4J aggiunta");
        } else {
            LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties);
        }
    }

    public static Logger getPddConsoleCoreLogger() {
        return LoggerWrapperFactory.getLogger((String)"govwayConsole.core");
    }

    public static Logger getSmistatoreLogger() {
        return LoggerWrapperFactory.getLogger((String)"govwayConsole.gestori.smistatore");
    }

    public static Logger getGestorePddLogger() {
        return LoggerWrapperFactory.getLogger((String)"govwayConsole.gestori.config");
    }

    public static Logger getGestoreGELogger() {
        return LoggerWrapperFactory.getLogger((String)"govwayConsole.gestori.gestoreEventi");
    }

    public static Logger getGestoreRegistroLogger() {
        return LoggerWrapperFactory.getLogger((String)"govwayConsole.gestori.registry");
    }

    public static Logger getGestoreAutorizzazioneLogger() {
        return LoggerWrapperFactory.getLogger((String)"govwayConsole.gestori.auth");
    }

    public static Logger getDriverDBPddConsoleLogger() {
        return LoggerWrapperFactory.getLogger((String)"DRIVER_DB_PDD_CONSOLE");
    }

    public static Logger getSincronizzatoreLogger() {
        return LoggerWrapperFactory.getLogger((String)"govwayConsole.sincronizzatore");
    }
}

