/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.util.Properties;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.tracciamento.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.web.ctrlstat.config.DatasourceProperties;
import org.slf4j.Logger;

public class DAOConsolePropertiesFactory
extends DAOFactoryProperties {
    public DAOConsolePropertiesFactory(Logger log) throws Exception {
        super(log);
    }

    private boolean isDiag(IProjectInfo tipoDAO) {
        return ProjectInfo.getInstance().getProjectName().equals(tipoDAO.getProjectName()) || org.openspcoop2.core.statistiche.utils.ProjectInfo.getInstance().getProjectName().equals(tipoDAO.getProjectName()) || org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance().getProjectName().equals(tipoDAO.getProjectName()) || org.openspcoop2.core.diagnostica.utils.ProjectInfo.getInstance().getProjectName().equals(tipoDAO.getProjectName());
    }

    public String getTipoDatabase(IProjectInfo tipoDAO) throws Exception {
        if (this.isDiag(tipoDAO)) {
            return super.getTipoDatabase(tipoDAO);
        }
        return DatasourceProperties.getInstance().getTipoDatabase();
    }

    public String getTipoAccessoDatabase(IProjectInfo tipoDAO) throws Exception {
        if (this.isDiag(tipoDAO)) {
            return super.getTipoAccessoDatabase(tipoDAO);
        }
        return "datasource";
    }

    public String getDatasourceJNDIName(IProjectInfo tipoDAO) throws Exception {
        if (this.isDiag(tipoDAO)) {
            return super.getDatasourceJNDIName(tipoDAO);
        }
        return DatasourceProperties.getInstance().getDataSource();
    }

    public Properties getDatasourceJNDIContext(IProjectInfo tipoDAO) throws Exception {
        if (this.isDiag(tipoDAO)) {
            return super.getDatasourceJNDIContext(tipoDAO);
        }
        return DatasourceProperties.getInstance().getDataSourceContext();
    }
}

