/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openapi4j.parser.validation.v3.OpenApi3Validator;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.XMLDiff;
import org.openspcoop2.monitor.engine.alarm.AlarmConfigProperties;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.AlarmManager;
import org.openspcoop2.monitor.engine.dynamic.CorePluginLoader;
import org.openspcoop2.monitor.engine.dynamic.IRegistroPluginsReader;
import org.openspcoop2.monitor.engine.dynamic.PluginLoader;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeProperties;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.logger.filetrace.FileTraceGovWayState;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.basic.archive.BasicArchive;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.json.YamlSnakeLimits;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.utils.xml.XMLDiffImplType;
import org.openspcoop2.utils.xml.XMLDiffOptions;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.config.DatasourceProperties;
import org.openspcoop2.web.ctrlstat.config.RegistroServiziRemotoProperties;
import org.openspcoop2.web.ctrlstat.core.Connettori;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.core.GestoreConsistenzaDati;
import org.openspcoop2.web.ctrlstat.core.InitRuntimeConfigReader;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB_LIB;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneRegistroPluginsReader;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementParameter;
import org.openspcoop2.web.lib.mvc.login.FailedAttempts;
import org.slf4j.Logger;

public class InitListener
implements ServletContextListener {
    protected static Logger log = null;
    private static final Semaphore semaphoreInitListener = new Semaphore("InitListener");
    private static boolean initialized = false;
    private static FileTraceGovWayState fileTraceGovWayState;
    private GestoreConsistenzaDati gestoreConsistenzaDati;
    private InitRuntimeConfigReader initRuntimeConfigReader;

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        InitListener.log = log;
    }

    static void logDebug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    static void logDebug(String msg, Throwable e) {
        if (log != null) {
            log.debug(msg, e);
        }
    }

    static void logInfo(String msg) {
        if (log != null) {
            log.info(msg);
        }
    }

    static void logError(String msg) {
        if (log != null) {
            log.error(msg);
        }
    }

    static void logError(String msg, Throwable e) {
        if (log != null) {
            log.error(msg, e);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void setInitialized(boolean initialized) {
        InitListener.initialized = initialized;
    }

    static void setFileTraceGovWayState(FileTraceGovWayState fileTraceGovWayState) {
        InitListener.fileTraceGovWayState = fileTraceGovWayState;
    }

    public static FileTraceGovWayState getFileTraceGovWayState() {
        return fileTraceGovWayState;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        InitListener.logInfo("Undeploy govwayConsole in corso...");
        InitListener.setInitialized(false);
        if (this.gestoreConsistenzaDati != null) {
            this.gestoreConsistenzaDati.setStop(true);
            int limite = 60;
            for (int index = 0; GestoreConsistenzaDati.gestoreConsistenzaDatiInEsecuzione && index < limite; ++index) {
                Utilities.sleep((long)1000L);
            }
        }
        if (this.initRuntimeConfigReader != null) {
            this.initRuntimeConfigReader.setStop(true);
        }
        try {
            CorePluginLoader.close((Logger)log);
        }
        catch (Exception e) {
            String msgErrore = "Errore durante la chiusura del loader dei plugins: " + e.getMessage();
            InitListener.logError(msgErrore, e);
        }
        InitListener.logInfo("Undeploy govwayConsole effettuato.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        SemaphoreLock lock = semaphoreInitListener.acquireThrowRuntime("contextInitialized");
        try {
            String msgErrore;
            File f;
            String msgErrore2;
            if (initialized) {
                return;
            }
            String confDir = null;
            String confPropertyName = null;
            String confLocalPathPrefix = null;
            boolean appendActualConfiguration = false;
            try (InputStream is2 = InitListener.class.getResourceAsStream("/console.properties");){
                if (is2 != null) {
                    String tmpAppendActualConfiguration;
                    Properties p = new Properties();
                    p.load(is2);
                    confDir = p.getProperty("confDirectory");
                    if (confDir != null) {
                        confDir = confDir.trim();
                    }
                    if ((confPropertyName = p.getProperty("confPropertyName")) != null) {
                        confPropertyName = confPropertyName.trim();
                    }
                    if ((confLocalPathPrefix = p.getProperty("confLocalPathPrefix")) != null) {
                        confLocalPathPrefix = confLocalPathPrefix.trim();
                    }
                    if ((tmpAppendActualConfiguration = p.getProperty("appendLog4j")) != null) {
                        appendActualConfiguration = "true".equalsIgnoreCase(tmpAppendActualConfiguration.trim());
                    }
                }
            }
            catch (Exception is2) {
                // empty catch block
            }
            try {
                ControlStationLogger.initialize(log, confDir, confPropertyName, confLocalPathPrefix, null, appendActualConfiguration);
                InitListener.setLog(ControlStationLogger.getPddConsoleCoreLogger());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione resources (properties) govwayConsole in corso...");
            ConsoleProperties consoleProperties = null;
            try {
                if (!ConsoleProperties.initialize(confDir, confPropertyName, confLocalPathPrefix, log)) {
                    throw new UtilsException("ConsoleProperties not initialized");
                }
                consoleProperties = ConsoleProperties.getInstance();
                if (!DatasourceProperties.initialize(confDir, confPropertyName, confLocalPathPrefix, log)) {
                    throw new UtilsException("DatasourceProperties not initialized");
                }
                if (!(consoleProperties.isSinglePddRegistroServiziLocale() != null && consoleProperties.isSinglePddRegistroServiziLocale().booleanValue() || RegistroServiziRemotoProperties.initialize(confDir, confPropertyName, confLocalPathPrefix, log))) {
                    throw new UtilsException("RegistroServiziRemotoProperties not initialized");
                }
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione resources (properties) govwayConsole effettuata con successo.");
            try {
                if (!consoleProperties.isLoginApplication() && (consoleProperties.getLoginTipo() == null || StringUtils.isEmpty((CharSequence)consoleProperties.getLoginTipo()))) {
                    throw new UtilsException("Con login applicativo disabilitato (login.application=false) deve essere obbligatoriamente definito un tipo di login tramite la propriet\u00e0 'login.tipo'");
                }
            }
            catch (Exception e) {
                msgErrore2 = "Configurazione login errata: " + e.getMessage();
                InitListener.logError(msgErrore2, e);
                throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
            }
            try {
                if (consoleProperties.getConnettoriRemoteAccessUtilityLibrary() != null) {
                    HttpLibraryConnection.setDefaultLibrary((HttpLibrary)consoleProperties.getConnettoriRemoteAccessUtilityLibrary());
                }
                InitListener.logInfo("HttpLibraryConnection: " + String.valueOf(HttpLibraryConnection.getDefaultLibrary()));
            }
            catch (Exception e) {
                msgErrore2 = "Inizializzazione libreria accesso risorse esterne non riuscita: " + e.getMessage();
                InitListener.logError(msgErrore2, e);
                throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
            }
            try {
                Logger logR = ControlStationLogger.getPddConsoleCoreLogger() != null ? ControlStationLogger.getPddConsoleCoreLogger() : log;
                ServicesUtils.initCheckConnectionDB((Logger)logR, (boolean)consoleProperties.isJdbcCloseConnectionCheckIsClosed(), (boolean)consoleProperties.isJdbcCloseConnectionCheckAutocommit());
                DriverControlStationDB.setCheckLogger(logR);
                DriverControlStationDB.setCheckIsClosed(consoleProperties.isJdbcCloseConnectionCheckIsClosed());
                DriverControlStationDB.setCheckAutocommit(consoleProperties.isJdbcCloseConnectionCheckAutocommit());
                DBManager.setCheckLogger(logR);
                DBManager.setCheckIsClosed(consoleProperties.isJdbcCloseConnectionCheckIsClosed());
                DBManager.setCheckAutocommit(consoleProperties.isJdbcCloseConnectionCheckAutocommit());
            }
            catch (Exception e) {
                msgErrore2 = "Inizializzazione controlli connessione non riuscita: " + e.getMessage();
                InitListener.logError(msgErrore2, e);
                throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
            }
            try {
                String mapConfig = consoleProperties.getEnvMapConfig();
                if (StringUtils.isNotEmpty((CharSequence)mapConfig)) {
                    InitListener.logInfo("Inizializzazione environment in corso...");
                    MapProperties.initialize((Logger)log, (String)mapConfig, (boolean)consoleProperties.isEnvMapConfigRequired());
                    MapProperties mapProperties = MapProperties.getInstance();
                    mapProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + String.valueOf(mapProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(mapProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + String.valueOf(mapProperties.getObfuscatedJavaKeys()) + "\n\tObfuscatedEnvKeys: " + String.valueOf(mapProperties.getObfuscatedEnvKeys());
                    InitListener.logInfo(msgInit);
                }
            }
            catch (Exception e) {
                msgErrore2 = "Inizializzazione ambiente non riuscita: " + e.getMessage();
                InitListener.logError(msgErrore2, e);
                throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
            }
            try {
                if (consoleProperties.isSecurityLoadBouncyCastle()) {
                    ProviderUtils.addBouncyCastleAfterSun((boolean)true);
                    InitListener.logInfo("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
                }
            }
            catch (Exception e) {
                msgErrore2 = "Errore durante l'aggiunta dei security provider: " + e.getMessage();
                InitListener.logError(msgErrore2, e);
                throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
            }
            try {
                String hsmConfig = consoleProperties.getHSMConfigurazione();
                if (StringUtils.isNotEmpty((CharSequence)hsmConfig)) {
                    InitListener.logInfo("Inizializzazione HSM in corso...");
                    f = new File(hsmConfig);
                    HSMManager.init((File)f, (boolean)consoleProperties.isHSMRequired(), (Logger)log, (boolean)false);
                    HSMUtils.setHsmConfigurableKeyPassword((boolean)consoleProperties.isHSMKeyPasswordConfigurable());
                    InitListener.logInfo("Inizializzazione HSM effettuata con successo");
                }
            }
            catch (Exception e) {
                msgErrore2 = "Errore durante l'inizializzazione del manager HSM: " + e.getMessage();
                InitListener.logError(msgErrore2, e);
                throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
            }
            try {
                String ocspConfig = consoleProperties.getOCSPConfigurazione();
                if (StringUtils.isNotEmpty((CharSequence)ocspConfig)) {
                    InitListener.logInfo("Inizializzazione OCSP in corso...");
                    f = new File(ocspConfig);
                    OCSPManager.init((File)f, (boolean)consoleProperties.isOCSPRequired(), (boolean)consoleProperties.isOCSPLoadDefault(), (Logger)log);
                    InitListener.logInfo("Inizializzazione OCSP effettuata con successo");
                }
            }
            catch (Exception e) {
                msgErrore2 = "Errore durante l'inizializzazione del manager OCSP: " + e.getMessage();
                InitListener.logError(msgErrore2, e);
                throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
            }
            BYOKManager byokManager = null;
            try {
                String byokConfig = consoleProperties.getBYOKConfig();
                if (StringUtils.isNotEmpty((CharSequence)byokConfig)) {
                    InitListener.logInfo("Inizializzazione BYOK in corso...");
                    File f2 = new File(byokConfig);
                    BYOKManager.init((File)f2, (boolean)consoleProperties.isBYOKConfigRequired(), (Logger)log);
                    byokManager = BYOKManager.getInstance();
                    BYOKProvider.setUnwrapKeystoreFileEnabled((boolean)consoleProperties.isConsoleBYOKShowUnwrapPolicy());
                    String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + String.valueOf(byokManager.getKeystoreTypes()) + "\n\tSecurityEngine registrati: " + String.valueOf(byokManager.getSecurityEngineTypes()) + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription() + "\n\tVisualizza informazioni cifrate: " + consoleProperties.isVisualizzaInformazioniCifrate() + "\n\tVisualizza policy unwrap: " + consoleProperties.isConsoleBYOKShowUnwrapPolicy();
                    InitListener.logInfo(msgInit);
                }
            }
            catch (Exception e) {
                String msgErrore3 = "Errore durante l'inizializzazione del manager BYOK: " + e.getMessage();
                InitListener.logError(msgErrore3, e);
                throw new UtilsRuntimeException(msgErrore3, (Throwable)e);
            }
            boolean reInitSecretMaps = false;
            try {
                String secretsConfig = consoleProperties.getBYOKEnvSecretsConfig();
                if (byokManager != null && StringUtils.isNotEmpty((CharSequence)secretsConfig)) {
                    InitListener.logInfo("Inizializzazione secrets in corso...");
                    boolean useSecurityEngine = true;
                    HashMap dynamicMap = new HashMap();
                    DynamicInfo dynamicInfo = new DynamicInfo();
                    DynamicUtils.fillDynamicMap((Logger)log, dynamicMap, (DynamicInfo)dynamicInfo);
                    if (byokManager.isBYOKRemoteGovWayNodeUnwrapConfig()) {
                        reInitSecretMaps = true;
                        useSecurityEngine = false;
                    }
                    BYOKMapProperties.initialize((Logger)log, (String)secretsConfig, (boolean)consoleProperties.isBYOKEnvSecretsConfigRequired(), (boolean)useSecurityEngine, dynamicMap, (boolean)true);
                    BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                    secretsProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + String.valueOf(secretsProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(secretsProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                    InitListener.logInfo(msgInit);
                }
            }
            catch (Exception e) {
                String msgErrore4 = "Inizializzazione ambiente (secrets) non riuscita: " + e.getMessage();
                InitListener.logError(msgErrore4, e);
                throw new UtilsRuntimeException(msgErrore4, (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione NodiRuntime in corso...");
            try {
                ConfigurazioneNodiRuntimeProperties backwardCompatibility = new ConfigurazioneNodiRuntimeProperties(consoleProperties.getJmxPdDBackwardCompatibilityPrefix(), consoleProperties.getJmxPdDBackwardCompatibilityProperties());
                ConfigurazioneNodiRuntime.initialize((String)consoleProperties.getJmxPdDExternalConfiguration(), (ConfigurazioneNodiRuntimeProperties[])new ConfigurazioneNodiRuntimeProperties[]{backwardCompatibility});
            }
            catch (Exception e) {
                String msgErrore5 = "Errore durante l'inizializzazione del gestore dei nodi run: " + e.getMessage();
                InitListener.logError(msgErrore5, e);
                throw new UtilsRuntimeException(msgErrore5, (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione NodiRuntime effettuata con successo");
            InitListener.logInfo("Inizializzazione ExtendedInfoManager in corso...");
            try {
                ExtendedInfoManager.initialize((Loader)new Loader(), (String)consoleProperties.getExtendedInfoDriverConfigurazione(), (String)consoleProperties.getExtendedInfoDriverPortaDelegata(), (String)consoleProperties.getExtendedInfoDriverPortaApplicativa());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione ExtendedInfoManager effettuata con successo");
            InitListener.logInfo("Inizializzazione resources govwayConsole in corso...");
            try {
                Connettori.initialize(log);
                DriverControlStationDB_LIB.initialize(log);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione resources govwayConsole effettuata con successo.");
            InitListener.logInfo("Inizializzazione YAML Limits in corso...");
            try {
                Properties yamlSnakeLimits = consoleProperties.getApiYamlSnakeLimits();
                if (yamlSnakeLimits != null && !yamlSnakeLimits.isEmpty()) {
                    YamlSnakeLimits.initialize((Logger)log, (Properties)yamlSnakeLimits);
                }
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione YAML Limits con successo");
            InitListener.logInfo("Inizializzazione XMLDiff in corso...");
            try {
                XMLDiff diff = new XMLDiff(OpenSPCoop2MessageFactory.getDefaultMessageFactory());
                diff.initialize(XMLDiffImplType.XML_UNIT, new XMLDiffOptions());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione XMLDiff effettuata con successo");
            try {
                InitListener.logInfo("Inizializzazione DiskFileItem (opzione serializable), in corso...");
                System.setProperty("org.apache.commons.fileupload.disk.DiskFileItem.serializable", "true");
                InitListener.logInfo("Inizializzazione DiskFileItem (opzione serializable), effettuata.");
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione keystore config in corso...");
            try {
                DBUtils.setKeystoreJksPasswordRequired((boolean)consoleProperties.isKeystoreJksPasswordRequired());
                DBUtils.setKeystoreJksKeyPasswordRequired((boolean)consoleProperties.isKeystoreJksKeyPasswordRequired());
                DBUtils.setKeystorePkcs12PasswordRequired((boolean)consoleProperties.isKeystorePkcs12PasswordRequired());
                DBUtils.setKeystorePkcs12KeyPasswordRequired((boolean)consoleProperties.isKeystorePkcs12KeyPasswordRequired());
                DBUtils.setTruststoreJksPasswordRequired((boolean)consoleProperties.isTruststoreJksPasswordRequired());
                DBUtils.setTruststorePkcs12PasswordRequired((boolean)consoleProperties.isTruststorePkcs12PasswordRequired());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione keystore config effettuata con successo");
            try {
                if (consoleProperties.isGestoreConsistenzaDatiEnabled()) {
                    this.gestoreConsistenzaDati = new GestoreConsistenzaDati(consoleProperties.isGestoreConsistenzaDatiForceCheckMapping());
                    new Thread(this.gestoreConsistenzaDati).start();
                    InitListener.logInfo("Gestore Controllo Consistenza Dati avviato con successo.");
                } else {
                    InitListener.logInfo("Gestore Controllo Consistenza Dati disabilitato.");
                }
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione DataElement in corso...");
            try {
                int consoleLunghezzaLabel = consoleProperties.getConsoleLunghezzaLabel();
                int numeroColonneTextArea = consoleProperties.getConsoleNumeroColonneDefaultTextArea();
                DataElementParameter dep = new DataElementParameter();
                dep.setSize(Integer.valueOf(consoleLunghezzaLabel));
                dep.setCols(Integer.valueOf(numeroColonneTextArea));
                DataElement.initialize((DataElementParameter)dep);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            InitListener.logInfo("Inizializzazione DataElement effettuata con successo");
            ServletContext servletContext = sce.getServletContext();
            InputStream isFont = null;
            try {
                String fontFileName = ConsoleProperties.getInstance().getConsoleFont();
                InitListener.logDebug("Caricato Font dal file: [" + fontFileName + "] in corso... ");
                isFont = servletContext.getResourceAsStream("/fonts/" + fontFileName);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Font fontCaricato = Font.createFont(0, isFont);
                InitListener.logDebug("Caricato Font: [" + fontCaricato.getName() + "] FontName: [" + fontCaricato.getFontName() + "] FontFamily: [" + fontCaricato.getFamily() + "] FontStyle: [" + fontCaricato.getStyle() + "]");
                ge.registerFont(fontCaricato);
                InitListener.logDebug("Check Graphics Environment: is HeadeLess [" + GraphicsEnvironment.isHeadless() + "]");
                InitListener.logDebug("Elenco Nomi Font disponibili: " + String.valueOf(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())));
                ConsoleProperties.getInstance().setConsoleFontName(fontCaricato.getName());
                ConsoleProperties.getInstance().setConsoleFontFamilyName(fontCaricato.getFamily());
                ConsoleProperties.getInstance().setConsoleFontStyle(fontCaricato.getStyle());
                InitListener.logDebug("Caricato Font dal file: [" + fontFileName + "] completato.");
            }
            catch (Exception e) {
                InitListener.logError(e.getMessage(), e);
            }
            finally {
                if (isFont != null) {
                    try {
                        isFont.close();
                    }
                    catch (IOException e) {}
                }
            }
            try {
                if (consoleProperties.isConfigurazionePluginsEnabled() != null && consoleProperties.isConfigurazionePluginsEnabled().booleanValue()) {
                    CorePluginLoader.initialize((Loader)new Loader(), (Logger)log, PluginLoader.class, (IRegistroPluginsReader)new ConfigurazioneRegistroPluginsReader(new ControlStationCore()), (int)consoleProperties.getPluginsSeconds());
                }
                if (consoleProperties.isConfigurazioneAllarmiEnabled() != null && consoleProperties.isConfigurazioneAllarmiEnabled().booleanValue()) {
                    AlarmEngineConfig alarmEngineConfig = AlarmConfigProperties.getAlarmConfiguration((Logger)log, (String)consoleProperties.getAllarmiConfigurazione(), (String)consoleProperties.getConfDirectory());
                    AlarmManager.setAlarmEngineConfig((AlarmEngineConfig)alarmEngineConfig);
                    CostantiDB.setAllarmiEnabled((boolean)true);
                }
            }
            catch (Exception e) {
                msgErrore = "Errore durante l'inizializzazione del loader dei plugins: " + e.getMessage();
                InitListener.logError(msgErrore, e);
                throw new UtilsRuntimeException(msgErrore, (Throwable)e);
            }
            try {
                OpenApi3Validator.VALIDATE_URI_REFERENCE_AS_URL = consoleProperties.isApiOpenAPIValidateUriReferenceAsUrl();
            }
            catch (Exception e) {
                msgErrore = "Errore durante l'inizializzazione del validatore OpenAPI: " + e.getMessage();
                InitListener.logError(msgErrore, e);
                throw new UtilsRuntimeException(msgErrore, (Throwable)e);
            }
            try {
                BasicArchive.setNormalizeDescription255((boolean)consoleProperties.isApiDescriptionTruncate255());
                BasicArchive.setNormalizeDescription4000((boolean)consoleProperties.isApiDescriptionTruncate4000());
            }
            catch (Exception e) {
                msgErrore = "Errore durante l'inizializzazione del BasicArchive: " + e.getMessage();
                InitListener.logError(msgErrore, e);
                throw new UtilsRuntimeException(msgErrore, (Throwable)e);
            }
            try {
                if (ProtocolFactoryManager.getInstance().existsProtocolFactory("modipa")) {
                    CostantiDB.setServiziDigestEnabled((boolean)ModIUtils.isSignalHubEnabled());
                }
            }
            catch (Exception e) {
                msgErrore = "Errore durante l'inizializzazione del SignalHub: " + e.getMessage();
                InitListener.logError(msgErrore, e);
                throw new UtilsRuntimeException(msgErrore, (Throwable)e);
            }
            try {
                this.initRuntimeConfigReader = new InitRuntimeConfigReader(consoleProperties, reInitSecretMaps);
                this.initRuntimeConfigReader.start();
                InitListener.logInfo("RuntimeConfigReader avviato con successo.");
            }
            catch (Exception e) {
                msgErrore = "Errore durante l'inizializzazione del RuntimeConfigReader: " + e.getMessage();
                InitListener.logError(msgErrore, e);
            }
            try {
                FailedAttempts.createInstance((String)consoleProperties.getLoginRetryDelays());
            }
            catch (UtilsException e) {
                msgErrore = "Errore durante l'inizializzazione del FailedAttempts: " + e.getMessage();
                InitListener.logError(msgErrore, e);
            }
            InitListener.setInitialized(true);
        }
        finally {
            semaphoreInitListener.release(lock, "contextInitialized");
        }
    }

    static {
        log = LoggerWrapperFactory.getLogger(InitListener.class);
    }
}

