/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.TipologiaConnettori;
import org.openspcoop2.web.lib.mvc.DataElement;

public class Utilities {
    private static TipologiaConnettori TIPOLOGIA_CONNETTORI = null;

    private Utilities() {
    }

    public static boolean contains(String value, String[] listaValoriPossibili) {
        if (value == null) {
            return false;
        }
        if (listaValoriPossibili == null) {
            return false;
        }
        for (int i = 0; i < listaValoriPossibili.length; ++i) {
            if (!value.equals(listaValoriPossibili[i])) continue;
            return true;
        }
        return false;
    }

    public static String toString(String[] values, String separator) {
        StringBuilder bf = new StringBuilder();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (i <= 0) continue;
                bf.append(separator);
                bf.append(values[i]);
            }
        }
        return bf.toString();
    }

    public static TipologiaConnettori getTipologiaConnettori(ControlStationCore core) {
        if (TIPOLOGIA_CONNETTORI == null) {
            Utilities.readTipologiaConnettori(core);
        }
        return TIPOLOGIA_CONNETTORI;
    }

    public static void setTipologiaConnettori(TipologiaConnettori tipologia) {
        TIPOLOGIA_CONNETTORI = tipologia == null ? TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL : tipologia;
    }

    public static void readTipologiaConnettori(ControlStationCore core) {
        TIPOLOGIA_CONNETTORI = core.isShowAllConnettori() ? TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL : TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP;
    }

    public static void setDataElementLabelTipoConnettore(DataElement de, Connettore connettore) {
        de.setValue("Connettore (" + connettore.getTipo() + ")");
    }

    public static ArrayList<String> parseIdsToRemove(String idsToRemove) {
        ArrayList<String> toRem = new ArrayList<String>();
        StringTokenizer objTok = new StringTokenizer(idsToRemove, ",");
        while (objTok.hasMoreElements()) {
            String id2rem = (String)objTok.nextElement();
            toRem.add(id2rem);
        }
        return toRem;
    }

    public static String getTestoVisualizzabile(byte[] b, StringBuilder stringBuffer) {
        try {
            int max = 256000;
            stringBuffer.append(org.openspcoop2.utils.Utilities.convertToPrintableText((byte[])b, (int)max));
            return null;
        }
        catch (Exception e) {
            ControlStationCore.logError("getTestoVisualizzabile error", e);
            return e.getMessage();
        }
    }
}

