/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.plugins.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.web.ctrlstat.costanti.ConnettoreServletType;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettoreConverter;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettoreItem;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedException;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedConnettore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class ServletExtendedConnettoreUtils {
    private ServletExtendedConnettoreUtils() {
    }

    public static List<ExtendedConnettore> getExtendedConnettore(Connettore connettore, ConnettoreServletType servletType, ConsoleHelper consoleHelper, boolean first, String endpointType) throws ExtendedException {
        return ServletExtendedConnettoreUtils.getExtendedConnettore(connettore, servletType, consoleHelper, null, first, endpointType);
    }

    public static List<ExtendedConnettore> getExtendedConnettore(Connettore connettore, ConnettoreServletType servletType, ConsoleHelper consoleHelper, Properties parametersPOST, boolean first, String endpointType) throws ExtendedException {
        List<ExtendedConnettore> l;
        boolean connettoreDisabilitato = true;
        String tipoConnettore = TipiConnettore.DISABILITATO.getNome();
        if (ConnettoreServletType.SERVIZIO_APPLICATIVO_ADD.equals((Object)servletType)) {
            connettoreDisabilitato = false;
            tipoConnettore = TipiConnettore.HTTP.getNome();
        }
        if (first) {
            if (connettore != null) {
                connettoreDisabilitato = TipiConnettore.DISABILITATO.getNome().equals(connettore.getTipo());
                tipoConnettore = connettore.getTipo();
            }
        } else {
            connettoreDisabilitato = TipiConnettore.DISABILITATO.getNome().equals(endpointType);
            tipoConnettore = endpointType;
        }
        if (!(l = ServletExtendedConnettoreUtils.getExtendedConnettore(servletType, consoleHelper, connettoreDisabilitato, tipoConnettore)).isEmpty()) {
            if (first) {
                ExtendedConnettoreConverter.readExtendedInfoFromConnettore(l, connettore);
            } else {
                ServletExtendedConnettoreUtils.updateInfo(consoleHelper, parametersPOST, l);
            }
        }
        return l;
    }

    public static List<ExtendedConnettore> getExtendedConnettore(org.openspcoop2.core.registry.Connettore connettore, ConnettoreServletType servletType, ConsoleHelper consoleHelper, boolean first, String endpointType) throws Exception {
        return ServletExtendedConnettoreUtils.getExtendedConnettore(connettore, servletType, consoleHelper, null, first, endpointType);
    }

    public static List<ExtendedConnettore> getExtendedConnettore(org.openspcoop2.core.registry.Connettore connettore, ConnettoreServletType servletType, ConsoleHelper consoleHelper, Properties parametersPOST, boolean first, String endpointType) throws Exception {
        List<ExtendedConnettore> l;
        boolean connettoreDisabilitato = true;
        String tipoConnettore = TipiConnettore.DISABILITATO.getNome();
        if (first) {
            if (connettore != null) {
                connettoreDisabilitato = TipiConnettore.DISABILITATO.getNome().equals(connettore.getTipo());
                tipoConnettore = connettore.getTipo();
            }
        } else {
            connettoreDisabilitato = TipiConnettore.DISABILITATO.getNome().equals(endpointType);
            tipoConnettore = endpointType;
        }
        if (!(l = ServletExtendedConnettoreUtils.getExtendedConnettore(servletType, consoleHelper, connettoreDisabilitato, tipoConnettore)).isEmpty()) {
            if (first) {
                ExtendedConnettoreConverter.readExtendedInfoFromConnettore(l, connettore);
            } else {
                ServletExtendedConnettoreUtils.updateInfo(consoleHelper, parametersPOST, l);
            }
        }
        return l;
    }

    private static List<ExtendedConnettore> getExtendedConnettore(ConnettoreServletType servletType, ConsoleHelper consoleHelper, boolean connettoreDisabilitato, String tipoConnettore) throws ExtendedException {
        ArrayList<ExtendedConnettore> list = new ArrayList<ExtendedConnettore>();
        if (consoleHelper.getCore().getExtendedConnettore() != null && !consoleHelper.getCore().getExtendedConnettore().isEmpty()) {
            boolean interfacciaAvanzata = consoleHelper.isModalitaAvanzata();
            for (IExtendedConnettore ext : consoleHelper.getCore().getExtendedConnettore()) {
                List<ExtendedConnettore> l = ext.getExtendedConnettore(servletType, interfacciaAvanzata, connettoreDisabilitato, tipoConnettore);
                if (l == null || l.isEmpty()) continue;
                list.addAll(l);
            }
        }
        return list;
    }

    public static void addToDatiEnabled(List<DataElement> dati, List<ExtendedConnettore> list) {
        if (list != null) {
            for (ExtendedConnettore extendedConnettore : list) {
                DataElement de = new DataElement();
                de.setName(extendedConnettore.getId());
                de.setValue("" + extendedConnettore.isEnabled());
                de.setSelected(extendedConnettore.isEnabled());
                de.setLabel(extendedConnettore.getLabel());
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                dati.add(de);
                de = new DataElement();
                de.setName(extendedConnettore.getIdForOldValue());
                de.setValue("" + extendedConnettore.isEnabled());
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            }
        }
    }

    public static void addToDatiExtendedInfo(List<DataElement> dati, List<ExtendedConnettore> list) {
        if (list != null) {
            for (ExtendedConnettore extendedConnettore : list) {
                if (!extendedConnettore.isEnabled()) continue;
                DataElement de = new DataElement();
                de.setName("ExtendedSection-" + extendedConnettore.getId());
                de.setLabel(extendedConnettore.getSection());
                de.setValue(extendedConnettore.getSection());
                de.setType(DataElementType.TITLE);
                dati.add(de);
                if (extendedConnettore.getListItem() == null || extendedConnettore.getListItem().isEmpty()) continue;
                for (ExtendedConnettoreItem extendedConnettoreItem : extendedConnettore.getListItem()) {
                    String id = ExtendedConnettoreConverter.buildId(extendedConnettore.getId(), extendedConnettoreItem.getId());
                    de = new DataElement();
                    de.setName(id);
                    de.setLabel(extendedConnettoreItem.getLabel());
                    de.setNote(extendedConnettoreItem.getNote());
                    de.setValue(extendedConnettoreItem.getValue());
                    de.setRequired(extendedConnettoreItem.isRequired());
                    de.setType(DataElementType.TEXT_EDIT);
                    dati.add(de);
                }
            }
        }
    }

    public static void updateInfo(ConsoleHelper consoleHelper, Properties parametersPOST, List<ExtendedConnettore> list) throws ExtendedException {
        try {
            if (list != null) {
                for (ExtendedConnettore extendedConnettore : list) {
                    boolean oldValue;
                    boolean changeRidefinizione;
                    String tmp = consoleHelper.getParameter(extendedConnettore.getId());
                    if (parametersPOST != null && parametersPOST.size() > 0) {
                        tmp = ServletExtendedConnettoreUtils.getValueFromPropertiesPOST(parametersPOST, extendedConnettore.getId());
                    }
                    extendedConnettore.setEnabled(ServletUtils.isCheckBoxEnabled((String)tmp));
                    String tmpOldValue = consoleHelper.getParameter(extendedConnettore.getIdForOldValue());
                    if (parametersPOST != null && parametersPOST.size() > 0) {
                        tmpOldValue = ServletExtendedConnettoreUtils.getValueFromPropertiesPOST(parametersPOST, extendedConnettore.getIdForOldValue());
                    }
                    boolean bl = changeRidefinizione = (oldValue = ServletUtils.isCheckBoxEnabled((String)tmpOldValue)) != extendedConnettore.isEnabled();
                    if (!extendedConnettore.isEnabled() || changeRidefinizione || extendedConnettore.getListItem() == null || extendedConnettore.getListItem().isEmpty()) continue;
                    for (ExtendedConnettoreItem extendedConnettoreItem : extendedConnettore.getListItem()) {
                        String id = ExtendedConnettoreConverter.buildId(extendedConnettore.getId(), extendedConnettoreItem.getId());
                        tmp = consoleHelper.getParameter(id);
                        if (parametersPOST != null && parametersPOST.size() > 0) {
                            tmp = ServletExtendedConnettoreUtils.getValueFromPropertiesPOST(parametersPOST, id);
                        }
                        extendedConnettoreItem.setValue(tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ExtendedException(e.getMessage(), e);
        }
    }

    private static String getValueFromPropertiesPOST(Properties parametersPOST, String idParameter) {
        if (parametersPOST != null && parametersPOST.size() > 0) {
            Enumeration<Object> enKeys = parametersPOST.keys();
            while (enKeys.hasMoreElements()) {
                String s;
                Object object = enKeys.nextElement();
                if (!(object instanceof String) || (s = (String)object).indexOf("\"" + idParameter + "\"") == -1) continue;
                return parametersPOST.getProperty(s);
            }
        }
        return null;
    }

    public static void checkInfo(List<ExtendedConnettore> list) throws ExtendedException {
        if (list != null) {
            for (ExtendedConnettore extendedConnettore : list) {
                if (!extendedConnettore.isEnabled() || extendedConnettore.getListItem() == null || extendedConnettore.getListItem().isEmpty()) continue;
                for (ExtendedConnettoreItem extendedConnettoreItem : extendedConnettore.getListItem()) {
                    if (extendedConnettoreItem.getValue() == null || "".equals(extendedConnettoreItem.getValue())) {
                        if (!extendedConnettoreItem.isRequired()) continue;
                        throw new ExtendedException("Deve essere indicato un valore in '" + extendedConnettoreItem.getLabel() + "'");
                    }
                    if (extendedConnettoreItem.getRegularExpression() == null) continue;
                    try {
                        if (RegularExpressionEngine.isMatch((String)extendedConnettoreItem.getValue(), (String)extendedConnettoreItem.getRegularExpression())) continue;
                        throw new ExtendedException("Il valore indicato in '" + extendedConnettoreItem.getLabel() + "' non \u00e8 valido");
                    }
                    catch (Exception e) {
                        throw new ExtendedException(e.getMessage(), e);
                    }
                }
            }
        }
    }
}

