/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet;

import java.text.MessageFormat;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;

public class ConsoleUtilities {
    public static boolean alreadyExistsCorrelazioneApplicativaRichiesta(PorteDelegateCore porteDelegateCore, long idPorta, String elemento, long idCorrelazione, StringBuilder existsMessage) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return ConsoleUtilities._alreadyExistsCorrelazioneApplicativaRichiesta(true, porteDelegateCore, null, idPorta, elemento, idCorrelazione, existsMessage);
    }

    public static boolean alreadyExistsCorrelazioneApplicativaRichiesta(PorteApplicativeCore porteApplicativeCore, long idPorta, String elemento, long idCorrelazione, StringBuilder existsMessage) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return ConsoleUtilities._alreadyExistsCorrelazioneApplicativaRichiesta(false, null, porteApplicativeCore, idPorta, elemento, idCorrelazione, existsMessage);
    }

    private static boolean _alreadyExistsCorrelazioneApplicativaRichiesta(boolean portaDelegata, PorteDelegateCore porteDelegateCore, PorteApplicativeCore porteApplicativeCore, long idPorta, String elemento, long idCorrelazione, StringBuilder existsMessage) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        boolean giaRegistrato = false;
        long idCorrApp = 0L;
        CorrelazioneApplicativa ca = null;
        String nomePorta = null;
        if (portaDelegata) {
            PortaDelegata pde = null;
            pde = porteDelegateCore.getPortaDelegata(idPorta);
            ca = pde.getCorrelazioneApplicativa();
            nomePorta = pde.getNome();
        } else {
            PortaApplicativa pda = null;
            pda = porteApplicativeCore.getPortaApplicativa(idPorta);
            ca = pda.getCorrelazioneApplicativa();
            nomePorta = pda.getNome();
        }
        if (ca != null) {
            for (int i = 0; i < ca.sizeElementoList(); ++i) {
                CorrelazioneApplicativaElemento cae = ca.getElemento(i);
                String caeNome = cae.getNome();
                if (caeNome == null) {
                    caeNome = "";
                }
                if (!elemento.equals(caeNome) && (!"*".equals(caeNome) || !"".equals(elemento))) continue;
                idCorrApp = cae.getId();
                break;
            }
        }
        if (idCorrApp != 0L && idCorrApp != idCorrelazione) {
            giaRegistrato = true;
        }
        if (giaRegistrato) {
            String nomeElemento = "Non definito";
            if (elemento != null && !"".equals(elemento)) {
                nomeElemento = elemento;
            }
            String labelPorta = null;
            labelPorta = portaDelegata ? MessageFormat.format("Porta Delegata {0}", nomePorta) : MessageFormat.format("Porta Applicativa {0}", nomePorta);
            existsMessage.append(MessageFormat.format("Esiste gi&agrave; una correlazione applicativa con elemento [{0}] definita nella {1}", nomeElemento, labelPorta));
        }
        return giaRegistrato;
    }

    public static boolean alreadyExistsCorrelazioneApplicativaRisposta(PorteDelegateCore porteDelegateCore, long idPorta, String elemento, long idCorrelazione, StringBuilder existsMessage) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return ConsoleUtilities._alreadyExistsCorrelazioneApplicativaRisposta(true, porteDelegateCore, null, idPorta, elemento, idCorrelazione, existsMessage);
    }

    public static boolean alreadyExistsCorrelazioneApplicativaRisposta(PorteApplicativeCore porteApplicativeCore, long idPorta, String elemento, long idCorrelazione, StringBuilder existsMessage) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        return ConsoleUtilities._alreadyExistsCorrelazioneApplicativaRisposta(false, null, porteApplicativeCore, idPorta, elemento, idCorrelazione, existsMessage);
    }

    private static boolean _alreadyExistsCorrelazioneApplicativaRisposta(boolean portaDelegata, PorteDelegateCore porteDelegateCore, PorteApplicativeCore porteApplicativeCore, long idPorta, String elemento, long idCorrelazione, StringBuilder existsMessage) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        boolean giaRegistrato = false;
        int idCorrApp = 0;
        CorrelazioneApplicativaRisposta ca = null;
        String nomePorta = null;
        if (portaDelegata) {
            PortaDelegata pde = null;
            pde = porteDelegateCore.getPortaDelegata(idPorta);
            ca = pde.getCorrelazioneApplicativaRisposta();
            nomePorta = pde.getNome();
        } else {
            PortaApplicativa pda = null;
            pda = porteApplicativeCore.getPortaApplicativa(idPorta);
            ca = pda.getCorrelazioneApplicativaRisposta();
            nomePorta = pda.getNome();
        }
        if (ca != null) {
            for (int i = 0; i < ca.sizeElementoList(); ++i) {
                CorrelazioneApplicativaRispostaElemento cae = ca.getElemento(i);
                String caeNome = cae.getNome();
                if (caeNome == null) {
                    caeNome = "";
                }
                if (!elemento.equals(caeNome) && (!"*".equals(caeNome) || !"".equals(elemento))) continue;
                idCorrApp = cae.getId().intValue();
                break;
            }
        }
        if (idCorrApp != 0 && (long)idCorrApp != idCorrelazione) {
            giaRegistrato = true;
        }
        if (giaRegistrato) {
            String nomeElemento = "Non definito";
            if (elemento != null && !"".equals(elemento)) {
                nomeElemento = elemento;
            }
            String labelPorta = null;
            labelPorta = portaDelegata ? MessageFormat.format("Porta Delegata {0}", nomePorta) : MessageFormat.format("Porta Applicativa {0}", nomePorta);
            existsMessage.append(MessageFormat.format("Esiste gi&agrave; una correlazione applicativa per la risposta con elemento [{0}] definita nella {1}", nomeElemento, labelPorta));
        }
        return giaRegistrato;
    }
}

