/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.utils.ProtocolUtils;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.GeneralLink;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class GeneralHelper {
    protected HttpSession session;
    protected ControlStationCore core;
    protected PddCore pddCore;
    protected SoggettiCore soggettiCore;
    protected Logger log;

    public GeneralHelper(HttpSession session) {
        this.session = session;
        try {
            this.core = new ControlStationCore();
            this.pddCore = new PddCore(this.core);
            this.soggettiCore = new SoggettiCore(this.core);
        }
        catch (Exception e) {
            this.log = ControlStationLogger.getPddConsoleCoreLogger();
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
        }
        this.log = ControlStationLogger.getPddConsoleCoreLogger();
    }

    public GeneralData initGeneralData(HttpServletRequest request) {
        String baseUrl = request.getRequestURI();
        return this.initGeneralData_engine(request, baseUrl);
    }

    public GeneralData initGeneralData(HttpServletRequest request, String servletName) {
        Object baseUrl = request.getContextPath();
        baseUrl = servletName.startsWith("/") ? (String)baseUrl + servletName : (String)baseUrl + "/" + servletName;
        return this.initGeneralData_engine(request, (String)baseUrl);
    }

    private GeneralData initGeneralData_engine(HttpServletRequest request, String baseUrl) {
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)this.session);
        String css = this.core.getConsoleCSS();
        User u = ServletUtils.getUserFromSession((HttpServletRequest)request, (HttpSession)this.session);
        boolean displayUtente = false;
        boolean displayLogin = true;
        boolean displayLogout = true;
        if (baseUrl.indexOf("/login.do") != -1 && u == null || baseUrl.indexOf("/logout.do") != -1 || baseUrl.indexOf("/loginMessagePage.do") != -1 || baseUrl.indexOf("/utentePasswordChange.do") != -1 && u == null) {
            displayLogin = false;
            displayLogout = false;
        }
        if (u != null) {
            displayLogin = false;
            displayUtente = true;
        }
        GeneralData gd = new GeneralData("https://link.it");
        gd.setProduct(this.core.getConsoleNomeSintesi());
        gd.setLanguage(this.core.getConsoleLanguage());
        gd.setTitle(StringEscapeUtils.escapeHtml4((String)this.core.getConsoleNomeEsteso(request, this.session)));
        gd.setLogoHeaderImage(this.core.getLogoHeaderImage());
        gd.setLogoHeaderLink(this.core.getLogoHeaderLink());
        gd.setLogoHeaderTitolo(this.core.getLogoHeaderTitolo());
        gd.setVisualizzaLinkHome(this.core.isVisualizzaLinkHomeHeader());
        gd.setUrl(baseUrl);
        gd.setCss(css);
        if (displayLogin || displayLogout) {
            ArrayList<GeneralLink> link = new ArrayList<GeneralLink>();
            if (displayLogin) {
                GeneralLink gl1 = new GeneralLink();
                gl1.setLabel("Login");
                gl1.setUrl("login.do");
                link.add(gl1);
            } else {
                GeneralLink glUtente;
                if (displayUtente) {
                    glUtente = new GeneralLink();
                    glUtente.setLabel(userLogin);
                    glUtente.setUrl("");
                    link.add(glUtente);
                }
                glUtente = new GeneralLink();
                InterfaceType tipoInterfaccia = u.getInterfaceType();
                if (!tipoInterfaccia.equals((Object)InterfaceType.COMPLETA)) {
                    if (tipoInterfaccia.equals((Object)InterfaceType.STANDARD)) {
                        glUtente.setLabel("Modalit&agrave; avanzata");
                        glUtente.setIcon("checkbox-unchecked-white");
                        glUtente.setUrl("utenteChange.do", new Parameter[]{new Parameter("tipo_gui", InterfaceType.AVANZATA.toString()), new Parameter("edit-mode", "end"), new Parameter("change_gui", "yes")});
                    } else {
                        glUtente.setLabel("Modalit&agrave; avanzata");
                        glUtente.setIcon("checkbox-checked-white");
                        glUtente.setUrl("utenteChange.do", new Parameter[]{new Parameter("tipo_gui", InterfaceType.STANDARD.toString()), new Parameter("edit-mode", "end"), new Parameter("change_gui", "yes")});
                    }
                    link.add(glUtente);
                }
                GeneralLink glO = new GeneralLink();
                glO.setLabel("Informazioni");
                glO.setUrl("about.do");
                link.add(glO);
                if (displayUtente) {
                    GeneralLink glProfiloUtente = new GeneralLink();
                    glProfiloUtente.setLabel("Profilo Utente");
                    glProfiloUtente.setUrl("utenteChange.do");
                    link.add(glProfiloUtente);
                }
            }
            if (displayLogout && this.core.isMostraButtonLogout()) {
                GeneralLink gl2 = new GeneralLink();
                gl2.setLabel("Logout");
                gl2.setUrl("logout.do");
                link.add(gl2);
            }
            gd.setHeaderLinks(link);
            if (u != null) {
                if (!u.hasOnlyPermessiUtenti()) {
                    gd.setModalitaLinks(this.caricaMenuProtocolliUtente(request, u));
                }
                if (!u.hasOnlyPermessiUtenti()) {
                    gd.setSoggettiLinks(this.caricaMenuSoggetti(request, u));
                }
            }
        }
        return gd;
    }

    public PageData initPageData() {
        return this.initPageData(null);
    }

    public PageData initPageData(String breadcrumb) {
        PageData pd = new PageData();
        if (breadcrumb != null) {
            ArrayList<GeneralLink> titlelist = new ArrayList<GeneralLink>();
            GeneralLink tl1 = new GeneralLink();
            tl1.setLabel(breadcrumb);
            titlelist.add(tl1);
            pd.setTitleList(titlelist);
        }
        ArrayList<DataElement> dati = new ArrayList<DataElement>();
        pd.setNascondiButtonRowLogin(true);
        DataElement titoloSezione = new DataElement();
        titoloSezione.setLabel("Login");
        titoloSezione.setType(DataElementType.TITLE);
        titoloSezione.setName("");
        dati.add(titoloSezione);
        if (this.core.isLoginApplication()) {
            if (this.core.isMultiLoginEnabled()) {
                DataElement sottoSezioneLogin = new DataElement();
                sottoSezioneLogin.setLabel("Account Locale");
                sottoSezioneLogin.setType(DataElementType.SUBTITLE);
                sottoSezioneLogin.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.APERTO);
                sottoSezioneLogin.abilitaModalitaAccordion();
                dati.add(sottoSezioneLogin);
            }
            DataElement login = new DataElement();
            login.setLabel("Username");
            login.setType(DataElementType.TEXT_EDIT);
            login.setName("login");
            login.setStyleClass("inputLink");
            dati.add(login);
            DataElement pwd = new DataElement();
            pwd.setLabel("Password");
            pwd.setType(DataElementType.CRYPT);
            pwd.setName("password");
            pwd.setStyleClass("inputLink");
            dati.add(pwd);
            DataElement buttonLogin = new DataElement();
            buttonLogin.setType(DataElementType.BUTTON);
            buttonLogin.setValue("Login");
            buttonLogin.setOnClick("CheckDati();return false;");
            dati.add(buttonLogin);
        }
        if (this.core.isLoginOAuth2Enabled()) {
            if (this.core.isMultiLoginEnabled()) {
                DataElement sottoSezioneOAuth2 = new DataElement();
                sottoSezioneOAuth2.setLabel("Autenticazione OIDC");
                sottoSezioneOAuth2.setType(DataElementType.SUBTITLE);
                sottoSezioneOAuth2.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
                sottoSezioneOAuth2.abilitaModalitaAccordion();
                dati.add(sottoSezioneOAuth2);
            }
            DataElement buttonAuth2 = new DataElement();
            buttonAuth2.setType(DataElementType.BUTTON);
            buttonAuth2.setValue("Accedi");
            StringBuilder oauth2ButtonOnClickFunction = new StringBuilder();
            oauth2ButtonOnClickFunction.append("goToLocation('");
            oauth2ButtonOnClickFunction.append(this.session.getServletContext().getContextPath() + "/oauth2/loginStart");
            oauth2ButtonOnClickFunction.append("')");
            buttonAuth2.setOnClick(oauth2ButtonOnClickFunction.toString());
            dati.add(buttonAuth2);
        }
        pd.setDati(dati);
        return pd;
    }

    public int getSize() {
        return 50;
    }

    public List<GeneralLink> caricaMenuProtocolliUtente(HttpServletRequest request, User u) {
        ArrayList<GeneralLink> link = new ArrayList<GeneralLink>();
        try {
            List<String> protocolliDispondibili = this.core.getProtocolli(request, this.session, true);
            if (protocolliDispondibili != null && !protocolliDispondibili.isEmpty()) {
                String protocolloSelezionato = u.getProtocolloSelezionatoPddConsole();
                if (protocolliDispondibili.size() == 1) {
                    protocolloSelezionato = protocolliDispondibili.get(0);
                }
                GeneralLink glModalitaCorrente = new GeneralLink();
                String labelSelezionato = protocolloSelezionato == null ? "Tutti" : ConsoleHelper._getLabelProtocollo(protocolloSelezionato);
                String labelSelezionatoCompleta = MessageFormat.format("Profilo: {0}", labelSelezionato);
                glModalitaCorrente.setLabel(labelSelezionatoCompleta);
                glModalitaCorrente.setUrl("");
                glModalitaCorrente.setLabelWidth(this.core.getFontWidth(labelSelezionatoCompleta, 1, 16).intValue());
                link.add(glModalitaCorrente);
                if (protocolliDispondibili.size() > 1) {
                    for (String protocolloDisponibile : ProtocolUtils.orderProtocolli(protocolliDispondibili)) {
                        GeneralLink glProt = new GeneralLink();
                        String labelProt = ConsoleHelper._getLabelProtocollo(protocolloDisponibile);
                        glProt.setLabel(labelProt);
                        if (protocolloSelezionato != null && protocolloSelezionato.equals(protocolloDisponibile)) {
                            glProt.setUrl("");
                        } else {
                            glProt.setUrl("utenteChange.do", new Parameter[]{new Parameter("tipo_mod", protocolloDisponibile), new Parameter("edit-mode", "end"), new Parameter("change_mod", "yes")});
                        }
                        glProt.setLabelWidth(this.core.getFontWidth(glProt.getLabel(), 14).intValue());
                        link.add(glProt);
                    }
                    GeneralLink glAll = new GeneralLink();
                    glAll.setLabel("Tutti");
                    if (protocolloSelezionato == null) {
                        glAll.setUrl("");
                    } else {
                        glAll.setUrl("utenteChange.do", new Parameter[]{new Parameter("tipo_mod", "all"), new Parameter("edit-mode", "end"), new Parameter("change_mod", "yes")});
                    }
                    glAll.setLabelWidth(this.core.getFontWidth("Tutti", 14).intValue());
                    link.add(glAll);
                }
            }
        }
        catch (Exception e) {
            ControlStationLogger.getPddConsoleCoreLogger().error(e.getMessage(), (Throwable)e);
        }
        return link;
    }

    public List<GeneralLink> caricaMenuSoggetti(HttpServletRequest request, User u) {
        ArrayList<GeneralLink> link = new ArrayList<GeneralLink>();
        try {
            List<String> protocolliDispondibili = this.core.getProtocolli(request, this.session, true);
            String protocolloSelezionato = u.getProtocolloSelezionatoPddConsole();
            if (protocolliDispondibili.size() == 1) {
                protocolloSelezionato = protocolliDispondibili.get(0);
            }
            String soggettoOperativoSelezionato = u.getSoggettoSelezionatoPddConsole();
            List<IDSoggetto> idSoggettiOperativi = this.soggettiCore.getIdSoggettiOperativi(protocolloSelezionato);
            if (protocolloSelezionato != null && !"".equals(protocolloSelezionato) && idSoggettiOperativi != null && !idSoggettiOperativi.isEmpty()) {
                if (soggettoOperativoSelezionato == null && idSoggettiOperativi.size() == 1) {
                    IDSoggetto idSoggetto = idSoggettiOperativi.get(0);
                    soggettoOperativoSelezionato = idSoggetto.toString();
                }
                GeneralLink glSoggettoCorrente = new GeneralLink();
                IDSoggetto idSoggettoOperativo = null;
                if (soggettoOperativoSelezionato != null) {
                    idSoggettoOperativo = this.soggettiCore.convertSoggettoSelezionatoToID(soggettoOperativoSelezionato);
                }
                String labelSelezionato = soggettoOperativoSelezionato == null ? "Tutti" : ConsoleHelper._getLabelNomeSoggetto(idSoggettoOperativo);
                String labelSelezionatoCompleta = MessageFormat.format("Soggetto: {0}", labelSelezionato);
                glSoggettoCorrente.setLabel(labelSelezionatoCompleta);
                if (labelSelezionatoCompleta.length() > this.core.getLunghezzaMassimaLabelSoggettiOperativiMenuUtente()) {
                    glSoggettoCorrente.setLabel(ConsoleHelper.normalizeLabel(labelSelezionatoCompleta, this.core.getLunghezzaMassimaLabelSoggettiOperativiMenuUtente()));
                }
                glSoggettoCorrente.setUrl("");
                glSoggettoCorrente.setLabelWidth(this.core.getFontWidth(glSoggettoCorrente.getLabel(), 1, 16).intValue());
                link.add(glSoggettoCorrente);
                Integer numeroMassimoSoggettiSelectListSoggettiOperatiti = this.core.getNumeroMassimoSoggettiSelectListSoggettiOperatiti();
                if (idSoggettiOperativi.size() > 1) {
                    ArrayList<String> listaLabel = new ArrayList<String>();
                    HashMap<String, IDSoggetto> mapLabelIds = new HashMap<String, IDSoggetto>();
                    for (IDSoggetto idSoggetto : idSoggettiOperativi) {
                        String labelSoggetto = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                        if (listaLabel.contains(labelSoggetto)) continue;
                        listaLabel.add(labelSoggetto);
                        mapLabelIds.put(labelSoggetto, idSoggetto);
                    }
                    Collections.sort(listaLabel, new Comparator<String>(this){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.toLowerCase().compareTo(o2.toLowerCase());
                        }
                    });
                    for (String label : listaLabel) {
                        GeneralLink glSoggetto = new GeneralLink();
                        glSoggetto.setLabel(label);
                        if (soggettoOperativoSelezionato != null && ((IDSoggetto)mapLabelIds.get(label)).toString().equals(idSoggettoOperativo.toString())) {
                            glSoggetto.setUrl("");
                        } else {
                            glSoggetto.setUrl("utenteChange.do", new Parameter[]{new Parameter("id_sog", NamingUtils.getSoggettoFromLabel((String)protocolloSelezionato, (String)label).toString()), new Parameter("edit-mode", "end"), new Parameter("change_sog", "yes")});
                        }
                        if (label.length() > this.core.getLunghezzaMassimaLabelSoggettiOperativiMenuUtente()) {
                            glSoggetto.setLabel(ConsoleHelper.normalizeLabel(label, this.core.getLunghezzaMassimaLabelSoggettiOperativiMenuUtente()));
                            glSoggetto.setTooltip(label);
                        }
                        glSoggetto.setLabelWidth(this.core.getFontWidth(glSoggetto.getLabel(), 14).intValue());
                        link.add(glSoggetto);
                    }
                    GeneralLink glAll = new GeneralLink();
                    glAll.setLabel("Tutti");
                    if (soggettoOperativoSelezionato == null) {
                        glAll.setUrl("");
                    } else {
                        glAll.setUrl("utenteChange.do", new Parameter[]{new Parameter("id_sog", "all"), new Parameter("edit-mode", "end"), new Parameter("change_sog", "yes")});
                    }
                    glAll.setLabelWidth(this.core.getFontWidth("Tutti", 14).intValue());
                    link.add(glAll);
                }
                if (idSoggettiOperativi.size() > numeroMassimoSoggettiSelectListSoggettiOperatiti) {
                    glSoggettoCorrente.setUrl("abilitaAutocomplete");
                }
            }
        }
        catch (Exception e) {
            ControlStationLogger.getPddConsoleCoreLogger().error(e.getMessage(), (Throwable)e);
        }
        return link;
    }

    public ControlStationCore getCore() {
        return this.core;
    }
}

