/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ac;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneAddStrutsBean;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiCooperazioneAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        AccordiCooperazioneAddStrutsBean strutsBean = new AccordiCooperazioneAddStrutsBean();
        strutsBean.consoleOperationType = ConsoleOperationType.ADD;
        TipoOperazione tipoOp = TipoOperazione.ADD;
        try {
            AccordiCooperazioneHelper acHelper = new AccordiCooperazioneHelper(request, pd, session);
            acHelper.makeMenu();
            strutsBean.editMode = acHelper.getParametroEditMode("edit-mode");
            strutsBean.nome = acHelper.getParameter("nome");
            strutsBean.descr = acHelper.getParameter("descr");
            strutsBean.referente = acHelper.getParameter("referente");
            strutsBean.versione = acHelper.getParameter("versione");
            strutsBean.tipoProtocollo = acHelper.getParameter("tipoProtocollo");
            String privatoS = acHelper.getParametroBoolean("privato");
            strutsBean.privato = ServletUtils.isCheckBoxEnabled((String)privatoS);
            strutsBean.statoPackage = acHelper.getParameter("stato");
            String tipoSICA = acHelper.getParameter("tipoSICA");
            if ("".equals(tipoSICA)) {
                tipoSICA = null;
            }
            AccordiCooperazioneCore acCore = new AccordiCooperazioneCore();
            SoggettiCore soggettiCore = new SoggettiCore(acCore);
            List<String> listaTipiProtocollo = acCore.getProtocolliByFilter(request, session, true, false);
            if (strutsBean.tipoProtocollo == null) {
                strutsBean.tipoProtocollo = acCore.getProtocolloDefault(request, session, listaTipiProtocollo);
            }
            if (listaTipiProtocollo.isEmpty()) {
                pd.setMessage("Non risultano registrati soggetti", Costanti.MESSAGE_TYPE_INFO);
                pd.disableEditMode();
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.ADD());
            }
            List<String> tipiSoggettiGestitiProtocollo = soggettiCore.getTipiSoggettiGestitiProtocollo(strutsBean.tipoProtocollo);
            String[] providersList = null;
            String[] providersListLabel = null;
            List<Soggetto> lista = null;
            lista = acCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiRegistroList(null, (ISearch)new ConsoleSearch(true)) : soggettiCore.soggettiRegistroList(userLogin, (ISearch)new ConsoleSearch(true));
            ArrayList<String> soggettiListTmp = new ArrayList<String>();
            ArrayList<String> soggettiListLabelTmp = new ArrayList<String>();
            soggettiListTmp.add("-");
            soggettiListLabelTmp.add("-");
            if (!lista.isEmpty()) {
                for (Soggetto soggetto : lista) {
                    if (!tipiSoggettiGestitiProtocollo.contains(soggetto.getTipo())) continue;
                    soggettiListTmp.add(soggetto.getId().toString());
                    soggettiListLabelTmp.add(acHelper.getLabelNomeSoggetto(strutsBean.tipoProtocollo, soggetto.getTipo(), soggetto.getNome()));
                }
            }
            providersList = soggettiListTmp.toArray(new String[1]);
            providersListLabel = soggettiListLabelTmp.toArray(new String[1]);
            strutsBean.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(strutsBean.tipoProtocollo);
            strutsBean.consoleDynamicConfiguration = strutsBean.protocolFactory.createDynamicConfigurationConsole();
            strutsBean.registryReader = soggettiCore.getRegistryReader(strutsBean.protocolFactory);
            strutsBean.configRegistryReader = soggettiCore.getConfigIntegrationReader(strutsBean.protocolFactory);
            IDAccordo idAc = null;
            strutsBean.consoleConfiguration = strutsBean.consoleDynamicConfiguration.getDynamicConfigAccordoCooperazione(strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.registryReader, strutsBean.configRegistryReader, idAc);
            strutsBean.protocolProperties = acHelper.estraiProtocolPropertiesDaRequest(strutsBean.consoleConfiguration, strutsBean.consoleOperationType);
            String postBackElementName = acHelper.getParameter("postBackElementName");
            if (postBackElementName != null && postBackElementName.equalsIgnoreCase("protocollo")) {
                strutsBean.referente = null;
                acHelper.deleteProtocolPropertiesBinaryParameters(new BinaryParameter[0]);
            }
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode)) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Accordi Cooperazione", (String)"accordiCooperazioneList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (acHelper.isShowGestioneWorkflowStatoDocumenti()) {
                    if (strutsBean.statoPackage == null) {
                        strutsBean.statoPackage = StatiAccordo.bozza.toString();
                    }
                } else {
                    strutsBean.statoPackage = StatiAccordo.finale.toString();
                }
                strutsBean.versione = "1";
                if (strutsBean.nome == null) {
                    strutsBean.nome = "";
                }
                if (strutsBean.descr == null) {
                    strutsBean.descr = "";
                }
                if (strutsBean.referente == null) {
                    strutsBean.referente = "";
                }
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAc);
                dati = acHelper.addAccordiCooperazioneToDati(dati, strutsBean.nome, strutsBean.descr, "0", tipoOp, strutsBean.referente, strutsBean.versione, providersList, providersListLabel, false, strutsBean.statoPackage, strutsBean.statoPackage, strutsBean.tipoProtocollo, listaTipiProtocollo, false);
                dati = acHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = acHelper.accordiCooperazioneCheckData(tipoOp, strutsBean.nome, strutsBean.descr, "0", strutsBean.referente, strutsBean.versione, strutsBean.privato, null);
            if (isOk) {
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAc);
            }
            if (isOk) {
                try {
                    acHelper.validaProtocolProperties(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (isOk) {
                try {
                    idAc = acHelper.getIDAccordoFromValues(strutsBean.nome, strutsBean.referente, strutsBean.versione);
                    strutsBean.consoleDynamicConfiguration.validateDynamicConfigCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAc);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (!isOk) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Accordi Cooperazione", (String)"accordiCooperazioneList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAc);
                dati = acHelper.addAccordiCooperazioneToDati(dati, strutsBean.nome, strutsBean.descr, "0", tipoOp, strutsBean.referente, strutsBean.versione, providersList, providersListLabel, strutsBean.privato, strutsBean.statoPackage, strutsBean.statoPackage, strutsBean.tipoProtocollo, listaTipiProtocollo, false);
                dati = acHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.ADD());
            }
            AccordoCooperazione ac = new AccordoCooperazione();
            ac.setNome(strutsBean.nome);
            ac.setDescrizione(strutsBean.descr);
            ac.setOraRegistrazione(Calendar.getInstance().getTime());
            if (strutsBean.referente != null && !"".equals(strutsBean.referente) && !"-".equals(strutsBean.referente)) {
                int idRef = 0;
                try {
                    idRef = Integer.parseInt(strutsBean.referente);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (idRef != 0) {
                    int idReferente = Integer.parseInt(strutsBean.referente);
                    Soggetto s = soggettiCore.getSoggettoRegistro(idReferente);
                    IdSoggetto acsr = new IdSoggetto();
                    acsr.setTipo(s.getTipo());
                    acsr.setNome(s.getNome());
                    ac.setSoggettoReferente(acsr);
                }
            } else {
                ac.setSoggettoReferente(null);
            }
            if (strutsBean.versione != null) {
                ac.setVersione(Integer.valueOf(Integer.parseInt(strutsBean.versione)));
            }
            ac.setPrivato(strutsBean.privato ? Boolean.TRUE : Boolean.FALSE);
            ac.setSuperUser(userLogin);
            ac.setStatoPackage(strutsBean.statoPackage);
            if (acHelper.isShowGestioneWorkflowStatoDocumenti()) {
                try {
                    acCore.validaStatoAccordoCooperazione(ac);
                }
                catch (ValidazioneStatoPackageException validazioneException) {
                    pd.setMessage(validazioneException.toString());
                    ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Accordi Cooperazione", (String)"accordiCooperazioneList.do");
                    List<DataElement> dati = new ArrayList<DataElement>();
                    dati.add(ServletUtils.getDataElementForEditModeFinished());
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAc);
                    dati = acHelper.addAccordiCooperazioneToDati(dati, strutsBean.nome, strutsBean.descr, "0", tipoOp, strutsBean.referente, strutsBean.versione, providersList, providersListLabel, strutsBean.privato, strutsBean.statoPackage, strutsBean.statoPackage, strutsBean.tipoProtocollo, listaTipiProtocollo, false);
                    dati = acHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                    pd.setDati(dati);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.ADD());
                }
            }
            ac.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (ConsoleOperationType)strutsBean.consoleOperationType, null));
            acCore.performCreateOperation(userLogin, acHelper.smista(), ac);
            acHelper.deleteBinaryProtocolPropertiesTmpFiles(strutsBean.protocolProperties);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<AccordoCooperazione> listaAC = null;
            listaAC = acCore.isVisioneOggettiGlobale(userLogin) ? acCore.accordiCooperazioneList(null, (ISearch)ricerca) : acCore.accordiCooperazioneList(userLogin, (ISearch)ricerca);
            acHelper.prepareAccordiCooperazioneList(listaAC, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.ADD());
        }
    }
}

