/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ac;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneChangeStrutsBean;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiCooperazioneChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        List<String> listaTipiProtocollo = null;
        boolean used = false;
        AccordiCooperazioneChangeStrutsBean strutsBean = new AccordiCooperazioneChangeStrutsBean();
        strutsBean.consoleOperationType = ConsoleOperationType.CHANGE;
        TipoOperazione tipoOp = TipoOperazione.CHANGE;
        List oldProtocolPropertyList = null;
        try {
            ArrayList<Parameter> lstParam;
            AccordiCooperazioneHelper acHelper = new AccordiCooperazioneHelper(request, pd, session);
            acHelper.makeMenu();
            strutsBean.editMode = acHelper.getParametroEditMode("edit-mode");
            strutsBean.protocolPropertiesSet = acHelper.getParameter("ppSet");
            String id = acHelper.getParametroLong("id");
            int idAcc = Integer.parseInt(id);
            String descr = acHelper.getParameter("descr");
            Object referente = acHelper.getParameter("referente");
            Object versione = acHelper.getParametroInteger("versione");
            String tipoProtocollo = acHelper.getParameter("protocollo");
            String actionConfirm = acHelper.getParameter("actionConfirm");
            String privatoS = acHelper.getParametroBoolean("privato");
            boolean privato = ServletUtils.isCheckBoxEnabled((String)privatoS);
            String statoPackage = acHelper.getParameter("stato");
            AccordiCooperazioneCore acCore = new AccordiCooperazioneCore();
            SoggettiCore soggettiCore = new SoggettiCore(acCore);
            AccordoCooperazione ac = acCore.getAccordoCooperazione(idAcc);
            if (ac == null) {
                throw new Exception("Accordo Cooperazione '" + idAcc + "' non trovato");
            }
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(acCore);
            IDAccordoCooperazione idAccordoOLD = idAccordoCooperazioneFactory.getIDAccordoFromValues(ac.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)ac.getSoggettoReferente()), ac.getVersione().intValue());
            String uriAS = idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoOLD);
            String titleAS = acHelper.getLabelIdAccordoCooperazione(ac);
            String oldStatoPackage = ac.getStatoPackage();
            String nome = acHelper.getParameter("nome");
            if (nome == null || nome.equals("")) {
                pd.setMessage("Il nome dell'accordo &egrave; necessario!");
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardGeneralError((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.CHANGE());
            }
            try {
                FiltroRicercaAccordi filtroRicerca = new FiltroRicercaAccordi();
                filtroRicerca.setServizioComposto(Boolean.valueOf(true));
                filtroRicerca.setIdAccordoCooperazione(idAccordoOLD);
                List<IDAccordo> allIdAccordiServizio = apcCore.getAllIdAccordiServizio(filtroRicerca);
                if (allIdAccordiServizio != null && !allIdAccordiServizio.isEmpty()) {
                    used = true;
                }
            }
            catch (DriverRegistroServiziNotFound de) {
                used = false;
            }
            catch (Exception e) {
                used = true;
            }
            listaTipiProtocollo = acCore.getProtocolliByFilter(request, session, true, false);
            if (tipoProtocollo == null) {
                tipoProtocollo = ac != null && ac.getSoggettoReferente() != null ? soggettiCore.getProtocolloAssociatoTipoSoggetto(ac.getSoggettoReferente().getTipo()) : acCore.getProtocolloDefault(request, session, listaTipiProtocollo);
            }
            List<String> tipiSoggettiGestitiProtocollo = soggettiCore.getTipiSoggettiGestitiProtocollo(tipoProtocollo);
            String[] providersList = null;
            String[] providersListLabel = null;
            List<Soggetto> lista = null;
            lista = acCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiRegistroList(null, (ISearch)new ConsoleSearch(true)) : soggettiCore.soggettiRegistroList(userLogin, (ISearch)new ConsoleSearch(true));
            ArrayList<String> soggettiListTmp = new ArrayList<String>();
            ArrayList<String> soggettiListLabelTmp = new ArrayList<String>();
            soggettiListTmp.add("-");
            soggettiListLabelTmp.add("-");
            if (!lista.isEmpty()) {
                for (Soggetto soggetto : lista) {
                    if (!tipiSoggettiGestitiProtocollo.contains(soggetto.getTipo())) continue;
                    soggettiListTmp.add(soggetto.getId().toString());
                    soggettiListLabelTmp.add(acHelper.getLabelNomeSoggetto(tipoProtocollo, soggetto.getTipo(), soggetto.getNome()));
                }
            }
            providersList = soggettiListTmp.toArray(new String[1]);
            providersListLabel = soggettiListLabelTmp.toArray(new String[1]);
            IdSoggetto acsr = ac.getSoggettoReferente();
            if (acsr != null) {
                Soggetto s = soggettiCore.getSoggettoRegistro(new IDSoggetto(acsr.getTipo(), acsr.getNome()));
                referente = "" + s.getId();
            } else {
                referente = "-";
            }
            if (versione == null && ac.getVersione() != null) {
                versione = "" + ac.getVersione();
            }
            IDAccordo idAcOLD = acHelper.getIDAccordoFromValues(nome, (String)referente, (String)versione);
            strutsBean.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
            strutsBean.consoleDynamicConfiguration = strutsBean.protocolFactory.createDynamicConfigurationConsole();
            strutsBean.registryReader = soggettiCore.getRegistryReader(strutsBean.protocolFactory);
            strutsBean.configRegistryReader = soggettiCore.getConfigIntegrationReader(strutsBean.protocolFactory);
            strutsBean.consoleConfiguration = strutsBean.consoleDynamicConfiguration.getDynamicConfigAccordoCooperazione(strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.registryReader, strutsBean.configRegistryReader, idAcOLD);
            strutsBean.protocolProperties = acHelper.estraiProtocolPropertiesDaRequest(strutsBean.consoleConfiguration, strutsBean.consoleOperationType);
            oldProtocolPropertyList = ac.getProtocolPropertyList();
            if (strutsBean.protocolPropertiesSet == null) {
                ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (List)oldProtocolPropertyList, (ConsoleOperationType)strutsBean.consoleOperationType);
            }
            Properties propertiesProprietario = new Properties();
            propertiesProprietario.setProperty("idProprietario", id);
            propertiesProprietario.setProperty("tipoProprietario", "ACCORDO_COOPERAZIONE");
            propertiesProprietario.setProperty("nomeProprietario", uriAS);
            Parameter urlOrig = new Parameter(uriAS, "accordiCooperazioneChange.do?id=" + id + "&nome=" + nome);
            propertiesProprietario.setProperty("urlOrigChange", URLEncoder.encode(urlOrig.getValue(), "UTF-8"));
            propertiesProprietario.setProperty("protocollo", tipoProtocollo);
            propertiesProprietario.setProperty("tipoAccordo", "");
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode)) {
                ArrayList<Parameter> lstParam2 = new ArrayList<Parameter>();
                lstParam2.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
                lstParam2.add(new Parameter(titleAS, null));
                ServletUtils.setPageDataTitle((PageData)pd, lstParam2);
                if (descr == null) {
                    descr = ac.getDescrizione();
                }
                boolean bl = privato = ac.getPrivato() != null && ac.getPrivato() != false;
                if (statoPackage == null) {
                    statoPackage = ac.getStatoPackage();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAcOLD);
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = acHelper.addHiddenFieldsToDati(tipoOp, id, null, null, dati);
                dati = acHelper.addAccordiCooperazioneToDati(dati, nome, descr, id, tipoOp, (String)referente, (String)versione, providersList, providersListLabel, privato, statoPackage, oldStatoPackage, tipoProtocollo, listaTipiProtocollo, used);
                dati = acHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                pd.setDati(dati);
                if (acHelper.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(ac.getStatoPackage())) {
                    pd.setMode("view-noeditbutton");
                }
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = acHelper.accordiCooperazioneCheckData(tipoOp, nome, descr, id, (String)referente, (String)versione, privato, idAccordoOLD);
            if (isOk) {
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAcOLD);
            }
            if (isOk) {
                try {
                    acHelper.validaProtocolProperties(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (isOk) {
                try {
                    strutsBean.consoleDynamicConfiguration.validateDynamicConfigCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAcOLD);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (!isOk) {
                lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
                lstParam.add(new Parameter(titleAS, null));
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAcOLD);
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = acHelper.addHiddenFieldsToDati(tipoOp, id, null, null, dati);
                dati = acHelper.addAccordiCooperazioneToDati(dati, nome, descr, id, tipoOp, (String)referente, (String)versione, providersList, providersListLabel, privato, statoPackage, oldStatoPackage, tipoProtocollo, listaTipiProtocollo, used);
                dati = acHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.CHANGE());
            }
            if (used && actionConfirm == null) {
                lstParam = new ArrayList();
                lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
                lstParam.add(new Parameter(titleAS, null));
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAcOLD);
                dati.add(ServletUtils.getDataElementForEditModeInProgress());
                dati = acHelper.addHiddenFieldsToDati(tipoOp, id, null, null, dati);
                dati = acHelper.addAccordiCooperazioneToDati(dati, nome, descr, id, tipoOp, (String)referente, (String)versione, providersList, providersListLabel, privato, statoPackage, oldStatoPackage, tipoProtocollo, listaTipiProtocollo, used);
                dati = acHelper.addAccordiCooperazioneToDatiAsHidden(dati, nome, descr, id, tipoOp, (String)referente, (String)versione, providersList, providersListLabel, privato, statoPackage, oldStatoPackage, tipoProtocollo, listaTipiProtocollo, used);
                dati = acHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                dati = acHelper.addProtocolPropertiesToDatiAsHidden(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                String msg = "Attenzione, esistono Accordi di Servizio Composto che riferiscono l''Accordo di Cooperazione [{0}] che si sta modificando, continuare?";
                String uriAccordo = idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoOLD);
                String pre = "<p class=\"contenutoModal\"><span>";
                String post = "</span></p>";
                pd.setMessage(pre + MessageFormat.format(msg, uriAccordo) + post, Costanti.MESSAGE_TYPE_CONFIRM);
                String[][] bottoni = new String[][]{{"Annulla", "AnnullaConferma()"}, {"Conferma", "EseguiConferma()"}};
                pd.setBottoni(bottoni);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.CHANGE());
            }
            ac.setNome(nome);
            ac.setDescrizione(descr);
            if (!"".equals(referente) && !"-".equals(referente)) {
                int idRef = 0;
                try {
                    idRef = Integer.parseInt((String)referente);
                }
                catch (Exception dati) {
                    // empty catch block
                }
                if (idRef != 0) {
                    int idReferente = Integer.parseInt((String)referente);
                    Soggetto s = soggettiCore.getSoggettoRegistro(idReferente);
                    acsr = new IdSoggetto();
                    acsr.setTipo(s.getTipo());
                    acsr.setNome(s.getNome());
                    ac.setSoggettoReferente(acsr);
                }
            } else {
                ac.setSoggettoReferente(null);
            }
            if (versione != null) {
                ac.setVersione(Integer.valueOf(Integer.parseInt((String)versione)));
            }
            ac.setOraRegistrazione(Calendar.getInstance().getTime());
            ac.setPrivato(privato ? Boolean.TRUE : Boolean.FALSE);
            ac.setSuperUser(userLogin);
            ac.setOldIDAccordoForUpdate(idAccordoOLD);
            ac.setStatoPackage(statoPackage);
            if (acHelper.isShowGestioneWorkflowStatoDocumenti()) {
                try {
                    acCore.validaStatoAccordoCooperazione(ac);
                }
                catch (ValidazioneStatoPackageException validazioneException) {
                    pd.setMessage(validazioneException.toString());
                    ArrayList<Parameter> lstParam3 = new ArrayList<Parameter>();
                    lstParam3.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
                    lstParam3.add(new Parameter(titleAS, null));
                    ServletUtils.setPageDataTitle((PageData)pd, lstParam3);
                    List<DataElement> dati = new ArrayList<DataElement>();
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoCooperazione(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)acHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idAcOLD);
                    dati.add(ServletUtils.getDataElementForEditModeFinished());
                    dati = acHelper.addHiddenFieldsToDati(tipoOp, id, null, null, dati);
                    dati = acHelper.addAccordiCooperazioneToDati(dati, nome, descr, id, tipoOp, (String)referente, (String)versione, providersList, providersListLabel, privato, statoPackage, oldStatoPackage, tipoProtocollo, listaTipiProtocollo, used);
                    dati = acHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties, oldProtocolPropertyList, propertiesProprietario);
                    pd.setDati(dati);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.CHANGE());
                }
            }
            ArrayList<Object> oggettiDaAggiornare = new ArrayList<Object>();
            oggettiDaAggiornare.add(ac);
            if (!idAccordoCooperazioneFactory.getUriFromAccordo(ac).equals(idAccordoCooperazioneFactory.getUriFromIDAccordo(ac.getOldIDAccordoForUpdate()))) {
                List<AccordoServizioParteComune> ass = apcCore.accordiServizioWithAccordoCooperazione(ac.getOldIDAccordoForUpdate());
                for (int i = 0; i < ass.size(); ++i) {
                    AccordoServizioParteComune as = ass.get(i);
                    if (as.getServizioComposto() == null) continue;
                    as.getServizioComposto().setAccordoCooperazione(idAccordoCooperazioneFactory.getUriFromAccordo(ac));
                    oggettiDaAggiornare.add(as);
                }
            }
            ac.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (ConsoleOperationType)strutsBean.consoleOperationType, (List)oldProtocolPropertyList));
            acCore.performUpdateOperation(userLogin, acHelper.smista(), oggettiDaAggiornare.toArray());
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<AccordoCooperazione> lista2 = null;
            lista2 = acCore.isVisioneOggettiGlobale(userLogin) ? acCore.accordiCooperazioneList(null, (ISearch)ricerca) : acCore.accordiCooperazioneList(userLogin, (ISearch)ricerca);
            acHelper.prepareAccordiCooperazioneList(lista2, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiCooperazione", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

