/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.GruppiAccordo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneAddStrutsBean;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.apc.api.ApiHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        AccordiServizioParteComuneAddStrutsBean strutsBean = new AccordiServizioParteComuneAddStrutsBean();
        strutsBean.consoleOperationType = ConsoleOperationType.ADD;
        TipoOperazione tipoOp = TipoOperazione.ADD;
        try {
            boolean isOk;
            String tmpValidazioneDocumenti;
            ApiHelper apcHelper = new ApiHelper(request, pd, session);
            apcHelper.makeMenu();
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)session, (HttpServletRequest)request, (Boolean)false).getValue();
            strutsBean.editMode = apcHelper.getParametroEditMode("edit-mode");
            strutsBean.nome = apcHelper.getParameter("nome");
            strutsBean.descr = apcHelper.getParameter("descr");
            strutsBean.profcoll = apcHelper.getParameter("profcoll");
            strutsBean.wsdldef = apcHelper.getBinaryParameter("wsdldef");
            strutsBean.wsdlconc = apcHelper.getBinaryParameter("wsdlconc");
            strutsBean.wsdlserv = apcHelper.getBinaryParameter("wsdlserv");
            strutsBean.wsdlservcorr = apcHelper.getBinaryParameter("wsdlservcorr");
            strutsBean.wsblconc = apcHelper.getBinaryParameter("wsblconc");
            strutsBean.wsblserv = apcHelper.getBinaryParameter("wsblserv");
            strutsBean.wsblservcorr = apcHelper.getBinaryParameter("wsblservcorr");
            strutsBean.filtrodup = apcHelper.getParameter("filtrodup");
            strutsBean.confric = apcHelper.getParameter("confric");
            strutsBean.idcoll = apcHelper.getParameter("idcoll");
            strutsBean.idRifRichiesta = apcHelper.getParameter("idRifReq");
            strutsBean.consord = apcHelper.getParameter("consord");
            strutsBean.scadenza = apcHelper.getParameter("scadenza");
            strutsBean.referente = apcHelper.getParameter("referente");
            strutsBean.versione = apcHelper.getParameter("versione");
            String serviceBindingS = apcHelper.getParametroServiceBinding("serviceBinding");
            strutsBean.serviceBinding = StringUtils.isNotEmpty((CharSequence)serviceBindingS) ? ServiceBinding.valueOf((String)serviceBindingS) : null;
            String messageProcessorS = apcHelper.getParameter("messageType");
            strutsBean.messageType = StringUtils.isNotEmpty((CharSequence)messageProcessorS) && !messageProcessorS.equals("D") ? MessageType.valueOf((String)messageProcessorS) : null;
            String formatoSpecificaS = apcHelper.getParameter("interfaceType");
            strutsBean.interfaceType = StringUtils.isNotEmpty((CharSequence)formatoSpecificaS) ? InterfaceType.toEnumConstant((String)formatoSpecificaS) : null;
            strutsBean.gruppi = apcHelper.getParameter("gruppi");
            strutsBean.canale = apcHelper.getParameter("canale");
            strutsBean.canaleStato = apcHelper.getParameter("canaleStato");
            String priv = apcHelper.getParameter("privato");
            strutsBean.privato = ServletUtils.isCheckBoxEnabled((String)priv);
            String isServComp = apcHelper.getParameter("isServizioComposto");
            strutsBean.isServizioComposto = ServletUtils.isCheckBoxEnabled((String)isServComp);
            strutsBean.accordoCooperazione = apcHelper.getParameter("accordoCooperazione");
            strutsBean.statoPackage = apcHelper.getParameter("stato");
            strutsBean.tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(strutsBean.tipoAccordo)) {
                strutsBean.tipoAccordo = null;
            }
            if (strutsBean.tipoAccordo != null) {
                if ("apc".equals(strutsBean.tipoAccordo)) {
                    strutsBean.isServizioComposto = false;
                } else if ("asc".equals(strutsBean.tipoAccordo)) {
                    strutsBean.isServizioComposto = true;
                }
            }
            if (apcHelper.isMultipart()) {
                strutsBean.decodeRequestValidazioneDocumenti = true;
                tmpValidazioneDocumenti = apcHelper.getParameter("validazioneDocumenti");
                strutsBean.validazioneDocumenti = ServletUtils.isCheckBoxEnabled((String)tmpValidazioneDocumenti);
            }
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode)) {
                strutsBean.validazioneDocumenti = true;
            } else if (!strutsBean.decodeRequestValidazioneDocumenti) {
                tmpValidazioneDocumenti = apcHelper.getParameter("validazioneDocumenti");
                strutsBean.validazioneDocumenti = ServletUtils.isCheckBoxEnabled((String)tmpValidazioneDocumenti);
            }
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            SoggettiCore soggettiCore = new SoggettiCore(apcCore);
            AccordiCooperazioneCore acCore = new AccordiCooperazioneCore(apcCore);
            GruppiCore gruppiCore = new GruppiCore(apcCore);
            ConfigurazioneCore confCore = new ConfigurazioneCore(apcCore);
            String labelAccordoServizio = AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(strutsBean.tipoAccordo);
            CanaliConfigurazione gestioneCanali = confCore.getCanaliConfigurazione(false);
            List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
            boolean gestioneCanaliEnabled = gestioneCanali != null && org.openspcoop2.core.config.constants.StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            List<String> listaTipiProtocollo = apcCore.getProtocolliByFilter(request, session, true, PddTipologia.OPERATIVO, false, strutsBean.isServizioComposto);
            strutsBean.tipoProtocollo = apcHelper.getParameter("protocollo");
            if (strutsBean.tipoProtocollo == null) {
                strutsBean.tipoProtocollo = apcCore.getProtocolloDefault(request, session, listaTipiProtocollo);
            }
            String nuovaVersioneTmp = apcHelper.getParameter("apiNewVersion");
            strutsBean.nuovaVersione = ServletUtils.isCheckBoxEnabled((String)nuovaVersioneTmp);
            int gestioneNuovaVersioneMin = 1;
            boolean nuovaVersioneRidefinisciInterfaccia = true;
            long gestioneNuovaVersioneOldIdApc = -1L;
            List gestioneNuovaVersioneOldProtocolProperties = null;
            if (strutsBean.nuovaVersione) {
                String tmpIdPrecedenteAccordo;
                String nuovaVersioneTmpMinVersion = apcHelper.getParameter("apiNewVersionMin");
                if (!StringUtils.isEmpty((CharSequence)nuovaVersioneTmpMinVersion)) {
                    gestioneNuovaVersioneMin = Integer.parseInt(nuovaVersioneTmpMinVersion);
                }
                if (!StringUtils.isEmpty((CharSequence)(tmpIdPrecedenteAccordo = apcHelper.getParameter("id")))) {
                    long idAccordoPrec;
                    nuovaVersioneRidefinisciInterfaccia = true;
                    gestioneNuovaVersioneOldIdApc = idAccordoPrec = Long.parseLong(tmpIdPrecedenteAccordo);
                    AccordoServizioParteComune aspc = apcCore.getAccordoServizioFull(idAccordoPrec);
                    gestioneNuovaVersioneOldProtocolProperties = aspc.getProtocolPropertyList();
                    IDAccordo idAccordoPrecedente = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(aspc);
                    strutsBean.nome = aspc.getNome();
                    strutsBean.referente = "" + soggettiCore.getSoggetto(aspc.getSoggettoReferente().toIDSoggetto()).getId();
                    strutsBean.tipoProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(aspc.getSoggettoReferente().getTipo());
                    strutsBean.serviceBinding = apcCore.toMessageServiceBinding(aspc.getServiceBinding());
                    if (aspc.getMessageType() != null) {
                        strutsBean.messageType = apcCore.toMessageMessageType(aspc.getMessageType());
                    }
                    if (aspc.getServizioComposto() != null && aspc.getServizioComposto().getAccordoCooperazione() != null && !"".equals(aspc.getServizioComposto().getAccordoCooperazione())) {
                        IDAccordoCooperazione idAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(aspc.getServizioComposto().getAccordoCooperazione());
                        strutsBean.accordoCooperazione = "" + acCore.getAccordoCooperazione(idAccordoCooperazione).getId();
                        strutsBean.isServizioComposto = true;
                    }
                    if (strutsBean.interfaceType == null) {
                        strutsBean.interfaceType = apcCore.formatoSpecifica2InterfaceType(aspc.getFormatoSpecifica());
                    }
                    if (strutsBean.descr == null || StringUtils.isEmpty((CharSequence)strutsBean.descr)) {
                        strutsBean.descr = aspc.getDescrizione();
                    }
                    if ((strutsBean.gruppi == null || StringUtils.isEmpty((CharSequence)strutsBean.gruppi)) && aspc.getGruppi() != null && aspc.getGruppi().getGruppoList() != null && !aspc.getGruppi().getGruppoList().isEmpty()) {
                        List nomiGruppi = aspc.getGruppi().getGruppoList().stream().flatMap(e -> Stream.of(e.getNome())).collect(Collectors.toList());
                        strutsBean.gruppi = StringUtils.join(nomiGruppi, (String)",");
                    }
                    if (strutsBean.profcoll == null || StringUtils.isEmpty((CharSequence)strutsBean.profcoll)) {
                        strutsBean.profcoll = AccordiServizioParteComuneHelper.convertProfiloCollaborazioneDB2View(aspc.getProfiloCollaborazione());
                    }
                    if (strutsBean.filtrodup == null || StringUtils.isEmpty((CharSequence)strutsBean.filtrodup)) {
                        strutsBean.filtrodup = AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View(aspc.getFiltroDuplicati());
                    }
                    if (strutsBean.confric == null || StringUtils.isEmpty((CharSequence)strutsBean.confric)) {
                        strutsBean.confric = AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View(aspc.getConfermaRicezione());
                    }
                    if (strutsBean.idcoll == null || StringUtils.isEmpty((CharSequence)strutsBean.idcoll)) {
                        strutsBean.idcoll = AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View(aspc.getIdCollaborazione());
                    }
                    if (strutsBean.idRifRichiesta == null || StringUtils.isEmpty((CharSequence)strutsBean.idRifRichiesta)) {
                        strutsBean.idRifRichiesta = AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View(aspc.getIdRiferimentoRichiesta());
                    }
                    if (strutsBean.consord == null || StringUtils.isEmpty((CharSequence)strutsBean.consord)) {
                        strutsBean.consord = AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View(aspc.getConsegnaInOrdine());
                    }
                    if (strutsBean.scadenza == null || StringUtils.isEmpty((CharSequence)strutsBean.scadenza)) {
                        strutsBean.scadenza = aspc.getScadenza() != null ? aspc.getScadenza() : "";
                    }
                    gestioneNuovaVersioneMin = apcCore.getAccordoServizioParteComuneNextVersion(idAccordoPrecedente);
                    if (strutsBean.versione == null || StringUtils.isEmpty((CharSequence)strutsBean.versione)) {
                        strutsBean.versione = "" + gestioneNuovaVersioneMin;
                    }
                    if (strutsBean.canale == null || StringUtils.isEmpty((CharSequence)strutsBean.canale)) {
                        strutsBean.canale = aspc.getCanale();
                    }
                    if (strutsBean.canaleStato == null || StringUtils.isEmpty((CharSequence)strutsBean.canaleStato)) {
                        strutsBean.canaleStato = strutsBean.canale == null ? "default" : "ridefinito";
                    }
                } else {
                    String nuovaVersioneRidefinisciInterfacciaTmp = apcHelper.getParameter("apiNewVersionRedefine");
                    nuovaVersioneRidefinisciInterfaccia = ServletUtils.isCheckBoxEnabled((String)nuovaVersioneRidefinisciInterfacciaTmp);
                    String nuovaVersioneOldIdApcTmp = apcHelper.getParameter("apiNewVersionOldIdApc");
                    gestioneNuovaVersioneOldIdApc = Long.valueOf(nuovaVersioneOldIdApcTmp);
                }
            }
            strutsBean.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(strutsBean.tipoProtocollo);
            strutsBean.consoleDynamicConfiguration = strutsBean.protocolFactory.createDynamicConfigurationConsole();
            strutsBean.registryReader = soggettiCore.getRegistryReader(strutsBean.protocolFactory);
            strutsBean.configRegistryReader = soggettiCore.getConfigIntegrationReader(strutsBean.protocolFactory);
            if (strutsBean.serviceBinding == null) {
                strutsBean.serviceBinding = soggettiCore.getDefaultServiceBinding(strutsBean.protocolFactory);
            }
            FiltroRicercaGruppi filtroRicerca = new FiltroRicercaGruppi();
            filtroRicerca.setServiceBinding(apcCore.fromMessageServiceBinding(strutsBean.serviceBinding));
            List<String> elencoGruppi = gruppiCore.getAllGruppi(filtroRicerca);
            boolean showReferente = false;
            showReferente = strutsBean.isServizioComposto ? true : apcCore.isSupportatoSoggettoReferente(strutsBean.tipoProtocollo);
            IDAccordo idApc = null;
            strutsBean.consoleConfiguration = strutsBean.tipoAccordo == null || strutsBean.tipoAccordo.equals("apc") ? strutsBean.consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteComune(strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.registryReader, strutsBean.configRegistryReader, idApc) : strutsBean.consoleDynamicConfiguration.getDynamicConfigAccordoServizioComposto(strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
            strutsBean.protocolProperties = apcHelper.estraiProtocolPropertiesDaRequest(strutsBean.consoleConfiguration, strutsBean.consoleOperationType);
            if (strutsBean.nuovaVersione && gestioneNuovaVersioneOldProtocolProperties != null && !gestioneNuovaVersioneOldProtocolProperties.isEmpty()) {
                ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (List)gestioneNuovaVersioneOldProtocolProperties, (ConsoleOperationType)strutsBean.consoleOperationType);
            }
            boolean enableAutoMapping = apcCore.isEnableAutoMappingWsdlIntoAccordo();
            boolean enableAutoMappingEstraiXsdSchemiFromWsdlTypes = apcCore.isEnableAutoMappingWsdlIntoAccordoEstrazioneSchemiInWsdlTypes();
            List<String> tipiSoggettiGestitiProtocollo = soggettiCore.getTipiSoggettiGestitiProtocollo(strutsBean.tipoProtocollo);
            if (listaTipiProtocollo.isEmpty()) {
                List<String> listaTipiProtocolloSenzaAccordiCooperazione;
                boolean msg = true;
                if (strutsBean.isServizioComposto && !(listaTipiProtocolloSenzaAccordiCooperazione = apcCore.getProtocolliByFilter(request, session, true, PddTipologia.OPERATIVO, false, false)).isEmpty()) {
                    pd.setMessage("Non risultano registrati accordi di cooperazione", Costanti.MESSAGE_TYPE_INFO);
                    msg = false;
                }
                if (msg) {
                    if (soggettiCore.isGestionePddAbilitata(apcHelper)) {
                        pd.setMessage("Non risultano registrati soggetti associati a porte di dominio di tipo operativo", Costanti.MESSAGE_TYPE_INFO);
                    } else {
                        pd.setMessage("Non risultano registrati soggetti di dominio interno", Costanti.MESSAGE_TYPE_INFO);
                    }
                }
                pd.disableEditMode();
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteComune", (ForwardParams)ForwardParams.ADD());
            }
            List<org.openspcoop2.core.config.Soggetto> listaSoggetti = null;
            listaSoggetti = apcCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiList(null, (ISearch)new ConsoleSearch(true)) : soggettiCore.soggettiList(userLogin, (ISearch)new ConsoleSearch(true));
            String[] providersList = null;
            String[] providersListLabel = null;
            ArrayList<String> soggettiListTmp = new ArrayList<String>();
            ArrayList<String> soggettiListLabelTmp = new ArrayList<String>();
            soggettiListTmp.add("-");
            soggettiListLabelTmp.add("-");
            if (!listaSoggetti.isEmpty()) {
                for (org.openspcoop2.core.config.Soggetto soggetto : listaSoggetti) {
                    if (!tipiSoggettiGestitiProtocollo.contains(soggetto.getTipo())) continue;
                    soggettiListTmp.add(soggetto.getId().toString());
                    soggettiListLabelTmp.add(apcHelper.getLabelNomeSoggetto(strutsBean.tipoProtocollo, soggetto.getTipo(), soggetto.getNome()));
                }
            }
            providersList = soggettiListTmp.toArray(new String[1]);
            providersListLabel = soggettiListLabelTmp.toArray(new String[1]);
            String[] accordiCooperazioneEsistenti = null;
            String[] accordiCooperazioneEsistentiLabel = null;
            String postBackElementName = apcHelper.getParameter("postBackElementName");
            if (postBackElementName != null) {
                if (postBackElementName.equalsIgnoreCase("protocollo")) {
                    strutsBean.referente = null;
                    apcHelper.deleteBinaryParameters(strutsBean.wsdlconc, strutsBean.wsdldef, strutsBean.wsdlserv, strutsBean.wsdlservcorr, strutsBean.wsblconc, strutsBean.wsblserv, strutsBean.wsblservcorr);
                    apcHelper.deleteProtocolPropertiesBinaryParameters(strutsBean.wsdlconc, strutsBean.wsdldef, strutsBean.wsdlserv, strutsBean.wsdlservcorr, strutsBean.wsblconc, strutsBean.wsblserv, strutsBean.wsblservcorr);
                    strutsBean.serviceBinding = soggettiCore.getDefaultServiceBinding(strutsBean.protocolFactory);
                    strutsBean.interfaceType = null;
                    strutsBean.messageType = null;
                    strutsBean.wsdldef = apcHelper.newBinaryParameter("wsdldef");
                    strutsBean.wsdlconc = apcHelper.newBinaryParameter("wsdlconc");
                    strutsBean.wsdlserv = apcHelper.newBinaryParameter("wsdlserv");
                    strutsBean.wsdlservcorr = apcHelper.newBinaryParameter("wsdlservcorr");
                    strutsBean.wsblconc = apcHelper.newBinaryParameter("wsblconc");
                    strutsBean.wsblserv = apcHelper.newBinaryParameter("wsblserv");
                    strutsBean.wsblservcorr = apcHelper.newBinaryParameter("wsblservcorr");
                    filtroRicerca = new FiltroRicercaGruppi();
                    filtroRicerca.setServiceBinding(apcCore.fromMessageServiceBinding(strutsBean.serviceBinding));
                    elencoGruppi = gruppiCore.getAllGruppi(filtroRicerca);
                } else if (postBackElementName.equalsIgnoreCase("serviceBinding")) {
                    strutsBean.interfaceType = null;
                    strutsBean.messageType = null;
                    strutsBean.wsdldef = apcHelper.newBinaryParameter("wsdldef");
                    strutsBean.wsdlconc = apcHelper.newBinaryParameter("wsdlconc");
                    strutsBean.wsdlserv = apcHelper.newBinaryParameter("wsdlserv");
                    strutsBean.wsdlservcorr = apcHelper.newBinaryParameter("wsdlservcorr");
                    strutsBean.wsblconc = apcHelper.newBinaryParameter("wsblconc");
                    strutsBean.wsblserv = apcHelper.newBinaryParameter("wsblserv");
                    strutsBean.wsblservcorr = apcHelper.newBinaryParameter("wsblservcorr");
                    filtroRicerca = new FiltroRicercaGruppi();
                    filtroRicerca.setServiceBinding(apcCore.fromMessageServiceBinding(strutsBean.serviceBinding));
                    elencoGruppi = gruppiCore.getAllGruppi(filtroRicerca);
                }
            }
            Soggetto soggettoReferente = null;
            try {
                soggettoReferente = soggettiCore.getSoggettoRegistro(Long.valueOf(strutsBean.referente));
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<Object> tipiSoggettiCompatibili = new ArrayList();
            if (soggettoReferente != null) {
                String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(soggettoReferente.getTipo());
                tipiSoggettiCompatibili = soggettiCore.getTipiSoggettiGestitiProtocollo(protocollo);
            }
            if (strutsBean.isServizioComposto) {
                List<AccordoCooperazione> listaTmp = null;
                listaTmp = apcCore.isVisioneOggettiGlobale(userLogin) ? acCore.accordiCooperazioneList(null, (ISearch)new ConsoleSearch(true)) : acCore.accordiCooperazioneList(userLogin, (ISearch)new ConsoleSearch(true));
                ArrayList<AccordoCooperazione> listaAccordoCooperazione = new ArrayList<AccordoCooperazione>();
                for (AccordoCooperazione accordoCooperazione : listaTmp) {
                    if (accordoCooperazione.getSoggettoReferente() == null || tipiSoggettiCompatibili == null || !tipiSoggettiCompatibili.contains(accordoCooperazione.getSoggettoReferente().getTipo())) continue;
                    listaAccordoCooperazione.add(accordoCooperazione);
                }
                if (listaAccordoCooperazione != null && !listaAccordoCooperazione.isEmpty()) {
                    accordiCooperazioneEsistenti = new String[listaAccordoCooperazione.size() + 1];
                    accordiCooperazioneEsistentiLabel = new String[listaAccordoCooperazione.size() + 1];
                    int i = 1;
                    accordiCooperazioneEsistenti[0] = "-";
                    accordiCooperazioneEsistentiLabel[0] = "-";
                    for (AccordoCooperazione singleAC : listaAccordoCooperazione) {
                        accordiCooperazioneEsistenti[i] = "" + singleAC.getId();
                        accordiCooperazioneEsistentiLabel[i] = apcHelper.getLabelIdAccordoCooperazione(acCore.getAccordoCooperazione(singleAC.getId()));
                        ++i;
                    }
                } else {
                    accordiCooperazioneEsistenti = new String[1];
                    accordiCooperazioneEsistentiLabel = new String[1];
                    accordiCooperazioneEsistenti[0] = "-";
                    accordiCooperazioneEsistentiLabel[0] = "-";
                }
            }
            if (strutsBean.interfaceType == null && strutsBean.serviceBinding != null) {
                switch (strutsBean.serviceBinding) {
                    case REST: {
                        strutsBean.interfaceType = InterfaceType.toEnumConstant((String)AccordiServizioParteComuneCostanti.DEFAULT_VALUE_PARAMETRO_INTERFACE_TYPE_REST);
                        break;
                    }
                    default: {
                        strutsBean.interfaceType = InterfaceType.toEnumConstant((String)AccordiServizioParteComuneCostanti.DEFAULT_VALUE_PARAMETRO_INTERFACE_TYPE_SOAP);
                    }
                }
            }
            String servletNameApcList = isModalitaVistaApiCustom != null && isModalitaVistaApiCustom != false ? "accordiServizioParteComuneApiList.do" : "accordiServizioParteComuneList.do";
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(strutsBean.tipoAccordo);
            ArrayList<Parameter> listaParams = new ArrayList<Parameter>();
            listaParams.add(new Parameter(labelAccordoServizio, servletNameApcList, new Parameter[]{pTipoAccordo}));
            listaParams.add(new Parameter("Aggiungi", null));
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode)) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                if (strutsBean.nome == null) {
                    strutsBean.nome = "";
                    strutsBean.accordoCooperazione = "";
                    strutsBean.confric = "";
                    strutsBean.consord = "";
                    strutsBean.descr = "";
                    strutsBean.filtrodup = "yes";
                    strutsBean.idcoll = "";
                    strutsBean.idRifRichiesta = "";
                    strutsBean.profcoll = "sincrono";
                    if (strutsBean.serviceBinding != null) {
                        switch (strutsBean.serviceBinding) {
                            case REST: {
                                if (strutsBean.protocolFactory.createProtocolConfiguration().isSupportato(strutsBean.serviceBinding, ProfiloDiCollaborazione.ONEWAY)) {
                                    strutsBean.profcoll = "oneway";
                                    break;
                                }
                                strutsBean.profcoll = "sincrono";
                                break;
                            }
                        }
                    }
                    strutsBean.accordoCooperazione = "-1";
                    strutsBean.scadenza = "";
                    strutsBean.privato = false;
                    if (strutsBean.tipoProtocollo == null) {
                        strutsBean.tipoProtocollo = apcCore.getProtocolloDefault(request, session, listaTipiProtocollo);
                    }
                    strutsBean.referente = "";
                    if (strutsBean.tipoAccordo != null) {
                        if ("apc".equals(strutsBean.tipoAccordo)) {
                            strutsBean.isServizioComposto = false;
                        } else if ("asc".equals(strutsBean.tipoAccordo)) {
                            strutsBean.isServizioComposto = true;
                        }
                    } else {
                        strutsBean.isServizioComposto = false;
                    }
                    if (apcHelper.isShowGestioneWorkflowStatoDocumenti()) {
                        if (strutsBean.statoPackage == null) {
                            strutsBean.statoPackage = StatiAccordo.bozza.toString();
                        }
                    } else {
                        strutsBean.statoPackage = StatiAccordo.finale.toString();
                    }
                    strutsBean.versione = "1";
                    strutsBean.gruppi = "";
                    strutsBean.canaleStato = "default";
                    strutsBean.canale = "";
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (strutsBean.tipoAccordo == null || strutsBean.tipoAccordo.equals("apc")) {
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioParteComune(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                } else {
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioComposto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                }
                dati = apcHelper.addAccordiToDati(dati, strutsBean.nome, strutsBean.descr, strutsBean.profcoll, strutsBean.wsdldef, strutsBean.wsdlconc, strutsBean.wsdlserv, strutsBean.wsdlservcorr, strutsBean.wsblconc, strutsBean.wsblserv, strutsBean.wsblservcorr, strutsBean.filtrodup, strutsBean.confric, strutsBean.idcoll, strutsBean.idRifRichiesta, strutsBean.consord, strutsBean.scadenza, "0", tipoOp, false, true, strutsBean.referente, strutsBean.versione, providersList, providersListLabel, strutsBean.privato, strutsBean.isServizioComposto, accordiCooperazioneEsistenti, accordiCooperazioneEsistentiLabel, strutsBean.accordoCooperazione, strutsBean.statoPackage, strutsBean.statoPackage, strutsBean.tipoAccordo, strutsBean.validazioneDocumenti, strutsBean.tipoProtocollo, listaTipiProtocollo, false, false, strutsBean.protocolFactory, strutsBean.serviceBinding, strutsBean.messageType, strutsBean.interfaceType, strutsBean.gruppi, elencoGruppi, strutsBean.nuovaVersione, gestioneNuovaVersioneMin, nuovaVersioneRidefinisciInterfaccia, gestioneNuovaVersioneOldIdApc, false, strutsBean.canaleStato, strutsBean.canale, canaleList, gestioneCanaliEnabled);
                dati = apcHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteComune", (ForwardParams)ForwardParams.ADD());
            }
            boolean visibilitaAccordoCooperazione = false;
            if (!"-".equals(strutsBean.accordoCooperazione) && !"".equals(strutsBean.accordoCooperazione) && strutsBean.accordoCooperazione != null) {
                AccordoCooperazione ac = acCore.getAccordoCooperazione(Long.parseLong(strutsBean.accordoCooperazione));
                boolean bl = visibilitaAccordoCooperazione = ac.getPrivato() != null && ac.getPrivato() != false;
            }
            if (isOk = apcHelper.accordiCheckData(tipoOp, strutsBean.nome, strutsBean.descr, strutsBean.profcoll, strutsBean.wsdldef, strutsBean.wsdlconc, strutsBean.wsdlserv, strutsBean.wsdlservcorr, strutsBean.filtrodup, strutsBean.confric, strutsBean.idcoll, strutsBean.idRifRichiesta, strutsBean.consord, strutsBean.scadenza, "0", strutsBean.referente, strutsBean.versione, strutsBean.accordoCooperazione, strutsBean.privato, visibilitaAccordoCooperazione, null, strutsBean.wsblconc, strutsBean.wsblserv, strutsBean.wsblservcorr, strutsBean.validazioneDocumenti, strutsBean.tipoProtocollo, null, strutsBean.serviceBinding, strutsBean.messageType, strutsBean.interfaceType, showReferente, strutsBean.gruppi, strutsBean.canaleStato, strutsBean.canale, gestioneCanaliEnabled)) {
                if (strutsBean.tipoAccordo.equals("apc")) {
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioParteComune(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                } else {
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioComposto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                }
            }
            if (isOk) {
                try {
                    apcHelper.validaProtocolProperties(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                }
                catch (ProtocolException e2) {
                    ControlStationCore.getLog().error(e2.getMessage(), (Throwable)e2);
                    pd.setMessage(e2.getMessage());
                    isOk = false;
                }
            }
            if (isOk) {
                try {
                    idApc = apcHelper.getIDAccordoFromValues(strutsBean.nome, strutsBean.referente, strutsBean.versione, visibilitaAccordoCooperazione);
                    if (strutsBean.tipoAccordo.equals("apc")) {
                        strutsBean.consoleDynamicConfiguration.validateDynamicConfigAccordoServizioParteComune(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                    } else {
                        strutsBean.consoleDynamicConfiguration.validateDynamicConfigAccordoServizioComposto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                    }
                }
                catch (ProtocolException e3) {
                    ControlStationCore.getLog().error(e3.getMessage(), (Throwable)e3);
                    pd.setMessage(e3.getMessage());
                    isOk = false;
                }
            }
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (strutsBean.tipoAccordo.equals("apc")) {
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioParteComune(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                } else {
                    strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioComposto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                }
                dati = apcHelper.addAccordiToDati(dati, strutsBean.nome, strutsBean.descr, strutsBean.profcoll, strutsBean.wsdldef, strutsBean.wsdlconc, strutsBean.wsdlserv, strutsBean.wsdlservcorr, strutsBean.wsblconc, strutsBean.wsblserv, strutsBean.wsblservcorr, strutsBean.filtrodup, strutsBean.confric, strutsBean.idcoll, strutsBean.idRifRichiesta, strutsBean.consord, strutsBean.scadenza, "0", tipoOp, false, true, strutsBean.referente, strutsBean.versione, providersList, providersListLabel, strutsBean.privato, strutsBean.isServizioComposto, accordiCooperazioneEsistenti, accordiCooperazioneEsistentiLabel, strutsBean.accordoCooperazione, strutsBean.statoPackage, strutsBean.statoPackage, strutsBean.tipoAccordo, strutsBean.validazioneDocumenti, strutsBean.tipoProtocollo, listaTipiProtocollo, false, false, strutsBean.protocolFactory, strutsBean.serviceBinding, strutsBean.messageType, strutsBean.interfaceType, strutsBean.gruppi, elencoGruppi, strutsBean.nuovaVersione, gestioneNuovaVersioneMin, nuovaVersioneRidefinisciInterfaccia, gestioneNuovaVersioneOldIdApc, false, strutsBean.canaleStato, strutsBean.canale, canaleList, gestioneCanaliEnabled);
                dati = apcHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteComune", (ForwardParams)ForwardParams.ADD());
            }
            ArrayList<Object> objectToCreate = new ArrayList<Object>();
            AccordoServizioParteComune as = new AccordoServizioParteComune();
            as.setNome(strutsBean.nome);
            as.setDescrizione(strutsBean.descr);
            strutsBean.profcoll = AccordiServizioParteComuneHelper.convertProfiloCollaborazioneView2DB(strutsBean.profcoll);
            as.setProfiloCollaborazione(ProfiloCollaborazione.toEnumConstant((String)strutsBean.profcoll));
            FormatoSpecifica formato = apcCore.interfaceType2FormatoSpecifica(strutsBean.interfaceType);
            String wsdlconcS = strutsBean.wsdlconc.getValue() != null ? new String(strutsBean.wsdlconc.getValue()) : null;
            as.setByteWsdlConcettuale(apcCore.getInterfaceAsByteArray(formato, wsdlconcS));
            String wsdldefS = strutsBean.wsdldef.getValue() != null ? new String(strutsBean.wsdldef.getValue()) : null;
            as.setByteWsdlDefinitorio(apcCore.getInterfaceAsByteArray(formato, wsdldefS));
            String wsdlservS = strutsBean.wsdlserv.getValue() != null ? new String(strutsBean.wsdlserv.getValue()) : null;
            as.setByteWsdlLogicoErogatore(apcCore.getInterfaceAsByteArray(formato, wsdlservS));
            String wsdlservcorrS = strutsBean.wsdlservcorr.getValue() != null ? new String(strutsBean.wsdlservcorr.getValue()) : null;
            as.setByteWsdlLogicoFruitore(apcCore.getInterfaceAsByteArray(formato, wsdlservcorrS));
            boolean facilityUnicoWSDLInterfacciaStandard = false;
            if (as.getByteWsdlLogicoErogatore() != null && as.getByteWsdlLogicoFruitore() == null && as.getByteWsdlConcettuale() == null) {
                as.setByteWsdlConcettuale(as.getByteWsdlLogicoErogatore());
                facilityUnicoWSDLInterfacciaStandard = true;
            }
            as.setFiltroDuplicati(StatoFunzionalita.toEnumConstant((String)AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoView2DB(strutsBean.filtrodup)));
            as.setConfermaRicezione(StatoFunzionalita.toEnumConstant((String)AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoView2DB(strutsBean.confric)));
            as.setConsegnaInOrdine(StatoFunzionalita.toEnumConstant((String)AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoView2DB(strutsBean.consord)));
            as.setIdCollaborazione(StatoFunzionalita.toEnumConstant((String)AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoView2DB(strutsBean.idcoll)));
            as.setIdRiferimentoRichiesta(StatoFunzionalita.toEnumConstant((String)AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoView2DB(strutsBean.idRifRichiesta)));
            if (strutsBean.scadenza != null && !"".equals(strutsBean.scadenza)) {
                as.setScadenza(strutsBean.scadenza);
            }
            as.setSuperUser(userLogin);
            as.setUtilizzoSenzaAzione(true);
            String wsblconcS = strutsBean.wsblconc.getValue() != null ? new String(strutsBean.wsblconc.getValue()) : null;
            as.setByteSpecificaConversazioneConcettuale(apcCore.getInterfaceAsByteArray(formato, wsblconcS));
            String wsblservS = strutsBean.wsblserv.getValue() != null ? new String(strutsBean.wsblserv.getValue()) : null;
            as.setByteSpecificaConversazioneErogatore(apcCore.getInterfaceAsByteArray(formato, wsblservS));
            String wsblservcorrS = strutsBean.wsblservcorr.getValue() != null ? new String(strutsBean.wsblservcorr.getValue()) : null;
            as.setByteSpecificaConversazioneFruitore(apcCore.getInterfaceAsByteArray(formato, wsblservcorrS));
            as.setServiceBinding(apcCore.fromMessageServiceBinding(strutsBean.serviceBinding));
            as.setMessageType(apcCore.fromMessageMessageType(strutsBean.messageType));
            as.setFormatoSpecifica(formato);
            if (strutsBean.referente != null && !"".equals(strutsBean.referente) && !"-".equals(strutsBean.referente)) {
                int idRef = 0;
                try {
                    idRef = Integer.parseInt(strutsBean.referente);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (idRef != 0) {
                    int idReferente = Integer.parseInt(strutsBean.referente);
                    org.openspcoop2.core.config.Soggetto s = soggettiCore.getSoggetto(idReferente);
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(s.getTipo());
                    assr.setNome(s.getNome());
                    as.setSoggettoReferente(assr);
                }
            } else if (!showReferente) {
                IDSoggetto idSoggetto = apcCore.getSoggettoOperativoDefault(userLogin, strutsBean.tipoProtocollo);
                org.openspcoop2.core.config.Soggetto s = soggettiCore.getSoggetto(idSoggetto);
                IdSoggetto assr = new IdSoggetto();
                assr.setTipo(s.getTipo());
                assr.setNome(s.getNome());
                as.setSoggettoReferente(assr);
            } else {
                as.setSoggettoReferente(null);
            }
            if (strutsBean.versione != null) {
                as.setVersione(Integer.valueOf(Integer.parseInt(strutsBean.versione)));
            }
            as.setPrivato(strutsBean.privato ? Boolean.TRUE : Boolean.FALSE);
            if (strutsBean.accordoCooperazione != null && !"".equals(strutsBean.accordoCooperazione) && !"-".equals(strutsBean.accordoCooperazione)) {
                AccordoServizioParteComuneServizioComposto assc = new AccordoServizioParteComuneServizioComposto();
                assc.setIdAccordoCooperazione(Long.valueOf(Long.parseLong(strutsBean.accordoCooperazione)));
                as.setServizioComposto(assc);
            }
            as.setStatoPackage(strutsBean.statoPackage);
            if (StringUtils.isNotEmpty((CharSequence)strutsBean.gruppi)) {
                if (as.getGruppi() == null) {
                    as.setGruppi(new GruppiAccordo());
                }
                List<String> nomiGruppi = Arrays.asList(strutsBean.gruppi.split(","));
                for (String nomeGruppo : nomiGruppi) {
                    if (!gruppiCore.existsGruppo(nomeGruppo)) {
                        Gruppo nuovoGruppo = new Gruppo();
                        nuovoGruppo.setNome(nomeGruppo);
                        nuovoGruppo.setSuperUser(userLogin);
                        objectToCreate.add(nuovoGruppo);
                    }
                    GruppoAccordo gruppoAccordo = new GruppoAccordo();
                    gruppoAccordo.setNome(nomeGruppo);
                    as.getGruppi().addGruppo(gruppoAccordo);
                }
            }
            if (gestioneCanaliEnabled) {
                if ("ridefinito".equals(strutsBean.canaleStato)) {
                    as.setCanale(strutsBean.canale);
                } else {
                    as.setCanale(null);
                }
            } else {
                as.setCanale(null);
            }
            if (strutsBean.nuovaVersione && !nuovaVersioneRidefinisciInterfaccia) {
                IDAccordo idAcc = apcCore.getIdAccordoServizio(gestioneNuovaVersioneOldIdApc);
                AccordoServizioParteComune aspcOld = apcCore.getAccordoServizioFull(idAcc, true);
                as.setAllegatoList(aspcOld.getAllegatoList());
                as.setSpecificaSemiformaleList(aspcOld.getSpecificaSemiformaleList());
                as.setAzioneList(aspcOld.getAzioneList());
                as.setPortTypeList(aspcOld.getPortTypeList());
                as.setResourceList(aspcOld.getResourceList());
                as.setByteWsdlDefinitorio(aspcOld.getByteWsdlDefinitorio());
                as.setByteWsdlConcettuale(aspcOld.getByteWsdlConcettuale());
                as.setByteWsdlLogicoErogatore(aspcOld.getByteWsdlLogicoErogatore());
                as.setByteWsdlLogicoFruitore(aspcOld.getByteWsdlLogicoFruitore());
                as.setByteSpecificaConversazioneConcettuale(aspcOld.getByteSpecificaConversazioneConcettuale());
                as.setByteSpecificaConversazioneErogatore(aspcOld.getByteSpecificaConversazioneErogatore());
                as.setByteSpecificaConversazioneFruitore(aspcOld.getByteSpecificaConversazioneFruitore());
            }
            if (apcHelper.isShowGestioneWorkflowStatoDocumenti()) {
                try {
                    boolean utilizzoAzioniDiretteInAccordoAbilitato = apcCore.isShowAccordiColonnaAzioni();
                    apcCore.validaStatoAccordoServizio(as, utilizzoAzioniDiretteInAccordoAbilitato, true);
                }
                catch (ValidazioneStatoPackageException validazioneException) {
                    pd.setMessage(validazioneException.toString());
                    ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                    List<DataElement> dati = new ArrayList<DataElement>();
                    dati.add(ServletUtils.getDataElementForEditModeFinished());
                    if (strutsBean.tipoAccordo.equals("apc")) {
                        strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioParteComune(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                    } else {
                        strutsBean.consoleDynamicConfiguration.updateDynamicConfigAccordoServizioComposto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)apcHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idApc);
                    }
                    dati = apcHelper.addAccordiToDati(dati, strutsBean.nome, strutsBean.descr, strutsBean.profcoll, strutsBean.wsdldef, strutsBean.wsdlconc, strutsBean.wsdlserv, strutsBean.wsdlservcorr, strutsBean.wsblconc, strutsBean.wsblserv, strutsBean.wsblservcorr, strutsBean.filtrodup, strutsBean.confric, strutsBean.idcoll, strutsBean.idRifRichiesta, strutsBean.consord, strutsBean.scadenza, "0", tipoOp, false, true, strutsBean.referente, strutsBean.versione, providersList, providersListLabel, strutsBean.privato, strutsBean.isServizioComposto, accordiCooperazioneEsistenti, accordiCooperazioneEsistentiLabel, strutsBean.accordoCooperazione, strutsBean.statoPackage, strutsBean.statoPackage, strutsBean.tipoAccordo, strutsBean.validazioneDocumenti, strutsBean.tipoProtocollo, listaTipiProtocollo, false, false, strutsBean.protocolFactory, strutsBean.serviceBinding, strutsBean.messageType, strutsBean.interfaceType, strutsBean.gruppi, elencoGruppi, strutsBean.nuovaVersione, gestioneNuovaVersioneMin, nuovaVersioneRidefinisciInterfaccia, gestioneNuovaVersioneOldIdApc, false, strutsBean.canaleStato, strutsBean.canale, canaleList, gestioneCanaliEnabled);
                    dati = apcHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                    pd.setDati(dati);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteComune", (ForwardParams)ForwardParams.ADD());
                }
            }
            if (!strutsBean.nuovaVersione || nuovaVersioneRidefinisciInterfaccia) {
                AccordiServizioParteComuneUtilities.mapppingAutomaticoInterfaccia(as, apcCore, enableAutoMapping, strutsBean.validazioneDocumenti, enableAutoMappingEstraiXsdSchemiFromWsdlTypes, facilityUnicoWSDLInterfacciaStandard, strutsBean.tipoProtocollo, strutsBean.interfaceType);
            }
            as.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (ConsoleOperationType)strutsBean.consoleOperationType, null));
            objectToCreate.add(as);
            apcCore.performCreateOperation(userLogin, apcHelper.smista(), objectToCreate.toArray(new Object[objectToCreate.size()]));
            apcHelper.deleteBinaryParameters(strutsBean.wsdlconc, strutsBean.wsdldef, strutsBean.wsdlserv, strutsBean.wsdlservcorr, strutsBean.wsblconc, strutsBean.wsblserv, strutsBean.wsblservcorr);
            apcHelper.deleteBinaryProtocolPropertiesTmpFiles(strutsBean.protocolProperties);
            boolean incomplete = apcHelper.setMessageWarningStatoConsistenzaAccordo(true, as);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            if (incomplete || apcCore.isSetSearchAfterAdd()) {
                apcCore.setSearchAfterAdd(Liste.ACCORDI, as.getNome(), request, session, (ISearch)ricerca);
            }
            List<AccordoServizioParteComuneSintetico> lista = AccordiServizioParteComuneUtilities.accordiList(apcCore, userLogin, ricerca, strutsBean.tipoAccordo);
            if (isModalitaVistaApiCustom != null && isModalitaVistaApiCustom.booleanValue()) {
                apcHelper.prepareApiList(lista, (ISearch)ricerca, strutsBean.tipoAccordo);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComuneApi", (ForwardParams)ForwardParams.ADD());
            }
            apcHelper.prepareAccordiList(lista, (ISearch)ricerca, strutsBean.tipoAccordo);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComune", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e4) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e4, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComune", (ForwardParams)ForwardParams.ADD());
        }
    }
}

