/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneAllegatiDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            AccordiServizioParteComuneHelper apcHelper = new AccordiServizioParteComuneHelper(request, pd, session);
            apcHelper.makeMenu();
            String objToRemove = apcHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            String tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            ArchiviCore archiviCore = new ArchiviCore(apcCore);
            AccordoServizioParteComune as = null;
            ArrayList<Long> idAllegati = new ArrayList<Long>();
            for (int i = 0; i < idsToRemove.size(); ++i) {
                long idAllegato = Long.parseLong(idsToRemove.get(i));
                idAllegati.add(idAllegato);
                if (as != null) continue;
                Documento doc = archiviCore.getDocumento(idAllegato, false);
                as = apcCore.getAccordoServizioFull(doc.getIdProprietarioDocumento());
            }
            if (as == null) {
                throw new Exception("API non trovata");
            }
            AccordiServizioParteComuneUtilities.deleteAccordoServizioParteComuneAllegati(as, userLogin, apcCore, apcHelper, idAllegati);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Documento> lista = apcCore.accordiAllegatiList(as.getId().intValue(), (ISearch)ricerca);
            apcHelper.prepareAccordiAllegatiList(as, (ISearch)ricerca, lista, tipoAccordo);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)ForwardParams.DEL());
        }
    }
}

