/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaProtocolPropertyRegistry;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.IDAccordoDB;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.lib.mvc.Parameter;

public class AccordiServizioParteComuneUtilities {
    public static void findOggettiDaAggiornare(IDAccordo idAccordoOLD, AccordoServizioParteComune as, AccordiServizioParteComuneCore apcCore, List<Object> listOggettiDaAggiornare) throws Exception {
        AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(apcCore);
        IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
        String newURI = idAccordoFactory.getUriFromAccordo(as);
        List<AccordoServizioParteSpecifica> servizi = apsCore.serviziByAccordoFilterList(idAccordoOLD);
        if (servizi != null) {
            while (servizi.size() > 0) {
                AccordoServizioParteSpecifica s = servizi.remove(0);
                s.setAccordoServizioParteComune(newURI);
                listOggettiDaAggiornare.add(s);
            }
        }
        if ("modipa".equals(idAccordoOLD.getSoggettoReferente().getTipo())) {
            String oldURI = idAccordoFactory.getUriFromIDAccordo(idAccordoOLD);
            HashMap<String, AccordoServizioParteComune> map = new HashMap<String, AccordoServizioParteComune>();
            if (ServiceBinding.REST.equals((Object)as.getServiceBinding())) {
                FiltroRicercaResources filtroRicerca = new FiltroRicercaResources();
                FiltroRicercaProtocolPropertyRegistry filtroRPP = new FiltroRicercaProtocolPropertyRegistry();
                filtroRPP.setName("modipaInteractionAsyncApiRequest");
                filtroRPP.setValueAsString(oldURI);
                filtroRicerca.addProtocolPropertyResource(filtroRPP);
                List<IDResource> list = null;
                try {
                    list = apcCore.getAllIdResource(filtroRicerca);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (list != null && !list.isEmpty()) {
                    for (IDResource idResource : list) {
                        AccordoServizioParteComune aspc = null;
                        String uri = idAccordoFactory.getUriFromIDAccordo(idResource.getIdAccordo());
                        boolean forceAdd = false;
                        if (map.containsKey(uri)) {
                            aspc = (AccordoServizioParteComune)map.remove(uri);
                            forceAdd = true;
                        } else {
                            aspc = idResource.getIdAccordo().equals((Object)idAccordoOLD) ? as : apcCore.getAccordoServizioFull(idResource.getIdAccordo());
                        }
                        boolean find = false;
                        if (aspc.sizeResourceList() > 0) {
                            block6: for (Resource res : aspc.getResourceList()) {
                                if (!res.getNome().equals(idResource.getNome())) continue;
                                if (res.sizeProtocolPropertyList() <= 0) break;
                                for (ProtocolProperty pp : res.getProtocolPropertyList()) {
                                    if (!"modipaInteractionAsyncApiRequest".equals(pp.getName())) continue;
                                    pp.setValue(newURI);
                                    find = true;
                                    break block6;
                                }
                            }
                        }
                        if (idResource.getIdAccordo().equals((Object)idAccordoOLD) || !forceAdd && !find) continue;
                        map.put(uri, aspc);
                    }
                }
            } else {
                FiltroRicercaOperations filtroRicerca = new FiltroRicercaOperations();
                FiltroRicercaProtocolPropertyRegistry filtroRPP = new FiltroRicercaProtocolPropertyRegistry();
                filtroRPP.setName("modipaInteractionAsyncApiRequest");
                filtroRPP.setValueAsString(oldURI);
                filtroRicerca.addProtocolPropertyAzione(filtroRPP);
                List<IDPortTypeAzione> list = null;
                try {
                    list = apcCore.getAllIdOperation(filtroRicerca);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (list != null && !list.isEmpty()) {
                    for (IDPortTypeAzione idAzione : list) {
                        AccordoServizioParteComune aspc = null;
                        String uri = idAccordoFactory.getUriFromIDAccordo(idAzione.getIdPortType().getIdAccordo());
                        boolean forceAdd = false;
                        if (map.containsKey(uri)) {
                            aspc = (AccordoServizioParteComune)map.remove(uri);
                            forceAdd = true;
                        } else {
                            aspc = idAzione.getIdPortType().getIdAccordo().equals((Object)idAccordoOLD) ? as : apcCore.getAccordoServizioFull(idAzione.getIdPortType().getIdAccordo());
                        }
                        boolean find = false;
                        if (aspc.sizePortTypeList() > 0) {
                            block9: for (PortType portType : aspc.getPortTypeList()) {
                                if (!portType.getNome().contentEquals(idAzione.getIdPortType().getNome())) continue;
                                if (portType.sizeAzioneList() <= 0) break;
                                for (Operation op : portType.getAzioneList()) {
                                    if (!op.getNome().equals(idAzione.getNome())) continue;
                                    if (op.sizeProtocolPropertyList() <= 0) break block9;
                                    for (ProtocolProperty pp : op.getProtocolPropertyList()) {
                                        if (!"modipaInteractionAsyncApiRequest".equals(pp.getName())) continue;
                                        pp.setValue(newURI);
                                        find = true;
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (idAzione.getIdPortType().getIdAccordo().equals((Object)idAccordoOLD) || !forceAdd && !find) continue;
                        map.put(uri, aspc);
                    }
                }
            }
            if (!map.isEmpty()) {
                listOggettiDaAggiornare.addAll(map.values());
            }
        }
    }

    public static boolean deleteAccordoServizioParteComune(AccordoServizioParteComune as, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        boolean normalizeObjectIds;
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        boolean bl = normalizeObjectIds = !apcHelper.isModalitaCompleta();
        if (!apcCore.isAccordoInUso(as, whereIsInUso, normalizeObjectIds)) {
            apcCore.performDeleteOperation(userLogin, apcHelper.smista(), as);
            return true;
        }
        inUsoMessage.append(DBOggettiInUsoUtils.toString((IDAccordo)idAccordo, whereIsInUso, (boolean)true, (String)newLine, (boolean)normalizeObjectIds));
        inUsoMessage.append(newLine);
        return false;
    }

    public static boolean deleteResource(AccordoServizioParteComune as, IDResource idResource, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        boolean normalizeObjectIds = !apcHelper.isModalitaCompleta();
        boolean risorsaInUso = apcCore.isRisorsaInUso(idResource, whereIsInUso, normalizeObjectIds);
        boolean modificaAS_effettuata = false;
        if (risorsaInUso) {
            String methodPath = null;
            for (int j = 0; j < as.sizeResourceList(); ++j) {
                Resource risorsa = as.getResource(j);
                if (!idResource.getNome().equals(risorsa.getNome())) continue;
                methodPath = NamingUtils.getLabelResource((Resource)risorsa);
                break;
            }
            if (methodPath == null) {
                methodPath = idResource.getNome();
            }
            inUsoMessage.append(DBOggettiInUsoUtils.toString((IDResource)idResource, (String)methodPath, whereIsInUso, (boolean)true, (String)newLine));
            inUsoMessage.append(newLine);
        } else {
            for (int j = 0; j < as.sizeResourceList(); ++j) {
                Resource risorsa = as.getResource(j);
                if (!idResource.getNome().equals(risorsa.getNome())) continue;
                modificaAS_effettuata = true;
                as.removeResource(j);
                break;
            }
        }
        return modificaAS_effettuata;
    }

    public static void deleteAccordoServizioParteComuneRisorse(AccordoServizioParteComune as, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, StringBuilder inUsoMessage, String newLine, List<String> resourcesToRemove) throws Exception {
        boolean modificaAS_effettuata = false;
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        for (int i = 0; i < resourcesToRemove.size(); ++i) {
            String nomeRisorsa = resourcesToRemove.get(i);
            IDResource idRisorsa = new IDResource();
            idRisorsa.setNome(nomeRisorsa);
            idRisorsa.setIdAccordo(idAccordo);
            boolean modificato = AccordiServizioParteComuneUtilities.deleteResource(as, idRisorsa, userLogin, apcCore, apcHelper, inUsoMessage, newLine);
            if (!modificato) continue;
            modificaAS_effettuata = true;
        }
        if (modificaAS_effettuata) {
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
        }
    }

    public static boolean deletePortType(AccordoServizioParteComune as, IDPortType idPortType, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        boolean normalizeObjectIds = !apcHelper.isModalitaCompleta();
        boolean portTypeInUso = apcCore.isPortTypeInUso(idPortType, whereIsInUso, normalizeObjectIds);
        boolean modificaAS_effettuata = false;
        if (portTypeInUso) {
            inUsoMessage.append(DBOggettiInUsoUtils.toString((IDPortType)idPortType, whereIsInUso, (boolean)true, (String)newLine));
            inUsoMessage.append(newLine);
        } else {
            for (int j = 0; j < as.sizePortTypeList(); ++j) {
                PortType pt = as.getPortType(j);
                if (!idPortType.getNome().equals(pt.getNome())) continue;
                modificaAS_effettuata = true;
                as.removePortType(j);
                break;
            }
        }
        return modificaAS_effettuata;
    }

    public static void deleteAccordoServizioParteComunePortTypes(AccordoServizioParteComune as, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, StringBuilder inUsoMessage, String newLine, List<String> ptsToRemove) throws Exception {
        boolean modificaAS_effettuata = false;
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        for (int i = 0; i < ptsToRemove.size(); ++i) {
            String nomePT = ptsToRemove.get(i);
            IDPortType idPT = new IDPortType();
            idPT.setNome(nomePT);
            idPT.setIdAccordo(idAccordo);
            boolean modificato = AccordiServizioParteComuneUtilities.deletePortType(as, idPT, userLogin, apcCore, apcHelper, inUsoMessage, newLine);
            if (!modificato) continue;
            modificaAS_effettuata = true;
        }
        if (modificaAS_effettuata) {
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
        }
    }

    public static boolean deleteOperazione(PortType pt, IDPortTypeAzione idOperazione, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        boolean normalizeObjectIds = !apcHelper.isModalitaCompleta();
        boolean operazioneInUso = apcCore.isOperazioneInUso(idOperazione, whereIsInUso, normalizeObjectIds);
        boolean modificaAS_effettuata = false;
        if (operazioneInUso) {
            inUsoMessage.append(DBOggettiInUsoUtils.toString((IDPortTypeAzione)idOperazione, whereIsInUso, (boolean)true, (String)newLine));
            inUsoMessage.append(newLine);
        } else {
            for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                Operation op = pt.getAzione(j);
                if (!idOperazione.getNome().equals(op.getNome())) continue;
                modificaAS_effettuata = true;
                pt.removeAzione(j);
                break;
            }
        }
        return modificaAS_effettuata;
    }

    public static void deleteAccordoServizioParteComuneOperations(AccordoServizioParteComune as, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, StringBuilder inUsoMessage, String newLine, PortType pt, List<String> optsToRemove) throws Exception {
        boolean modificaAS_effettuata = false;
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        IDPortType idPortType = new IDPortType();
        idPortType.setNome(pt.getNome());
        idPortType.setIdAccordo(idAccordo);
        for (int i = 0; i < optsToRemove.size(); ++i) {
            String nomeop = optsToRemove.get(i);
            IDPortTypeAzione idOperazione = new IDPortTypeAzione();
            idOperazione.setNome(nomeop);
            idOperazione.setIdPortType(idPortType);
            boolean modificato = AccordiServizioParteComuneUtilities.deleteOperazione(pt, idOperazione, userLogin, apcCore, apcHelper, inUsoMessage, newLine);
            if (!modificato) continue;
            modificaAS_effettuata = true;
        }
        if (modificaAS_effettuata) {
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), pt);
        }
    }

    public static void updateAccordoServizioParteComuneAllegati(AccordoServizioParteComune as, Documento doc, Documento docNew) {
        switch (RuoliDocumento.valueOf((String)doc.getRuolo())) {
            case allegato: {
                for (int i = 0; i < as.sizeAllegatoList(); ++i) {
                    Documento documento = as.getAllegato(i);
                    if (!documento.getId().equals(doc.getId())) continue;
                    as.removeAllegato(i);
                }
                as.addAllegato(docNew);
                break;
            }
            case specificaSemiformale: {
                for (int i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
                    Documento documento = as.getSpecificaSemiformale(i);
                    if (!documento.getId().equals(doc.getId())) continue;
                    as.removeSpecificaSemiformale(i);
                    break;
                }
                as.addSpecificaSemiformale(docNew);
                break;
            }
            case specificaCoordinamento: {
                AccordoServizioParteComuneServizioComposto assc = as.getServizioComposto();
                for (int i = 0; i < assc.sizeSpecificaCoordinamentoList(); ++i) {
                    Documento documento = assc.getSpecificaCoordinamento(i);
                    if (!documento.getId().equals(doc.getId())) continue;
                    assc.removeSpecificaCoordinamento(i);
                    break;
                }
                assc.addSpecificaCoordinamento(docNew);
                as.setServizioComposto(assc);
            }
        }
    }

    public static void deleteAccordoServizioParteComuneAllegati(AccordoServizioParteComune as, String userLogin, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, List<Long> idAllegati) throws Exception {
        ArchiviCore archiviCore = new ArchiviCore(apcCore);
        block6: for (int i = 0; i < idAllegati.size(); ++i) {
            long idAllegato = idAllegati.get(i);
            Documento doc = archiviCore.getDocumento(idAllegato, false);
            switch (RuoliDocumento.valueOf((String)doc.getRuolo())) {
                case allegato: {
                    Documento documento;
                    int j;
                    for (j = 0; j < as.sizeAllegatoList(); ++j) {
                        documento = as.getAllegato(j);
                        if (!documento.getFile().equals(doc.getFile())) continue;
                        as.removeAllegato(j);
                    }
                    continue block6;
                }
                case specificaSemiformale: {
                    Documento documento;
                    int j;
                    for (j = 0; j < as.sizeSpecificaSemiformaleList(); ++j) {
                        documento = as.getSpecificaSemiformale(j);
                        if (!documento.getFile().equals(doc.getFile())) continue;
                        as.removeSpecificaSemiformale(j);
                    }
                    continue block6;
                }
                case specificaCoordinamento: {
                    Documento documento;
                    int j;
                    if (as.getServizioComposto() == null) continue block6;
                    for (j = 0; j < as.getServizioComposto().sizeSpecificaCoordinamentoList(); ++j) {
                        documento = as.getServizioComposto().getSpecificaCoordinamento(j);
                        if (!documento.getFile().equals(doc.getFile())) continue;
                        as.getServizioComposto().removeSpecificaCoordinamento(j);
                    }
                    continue block6;
                }
                case specificaLivelloServizio: {
                    continue block6;
                }
            }
        }
        apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
    }

    public static String getTerminologiaAccordoServizio(String tipo) {
        String termine = null;
        termine = "apc".equals(tipo) ? "API" : "API (Servizio Composto)";
        return termine;
    }

    @Deprecated
    public static String getParametroAccordoServizio(String tipo, String appendChar) {
        Object parametro = "";
        parametro = "apc".equals(tipo) ? appendChar + "tipoAccordo=apc" : appendChar + "tipoAccordo=asc";
        return parametro;
    }

    public static Parameter getParametroAccordoServizio(AccordoServizioParteComune apc) {
        if (apc.getServizioComposto() != null) {
            return new Parameter("tipoAccordo", "asc");
        }
        return new Parameter("tipoAccordo", "apc");
    }

    public static Parameter getParametroAccordoServizio(AccordoServizioParteComuneSintetico apc) {
        if (apc.getServizioComposto() != null) {
            return new Parameter("tipoAccordo", "asc");
        }
        return new Parameter("tipoAccordo", "apc");
    }

    public static Parameter getParametroAccordoServizio(String tipo) {
        if ("apc".equals(tipo)) {
            return new Parameter("tipoAccordo", "apc");
        }
        return new Parameter("tipoAccordo", "asc");
    }

    public static boolean showInformazioniServiziComponenti(String tipo) {
        boolean value = true;
        if ("apc".equals(tipo)) {
            value = false;
        }
        return value;
    }

    public static boolean showFlagServizioComposto() {
        return false;
    }

    public static List<AccordoServizioParteComuneSintetico> accordiList(AccordiServizioParteComuneCore core, String userLogin, ConsoleSearch ricerca, String tipoAccordo) throws DriverRegistroServiziException {
        List<AccordoServizioParteComuneSintetico> lista = null;
        lista = "apc".equals(tipoAccordo) ? (core.isVisioneOggettiGlobale(userLogin) ? core.accordiServizioParteComuneList(null, (ISearch)ricerca) : core.accordiServizioParteComuneList(userLogin, (ISearch)ricerca)) : ("asc".equals(tipoAccordo) ? (core.isVisioneOggettiGlobale(userLogin) ? core.accordiServizioCompostiList(null, (ISearch)ricerca) : core.accordiServizioCompostiList(userLogin, (ISearch)ricerca)) : (core.isVisioneOggettiGlobale(userLogin) ? core.accordiList(null, (ISearch)ricerca) : core.accordiList(userLogin, (ISearch)ricerca)));
        return lista;
    }

    public static List<AccordoServizioParteComuneSintetico> accordiListFromPermessiUtente(AccordiServizioParteComuneCore core, String userLogin, ConsoleSearch ricerca, boolean[] permessiUtente) throws DriverRegistroServiziException {
        List<AccordoServizioParteComuneSintetico> lista = null;
        if (permessiUtente != null) {
            if (permessiUtente[0] && !permessiUtente[1]) {
                lista = core.isVisioneOggettiGlobale(userLogin) ? core.accordiServizioParteComuneList(null, (ISearch)ricerca) : core.accordiServizioParteComuneList(userLogin, (ISearch)ricerca);
                return lista;
            }
            if (!permessiUtente[0] && permessiUtente[1]) {
                lista = core.isVisioneOggettiGlobale(userLogin) ? core.accordiServizioCompostiList(null, (ISearch)ricerca) : core.accordiServizioCompostiList(userLogin, (ISearch)ricerca);
                return lista;
            }
        }
        lista = core.isVisioneOggettiGlobale(userLogin) ? core.accordiList(null, (ISearch)ricerca) : core.accordiList(userLogin, (ISearch)ricerca);
        return lista;
    }

    public static List<IDAccordoDB> idAccordiListFromPermessiUtente(AccordiServizioParteComuneCore core, String userLogin, ConsoleSearch ricerca, boolean[] permessiUtente, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        List<IDAccordoDB> lista = null;
        if (permessiUtente != null) {
            if (permessiUtente[0] && !permessiUtente[1]) {
                lista = core.isVisioneOggettiGlobale(userLogin) ? core.idAccordiServizioParteComuneList(null, (ISearch)ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap) : core.idAccordiServizioParteComuneList(userLogin, (ISearch)ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
                return lista;
            }
            if (!permessiUtente[0] && permessiUtente[1]) {
                lista = core.isVisioneOggettiGlobale(userLogin) ? core.idAccordiServizioCompostiList(null, (ISearch)ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap) : core.idAccordiServizioCompostiList(userLogin, (ISearch)ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
                return lista;
            }
        }
        lista = core.isVisioneOggettiGlobale(userLogin) ? core.idAccordiList(null, (ISearch)ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap) : core.idAccordiList(userLogin, (ISearch)ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
        return lista;
    }

    public static ArrayList<String> selectPortTypeAsincroni(AccordoServizioParteComune as, String profcollop, String nomept) {
        ArrayList<String> servCorrUniche = null;
        ArrayList<PortType> getServCorrList = new ArrayList<PortType>();
        for (int k = 0; k < as.sizePortTypeList(); ++k) {
            getServCorrList.add(as.getPortType(k));
        }
        if (!getServCorrList.isEmpty()) {
            servCorrUniche = new ArrayList<String>();
            servCorrUniche.add("-");
            for (PortType myPT : getServCorrList) {
                if (myPT.sizeAzioneList() <= 0) continue;
                ArrayList<Operation> opList = new ArrayList<Operation>();
                for (int j = 0; j < myPT.sizeAzioneList(); ++j) {
                    Operation op = myPT.getAzione(j);
                    if ("ridefinito".equals(op.getProfAzione()) && op.getProfiloCollaborazione() != null && op.getProfiloCollaborazione().equals(profcollop)) {
                        opList.add(op);
                        continue;
                    }
                    if ("default".equals(op.getProfAzione()) && "ridefinito".equals(myPT.getProfiloPT()) && myPT.getProfiloCollaborazione() != null && myPT.getProfiloCollaborazione().equals(profcollop)) {
                        opList.add(op);
                        continue;
                    }
                    if (!"default".equals(op.getProfAzione()) || !"default".equals(myPT.getProfiloPT()) || as.getProfiloCollaborazione() == null || !as.getProfiloCollaborazione().equals(profcollop)) continue;
                    opList.add(op);
                }
                if (opList.size() <= 0 || nomept.equals(myPT.getNome())) continue;
                servCorrUniche.add(myPT.getNome());
            }
        }
        if (servCorrUniche != null && servCorrUniche.size() > 0) {
            return servCorrUniche;
        }
        return null;
    }

    public static Map<String, List<Operation>> selectPortTypeOperationsListAsincrone(AccordoServizioParteComune as, String profcollop, String nomept) {
        ArrayList<PortType> getServCorrList = new ArrayList<PortType>();
        for (int k = 0; k < as.sizePortTypeList(); ++k) {
            getServCorrList.add(as.getPortType(k));
        }
        HashMap<String, List<Operation>> operationsListSelezionate = new HashMap<String, List<Operation>>();
        if (!getServCorrList.isEmpty()) {
            for (PortType myPT : getServCorrList) {
                if (myPT.sizeAzioneList() <= 0) continue;
                ArrayList<Operation> opList = new ArrayList<Operation>();
                for (int j = 0; j < myPT.sizeAzioneList(); ++j) {
                    Operation op = myPT.getAzione(j);
                    if ("ridefinito".equals(op.getProfAzione()) && op.getProfiloCollaborazione() != null && op.getProfiloCollaborazione().equals(profcollop)) {
                        opList.add(op);
                        continue;
                    }
                    if ("default".equals(op.getProfAzione()) && "ridefinito".equals(myPT.getProfiloPT()) && myPT.getProfiloCollaborazione() != null && myPT.getProfiloCollaborazione().equals(profcollop)) {
                        opList.add(op);
                        continue;
                    }
                    if (!"default".equals(op.getProfAzione()) || !"default".equals(myPT.getProfiloPT()) || as.getProfiloCollaborazione() == null || !as.getProfiloCollaborazione().equals(profcollop)) continue;
                    opList.add(op);
                }
                if (opList.size() <= 0) continue;
                if (!nomept.equals(myPT.getNome())) {
                    operationsListSelezionate.put(myPT.getNome(), opList);
                    continue;
                }
                operationsListSelezionate.put("-", opList);
            }
        }
        return operationsListSelezionate;
    }

    public static ArrayList<String> selectOperationAsincrone(AccordoServizioParteComune as, String servcorr, String profProtocollo, String profcollop, PortType pt, String nomeop, AccordiServizioParteComuneCore core, Map<String, List<Operation>> operationsListSelezionate) throws DriverRegistroServiziException {
        ArrayList<String> aziCorrUniche = null;
        List<Operation> getAziCorrList = null;
        PortType ptSel = null;
        if (!servcorr.equals("-")) {
            for (int j = 0; j < as.sizePortTypeList() && !servcorr.equals((ptSel = as.getPortType(j)).getNome()); ++j) {
            }
            getAziCorrList = operationsListSelezionate.get(servcorr);
        } else {
            boolean calcolaLista = false;
            if ("ridefinito".equals(profProtocollo) && profcollop.equals("asincronoAsimmetrico")) {
                calcolaLista = true;
            } else if ("default".contentEquals(profProtocollo)) {
                if ("ridefinito".equals(pt.getProfiloPT())) {
                    if (pt.getProfiloCollaborazione() != null) {
                        calcolaLista = "asincronoAsimmetrico".equals(pt.getProfiloCollaborazione().getValue());
                    }
                } else if (as.getProfiloCollaborazione() != null) {
                    calcolaLista = "asincronoAsimmetrico".equals(as.getProfiloCollaborazione().getValue());
                }
            }
            if (calcolaLista) {
                getAziCorrList = operationsListSelezionate.get(servcorr);
                ptSel = pt;
            }
        }
        if (getAziCorrList != null && getAziCorrList.size() > 0) {
            aziCorrUniche = new ArrayList<String>();
            aziCorrUniche.add("-");
            for (Operation operation : getAziCorrList) {
                if (servcorr.equals("-") && nomeop.equals(operation.getNome()) || ptSel == null || core.isOperationCorrelata(ptSel.getNome(), ptSel.getId(), operation.getNome(), operation.getId())) continue;
                aziCorrUniche.add(operation.getNome());
            }
        }
        if (aziCorrUniche != null && aziCorrUniche.size() > 0) {
            return aziCorrUniche;
        }
        return null;
    }

    public static void mapppingAutomaticoInterfaccia(AccordoServizioParteComune as, AccordiServizioParteComuneCore apcCore, boolean enableAutoMapping, boolean validazioneDocumenti, boolean enableAutoMapping_estraiXsdSchemiFromWsdlTypes, boolean facilityUnicoWSDL_interfacciaStandard, String tipoProtocollo, InterfaceType interfaceType) throws Exception {
        if (as.getByteWsdlConcettuale() != null || as.getByteWsdlLogicoErogatore() != null || as.getByteWsdlLogicoFruitore() != null) {
            apcCore.mappingAutomatico(tipoProtocollo, as, validazioneDocumenti);
            if (enableAutoMapping_estraiXsdSchemiFromWsdlTypes && InterfaceType.WSDL_11.equals((Object)interfaceType)) {
                HashMap<String, byte[]> schemiAggiuntiInQuestaOperazione = new HashMap<String, byte[]>();
                if (as.getByteWsdlConcettuale() != null) {
                    apcCore.estraiSchemiFromWSDLTypesAsAllegati(as, as.getByteWsdlConcettuale(), "Concettuale", schemiAggiuntiInQuestaOperazione);
                }
                if (facilityUnicoWSDL_interfacciaStandard) {
                    if (as.getByteWsdlConcettuale() != null) {
                        as.setByteWsdlLogicoErogatore(as.getByteWsdlConcettuale());
                    }
                } else {
                    if (as.getByteWsdlLogicoErogatore() != null) {
                        apcCore.estraiSchemiFromWSDLTypesAsAllegati(as, as.getByteWsdlLogicoErogatore(), "LogicoErogatore", schemiAggiuntiInQuestaOperazione);
                    }
                    if (as.getByteWsdlLogicoFruitore() != null) {
                        apcCore.estraiSchemiFromWSDLTypesAsAllegati(as, as.getByteWsdlLogicoFruitore(), "LogicoFruitore", schemiAggiuntiInQuestaOperazione);
                    }
                }
            }
            try {
                as.setStatoPackage(StatiAccordo.operativo.toString());
                boolean utilizzoAzioniDiretteInAccordoAbilitato = apcCore.isShowAccordiColonnaAzioni();
                apcCore.validaStatoAccordoServizio(as, utilizzoAzioniDiretteInAccordoAbilitato, false);
            }
            catch (ValidazioneStatoPackageException validazioneException) {
                as.setStatoPackage(StatiAccordo.bozza.toString());
            }
        }
    }

    public static boolean createPortTypeOperation(boolean enableAutoMapping, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, AccordoServizioParteComune as, PortType pt, String userLogin) throws Exception {
        boolean updateAccordo = false;
        try {
            if (enableAutoMapping && StatiAccordo.bozza.toString().equals(as.getStatoPackage()) && pt.sizeAzioneList() == 1) {
                as.setStatoPackage(StatiAccordo.operativo.toString());
                boolean utilizzoAzioniDiretteInAccordoAbilitato = apcCore.isShowAccordiColonnaAzioni();
                apcCore.validaStatoAccordoServizio(as, utilizzoAzioniDiretteInAccordoAbilitato, false);
                updateAccordo = true;
            }
        }
        catch (ValidazioneStatoPackageException validazioneStatoPackageException) {
            // empty catch block
        }
        if (updateAccordo) {
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
        } else {
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), pt);
        }
        return updateAccordo;
    }

    public static void createResource(boolean enableAutoMapping, AccordiServizioParteComuneCore apcCore, AccordiServizioParteComuneHelper apcHelper, AccordoServizioParteComune as, String userLogin) throws Exception {
        try {
            if (enableAutoMapping && StatiAccordo.bozza.toString().equals(as.getStatoPackage()) && as.sizeResourceList() == 1) {
                as.setStatoPackage(StatiAccordo.operativo.toString());
                boolean utilizzoAzioniDiretteInAccordoAbilitato = apcCore.isShowAccordiColonnaAzioni();
                apcCore.validaStatoAccordoServizio(as, utilizzoAzioniDiretteInAccordoAbilitato, false);
            }
        }
        catch (ValidazioneStatoPackageException validazioneException) {
            as.setStatoPackage(StatiAccordo.bozza.toString());
        }
        apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
    }

    public static void updateInterfacciaAccordoServizioParteComune(String tipoParam, String wsdlS, AccordoServizioParteComune as, boolean enableAutoMapping, boolean validazioneDocumenti, boolean enableAutoMapping_estraiXsdSchemiFromWsdlTypes, boolean facilityUnicoWSDL_interfacciaStandard, String tipoProtocollo, AccordiServizioParteComuneCore apcCore, boolean aggiornaEsistenti, boolean eliminaNonPresentiNuovaInterfaccia, List<IDResource> risorseEliminate, List<IDPortType> portTypeEliminati, List<IDPortTypeAzione> operationEliminate) throws Exception {
        FormatoSpecifica formato = null;
        byte[] wsdlBytes = null;
        if (as != null) {
            formato = as.getFormatoSpecifica();
        }
        if (wsdlS != null) {
            wsdlBytes = apcCore.getInterfaceAsByteArray(formato, wsdlS);
        }
        if (tipoParam.equals("wsdldef")) {
            as.setByteWsdlDefinitorio(wsdlBytes);
        } else if (enableAutoMapping) {
            if (wsdlBytes != null) {
                AccordoServizioParteComune asNuovo = new AccordoServizioParteComune();
                asNuovo.setFormatoSpecifica(as.getFormatoSpecifica());
                asNuovo.setServiceBinding(as.getServiceBinding());
                boolean fillXsd = false;
                String tipo = null;
                if (tipoParam.equals("wsdlconc")) {
                    as.setByteWsdlConcettuale(wsdlBytes);
                    asNuovo.setByteSpecificaConversazioneConcettuale(as.getByteSpecificaConversazioneConcettuale());
                    asNuovo.setByteSpecificaConversazioneErogatore(as.getByteSpecificaConversazioneErogatore());
                    asNuovo.setByteSpecificaConversazioneFruitore(as.getByteSpecificaConversazioneFruitore());
                    asNuovo.setByteWsdlConcettuale(wsdlBytes);
                    fillXsd = true;
                    tipo = "Concettuale";
                }
                if (tipoParam.equals("wsdlserv")) {
                    as.setByteWsdlLogicoErogatore(wsdlBytes);
                    asNuovo.setByteSpecificaConversazioneConcettuale(as.getByteSpecificaConversazioneConcettuale());
                    asNuovo.setByteSpecificaConversazioneErogatore(as.getByteSpecificaConversazioneErogatore());
                    asNuovo.setByteSpecificaConversazioneFruitore(as.getByteSpecificaConversazioneFruitore());
                    asNuovo.setByteWsdlLogicoErogatore(wsdlBytes);
                    fillXsd = true;
                    tipo = facilityUnicoWSDL_interfacciaStandard ? "Concettuale" : "LogicoErogatore";
                }
                if (tipoParam.equals("wsdlservcorr")) {
                    as.setByteWsdlLogicoFruitore(wsdlBytes);
                    asNuovo.setByteSpecificaConversazioneConcettuale(as.getByteSpecificaConversazioneConcettuale());
                    asNuovo.setByteSpecificaConversazioneErogatore(as.getByteSpecificaConversazioneErogatore());
                    asNuovo.setByteSpecificaConversazioneFruitore(as.getByteSpecificaConversazioneFruitore());
                    asNuovo.setByteWsdlLogicoFruitore(wsdlBytes);
                    fillXsd = true;
                    tipo = "LogicoFruitore";
                }
                if (tipoParam.equals("wsblconc")) {
                    as.setByteSpecificaConversazioneConcettuale(wsdlBytes);
                    asNuovo.setByteSpecificaConversazioneConcettuale(wsdlBytes);
                    asNuovo.setByteWsdlConcettuale(as.getByteWsdlConcettuale());
                    asNuovo.setByteWsdlLogicoErogatore(as.getByteWsdlLogicoErogatore());
                    asNuovo.setByteWsdlLogicoFruitore(as.getByteWsdlLogicoFruitore());
                }
                if (tipoParam.equals("wsblserv")) {
                    as.setByteSpecificaConversazioneErogatore(wsdlBytes);
                    asNuovo.setByteSpecificaConversazioneErogatore(wsdlBytes);
                    asNuovo.setByteWsdlConcettuale(as.getByteWsdlConcettuale());
                    asNuovo.setByteWsdlLogicoErogatore(as.getByteWsdlLogicoErogatore());
                    asNuovo.setByteWsdlLogicoFruitore(as.getByteWsdlLogicoFruitore());
                }
                if (tipoParam.equals("wsblservcorr")) {
                    as.setByteSpecificaConversazioneFruitore(wsdlBytes);
                    asNuovo.setByteSpecificaConversazioneFruitore(wsdlBytes);
                    asNuovo.setByteWsdlConcettuale(as.getByteWsdlConcettuale());
                    asNuovo.setByteWsdlLogicoErogatore(as.getByteWsdlLogicoErogatore());
                    asNuovo.setByteWsdlLogicoFruitore(as.getByteWsdlLogicoFruitore());
                }
                apcCore.mappingAutomatico(tipoProtocollo, asNuovo, validazioneDocumenti);
                if (ServiceBinding.REST.equals((Object)as.getServiceBinding())) {
                    apcCore.popolaResourceDaUnAltroASPC(as, asNuovo, aggiornaEsistenti, eliminaNonPresentiNuovaInterfaccia, risorseEliminate);
                } else {
                    apcCore.popolaPorttypeOperationDaUnAltroASPC(as, asNuovo, aggiornaEsistenti, eliminaNonPresentiNuovaInterfaccia, portTypeEliminati, operationEliminate);
                }
                if (fillXsd && enableAutoMapping_estraiXsdSchemiFromWsdlTypes && FormatoSpecifica.WSDL_11.equals((Object)as.getFormatoSpecifica())) {
                    apcCore.estraiSchemiFromWSDLTypesAsAllegati(as, wsdlBytes, tipo, new HashMap<String, byte[]>());
                    if (facilityUnicoWSDL_interfacciaStandard) {
                        as.setByteWsdlLogicoErogatore(as.getByteWsdlConcettuale());
                    }
                }
                try {
                    if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) {
                        as.setStatoPackage(StatiAccordo.operativo.toString());
                        boolean utilizzoAzioniDiretteInAccordoAbilitato = apcCore.isShowAccordiColonnaAzioni();
                        apcCore.validaStatoAccordoServizio(as, utilizzoAzioniDiretteInAccordoAbilitato, false);
                    }
                }
                catch (ValidazioneStatoPackageException validazioneException) {
                    as.setStatoPackage(StatiAccordo.bozza.toString());
                }
            }
        } else {
            if (tipoParam.equals("wsdlconc")) {
                as.setByteWsdlConcettuale(wsdlBytes);
            }
            if (tipoParam.equals("wsdlserv")) {
                as.setByteWsdlLogicoErogatore(wsdlBytes);
            }
            if (tipoParam.equals("wsdlservcorr")) {
                as.setByteWsdlLogicoFruitore(wsdlBytes);
            }
            if (tipoParam.equals("wsblconc")) {
                as.setByteSpecificaConversazioneConcettuale(wsdlBytes);
            }
            if (tipoParam.equals("wsblserv")) {
                as.setByteSpecificaConversazioneErogatore(wsdlBytes);
            }
            if (tipoParam.equals("wsblservcorr")) {
                as.setByteSpecificaConversazioneFruitore(wsdlBytes);
            }
        }
        if (as != null && as.getByteWsdlLogicoErogatore() != null && as.getByteWsdlLogicoFruitore() == null && as.getByteWsdlConcettuale() == null) {
            as.setByteWsdlConcettuale(as.getByteWsdlLogicoErogatore());
        }
    }
}

