/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import java.sql.Connection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.ResourceSintetica;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordoServizioParteComuneSinteticoCore;

public class AccordoServizioParteComuneInUsoCore
extends ControlStationCore {
    private AccordoServizioParteComuneSinteticoCore sinteticoCore;

    protected AccordoServizioParteComuneInUsoCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
        this.sinteticoCore = new AccordoServizioParteComuneSinteticoCore(core);
    }

    public boolean isAccordoInUso(IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isAccordoInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isAccordoInUso(idAccordo, whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isAccordoInUso(AccordoServizioParteComune as, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isAccordoInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isAccordoInUso(as, whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliAccordoInUso(IDAccordo idAccordo) throws DriverRegistroServiziException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean apcInUso = this.isAccordoInUso(idAccordo, whereIsInUso, normalizeObjectIds);
        StringBuilder inUsoMessage = new StringBuilder();
        if (apcInUso) {
            String s = DBOggettiInUsoUtils.toString((IDAccordo)idAccordo, whereIsInUso, (boolean)false, (String)"\n", (boolean)normalizeObjectIds);
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("L'API non risulta utilizzata in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }

    public boolean isRisorsaInUso(IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isRisorsaInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isRisorsaInUso(idRisorsa, whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliRisorsaInUso(IDResource idResource) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean risorsaInUso = this.isRisorsaInUso(idResource, whereIsInUso, normalizeObjectIds);
        StringBuilder inUsoMessage = new StringBuilder();
        if (risorsaInUso) {
            AccordoServizioParteComuneSintetico as = this.sinteticoCore.getAccordoServizioSintetico(idResource.getIdAccordo());
            String methodPath = this.getMethodPath(idResource, as);
            String s = DBOggettiInUsoUtils.toString((IDResource)idResource, (String)methodPath, whereIsInUso, (boolean)false, (String)"\n");
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("La risorsa non risulta utilizzata in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }

    private String getMethodPath(IDResource idResource, AccordoServizioParteComuneSintetico as) throws DriverRegistroServiziException {
        String methodPath = null;
        if (as.getResource() != null) {
            for (int j = 0; j < as.getResource().size(); ++j) {
                ResourceSintetica risorsa = (ResourceSintetica)as.getResource().get(j);
                if (!idResource.getNome().equals(risorsa.getNome())) continue;
                try {
                    methodPath = NamingUtils.getLabelResource((ResourceSintetica)risorsa);
                    break;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (methodPath == null) {
            methodPath = idResource.getNome();
        }
        return methodPath;
    }

    public boolean isPortTypeInUso(IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isPortTypeInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isPortTypeInUso(idPT, whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliPortTypeInUso(IDPortType idPT) throws DriverRegistroServiziException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean ptInUso = this.isPortTypeInUso(idPT, whereIsInUso, normalizeObjectIds);
        StringBuilder inUsoMessage = new StringBuilder();
        if (ptInUso) {
            String s = DBOggettiInUsoUtils.toString((IDPortType)idPT, whereIsInUso, (boolean)false, (String)"\n");
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("Il servizio non risulta utilizzato in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }

    public boolean isOperazioneInUso(IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isOperazioneInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isOperazioneInUso(idOperazione, whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliOperazioneInUso(IDPortTypeAzione idOperazione) throws DriverRegistroServiziException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean risorsaInUso = this.isOperazioneInUso(idOperazione, whereIsInUso, normalizeObjectIds);
        StringBuilder inUsoMessage = new StringBuilder();
        if (risorsaInUso) {
            String s = DBOggettiInUsoUtils.toString((IDPortTypeAzione)idOperazione, whereIsInUso, (boolean)false, (String)"\n");
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("L'azione non risulta utilizzata in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }
}

