/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteSpecificaAllegatiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            AccordiServizioParteSpecificaHelper apsHelper = new AccordiServizioParteSpecificaHelper(request, pd, session);
            apsHelper.makeMenu();
            String idServizio = apsHelper.getParametroLong("id");
            long idServizioLong = Long.parseLong(idServizio);
            String ruolo = apsHelper.getParameter("ruolo");
            String tipoFile = apsHelper.getParameter("tipoFile");
            String modificaAPI = apsHelper.getParameter("modificaAPI");
            List<BinaryParameter> binaryParameterDocumenti = apsHelper.getBinaryParameters("theFile");
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore();
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = false;
            if (tipologia != null && "fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            }
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idServizioLong);
            String tipoSoggettoFruitore = null;
            String nomeSoggettoFruitore = null;
            IDSoggetto idSoggettoFruitore = null;
            if (gestioneFruitori) {
                tipoSoggettoFruitore = apsHelper.getParametroTipoSoggetto("tipoSoggFru");
                nomeSoggettoFruitore = apsHelper.getParameter("nomeSoggFru");
                idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
            }
            String tipoProtocollo = apsCore.getProtocolloAssociatoTipoServizio(asps.getTipo());
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
            String tmpTitle = apsHelper.getLabelServizio(idSoggettoFruitore, gestioneFruitori, asps, tipoProtocollo);
            String[] ruoli = new String[]{RuoliDocumento.allegato.toString(), RuoliDocumento.specificaSemiformale.toString(), RuoliDocumento.specificaSicurezza.toString(), RuoliDocumento.specificaLivelloServizio.toString()};
            String[] tipiAmmessi = null;
            String[] tipiAmmessiLabel = null;
            if (ruolo != null && !"".equals(ruolo)) {
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        break;
                    }
                    case specificaSicurezza: {
                        tipiAmmessi = TipiDocumentoSicurezza.toEnumNameArray();
                        tipiAmmessiLabel = TipiDocumentoSicurezza.toStringArray();
                        break;
                    }
                    case specificaSemiformale: {
                        tipiAmmessi = TipiDocumentoSemiformale.toEnumNameArray();
                        tipiAmmessiLabel = TipiDocumentoSemiformale.toStringArray();
                        break;
                    }
                    case specificaLivelloServizio: {
                        tipiAmmessi = TipiDocumentoLivelloServizio.toEnumNameArray();
                        tipiAmmessiLabel = TipiDocumentoLivelloServizio.toStringArray();
                        break;
                    }
                }
            }
            boolean find = false;
            if (tipoFile != null && StringUtils.isNotEmpty((CharSequence)tipoFile) && tipiAmmessi != null && tipiAmmessi.length > 0) {
                for (String t : tipiAmmessi) {
                    if (!tipoFile.equals(t)) continue;
                    find = true;
                    break;
                }
            }
            if (!find) {
                tipoFile = null;
            }
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)session, (HttpServletRequest)request).getValue();
            if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
                if (gestioneFruitori) {
                    lstParam.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
                } else {
                    lstParam.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
                }
                ArrayList<Parameter> listErogazioniChange = new ArrayList<Parameter>();
                Parameter pIdServizio = new Parameter("id", "" + asps.getId());
                listErogazioniChange.add(pIdServizio);
                if (gestioneFruitori) {
                    Parameter pNomeSoggettoFruitore = new Parameter("nomeSoggFru", nomeSoggettoFruitore);
                    Parameter pTipoSoggettoFruitore = new Parameter("tipoSoggFru", tipoSoggettoFruitore);
                    listErogazioniChange.add(pNomeSoggettoFruitore);
                    listErogazioniChange.add(pTipoSoggettoFruitore);
                }
                if (modificaAPI != null) {
                    Parameter pModificaAPI = new Parameter("modificaAPI", modificaAPI);
                    listErogazioniChange.add(pModificaAPI);
                }
                lstParam.add(new Parameter(tmpTitle, "aspsErogazioniChange.do", listErogazioniChange.toArray(new Parameter[1])));
                lstParam.add(new Parameter("Informazioni Generali", "accordiServizioParteSpecificaChange.do", listErogazioniChange.toArray(new Parameter[1])));
                lstParam.add(new Parameter("Allegati", "accordiServizioParteSpecificaAllegatiList.do", listErogazioniChange.toArray(new Parameter[1])));
            } else {
                if (gestioneFruitori) {
                    lstParam.add(new Parameter("Fruizioni", "accordiServizioParteSpecificaList.do"));
                } else {
                    lstParam.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                }
                lstParam.add(new Parameter("Allegati di " + tmpTitle, "accordiServizioParteSpecificaAllegatiList.do", new Parameter[]{new Parameter("id", idServizio)}));
            }
            lstParam.add(ServletUtils.getParameterAggiungi());
            if (apsHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = apsHelper.addHiddenFieldsToDati(TipoOperazione.ADD, idServizio, null, null, null, null, tipoSoggettoFruitore, nomeSoggettoFruitore, dati);
                dati = apsHelper.addTipiAllegatiToDati(TipoOperazione.ADD, idServizio, ruolo, ruoli, tipiAmmessi, tipiAmmessiLabel, tipoFile, dati, modificaAPI, binaryParameterDocumenti);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteSpecificaAllegati", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = apsHelper.serviziAllegatiCheckData(TipoOperazione.ADD, binaryParameterDocumenti, asps.getId(), pf);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = apsHelper.addHiddenFieldsToDati(TipoOperazione.ADD, idServizio, null, null, dati);
                dati = apsHelper.addTipiAllegatiToDati(TipoOperazione.ADD, idServizio, ruolo, ruoli, tipiAmmessi, tipiAmmessiLabel, tipoFile, dati, modificaAPI, binaryParameterDocumenti);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteSpecificaAllegati", (ForwardParams)ForwardParams.ADD());
            }
            for (BinaryParameter binaryParameter : binaryParameterDocumenti) {
                Documento documento = new Documento();
                documento.setRuolo(RuoliDocumento.valueOf((String)ruolo).toString());
                documento.setByteContenuto(binaryParameter.getValue());
                documento.setFile(binaryParameter.getFilename());
                documento.setIdProprietarioDocumento(asps.getId());
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        documento.setTipo(binaryParameter.getFilename().substring(binaryParameter.getFilename().lastIndexOf(46) + 1, binaryParameter.getFilename().length()));
                        asps.addAllegato(documento);
                        break;
                    }
                    case specificaSemiformale: {
                        documento.setTipo(TipiDocumentoSemiformale.valueOf((String)tipoFile).getNome());
                        asps.addSpecificaSemiformale(documento);
                        break;
                    }
                    case specificaSicurezza: {
                        documento.setTipo(TipiDocumentoSicurezza.valueOf((String)tipoFile).getNome());
                        asps.addSpecificaSicurezza(documento);
                        break;
                    }
                    case specificaLivelloServizio: {
                        documento.setTipo(TipiDocumentoLivelloServizio.valueOf((String)tipoFile).getNome());
                        asps.addSpecificaLivelloServizio(documento);
                        break;
                    }
                }
            }
            apsCore.performUpdateOperation(userLogin, apsHelper.smista(), asps);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Documento> lista = apsCore.serviziAllegatiList(idServizioLong, (ISearch)ricerca);
            apsHelper.prepareServiziAllegatiList(asps, (ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteSpecificaAllegati", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteSpecificaAllegati", (ForwardParams)ForwardParams.ADD());
        }
    }
}

