/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.protocol.basic.registry.ConfigIntegrationReader;
import org.openspcoop2.protocol.basic.registry.RegistryReader;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ArchiveValidator;
import org.openspcoop2.protocol.engine.archive.DeleterArchiveUtils;
import org.openspcoop2.protocol.engine.archive.ExporterArchiveUtils;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.engine.archive.ImporterArchiveUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveCascadeConfiguration;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoDelete;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiveEngine;

public class ArchiviCore
extends ControlStationCore {
    public ArchiviCore() throws Exception {
    }

    public ArchiviCore(ControlStationCore core) throws Exception {
        super(core);
    }

    public boolean isCascadeEnabled(List<ExportMode> exportModes, String exportMode) {
        boolean cascadeEnabled = false;
        for (ExportMode exp : exportModes) {
            if (!exp.equals(exportMode) || exp.getCascade() == null || !exp.getCascade().isCascadePdd() && !exp.getCascade().isCascadeRuoli() && !exp.getCascade().isCascadeScope() && !exp.getCascade().isCascadeSoggetti() && !exp.getCascade().isCascadeServiziApplicativi() && !exp.getCascade().isCascadePorteDelegate() && !exp.getCascade().isCascadePorteApplicative() && !exp.getCascade().isCascadeAccordoCooperazione() && !exp.getCascade().isCascadeAccordoServizioComposto() && !exp.getCascade().isCascadeAccordoServizioParteComune() && !exp.getCascade().isCascadeAccordoServizioParteSpecifica() && !exp.getCascade().isCascadeFruizioni()) continue;
            cascadeEnabled = true;
            break;
        }
        return cascadeEnabled;
    }

    public ArchiveCascadeConfiguration getCascadeConfig(List<ExportMode> exportModes, String exportMode) {
        for (ExportMode exp : exportModes) {
            if (!exp.equals(exportMode)) continue;
            return exp.getCascade();
        }
        return null;
    }

    public byte[] export(String userLogin, boolean smista, String protocol, Archive archive, ArchiveMode archiveMode) throws DriverControlStationException, ImportInformationMissingException {
        Connection con = null;
        DriverControlStationDB driver = null;
        ByteArrayOutputStream bout = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ArchiveEngine importerEngine = new ArchiveEngine(driver.getDriverRegistroServiziDB(), driver.getDriverConfigurazioneDB(), driver.getJdbcServiceManagerPlugins(), driver.getJdbcServiceManagerControlloTraffico(), driver.getJdbcServiceManagerAllarmi(), this, smista, userLogin);
            ExporterArchiveUtils exportUtils = new ExporterArchiveUtils((AbstractArchiveEngine)importerEngine, log);
            bout = new ByteArrayOutputStream();
            exportUtils.export(protocol, archive, (OutputStream)bout, archiveMode);
            bout.flush();
            bout.close();
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (ImportInformationMissingException iime) {
            throw iime;
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("export", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void export(String userLogin, boolean smista, String protocol, Archive archive, OutputStream out, ArchiveMode archiveMode) throws DriverControlStationException, ImportInformationMissingException {
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ArchiveEngine importerEngine = new ArchiveEngine(driver.getDriverRegistroServiziDB(), driver.getDriverConfigurazioneDB(), driver.getJdbcServiceManagerPlugins(), driver.getJdbcServiceManagerControlloTraffico(), driver.getJdbcServiceManagerAllarmi(), this, smista, userLogin);
            ExporterArchiveUtils exportUtils = new ExporterArchiveUtils((AbstractArchiveEngine)importerEngine, log);
            exportUtils.export(protocol, archive, out, archiveMode);
        }
        catch (ImportInformationMissingException iime) {
            throw iime;
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("export", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Archive readArchiveForExport(String userLogin, boolean smista, ArchiveType tipoEsportazione, List<?> listObject, ArchiveCascadeConfiguration cascadeConfig) throws DriverControlStationException, ImportInformationMissingException {
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ArchiveEngine importerEngine = new ArchiveEngine(driver.getDriverRegistroServiziDB(), driver.getDriverConfigurazioneDB(), driver.getJdbcServiceManagerPlugins(), driver.getJdbcServiceManagerControlloTraffico(), driver.getJdbcServiceManagerAllarmi(), this, smista, userLogin);
            ExporterArchiveUtils exportUtils = new ExporterArchiveUtils((AbstractArchiveEngine)importerEngine, log);
            Archive archive = new Archive();
            exportUtils.fillArchive(archive, tipoEsportazione, listObject, cascadeConfig);
            Archive archive2 = archive;
            return archive2;
        }
        catch (ImportInformationMissingException iime) {
            throw iime;
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("readArchiveForExport", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String importArchive(Archive archive, ArchiveMode archiveMode, String protocol, String userLogin, boolean smista, boolean updateAbilitato, boolean importPolicyConfig, boolean importPluginConfig, boolean checkExistsPluginConfig, boolean importConfig, String nomePddOperativa, ConsoleHelper consoleHelper) throws DriverControlStationException, ImportInformationMissingException {
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ArchiveEngine importerEngine = new ArchiveEngine(driver.getDriverRegistroServiziDB(), driver.getDriverConfigurazioneDB(), driver.getJdbcServiceManagerPlugins(), driver.getJdbcServiceManagerControlloTraffico(), driver.getJdbcServiceManagerAllarmi(), this, smista, userLogin);
            ImporterArchiveUtils importerArchiveUtils = new ImporterArchiveUtils((AbstractArchiveEngine)importerEngine, log, userLogin, nomePddOperativa, this.getImportArchivi_tipoPdD(), consoleHelper.isShowGestioneWorkflowStatoDocumenti(), updateAbilitato, importPolicyConfig, importPluginConfig, checkExistsPluginConfig, importConfig);
            ArchiveEsitoImport esito = importerArchiveUtils.importArchive(archive, userLogin, this.isShowAccordiColonnaAzioni(), this.isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto(), this.isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto(), this.isSoggettiApplicativiCredenzialiBasicPermitSameCredentials(), this.isSoggettiApplicativiCredenzialiSslPermitSameCredentials(), this.isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials());
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            IArchive archiveEngine = pf.createArchive();
            String string = archiveEngine.toString(esito, archiveMode);
            return string;
        }
        catch (ImportInformationMissingException iime) {
            throw iime;
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("importArchive", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String deleteArchive(Archive archive, ArchiveMode archiveMode, String protocol, String userLogin, boolean smista, boolean deletePolicyConfig, boolean deletePluginConfig) throws DriverControlStationException, ImportInformationMissingException {
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ArchiveEngine importerEngine = new ArchiveEngine(driver.getDriverRegistroServiziDB(), driver.getDriverConfigurazioneDB(), driver.getJdbcServiceManagerPlugins(), driver.getJdbcServiceManagerControlloTraffico(), driver.getJdbcServiceManagerAllarmi(), this, smista, userLogin);
            DeleterArchiveUtils deleterArchiveUtils = new DeleterArchiveUtils((AbstractArchiveEngine)importerEngine, log, userLogin, deletePolicyConfig, deletePluginConfig);
            ArchiveEsitoDelete esito = deleterArchiveUtils.deleteArchive(archive, userLogin);
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            IArchive archiveEngine = pf.createArchive();
            String string = archiveEngine.toString(esito, archiveMode);
            return string;
        }
        catch (ImportInformationMissingException iime) {
            throw iime;
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("deleteArchive", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void validateArchive(Archive archive, String protocolloEffettivo, boolean validazioneDocumenti, ImportInformationMissingCollection importInformationMissingCollection, String userLogin, boolean delete) throws ImportInformationMissingException, DriverControlStationException {
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            RegistryReader reader = new RegistryReader((IDriverRegistroServiziGet)driver.getDriverRegistroServiziDB(), ControlStationCore.getLog());
            ArchiveValidator validator = new ArchiveValidator((IRegistryReader)reader);
            validator.validateArchive(archive, protocolloEffettivo, validazioneDocumenti, importInformationMissingCollection, userLogin, this.isShowCorrelazioneAsincronaInAccordi(), delete);
        }
        catch (ImportInformationMissingException iime) {
            throw iime;
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("validateArchive", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Archive convert(byte[] file, ArchiveModeType type, ArchiveMode mode, String protocol, boolean validateDocuments, MapPlaceholder importInformationMissingGlobalPlaceholder) throws DriverControlStationException, ImportInformationMissingException {
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            RegistryReader registryReader = new RegistryReader((IDriverRegistroServiziGet)driver.getDriverRegistroServiziDB(), ControlStationCore.getLog());
            ConfigIntegrationReader configReader = new ConfigIntegrationReader((IDriverConfigurazioneGet)driver.getDriverConfigurazioneDB(), ControlStationCore.getLog());
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            IArchive archiveEngine = pf.createArchive();
            Archive archive = archiveEngine.importArchive(file, mode, type, (IRegistryReader)registryReader, (IConfigIntegrationReader)configReader, validateDocuments, importInformationMissingGlobalPlaceholder);
            return archive;
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("convert", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void finalizeArchive(Archive archive, ArchiveModeType type, ArchiveMode mode, String protocol, boolean validateDocuments, MapPlaceholder importInformationMissingGlobalPlaceholder) throws DriverControlStationException, ImportInformationMissingException {
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            RegistryReader registryReader = new RegistryReader((IDriverRegistroServiziGet)driver.getDriverRegistroServiziDB(), ControlStationCore.getLog());
            ConfigIntegrationReader configReader = new ConfigIntegrationReader((IDriverConfigurazioneGet)driver.getDriverConfigurazioneDB(), ControlStationCore.getLog());
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            IArchive archiveEngine = pf.createArchive();
            archiveEngine.finalizeImportArchive(archive, mode, type, (IRegistryReader)registryReader, (IConfigIntegrationReader)configReader, validateDocuments, importInformationMissingGlobalPlaceholder);
        }
        catch (Exception e) {
            throw new DriverControlStationException(this.getPrefixError("finalizeArchive", e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Documento getDocumento(long idDocumento, boolean readBytes) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getDocumento";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Documento documento = driver.getDriverRegistroServiziDB().getDocumento(idDocumento, readBytes);
            return documento;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Documento getDocumento(String nome, String tipo, String ruolo, long idProprietario, boolean readBytes, ProprietariDocumento tipoProprietario) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getDocumento";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Documento documento = driver.getDriverRegistroServiziDB().getDocumento(nome, tipo, ruolo, idProprietario, readBytes, tipoProprietario);
            return documento;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] NotFound :" + e.getMessage(), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsDocumento(Documento documento, ProprietariDocumento proprietarioDocumento, boolean documentoUnivocoIndipendentementeTipo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsDocumento";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            String tipo = documento.getTipo();
            String ruoloDoc = documento.getRuolo();
            if (documentoUnivocoIndipendentementeTipo) {
                tipo = null;
                ruoloDoc = null;
            }
            boolean bl = driver.getDriverRegistroServiziDB().existsDocumento(documento.getFile(), tipo, ruoloDoc, documento.getIdProprietarioDocumento().longValue(), proprietarioDocumento);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

