/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiUtils;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class ConfigurazioneAllarmiDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String ruoloPortaParam = confHelper.getParameter("allRuoloPorta");
            RuoloPorta ruoloPorta = null;
            if (ruoloPortaParam != null) {
                ruoloPorta = RuoloPorta.toEnumConstant((String)ruoloPortaParam);
            }
            String nomePorta = confHelper.getParameter("allNomePorta");
            ServiceBinding serviceBinding = null;
            String serviceBindingParam = confHelper.getParameter("allServiceBinding");
            if (serviceBindingParam != null && !"".equals(serviceBindingParam)) {
                serviceBinding = ServiceBinding.valueOf((String)serviceBindingParam);
            }
            String objToRemove = confHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            Long id = null;
            ArrayList<Allarme> allarmiToRemove = new ArrayList<Allarme>();
            StringBuilder inUsoMessage = new StringBuilder();
            for (int i = 0; i < idsToRemove.size(); ++i) {
                id = Long.parseLong(idsToRemove.get(i));
                Allarme allarme = confCore.getAllarmeSenzaPlugin(id);
                allarmiToRemove.add(allarme);
            }
            ArrayList<Allarme> allarmiRimossi = new ArrayList<Allarme>();
            ConfigurazioneUtilities.deleteAllarmi(allarmiToRemove, confHelper, confCore, userLogin, inUsoMessage, "<br/>", allarmiRimossi);
            ArrayList<String> allarmiAttivi = new ArrayList<String>();
            if (!allarmiRimossi.isEmpty()) {
                for (Allarme allarme : allarmiRimossi) {
                    if (TipoAllarme.PASSIVO.equals((Object)allarme.getTipoAllarme())) {
                        ControlStationCore.getLog().debug("Allarme [" + allarme.getNome() + "] \u00e8 passivo. Non viene effettuata alcuna rimozione su Allarmi.war");
                        continue;
                    }
                    if (allarme.getEnabled() == 0) {
                        ControlStationCore.getLog().debug("Allarme [" + allarme.getNome() + "] \u00e8 disabilitato. Non viene effettuata alcuna rimozione su Allarmi.war");
                        continue;
                    }
                    allarmiAttivi.add(allarme.getNome());
                }
            }
            String pdMessage = null;
            try {
                if (!allarmiAttivi.isEmpty()) {
                    AlarmEngineConfig alarmEngineConfig = confCore.getAllarmiConfig();
                    AllarmiUtils.stopActiveThreads(allarmiAttivi, (Logger)ControlStationCore.getLog(), (AlarmEngineConfig)alarmEngineConfig);
                }
            }
            catch (Exception e) {
                String errorMsg = MessageFormat.format("Allarmi eliminati correttamente, ma la notifica verso il gestore degli allarmi \u00e8 fallita: {0}", e.getMessage());
                ControlStationCore.getLog().error(errorMsg, (Throwable)e);
                pd.setMessage(errorMsg);
                pdMessage = errorMsg;
            }
            Object[] oggetti = allarmiRimossi.toArray(new Allarme[allarmiRimossi.size()]);
            confCore.performDeleteOperation(userLogin, confHelper.smista(), oggetti);
            if (inUsoMessage.length() > 0) {
                if (pdMessage != null) {
                    pd.setMessage(pdMessage + "<br/><br/>" + inUsoMessage.toString());
                } else {
                    pd.setMessage(inUsoMessage.toString());
                }
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_ALLARMI;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<ConfigurazioneAllarmeBean> lista = confCore.allarmiList(ricerca, ruoloPorta, nomePorta);
            confHelper.prepareAllarmiList(ricerca, lista, ruoloPorta, nomePorta, serviceBinding);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"configurazioneAllarmi", (ForwardParams)ForwardParams.DEL());
        }
        catch (Throwable e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneAllarmi", (ForwardParams)ForwardParams.DEL());
        }
    }
}

