/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.CanaleConfigurazioneNodo;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazioneCanaliNodiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            List<DataElement> dati;
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String idNodoS = confHelper.getParameter("nodiID");
            String nome = confHelper.getParameter("nodiNome");
            String descrizione = confHelper.getParameter("nodiDescrizione");
            String[] canali = confHelper.getParameterValues("nodiCanali");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            Configurazione configurazioneGenerale = confCore.getConfigurazioneGenerale();
            CanaliConfigurazione gestioneCanali = configurazioneGenerale.getGestioneCanali();
            List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Nodi", "configurazioneCanaliNodiList.do"));
            lstParam.add(ServletUtils.getParameterAggiungi());
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            List<String> aliases = confCore.getJmxPdDAliases();
            boolean selectListNode = false;
            if (aliases != null && aliases.size() > 1) {
                selectListNode = true;
            }
            if (selectListNode) {
                if (gestioneCanali.sizeNodoList() > 0) {
                    for (CanaleConfigurazioneNodo confNodo : gestioneCanali.getNodoList()) {
                        if (!aliases.contains(confNodo.getNome())) continue;
                        aliases.remove(confNodo.getNome());
                    }
                }
                if (aliases.isEmpty()) {
                    pd.setMessage("Tutti i nodi sono stati registrati", MessageType.INFO);
                    pd.disableEditMode();
                    dati = new ArrayList();
                    dati.add(ServletUtils.getDataElementForEditModeFinished());
                    pd.setDati(dati);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneCanaliNodi", (ForwardParams)ForwardParams.ADD());
                }
            }
            if (confHelper.isEditModeInProgress()) {
                if (nome == null) {
                    nome = "";
                    descrizione = "";
                    canali = new String[]{};
                }
                dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addCanaleNodoToDati(TipoOperazione.ADD, dati, idNodoS, null, nome, descrizione, canali, canaleList, selectListNode, aliases);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneCanaliNodi", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.canaleNodoCheckData(TipoOperazione.ADD, null);
            if (!isOk) {
                List<DataElement> dati2 = new ArrayList<DataElement>();
                dati2.add(ServletUtils.getDataElementForEditModeFinished());
                dati2 = confHelper.addCanaleNodoToDati(TipoOperazione.ADD, dati2, idNodoS, null, nome, descrizione, canali, canaleList, selectListNode, aliases);
                pd.setDati(dati2);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneCanaliNodi", (ForwardParams)ForwardParams.ADD());
            }
            configurazioneGenerale = confCore.getConfigurazioneGenerale();
            if (configurazioneGenerale.getGestioneCanali() == null) {
                configurazioneGenerale.setGestioneCanali(new CanaliConfigurazione());
            }
            CanaleConfigurazioneNodo nodo = new CanaleConfigurazioneNodo();
            nodo.setNome(nome);
            nodo.setDescrizione(descrizione);
            if (nodo.getCanaleList() == null) {
                nodo.setCanaleList(new ArrayList());
            }
            for (String canale : canali) {
                nodo.getCanaleList().add(canale);
            }
            configurazioneGenerale.getGestioneCanali().addNodo(nodo);
            confCore.performUpdateOperation(userLogin, confHelper.smista(), configurazioneGenerale);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_CANALI_NODI;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<CanaleConfigurazioneNodo> lista = confCore.canaleNodoConfigurazioneList((ISearch)ricerca);
            confHelper.prepareCanaleNodoConfigurazioneList(ricerca, lista);
            pd.setMessage("Configurazione Propriet&agrave; di Sistema modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneCanaliNodi", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneCanaliNodi", (ForwardParams)ForwardParams.ADD());
        }
    }
}

