/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneGeneraleHandler;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.ConfigurazioneMessageHandlers;
import org.openspcoop2.core.config.ConfigurazionePortaHandler;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.FaseMessageHandler;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.plugins.utils.handlers.ConfigurazioneHandlerBean;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class ConfigurazioneHandlersRichiestaList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String ruoloPortaParam = confHelper.getParametroTipoPdD("hRuoloPorta");
            TipoPdD ruoloPorta = null;
            if (ruoloPortaParam != null) {
                ruoloPorta = TipoPdD.toTipoPdD((String)ruoloPortaParam);
            }
            String idPortaS = confHelper.getParametroLong("hIdPorta");
            Long idPorta = null;
            if (StringUtils.isNotBlank((CharSequence)idPortaS)) {
                idPorta = Long.parseLong(idPortaS);
            }
            ServiceBinding serviceBinding = null;
            String serviceBindingParam = confHelper.getParametroServiceBinding("hServiceBinding");
            if (serviceBindingParam != null && !"".equals(serviceBindingParam)) {
                serviceBinding = ServiceBinding.valueOf((String)serviceBindingParam);
            }
            String idTab = confHelper.getParametroInteger("idTab");
            if (!confHelper.isModalitaCompleta() && StringUtils.isNotEmpty((CharSequence)idTab)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)idTab, (String)"idTab");
            }
            String fase = confHelper.getParametroFaseMessageHandler("hFase");
            String cambiaPosizione = confHelper.getParameter("hPos");
            String idHandlerS = confHelper.getParameter("hId");
            FaseMessageHandler faseMH = FaseMessageHandler.toEnumConstant((String)fase);
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            if (StringUtils.isNotEmpty((CharSequence)cambiaPosizione)) {
                Long idHandler = Long.parseLong(idHandlerS);
                ArrayList<Object> oggettiDaAggiornare = new ArrayList<Object>();
                List listaDaAggiornare = null;
                if (ruoloPorta != null) {
                    if (ruoloPorta.equals((Object)TipoPdD.DELEGATA)) {
                        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(confCore);
                        PortaDelegata portaDelegata = porteDelegateCore.getPortaDelegata(idPorta);
                        if (portaDelegata.getConfigurazioneHandler() == null) {
                            portaDelegata.setConfigurazioneHandler(new ConfigurazionePortaHandler());
                        }
                        if (portaDelegata.getConfigurazioneHandler().getRequest() == null) {
                            portaDelegata.getConfigurazioneHandler().setRequest(new ConfigurazioneMessageHandlers());
                        }
                        switch (faseMH) {
                            case IN: {
                                listaDaAggiornare = portaDelegata.getConfigurazioneHandler().getRequest().getInList();
                                break;
                            }
                            case IN_PROTOCOL_INFO: {
                                listaDaAggiornare = portaDelegata.getConfigurazioneHandler().getRequest().getInProtocolInfoList();
                                break;
                            }
                            case OUT: {
                                listaDaAggiornare = portaDelegata.getConfigurazioneHandler().getRequest().getOutList();
                                break;
                            }
                            case POST_OUT: {
                                listaDaAggiornare = portaDelegata.getConfigurazioneHandler().getRequest().getPostOutList();
                                break;
                            }
                            case PRE_IN: {
                                listaDaAggiornare = portaDelegata.getConfigurazioneHandler().getRequest().getPreInList();
                            }
                        }
                        oggettiDaAggiornare.add(portaDelegata);
                    } else if (ruoloPorta.equals((Object)TipoPdD.APPLICATIVA)) {
                        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(confCore);
                        PortaApplicativa portaApplicativa = porteApplicativeCore.getPortaApplicativa(idPorta);
                        if (portaApplicativa.getConfigurazioneHandler() == null) {
                            portaApplicativa.setConfigurazioneHandler(new ConfigurazionePortaHandler());
                        }
                        if (portaApplicativa.getConfigurazioneHandler().getRequest() == null) {
                            portaApplicativa.getConfigurazioneHandler().setRequest(new ConfigurazioneMessageHandlers());
                        }
                        switch (faseMH) {
                            case IN: {
                                listaDaAggiornare = portaApplicativa.getConfigurazioneHandler().getRequest().getInList();
                                break;
                            }
                            case IN_PROTOCOL_INFO: {
                                listaDaAggiornare = portaApplicativa.getConfigurazioneHandler().getRequest().getInProtocolInfoList();
                                break;
                            }
                            case OUT: {
                                listaDaAggiornare = portaApplicativa.getConfigurazioneHandler().getRequest().getOutList();
                                break;
                            }
                            case POST_OUT: {
                                listaDaAggiornare = portaApplicativa.getConfigurazioneHandler().getRequest().getPostOutList();
                                break;
                            }
                            case PRE_IN: {
                                listaDaAggiornare = portaApplicativa.getConfigurazioneHandler().getRequest().getPreInList();
                            }
                        }
                        oggettiDaAggiornare.add(portaApplicativa);
                    }
                } else {
                    Configurazione configurazione = confCore.getConfigurazioneGenerale();
                    if (configurazione.getConfigurazioneHandler() == null) {
                        configurazione.setConfigurazioneHandler(new ConfigurazioneGeneraleHandler());
                    }
                    if (configurazione.getConfigurazioneHandler().getRequest() == null) {
                        configurazione.getConfigurazioneHandler().setRequest(new ConfigurazioneMessageHandlers());
                    }
                    switch (faseMH) {
                        case IN: {
                            listaDaAggiornare = configurazione.getConfigurazioneHandler().getRequest().getInList();
                            break;
                        }
                        case IN_PROTOCOL_INFO: {
                            listaDaAggiornare = configurazione.getConfigurazioneHandler().getRequest().getInProtocolInfoList();
                            break;
                        }
                        case OUT: {
                            listaDaAggiornare = configurazione.getConfigurazioneHandler().getRequest().getOutList();
                            break;
                        }
                        case POST_OUT: {
                            listaDaAggiornare = configurazione.getConfigurazioneHandler().getRequest().getPostOutList();
                            break;
                        }
                        case PRE_IN: {
                            listaDaAggiornare = configurazione.getConfigurazioneHandler().getRequest().getPreInList();
                        }
                    }
                    oggettiDaAggiornare.add(configurazione);
                }
                if (listaDaAggiornare != null) {
                    for (int j = 0; j < listaDaAggiornare.size(); ++j) {
                        ConfigurazioneHandler handlerToMove = null;
                        ConfigurazioneHandler handlerToCheck = (ConfigurazioneHandler)listaDaAggiornare.get(j);
                        if (!handlerToCheck.getId().equals(idHandler)) continue;
                        handlerToMove = handlerToCheck;
                        int posizioneAttuale = handlerToMove.getPosizione();
                        ConfigurazioneHandler handlerToSwitch = null;
                        handlerToSwitch = cambiaPosizione.equals("su") ? (ConfigurazioneHandler)listaDaAggiornare.get(j - 1) : (ConfigurazioneHandler)listaDaAggiornare.get(j + 1);
                        int posizioneNuova = handlerToSwitch.getPosizione();
                        handlerToMove.setPosizione(posizioneNuova);
                        handlerToSwitch.setPosizione(posizioneAttuale);
                        break;
                    }
                }
                confCore.performUpdateOperation(userLogin, confHelper.smista(), oggettiDaAggiornare.toArray(new Object[oggettiDaAggiornare.size()]));
                if (ruoloPorta == null) {
                    pd.setMessage("Configurazione Message Handler modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
                }
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_HANDLERS_RICHIESTA;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<ConfigurazioneHandlerBean> lista = confCore.handlersRichiestaList((ISearch)ricerca, fase, ruoloPorta, idPorta);
            confHelper.prepareHandlersRichiestaList(ricerca, lista, ruoloPorta, idPortaS, serviceBinding, fase);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"configurazioneHandlersRichiesta", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneHandlersRichiesta", (ForwardParams)ForwardParams.LIST());
        }
    }
}

