/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.connettori;

import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPProvider;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;

public class ConnettoreHTTPSUtils {
    private ConnettoreHTTPSUtils() {
    }

    public static void fillConnettoreConfig(org.openspcoop2.core.config.Connettore connettore, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy) {
        connettore.setCustom(Boolean.valueOf(true));
        org.openspcoop2.core.config.Property prop = new org.openspcoop2.core.config.Property();
        prop.setNome("location");
        prop.setValore(httpsurl);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("sslType");
        prop.setValore(httpstipologia);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("hostnameVerifier");
        prop.setValore(String.valueOf(httpshostverify));
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("trustAllCerts");
        if (httpsTrustVerifyCert) {
            prop.setValore(String.valueOf(false));
        } else {
            prop.setValore(String.valueOf(true));
        }
        connettore.addProperty(prop);
        if (httpsTrustVerifyCert) {
            prop = new org.openspcoop2.core.config.Property();
            prop.setNome("trustStoreLocation");
            prop.setValore(httpspath);
            connettore.addProperty(prop);
            prop = new org.openspcoop2.core.config.Property();
            prop.setNome("trustStoreType");
            prop.setValore(httpstipo);
            connettore.addProperty(prop);
            if (httpspwd != null && !"".equals(httpspwd)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("trustStorePassword");
                prop.setValore(httpspwd);
                connettore.addProperty(prop);
            }
            if (httpsTrustStoreCRLs != null && !"".equals(httpsTrustStoreCRLs)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("trustStoreCRLs");
                prop.setValore(httpsTrustStoreCRLs);
                connettore.addProperty(prop);
            }
            prop = new org.openspcoop2.core.config.Property();
            prop.setNome("trustManagementAlgorithm");
            if (httpsalgoritmo == null || "".equals(httpsalgoritmo)) {
                prop.setValore(TrustManagerFactory.getDefaultAlgorithm());
            } else {
                prop.setValore(httpsalgoritmo);
            }
            connettore.addProperty(prop);
        }
        if (httpsTrustStoreOCSPPolicy != null && !"".equals(httpsTrustStoreOCSPPolicy)) {
            prop = new org.openspcoop2.core.config.Property();
            prop.setNome("trustStoreOCSPPolicy");
            prop.setValore(httpsTrustStoreOCSPPolicy);
            connettore.addProperty(prop);
            if (!httpsTrustVerifyCert && httpsTrustStoreCRLs != null && !"".equals(httpsTrustStoreCRLs)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("trustStoreCRLs");
                prop.setValore(httpsTrustStoreCRLs);
                connettore.addProperty(prop);
            }
        }
        if (httpsstato) {
            prop = new org.openspcoop2.core.config.Property();
            prop.setNome("keyManagementAlgorithm");
            if (httpsalgoritmokey == null || "".equals(httpsalgoritmokey)) {
                prop.setValore(KeyManagerFactory.getDefaultAlgorithm());
            } else {
                prop.setValore(httpsalgoritmokey);
            }
            connettore.addProperty(prop);
            if ("default".equals(httpskeystore)) {
                if (httpspwdprivatekeytrust != null && !"".equals(httpspwdprivatekeytrust)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("keyPassword");
                    prop.setValore(httpspwdprivatekeytrust);
                    connettore.addProperty(prop);
                }
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("keyStoreLocation");
                prop.setValore(httpspath);
                connettore.addProperty(prop);
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("keyStoreType");
                prop.setValore(httpstipo);
                connettore.addProperty(prop);
                if (httpspwd != null && !"".equals(httpspwd)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("keyStorePassword");
                    prop.setValore(httpspwd);
                    connettore.addProperty(prop);
                }
            } else {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("keyStoreLocation");
                prop.setValore(httpspathkey);
                connettore.addProperty(prop);
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("keyStoreType");
                prop.setValore(httpstipokey);
                connettore.addProperty(prop);
                if (httpspwdkey != null && !"".equals(httpspwdkey)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("keyStorePassword");
                    prop.setValore(httpspwdkey);
                    connettore.addProperty(prop);
                }
                if (httpspwdprivatekey != null && !"".equals(httpspwdprivatekey)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("keyPassword");
                    prop.setValore(httpspwdprivatekey);
                    connettore.addProperty(prop);
                }
            }
            if (httpsKeyAlias != null && !"".equals(httpsKeyAlias)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("keyAlias");
                prop.setValore(httpsKeyAlias);
                connettore.addProperty(prop);
            }
            if (httpsKeyStoreBYOKPolicy != null && !"".equals(httpsKeyStoreBYOKPolicy)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("keyStoreBYOKPolicy");
                prop.setValore(httpsKeyStoreBYOKPolicy);
                connettore.addProperty(prop);
            }
        }
    }

    public static void fillConnettoreRegistry(Connettore connettore, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String user, String pwd) {
        connettore.setCustom(Boolean.valueOf(true));
        Property prop = new Property();
        prop.setNome("location");
        prop.setValore(httpsurl);
        connettore.addProperty(prop);
        if (user != null) {
            prop = new Property();
            prop.setNome("user");
            prop.setValore(user);
            connettore.addProperty(prop);
        }
        if (pwd != null) {
            prop = new Property();
            prop.setNome("password");
            prop.setValore(pwd);
            connettore.addProperty(prop);
        }
        prop = new Property();
        prop.setNome("sslType");
        prop.setValore(httpstipologia);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("hostnameVerifier");
        prop.setValore(String.valueOf(httpshostverify));
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("trustAllCerts");
        if (httpsTrustVerifyCert) {
            prop.setValore(String.valueOf(false));
        } else {
            prop.setValore(String.valueOf(true));
        }
        connettore.addProperty(prop);
        if (httpsTrustVerifyCert) {
            prop = new Property();
            prop.setNome("trustStoreLocation");
            prop.setValore(httpspath);
            connettore.addProperty(prop);
            prop = new Property();
            prop.setNome("trustStoreType");
            prop.setValore(httpstipo);
            connettore.addProperty(prop);
            if (httpspwd != null && !"".equals(httpspwd)) {
                prop = new Property();
                prop.setNome("trustStorePassword");
                prop.setValore(httpspwd);
                connettore.addProperty(prop);
            }
            if (httpsTrustStoreCRLs != null && !"".equals(httpsTrustStoreCRLs)) {
                prop = new Property();
                prop.setNome("trustStoreCRLs");
                prop.setValore(httpsTrustStoreCRLs);
                connettore.addProperty(prop);
            }
            prop = new Property();
            prop.setNome("trustManagementAlgorithm");
            if (httpsalgoritmo == null || "".equals(httpsalgoritmo)) {
                prop.setValore(TrustManagerFactory.getDefaultAlgorithm());
            } else {
                prop.setValore(httpsalgoritmo);
            }
            connettore.addProperty(prop);
        }
        if (httpsTrustStoreOCSPPolicy != null && !"".equals(httpsTrustStoreOCSPPolicy)) {
            prop = new Property();
            prop.setNome("trustStoreOCSPPolicy");
            prop.setValore(httpsTrustStoreOCSPPolicy);
            connettore.addProperty(prop);
            if (!httpsTrustVerifyCert && httpsTrustStoreCRLs != null && !"".equals(httpsTrustStoreCRLs)) {
                prop = new Property();
                prop.setNome("trustStoreCRLs");
                prop.setValore(httpsTrustStoreCRLs);
                connettore.addProperty(prop);
            }
        }
        if (httpsstato) {
            prop = new Property();
            prop.setNome("keyManagementAlgorithm");
            if (httpsalgoritmokey == null || "".equals(httpsalgoritmokey)) {
                prop.setValore(KeyManagerFactory.getDefaultAlgorithm());
            } else {
                prop.setValore(httpsalgoritmokey);
            }
            connettore.addProperty(prop);
            if ("default".equals(httpskeystore)) {
                if (httpspwdprivatekeytrust != null && !"".equals(httpspwdprivatekeytrust)) {
                    prop = new Property();
                    prop.setNome("keyPassword");
                    prop.setValore(httpspwdprivatekeytrust);
                    connettore.addProperty(prop);
                }
                prop = new Property();
                prop.setNome("keyStoreLocation");
                prop.setValore(httpspath);
                connettore.addProperty(prop);
                prop = new Property();
                prop.setNome("keyStoreType");
                prop.setValore(httpstipo);
                connettore.addProperty(prop);
                if (httpspwd != null && !"".equals(httpspwd)) {
                    prop = new Property();
                    prop.setNome("keyStorePassword");
                    prop.setValore(httpspwd);
                    connettore.addProperty(prop);
                }
            } else {
                prop = new Property();
                prop.setNome("keyStoreLocation");
                prop.setValore(httpspathkey);
                connettore.addProperty(prop);
                prop = new Property();
                prop.setNome("keyStoreType");
                prop.setValore(httpstipokey);
                connettore.addProperty(prop);
                if (httpspwdkey != null && !"".equals(httpspwdkey)) {
                    prop = new Property();
                    prop.setNome("keyStorePassword");
                    prop.setValore(httpspwdkey);
                    connettore.addProperty(prop);
                }
                if (httpspwdprivatekey != null && !"".equals(httpspwdprivatekey)) {
                    prop = new Property();
                    prop.setNome("keyPassword");
                    prop.setValore(httpspwdprivatekey);
                    connettore.addProperty(prop);
                }
            }
            if (httpsKeyAlias != null && !"".equals(httpsKeyAlias)) {
                prop = new Property();
                prop.setNome("keyAlias");
                prop.setValore(httpsKeyAlias);
                connettore.addProperty(prop);
            }
            if (httpsKeyStoreBYOKPolicy != null && !"".equals(httpsKeyStoreBYOKPolicy)) {
                prop = new Property();
                prop.setNome("keyStoreBYOKPolicy");
                prop.setValore(httpsKeyStoreBYOKPolicy);
                connettore.addProperty(prop);
            }
        }
    }

    public static void addHTTPSDati(List<DataElement> dati, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String stato, ControlStationCore core, ConsoleHelper consoleHelper, int pageSize, boolean addUrlParameter, String prefix, boolean forceHttpsClient, boolean modi, boolean fruizione, boolean forceNoSec, boolean postBackViaPost) throws UtilsException {
        DataElement de;
        if (httpsalgoritmo == null || "".equals(httpsalgoritmo)) {
            httpsalgoritmo = TrustManagerFactory.getDefaultAlgorithm();
        }
        if (httpsalgoritmokey == null || "".equals(httpsalgoritmokey)) {
            httpsalgoritmokey = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (httpstipologia == null || "".equals(httpstipologia)) {
            httpstipologia = ConnettoriCostanti.DEFAULT_CONNETTORE_HTTPS_TYPE;
        }
        if (addUrlParameter) {
            de = new DataElement();
            de.setLabel("Endpoint");
            de.setValue(httpsurl);
            if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
                DataElementInfo dInfoPatternFileName = new DataElementInfo("Endpoint");
                dInfoPatternFileName.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
                dInfoPatternFileName.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_CONNETTORE_VALORI((boolean)modi, (boolean)fruizione, (boolean)forceNoSec));
                de.setInfo(dInfoPatternFileName);
            } else {
                de.setType(DataElementType.TEXT);
            }
            de.setName("url");
            de.setSize(pageSize);
            dati.add(de);
        }
        if (prefix == null) {
            prefix = "";
        }
        de = new DataElement();
        de.setLabel(prefix + "Autenticazione Https");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipologia");
        de.setType(DataElementType.SELECT);
        List tipologie = null;
        try {
            tipologie = SSLUtilities.getSSLSupportedProtocols();
        }
        catch (Exception e) {
            ControlStationCore.logError(e.getMessage(), e);
            tipologie = SSLUtilities.getAllSslProtocol();
        }
        if (httpstipologia != null && !"".equals(httpstipologia) && !tipologie.contains(httpstipologia)) {
            tipologie.add(httpstipologia);
        }
        de.setValues(tipologie);
        de.setSelected(httpstipologia);
        de.setName("httpstipologia");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Verifica Hostname");
        de.setValue(httpshostverify ? "yes" : "");
        de.setSelected(httpshostverify);
        de.setType(DataElementType.CHECKBOX);
        de.setName("httpshostverify");
        dati.add(de);
        de = new DataElement();
        de.setLabel(prefix + "Autenticazione Server");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Verifica");
        de.setName("httpstrustverify");
        de.setValue(httpsTrustVerifyCert ? "yes" : "");
        de.setSelected(httpsTrustVerifyCert);
        de.setType(DataElementType.CHECKBOX);
        if (postBackViaPost) {
            de.setPostBack_viaPOST(true);
        } else {
            de.setPostBack(true);
        }
        dati.add(de);
        boolean truststoreHsm = false;
        String httpstipoDefault = null;
        de = new DataElement();
        de.setLabel("Tipo");
        de.setName("httpstipo");
        if (httpsTrustVerifyCert) {
            de.setType(DataElementType.SELECT);
            if (core.isConnettoriAllTypesEnabled()) {
                de.setValues(ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD);
            } else {
                List<String> values = ConnettoriCostanti.getTIPOLOGIE_KEYSTORE(true, false);
                List<String> labels = ConnettoriCostanti.getTIPOLOGIE_KEYSTORE(true, true);
                if (httpstipo != null && !"".equals(httpstipo)) {
                    boolean exists = false;
                    for (String v : values) {
                        if (!httpstipo.equalsIgnoreCase(v)) continue;
                        exists = true;
                    }
                    if (!exists) {
                        values.add(httpstipo);
                    }
                }
                de.setValues(values);
                de.setLabels(labels);
                if (ConnettoriCostanti.existsTIPOLOGIE_KEYSTORE_HSM(true)) {
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                }
            }
            if (httpstipo != null) {
                de.setSelected(httpstipo);
                truststoreHsm = HSMUtils.isKeystoreHSM((String)httpstipo);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if ((httpstipo == null || "".equals(httpstipo)) && de.getValues() != null && de.getValues().length > 0) {
            httpstipoDefault = de.getValues()[0];
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Path");
        de.setValue(httpspath);
        if (httpsTrustVerifyCert) {
            if (truststoreHsm) {
                de.setValue("HSM-" + httpstipo);
                de.setType(DataElementType.HIDDEN);
            } else {
                if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                    de.setType(DataElementType.TEXT_AREA);
                    de.setRequired(true);
                } else {
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                }
                de.setRows(3);
                de.setSize(pageSize);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("httpspath");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password");
        if (httpsTrustVerifyCert) {
            if (truststoreHsm) {
                de.setValue("-");
                de.setType(DataElementType.HIDDEN);
            } else if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setRequired(ConnettoreHTTPSUtils.isStorePasswordRequired(httpstipo, httpstipoDefault, false, false, core));
                core.getLockUtilities().lock(de, httpspwd);
            } else {
                core.getLockUtilities().lockReadOnly(de, httpspwd);
            }
            de.setSize(pageSize);
        } else {
            core.getLockUtilities().lockHidden(de, httpspwd);
        }
        de.setName("httpspwd");
        dati.add(de);
        OCSPProvider ocspProvider = new OCSPProvider();
        boolean ocspEnabled = ocspProvider.isOcspEnabled();
        List ocspTypes = ocspProvider.getValues();
        List ocspLabels = ocspProvider.getLabels();
        boolean crlWithOCSPEnabledTrustAllHttpsServer = ocspEnabled && core.isOCSPPolicyChoiceConnettoreHTTPSVerificaServerDisabilitata() && httpsTrustStoreOCSPPolicy != null && !"".equals(httpsTrustStoreOCSPPolicy);
        de = new DataElement();
        de.setName("httpsocsp");
        de.setLabel("OCSP Policy");
        if (ocspEnabled && (httpsTrustVerifyCert || core.isOCSPPolicyChoiceConnettoreHTTPSVerificaServerDisabilitata())) {
            if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setType(DataElementType.SELECT);
                de.setValues(ocspTypes);
                de.setLabels(ocspLabels);
                if (postBackViaPost) {
                    de.setPostBack_viaPOST(core.isOCSPPolicyChoiceConnettoreHTTPSVerificaServerDisabilitata());
                } else {
                    de.setPostBack(core.isOCSPPolicyChoiceConnettoreHTTPSVerificaServerDisabilitata());
                }
                if (httpsTrustStoreOCSPPolicy == null) {
                    httpsTrustStoreOCSPPolicy = "";
                }
                de.setSelected(httpsTrustStoreOCSPPolicy);
            } else {
                de.setType(DataElementType.HIDDEN);
                if (httpsTrustStoreOCSPPolicy != null && !"".equals(httpsTrustStoreOCSPPolicy)) {
                    String label = null;
                    for (int i = 0; i < ocspTypes.size(); ++i) {
                        String type = (String)ocspTypes.get(i);
                        if (type == null || !type.equals(httpsTrustStoreOCSPPolicy)) continue;
                        label = (String)ocspLabels.get(i);
                    }
                    if (label != null) {
                        DataElement deLABEL = new DataElement();
                        de.setType(DataElementType.TEXT);
                        deLABEL.setLabel("OCSP Policy");
                        deLABEL.setValue(label);
                        deLABEL.setName("httpsocsp__label");
                        dati.add(deLABEL);
                    }
                }
            }
            de.setSize(pageSize);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(httpsTrustStoreOCSPPolicy);
        dati.add(de);
        de = new DataElement();
        de.setLabel("CRL File(s)");
        de.setValue(httpsTrustStoreCRLs);
        if (httpsTrustVerifyCert || crlWithOCSPEnabledTrustAllHttpsServer) {
            de.setNote("Elencare pi\u00f9 file separandoli con la ','");
            if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setType(DataElementType.TEXT_AREA);
            } else {
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            }
            de.setRows(2);
            de.setSize(pageSize);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("httpscrl");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Algoritmo");
        de.setValue(httpsalgoritmo);
        if (httpsTrustVerifyCert) {
            if (!consoleHelper.isModalitaStandard()) {
                if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                    de.setType(DataElementType.TEXT_EDIT);
                    de.setRequired(true);
                } else {
                    de.setType(DataElementType.TEXT);
                }
                de.setSize(pageSize);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("httpsalgoritmo");
        dati.add(de);
        de = new DataElement();
        de.setLabel(prefix + "Autenticazione Client");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Abilitato");
        de.setName("httpsstato");
        if (forceHttpsClient) {
            httpsstato = true;
            de.setValue("yes");
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setValue(httpsstato ? "yes" : "");
            de.setSelected(httpsstato);
            de.setType(DataElementType.CHECKBOX);
            if (postBackViaPost) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Dati Accesso al KeyStore");
        de.setName("httpskeystore");
        if (httpsstato) {
            if (httpsTrustVerifyCert) {
                de.setType(DataElementType.SELECT);
                de.setValues(ConnettoriCostanti.DEFAULT_CONNETTORE_HTTPS_KEYSTORE_CLIENT_AUTH_MODES);
                de.setLabels(ConnettoriCostanti.DEFAULT_CONNETTORE_HTTPS_KEYSTORE_CLIENT_AUTH_LABEL_MODES);
                de.setSelected(httpskeystore);
                if (postBackViaPost) {
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setPostBack(true);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                httpskeystore = "ridefinisci";
                de.setValue("ridefinisci");
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password Chiave Privata");
        if (httpsstato && (httpskeystore == null || "".equals(httpskeystore) || httpskeystore.equals("default"))) {
            if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setRequired(ConnettoreHTTPSUtils.isStorePasswordRequired(httpstipo, httpstipoDefault, true, true, core));
                core.getLockUtilities().lock(de, httpspwdprivatekeytrust);
            } else {
                core.getLockUtilities().lockReadOnly(de, httpspwdprivatekeytrust);
            }
        } else {
            core.getLockUtilities().lockHidden(de, httpspwdprivatekeytrust);
        }
        de.setName("httpspwdprivatekeytrust");
        de.setSize(pageSize);
        dati.add(de);
        boolean keystoreHsm = false;
        de = new DataElement();
        de.setLabel("Tipo");
        de.setName("httpstipokey");
        String httpstipokeyDefault = null;
        if (httpsstato && httpskeystore != null && httpskeystore.equals("ridefinisci")) {
            de.setType(DataElementType.SELECT);
            if (core.isConnettoriAllTypesEnabled()) {
                de.setValues(ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD);
            } else {
                List<String> values = ConnettoriCostanti.getTIPOLOGIE_KEYSTORE(false, false);
                List<String> labels = ConnettoriCostanti.getTIPOLOGIE_KEYSTORE(false, true);
                if (httpstipokey != null && !"".equals(httpstipokey)) {
                    boolean exists = false;
                    for (String v : values) {
                        if (!httpstipokey.equalsIgnoreCase(v)) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        values.add(httpstipokey);
                    }
                }
                de.setValues(values);
                de.setLabels(labels);
                if (ConnettoriCostanti.existsTIPOLOGIE_KEYSTORE_HSM(false)) {
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                }
            }
            if (httpstipokey != null) {
                de.setSelected(httpstipokey);
                keystoreHsm = HSMUtils.isKeystoreHSM((String)httpstipokey);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        if ((httpstipokey == null || "".equals(httpstipokey)) && de.getValues() != null && de.getValues().length > 0) {
            httpstipokeyDefault = de.getValues()[0];
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Path");
        de.setValue(httpspathkey);
        if (httpsstato && httpskeystore != null && httpskeystore.equals("ridefinisci")) {
            if (keystoreHsm) {
                de.setValue("HSM-" + httpstipokey);
                de.setType(DataElementType.HIDDEN);
            } else {
                if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                    de.setType(DataElementType.TEXT_AREA);
                    de.setRequired(true);
                } else {
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                }
                de.setRows(3);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("httpspathkey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password");
        if (httpsstato && httpskeystore != null && httpskeystore.equals("ridefinisci")) {
            if (keystoreHsm) {
                de.setValue("-");
                de.setType(DataElementType.HIDDEN);
            } else if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setRequired(ConnettoreHTTPSUtils.isStorePasswordRequired(httpstipokey, httpstipokeyDefault, true, false, core));
                core.getLockUtilities().lock(de, httpspwdkey);
            } else {
                core.getLockUtilities().lockReadOnly(de, httpspwdkey);
            }
        } else {
            core.getLockUtilities().lockHidden(de, httpspwdkey);
        }
        de.setName("httpspwdkey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password Chiave Privata");
        if (httpsstato && httpskeystore != null && httpskeystore.equals("ridefinisci")) {
            if (keystoreHsm && !ConnettoriCostanti.DEFAULT_CONNETTORE_HTTPS_HSM_CONFIGURABLE_KEY_PASSWORD) {
                de.setValue("-");
                de.setType(DataElementType.HIDDEN);
            } else if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setRequired(ConnettoreHTTPSUtils.isStorePasswordRequired(httpstipokey, httpstipokeyDefault, true, true, core));
                core.getLockUtilities().lock(de, httpspwdprivatekey);
            } else {
                core.getLockUtilities().lockReadOnly(de, httpspwdprivatekey);
            }
        } else {
            core.getLockUtilities().lockHidden(de, httpspwdprivatekey);
        }
        de.setName("httpspwdprivatekey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Alias Chiave Privata");
        de.setValue(httpsKeyAlias);
        if (httpsstato) {
            if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.TEXT);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("httpsaliasprivatekey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Algoritmo");
        de.setValue(httpsalgoritmokey);
        if (httpsstato && !consoleHelper.isModalitaStandard()) {
            if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.TEXT);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("httpsalgoritmokey");
        de.setSize(pageSize);
        dati.add(de);
        BYOKProvider byokProvider = BYOKProvider.getUnwrapInstance();
        boolean byokEnabled = byokProvider.isUnwrapByokKeystoreEnabled();
        List byokTypes = byokProvider.getValues();
        List byokLabels = byokProvider.getLabels();
        de = new DataElement();
        de.setName("httpsbyok");
        de.setLabel("BYOK Policy");
        if (byokEnabled && httpsstato && !keystoreHsm) {
            if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                de.setType(DataElementType.SELECT);
                de.setValues(byokTypes);
                de.setLabels(byokLabels);
                if (postBackViaPost) {
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setPostBack(true);
                }
                if (httpsKeyStoreBYOKPolicy == null) {
                    httpsKeyStoreBYOKPolicy = "";
                }
                de.setSelected(httpsKeyStoreBYOKPolicy);
            } else {
                de.setType(DataElementType.HIDDEN);
                if (httpsKeyStoreBYOKPolicy != null && !"".equals(httpsKeyStoreBYOKPolicy)) {
                    String label = null;
                    for (int i = 0; i < byokTypes.size(); ++i) {
                        String type = (String)byokTypes.get(i);
                        if (type == null || !type.equals(httpsKeyStoreBYOKPolicy)) continue;
                        label = (String)byokLabels.get(i);
                    }
                    if (label != null) {
                        DataElement deLABEL = new DataElement();
                        de.setType(DataElementType.TEXT);
                        deLABEL.setLabel("BYOK Policy");
                        deLABEL.setValue(label);
                        deLABEL.setName("httpsbyok__label");
                        dati.add(deLABEL);
                    }
                }
            }
            de.setSize(pageSize);
            de.setValue(httpsKeyStoreBYOKPolicy);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
    }

    private static boolean isStorePasswordRequired(String httpstipo, String httpstipoDefault, boolean keystore, boolean key, ControlStationCore core) {
        String check = httpstipo;
        if (httpstipo == null || "".equals(httpstipo)) {
            check = httpstipoDefault;
        }
        if (KeystoreType.JKS.isType(check)) {
            return ConnettoreHTTPSUtils.isStoreJksPasswordRequired(keystore, key, core);
        }
        if (KeystoreType.PKCS12.isType(check)) {
            return ConnettoreHTTPSUtils.isStorePkcs12PasswordRequired(keystore, key, core);
        }
        return true;
    }

    private static boolean isStoreJksPasswordRequired(boolean keystore, boolean key, ControlStationCore core) {
        if (keystore) {
            return key ? core.isKeystoreJksKeyPasswordRequired() : core.isKeystoreJksPasswordRequired();
        }
        return core.isTruststoreJksPasswordRequired();
    }

    private static boolean isStorePkcs12PasswordRequired(boolean keystore, boolean key, ControlStationCore core) {
        if (keystore) {
            return key ? core.isKeystorePkcs12KeyPasswordRequired() : core.isKeystorePkcs12PasswordRequired();
        }
        return core.isTruststorePkcs12PasswordRequired();
    }

    public static void addHTTPSDatiAsHidden(List<DataElement> dati, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String stato, ControlStationCore core, int pageSize) {
        if (stato == null || core != null) {
            // empty if block
        }
        DataElement de = new DataElement();
        de.setLabel("Endpoint");
        de.setValue(httpsurl);
        de.setType(DataElementType.HIDDEN);
        de.setName("url");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipologia");
        de.setType(DataElementType.HIDDEN);
        de.setValue(httpstipologia);
        de.setName("httpstipologia");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Verifica Hostname");
        de.setValue(httpshostverify ? "yes" : "");
        de.setType(DataElementType.HIDDEN);
        de.setName("httpshostverify");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Verifica");
        de.setValue(httpsTrustVerifyCert ? "yes" : "");
        de.setType(DataElementType.HIDDEN);
        de.setName("httpstrustverify");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Path");
        de.setValue(httpspath);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpspath");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setType(DataElementType.HIDDEN);
        de.setValue(httpstipo);
        de.setName("httpstipo");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password");
        de.setValue(httpspwd);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpspwd");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("CRL File(s)");
        de.setValue(httpsTrustStoreCRLs);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpscrl");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("OCSP Policy");
        de.setValue(httpsTrustStoreOCSPPolicy);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpsocsp");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Algoritmo");
        de.setValue(httpsalgoritmo);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpsalgoritmo");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Abilitato");
        de.setValue(httpsstato ? "yes" : "");
        de.setType(DataElementType.HIDDEN);
        de.setName("httpsstato");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Dati Accesso al KeyStore");
        de.setName("httpskeystore");
        de.setType(DataElementType.HIDDEN);
        if (httpsstato) {
            de.setValue(httpskeystore);
        } else {
            de.setValue("");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password Chiave Privata");
        de.setValue(httpspwdprivatekeytrust);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpspwdprivatekeytrust");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Path");
        de.setValue(httpspathkey);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpspathkey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        if (httpsstato && httpskeystore != null && httpskeystore.equals("ridefinisci")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(httpstipokey);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        de.setName("httpstipokey");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password");
        de.setValue(httpspwdkey);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpspwdkey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password Chiave Privata");
        de.setValue(httpspwdprivatekey);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpspwdprivatekey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Alias Chiave Privata");
        de.setValue(httpsKeyAlias);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpsaliasprivatekey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Algoritmo");
        de.setValue(httpsalgoritmokey);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpsalgoritmokey");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("BYOK Policy");
        de.setValue(httpsKeyStoreBYOKPolicy);
        de.setType(DataElementType.HIDDEN);
        de.setName("httpsbyok");
        de.setSize(pageSize);
        dati.add(de);
    }
}

