/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.connettori;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;

public class ConnettoriCore
extends ControlStationCore {
    public ConnettoriCore() throws Exception {
    }

    public ConnettoriCore(boolean initForApi, String confDir, String protocolloDefault) throws Exception {
        super(initForApi, confDir, protocolloDefault);
    }

    public ConnettoriCore(ControlStationCore core) throws Exception {
        super(core);
    }

    protected static ArrayList<Property> fromPropertiesToCollection(Properties props) {
        ArrayList<Property> lista = new ArrayList<Property>();
        Property tmp = null;
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)props.get(key);
            tmp = new Property();
            tmp.setNome(key);
            tmp.setValore(value);
            lista.add(tmp);
        }
        return lista;
    }

    public List<String> connettoriList() throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "connettoriList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().connettoriList();
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Property[] getPropertiesConnettore(String nomeConnettore) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getPropertiesConnettore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Property[] propertyArray = driver.getDriverRegistroServiziDB().getPropertiesConnettore(nomeConnettore);
            return propertyArray;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public org.openspcoop2.core.config.Property[] getPropertiesConnettoreConfig(String nomeConnettore) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getPropertiesConnettore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            org.openspcoop2.core.config.Property[] propertyArray = driver.getDriverConfigurazioneDB().getPropertiesConnettore(nomeConnettore);
            return propertyArray;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public org.openspcoop2.core.registry.Connettore getConnettoreRegistro(long idConnettore) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getConnettoreRegistro";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            org.openspcoop2.core.registry.Connettore connettore = driver.getDriverRegistroServiziDB().getConnettore(idConnettore);
            return connettore;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Connettore getConnettoreConfig(long idConnettore) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getConnettoreRegistro";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Connettore connettore = driver.getDriverConfigurazioneDB().getConnettore(idConnettore);
            return connettore;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

