/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.gruppi;

import java.sql.Connection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;

public class GruppiCore
extends ControlStationCore {
    public GruppiCore() throws Exception {
    }

    public GruppiCore(ControlStationCore core) throws Exception {
        super(core);
    }

    public List<Gruppo> gruppiList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "gruppiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().gruppiList(superuser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Gruppo getGruppo(long id) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getGruppo";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Gruppo gruppo = driver.getDriverRegistroServiziDB().getGruppo(id);
            return gruppo;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Gruppo getGruppo(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getGruppo";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDGruppo idGruppo = new IDGruppo(nome);
            Gruppo gruppo = driver.getDriverRegistroServiziDB().getGruppo(idGruppo);
            return gruppo;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsGruppo(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsGruppo";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDGruppo idGruppo = new IDGruppo(nome);
            boolean bl = driver.getDriverRegistroServiziDB().existsGruppo(idGruppo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isGruppoInUso(String gruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isGruppoInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isGruppoInUso(new IDGruppo(gruppo), whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isGruppoConfigInUso(String gruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isGruppoConfigInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isGruppoConfigInUso(new IDGruppo(gruppo), whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliGruppoInUso(IDGruppo gruppo) throws DriverConfigurazioneException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean gruppoInUso = this.isGruppoInUso(gruppo.getNome(), whereIsInUso, normalizeObjectIds);
        StringBuilder inUsoMessage = new StringBuilder();
        if (gruppoInUso) {
            String s = DBOggettiInUsoUtils.toString((IDGruppo)gruppo, whereIsInUso, (boolean)false, (String)"\n");
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("Il tag non risulta utilizzato in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }
}

