/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginCore;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginSessionUtilities;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginTipologia;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class LoginAsSu
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        GeneralHelper generalHelper = new GeneralHelper(session);
        PageData pd = generalHelper.initPageData();
        GeneralData gd = generalHelper.initGeneralData(request, "login.do");
        try {
            ControlStationCore.clearAuditManager();
            LoginHelper loginHelper = new LoginHelper(request, pd, session);
            String login = loginHelper.getParameter("login");
            if (login == null) {
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"loginAsSu", (ForwardParams)ForwardParams.LOGIN());
            }
            boolean isOk = loginHelper.loginCheckData(LoginTipologia.WITHOUT_PASSWORD);
            if (!isOk) {
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"loginAsSu", (ForwardParams)ForwardParams.LOGIN());
            }
            String loginOLD = ServletUtils.getUserLoginFromSession((HttpSession)session);
            LoginCore loginCore = new LoginCore();
            LoginSessionUtilities.setLoginParametersSession(request, session, (ControlStationCore)loginCore, login);
            loginCore.performAuditLogout(loginOLD);
            loginCore.performAuditLogin(login);
            gd = generalHelper.initGeneralData(request, "login.do");
            loginHelper = new LoginHelper(request, pd, session);
            loginHelper.makeMenu();
            pd.setMessage("Login effettuato con successo", Costanti.MESSAGE_TYPE_INFO_SINTETICO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"loginAsSu", (ForwardParams)ForwardParams.LOGIN());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"loginAsSu", (ForwardParams)ForwardParams.LOGIN());
        }
    }
}

