/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.oauth2.BaseOAuth2CallbackServlet;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.slf4j.Logger;

public class OAuth2CallbackServlet
extends BaseOAuth2CallbackServlet {
    public static final String PATH_SERVLET_OAUTH2_USER = "/oauth2/user";
    private static final long serialVersionUID = 1L;
    private static Logger log = ControlStationLogger.getPddConsoleCoreLogger();

    protected String getConsoleError(HttpServletRequest request) {
        String loginUtenteNonAutorizzatoRedirectUrl = null;
        try {
            loginUtenteNonAutorizzatoRedirectUrl = ConsoleProperties.getInstance().getLoginUtenteNonAutorizzatoRedirectUrl();
        }
        catch (OpenSPCoop2ConfigurationException | UtilsException e) {
            log.error("Errore durante la lettura delle properties: " + e.getMessage(), e);
        }
        return StringUtils.isNotEmpty((CharSequence)loginUtenteNonAutorizzatoRedirectUrl) ? loginUtenteNonAutorizzatoRedirectUrl : request.getContextPath() + "/login.do";
    }

    protected String getConsoleHome(HttpServletRequest request) {
        return request.getContextPath() + PATH_SERVLET_OAUTH2_USER;
    }

    protected Properties getLoginProperties() {
        try {
            return ConsoleProperties.getInstance().getLoginProperties();
        }
        catch (OpenSPCoop2ConfigurationException | UtilsException e) {
            log.error("Errore durante la lettura delle properties: " + e.getMessage(), e);
            return new Properties();
        }
    }

    protected Logger getLog() {
        return log;
    }
}

