/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pd;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaRichiesta;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class PorteDelegateTrasformazioniAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            String azioniAllTmp;
            String idFruizione;
            PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(request, pd, session);
            porteDelegateHelper.makeMenu();
            Integer parentPD = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentPD == null) {
                parentPD = 0;
            }
            String id = porteDelegateHelper.getParametroLong("id");
            int idInt = Integer.parseInt(id);
            String idsogg = porteDelegateHelper.getParametroLong("idsogg");
            String idAsps = porteDelegateHelper.getParametroLong("idAsps");
            if (idAsps == null) {
                idAsps = "";
            }
            if ((idFruizione = porteDelegateHelper.getParametroLong("myId")) == null) {
                idFruizione = "";
            }
            Long idFru = Long.parseLong(idFruizione);
            String nome = porteDelegateHelper.getParameter("trNome");
            String stato = porteDelegateHelper.getParameter("trStato");
            if (stato == null || "".equals(stato)) {
                stato = StatoFunzionalita.DISABILITATO.getValue();
            }
            boolean azioniAll = (azioniAllTmp = porteDelegateHelper.getParameter("trAppAzioniAll")) == null || "".equals(azioniAllTmp) || "yes".equals(azioniAllTmp);
            String[] azioni = porteDelegateHelper.getParameterValues("trAppAzioni");
            String pattern = porteDelegateHelper.getParameter("trAppPat");
            String contentType = porteDelegateHelper.getParameter("trAppCT");
            Parameter pId = new Parameter("id", id);
            Parameter pIdSoggetto = new Parameter("idsogg", idsogg);
            Parameter pIdAsps = new Parameter("idAsps", idAsps);
            Parameter pIdFruizione = new Parameter("myId", idFruizione);
            PorteDelegateCore porteDelegateCore = new PorteDelegateCore();
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(porteDelegateCore);
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(porteDelegateCore);
            SoggettiCore soggettiCore = new SoggettiCore(porteDelegateCore);
            PortaDelegata portaDelegata = porteDelegateCore.getPortaDelegata(idInt);
            String nomePorta = portaDelegata.getNome();
            MappingFruizionePortaDelegata mappingAssociatoPorta = porteDelegateCore.getMappingFruizionePortaDelegata(portaDelegata);
            String[] azioniDisponibiliList = null;
            String[] azioniDisponibiliLabelList = null;
            ArrayList azioniAssociatePorta = new ArrayList();
            if (portaDelegata.getAzione() != null && portaDelegata.getAzione().getAzioneDelegataList() != null) {
                azioniAssociatePorta.addAll(portaDelegata.getAzione().getAzioneDelegataList());
            }
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idAsps));
            AccordoServizioParteComuneSintetico apc = apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
            ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(apc.getServiceBinding());
            Map<String, String> azioniAccordo = porteDelegateCore.getAzioniConLabel(asps, apc, false, true, new ArrayList<String>());
            if (azioniAccordo != null && azioniAccordo.size() > 0) {
                if (!mappingAssociatoPorta.isDefault()) {
                    azioniDisponibiliList = new String[azioniAssociatePorta.size()];
                    azioniDisponibiliLabelList = new String[azioniAssociatePorta.size()];
                    int i = 0;
                    for (String string : azioniAccordo.keySet()) {
                        if (!azioniAssociatePorta.contains(string)) continue;
                        azioniDisponibiliList[i] = string;
                        azioniDisponibiliLabelList[i] = azioniAccordo.get(string);
                        ++i;
                    }
                } else {
                    Object portaDelegataTmp;
                    int listaMappingErogazioneSize;
                    IDServizio idServizioFromAccordo = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
                    IDSoggetto idSoggettoFruitore = new IDSoggetto();
                    String tipoSoggettoFruitore = null;
                    String nomeSoggettoFruitore = null;
                    if (apsCore.isRegistroServiziLocale()) {
                        soggettoFruitore = soggettiCore.getSoggettoRegistro(Integer.parseInt(idsogg));
                        tipoSoggettoFruitore = soggettoFruitore.getTipo();
                        nomeSoggettoFruitore = soggettoFruitore.getNome();
                    } else {
                        soggettoFruitore = soggettiCore.getSoggetto(Integer.parseInt(idsogg));
                        tipoSoggettoFruitore = soggettoFruitore.getTipo();
                        nomeSoggettoFruitore = soggettoFruitore.getNome();
                    }
                    idSoggettoFruitore.setTipo(tipoSoggettoFruitore);
                    idSoggettoFruitore.setNome(nomeSoggettoFruitore);
                    List<MappingFruizionePortaDelegata> listaMappingFruizione = apsCore.serviziFruitoriMappingList(idFru, idSoggettoFruitore, idServizioFromAccordo, null);
                    ArrayList<String> azioniOccupate = new ArrayList<String>();
                    int n = listaMappingErogazioneSize = listaMappingFruizione != null ? listaMappingFruizione.size() : 0;
                    if (listaMappingErogazioneSize > 0) {
                        for (int i = 0; i < listaMappingFruizione.size(); ++i) {
                            MappingFruizionePortaDelegata mappingErogazionePortaDelegata = listaMappingFruizione.get(i);
                            portaDelegataTmp = porteDelegateCore.getPortaDelegata(mappingErogazionePortaDelegata.getIdPortaDelegata());
                            if (portaDelegataTmp.getAzione() == null || portaDelegataTmp.getAzione().getAzioneDelegataList() == null) continue;
                            azioniOccupate.addAll(portaDelegataTmp.getAzione().getAzioneDelegataList());
                        }
                    }
                    Map<String, String> azioniAccordoDisponibili = porteDelegateCore.getAzioniConLabel(asps, apc, false, true, azioniOccupate);
                    azioniDisponibiliList = new String[azioniAccordoDisponibili.size()];
                    azioniDisponibiliLabelList = new String[azioniAccordoDisponibili.size()];
                    int i = 0;
                    portaDelegataTmp = azioniAccordoDisponibili.keySet().iterator();
                    while (portaDelegataTmp.hasNext()) {
                        String string;
                        azioniDisponibiliList[i] = string = (String)portaDelegataTmp.next();
                        azioniDisponibiliLabelList[i] = azioniAccordoDisponibili.get(string);
                        ++i;
                    }
                }
            }
            List<Parameter> lstParam = porteDelegateHelper.getTitoloPD(parentPD, idsogg, idAsps, idFruizione);
            Object labelPerPorta = null;
            labelPerPorta = parentPD != null && parentPD == 2 ? porteDelegateCore.getLabelRegolaMappingFruizionePortaDelegata("Trasformazioni di ", "Trasformazioni", portaDelegata) : "Trasformazioni di " + nomePorta;
            lstParam.add(new Parameter((String)labelPerPorta, "porteDelegateTrasformazioniList.do", new Parameter[]{pId, pIdSoggetto, pIdAsps, pIdFruizione}));
            lstParam.add(ServletUtils.getParameterAggiungi());
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (porteDelegateHelper.isEditModeInProgress()) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = porteDelegateHelper.addTrasformazioneToDatiOpAdd(dati, portaDelegata, nome, stato, azioniAll, azioniDisponibiliList, azioniDisponibiliLabelList, azioni, pattern, contentType, null, null, null, apc.getServiceBinding(), true);
                dati = porteDelegateHelper.addHiddenFieldsToDati(TipoOperazione.ADD, id, idsogg, null, idAsps, idFruizione, portaDelegata.getTipoSoggettoProprietario(), portaDelegata.getNomeSoggettoProprietario(), dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"porteDelegateTrasformazioni", (ForwardParams)ForwardParams.ADD());
            }
            String azioniAsString = azioni != null ? StringUtils.join(Arrays.asList(azioni), (String)",") : "";
            String patternDBCheck = StringUtils.isNotEmpty((CharSequence)pattern) ? pattern : null;
            String contentTypeDBCheck = StringUtils.isNotEmpty((CharSequence)contentType) ? contentType : null;
            String azioniDBCheck = StringUtils.isNotEmpty((CharSequence)azioniAsString) ? azioniAsString : null;
            TrasformazioneRegola trasformazioneDBCheckCriteri = porteDelegateCore.getTrasformazione(Long.parseLong(id), azioniDBCheck, patternDBCheck, contentTypeDBCheck, null, null);
            TrasformazioneRegola trasformazioneDBCheckNome = porteDelegateCore.getTrasformazione(Long.parseLong(id), nome);
            boolean isOk = porteDelegateHelper.trasformazioniCheckData(TipoOperazione.ADD, Long.parseLong(id), nome, trasformazioneDBCheckCriteri, trasformazioneDBCheckNome, null, serviceBinding);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = porteDelegateHelper.addTrasformazioneToDatiOpAdd(dati, portaDelegata, nome, stato, azioniAll, azioniDisponibiliList, azioniDisponibiliLabelList, azioni, pattern, contentType, null, null, null, apc.getServiceBinding(), true);
                dati = porteDelegateHelper.addHiddenFieldsToDati(TipoOperazione.ADD, id, idsogg, null, idAsps, idFruizione, portaDelegata.getTipoSoggettoProprietario(), portaDelegata.getNomeSoggettoProprietario(), dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"porteDelegateTrasformazioni", (ForwardParams)ForwardParams.ADD());
            }
            if (portaDelegata.getTrasformazioni() == null) {
                portaDelegata.setTrasformazioni(new Trasformazioni());
            }
            int posizione = 1;
            for (TrasformazioneRegola check : portaDelegata.getTrasformazioni().getRegolaList()) {
                if (check.getPosizione() < posizione) continue;
                posizione = check.getPosizione() + 1;
            }
            TrasformazioneRegola trasformazioneRegola = new TrasformazioneRegola();
            trasformazioneRegola.setPosizione(posizione);
            trasformazioneRegola.setNome(nome);
            trasformazioneRegola.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita((String)stato));
            TrasformazioneRegolaApplicabilitaRichiesta applicabilita = new TrasformazioneRegolaApplicabilitaRichiesta();
            applicabilita.setPattern(pattern);
            if (contentType != null) {
                applicabilita.getContentTypeList().addAll(Arrays.asList(contentType.split(",")));
            }
            if (azioni != null && azioni.length > 0) {
                for (String azione : azioni) {
                    applicabilita.addAzione(azione);
                }
            }
            trasformazioneRegola.setApplicabilita(applicabilita);
            trasformazioneRegola.setRichiesta(new TrasformazioneRegolaRichiesta());
            portaDelegata.getTrasformazioni().addRegola(trasformazioneRegola);
            porteDelegateCore.performUpdateOperation(userLogin, porteDelegateHelper.smista(), portaDelegata);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.PORTE_DELEGATE_TRASFORMAZIONI;
            ricerca = porteDelegateHelper.checkSearchParameters(idLista, ricerca);
            List<TrasformazioneRegola> lista = porteDelegateCore.porteDelegateTrasformazioniList(Long.parseLong(id), (ISearch)ricerca);
            porteDelegateHelper.preparePorteDelegateTrasformazioniRegolaList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"porteDelegateTrasformazioni", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteDelegateTrasformazioni", (ForwardParams)ForwardParams.ADD());
        }
    }
}

