/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.protocol_properties;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class ProtocolPropertiesHelper
extends ConsoleHelper {
    public ProtocolPropertiesHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        super(request, pd, session);
    }

    public ProtocolPropertiesHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        super(core, request, pd, session);
    }

    public Object getIdOggettoProprietario(Object proprietario, String idProprietario, String nomeProprieta, String nomeParentProprieta, ProprietariProtocolProperty tipoProprietario, String tipoAccordo) throws Exception {
        if (tipoProprietario != null && proprietario != null) {
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: {
                    AccordoCooperazione ac = (AccordoCooperazione)proprietario;
                    IDAccordo idAccordoCooperazione = this.idAccordoFactory.getIDAccordoFromValues(ac.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)ac.getSoggettoReferente()), ac.getVersione());
                    return idAccordoCooperazione;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    AccordoServizioParteComune as = (AccordoServizioParteComune)proprietario;
                    IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)as.getSoggettoReferente()), as.getVersione());
                    return idAccordo;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    AccordoServizioParteSpecifica aps = (AccordoServizioParteSpecifica)proprietario;
                    IDServizio idAps = this.idServizioFactory.getIDServizioFromAccordo(aps);
                    return idAps;
                }
                case AZIONE_ACCORDO: {
                    Azione azione = (Azione)proprietario;
                    AccordoServizioParteComuneSintetico apca = this.apcCore.getAccordoServizioSintetico(Integer.parseInt(idProprietario));
                    IDAccordo idAccordoAz = this.idAccordoFactory.getIDAccordoFromValues(apca.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apca.getSoggettoReferente()), apca.getVersione());
                    IDAccordoAzione idAccordoAzione = new IDAccordoAzione();
                    idAccordoAzione.setIdAccordo(idAccordoAz);
                    idAccordoAzione.setNome(azione.getNome());
                    return idAccordoAzione;
                }
                case FRUITORE: {
                    Fruitore fruitore = (Fruitore)proprietario;
                    IDSoggetto idSoggettoFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                    AccordoServizioParteSpecifica apsFrui = this.apsCore.getAccordoServizioParteSpecifica(fruitore.getIdServizio());
                    IDServizio idApsFrui = this.idServizioFactory.getIDServizioFromAccordo(apsFrui);
                    IDFruizione idFruizione = new IDFruizione();
                    idFruizione.setIdServizio(idApsFrui);
                    idFruizione.setIdFruitore(idSoggettoFruitore);
                    return idFruizione;
                }
                case OPERATION: {
                    Operation azionePt = (Operation)proprietario;
                    IDPortType idPortTypeAz = new IDPortType();
                    int idProp = Integer.parseInt(idProprietario);
                    AccordoServizioParteComuneSintetico apc = this.apcCore.getAccordoServizioSintetico(idProp);
                    for (PortTypeSintetico pt : apc.getPortType()) {
                        if (!pt.getNome().equals(nomeParentProprieta)) continue;
                        IDAccordo idAccordoPt = this.idAccordoFactory.getIDAccordoFromValues(apc.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apc.getSoggettoReferente()), apc.getVersione());
                        idPortTypeAz.setIdAccordo(idAccordoPt);
                        idPortTypeAz.setNome(pt.getNome());
                        break;
                    }
                    IDPortTypeAzione idAzionePt = new IDPortTypeAzione();
                    idAzionePt.setIdPortType(idPortTypeAz);
                    idAzionePt.setNome(azionePt.getNome());
                    return idAzionePt;
                }
                case PORT_TYPE: {
                    PortType pt = (PortType)proprietario;
                    IDPortType idPt = new IDPortType();
                    AccordoServizioParteComuneSintetico apcPt = this.apcCore.getAccordoServizioSintetico(pt.getIdAccordo());
                    IDAccordo idAccordoPt = this.idAccordoFactory.getIDAccordoFromValues(apcPt.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apcPt.getSoggettoReferente()), apcPt.getVersione());
                    idPt.setIdAccordo(idAccordoPt);
                    idPt.setNome(pt.getNome());
                    return idPt;
                }
                case RESOURCE: {
                    Resource risorsa = (Resource)proprietario;
                    AccordoServizioParteComuneSintetico apcr = this.apcCore.getAccordoServizioSintetico(Integer.parseInt(idProprietario));
                    IDAccordo idAccordoRisorsa = this.idAccordoFactory.getIDAccordoFromValues(apcr.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apcr.getSoggettoReferente()), apcr.getVersione());
                    IDResource idAccordoR = new IDResource();
                    idAccordoR.setIdAccordo(idAccordoRisorsa);
                    idAccordoR.setNome(risorsa.getNome());
                    return idAccordoR;
                }
                case SOGGETTO: {
                    Soggetto soggettoRegistro = (Soggetto)proprietario;
                    IDSoggetto idSoggetto = new IDSoggetto(soggettoRegistro.getTipo(), soggettoRegistro.getNome());
                    return idSoggetto;
                }
                case SERVIZIO_APPLICATIVO: {
                    ServizioApplicativo servizioApplicativo = (ServizioApplicativo)proprietario;
                    IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                    idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(servizioApplicativo.getTipoSoggettoProprietario(), servizioApplicativo.getNomeSoggettoProprietario()));
                    idServizioApplicativo.setNome(servizioApplicativo.getNome());
                    return idServizioApplicativo;
                }
            }
        }
        return null;
    }

    public Object getOggettoProprietario(String idProprietario, String nomeProprieta, String nomeParentProprieta, ProprietariProtocolProperty tipoProprietario, String tipoAccordo) throws Exception {
        try {
            if (tipoProprietario != null && idProprietario != null) {
                long idProp = Long.valueOf(idProprietario);
                switch (tipoProprietario) {
                    case ACCORDO_COOPERAZIONE: {
                        AccordoCooperazione ac = this.acCore.getAccordoCooperazione(idProp);
                        return ac;
                    }
                    case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                        AccordoServizioParteComune as = this.apcCore.getAccordoServizioFull(idProp);
                        return as;
                    }
                    case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                        AccordoServizioParteSpecifica aps = this.apsCore.getAccordoServizioParteSpecifica(idProp);
                        return aps;
                    }
                    case AZIONE_ACCORDO: {
                        AccordoServizioParteComune apca = this.apcCore.getAccordoServizioFull(idProp);
                        for (Azione azione : apca.getAzioneList()) {
                            if (!azione.getNome().equals(nomeProprieta)) continue;
                            return azione;
                        }
                        return null;
                    }
                    case FRUITORE: {
                        Fruitore servFru = this.apsCore.getServizioFruitore(idProp);
                        return servFru;
                    }
                    case OPERATION: {
                        AccordoServizioParteComune apcop = this.apcCore.getAccordoServizioFull(idProp);
                        for (PortType pt : apcop.getPortTypeList()) {
                            if (!pt.getNome().equals(nomeParentProprieta)) continue;
                            for (Operation azione : pt.getAzioneList()) {
                                if (!azione.getNome().equals(nomeProprieta)) continue;
                                return azione;
                            }
                        }
                        return null;
                    }
                    case PORT_TYPE: {
                        AccordoServizioParteComune apc = this.apcCore.getAccordoServizioFull(idProp);
                        for (PortType pt : apc.getPortTypeList()) {
                            if (!pt.getNome().equals(nomeProprieta)) continue;
                            return pt;
                        }
                        return null;
                    }
                    case RESOURCE: {
                        AccordoServizioParteComune apcr = this.apcCore.getAccordoServizioFull(idProp);
                        for (Resource risorsa : apcr.getResourceList()) {
                            if (!risorsa.getNome().equals(nomeProprieta)) continue;
                            return risorsa;
                        }
                        return null;
                    }
                    case SOGGETTO: {
                        Soggetto soggettoRegistro = this.soggettiCore.getSoggettoRegistro(idProp);
                        return soggettoRegistro;
                    }
                    case SERVIZIO_APPLICATIVO: {
                        ServizioApplicativo servizioApplicativo = this.saCore.getServizioApplicativo(idProp);
                        return servizioApplicativo;
                    }
                }
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        return null;
    }

    public String getStatoOggettoProprietario(String idProprietario, String nomeProprieta, String nomeParentProprieta, ProprietariProtocolProperty tipoProprietario, String tipoAccordo) throws Exception {
        try {
            if (tipoProprietario != null && idProprietario != null) {
                int idProp = Integer.parseInt(idProprietario);
                switch (tipoProprietario) {
                    case ACCORDO_COOPERAZIONE: {
                        AccordoCooperazione ac = this.acCore.getAccordoCooperazione(idProp);
                        return ac.getStatoPackage();
                    }
                    case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                        AccordoServizioParteComuneSintetico as = this.apcCore.getAccordoServizioSintetico(idProp);
                        return as.getStatoPackage();
                    }
                    case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                        AccordoServizioParteSpecifica aps = this.apsCore.getAccordoServizioParteSpecifica(idProp);
                        return aps.getStatoPackage();
                    }
                    case AZIONE_ACCORDO: {
                        AccordoServizioParteComuneSintetico apca = this.apcCore.getAccordoServizioSintetico(idProp);
                        return apca.getStatoPackage();
                    }
                    case FRUITORE: {
                        Fruitore servFru = this.apsCore.getServizioFruitore(idProp);
                        return servFru.getStatoPackage();
                    }
                    case OPERATION: {
                        AccordoServizioParteComuneSintetico apcop = this.apcCore.getAccordoServizioSintetico(idProp);
                        return apcop.getStatoPackage();
                    }
                    case PORT_TYPE: {
                        AccordoServizioParteComuneSintetico apc = this.apcCore.getAccordoServizioSintetico(idProp);
                        return apc.getStatoPackage();
                    }
                    case RESOURCE: {
                        AccordoServizioParteComuneSintetico apcr = this.apcCore.getAccordoServizioSintetico(idProp);
                        return apcr.getStatoPackage();
                    }
                    case SOGGETTO: {
                        return null;
                    }
                    case SERVIZIO_APPLICATIVO: {
                        return null;
                    }
                }
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        return null;
    }

    public List<DataElement> addProtocolPropertyChangeToDati(TipoOperazione tipoOp, List<DataElement> dati, String protocollo, String id, String nome, String idProprietario, ProprietariProtocolProperty tipoProprietario, String tipoAccordo, String nomeProprietario, String nomeParentProprietario, String urlChange, String label, BinaryParameter contenutoDocumento, StringBuilder contenutoDocumentoStringBuilder, String errore, String tipologiaDocumentoScaricare, AbstractConsoleItem<?> binaryConsoleItem, boolean readOnly, String noteAggiornamento) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("id");
        de.setValue(id);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        de = new DataElement();
        de.setLabel("changeBinary");
        de.setValue("true");
        de.setType(DataElementType.HIDDEN);
        de.setName("changeBinary");
        dati.add(de);
        de = new DataElement();
        de.setLabel("nome");
        de.setValue(nome);
        de.setType(DataElementType.HIDDEN);
        de.setName("nome");
        dati.add(de);
        de = new DataElement();
        de.setLabel("idProprietario");
        de.setValue(idProprietario);
        de.setType(DataElementType.HIDDEN);
        de.setName("idProprietario");
        dati.add(de);
        de = new DataElement();
        de.setLabel("protocollo");
        de.setValue(protocollo);
        de.setType(DataElementType.HIDDEN);
        de.setName("protocollo");
        dati.add(de);
        de = new DataElement();
        de.setLabel("tipoProprietario");
        de.setValue(tipoProprietario.toString());
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoProprietario");
        dati.add(de);
        de = new DataElement();
        de.setLabel("tipoAccordo");
        de.setValue(tipoAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoAccordo");
        dati.add(de);
        de = new DataElement();
        de.setLabel("nomeProprietario");
        de.setValue(nomeProprietario);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomeProprietario");
        dati.add(de);
        de = new DataElement();
        de.setLabel("nomeParentProprietario");
        de.setValue(nomeParentProprietario);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomeParentProprietario");
        dati.add(de);
        de = new DataElement();
        de.setLabel("urlOrigChange");
        de.setValue(urlChange);
        de.setType(DataElementType.HIDDEN);
        de.setName("urlOrigChange");
        dati.add(de);
        de = new DataElement();
        de.setLabel(binaryConsoleItem.getLabel());
        de.setType(DataElementType.TITLE);
        dati.add(de);
        boolean showContent = true;
        if (binaryConsoleItem instanceof BinaryConsoleItem) {
            showContent = ((BinaryConsoleItem)binaryConsoleItem).isShowContent();
        }
        String statoPackage = this.getStatoOggettoProprietario(idProprietario, nomeProprietario, nomeParentProprietario, tipoProprietario, tipoAccordo);
        if (this.isShowGestioneWorkflowStatoDocumenti() && statoPackage != null && StatiAccordo.finale.toString().equals(statoPackage)) {
            this.pd.disableEditMode();
            if (contenutoDocumento != null && contenutoDocumento.getValue() != null && contenutoDocumento.getValue().length > 0) {
                de = new DataElement();
                de.setLabel("Nome");
                de.setType(DataElementType.TEXT);
                de.setValue(contenutoDocumento.getFilename());
                dati.add(de);
                if (showContent) {
                    if (errore != null) {
                        de = new DataElement();
                        de.setValue(errore);
                        de.setLabel(binaryConsoleItem.getLabel());
                        de.setType(DataElementType.TEXT);
                        de.setSize(this.getSize());
                        dati.add(de);
                    } else {
                        de = new DataElement();
                        de.setLabel("Attuale");
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                        de.setValue(contenutoDocumentoStringBuilder.toString());
                        de.setRows(30);
                        de.setCols(100);
                        dati.add(de);
                    }
                }
            } else {
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                de.setSize(this.getSize());
                dati.add(de);
            }
            if (id != null && !"".equals(id) && this.core.isVisualizzaInformazioniCifrate()) {
                DataElement saveAs = new DataElement();
                saveAs.setValue("Download");
                saveAs.setType(DataElementType.LINK);
                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAllegato", id), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("tipoDocumento", "protocolProperty")});
                saveAs.setDisabilitaAjaxStatus();
                if (this.core.getDriverBYOKUtilities().isEnabledBYOK() && binaryConsoleItem.isLockedType()) {
                    saveAs.setConfirm("Attenzione", this.core.getByokWarningMessage(), "Conferma");
                }
                dati.add(saveAs);
            }
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("__fn__contenutoDocumento");
            de.setValue(contenutoDocumento != null ? contenutoDocumento.getFilename() : null);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("__fd__contenutoDocumento");
            de.setValue(contenutoDocumento != null ? contenutoDocumento.getId() : null);
            dati.add(de);
        } else {
            if (contenutoDocumento != null && contenutoDocumento.getValue() != null && contenutoDocumento.getValue().length > 0) {
                de = new DataElement();
                de.setLabel("Nome");
                de.setType(DataElementType.TEXT);
                de.setValue(contenutoDocumento.getFilename());
                dati.add(de);
                if (showContent) {
                    if (errore != null) {
                        de = new DataElement();
                        de.setValue(errore);
                        de.setLabel(binaryConsoleItem.getLabel());
                        de.setType(DataElementType.TEXT);
                        de.setSize(this.getSize());
                        dati.add(de);
                    } else {
                        de = new DataElement();
                        de.setLabel("Attuale");
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                        de.setValue(contenutoDocumentoStringBuilder.toString());
                        de.setRows(30);
                        de.setCols(100);
                        dati.add(de);
                    }
                }
                if (id != null && !"".equals(id) && this.core.isVisualizzaInformazioniCifrate()) {
                    DataElement saveAs = new DataElement();
                    saveAs.setValue("Download");
                    saveAs.setType(DataElementType.LINK);
                    saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAllegato", id), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("tipoDocumento", "protocolProperty")});
                    saveAs.setDisabilitaAjaxStatus();
                    if (this.core.getDriverBYOKUtilities().isEnabledBYOK() && binaryConsoleItem.isLockedType()) {
                        saveAs.setConfirm("Attenzione", this.core.getByokWarningMessage(), "Conferma");
                    }
                    dati.add(saveAs);
                }
                if (!readOnly) {
                    de = new DataElement();
                    de.setType(DataElementType.TITLE);
                    de.setLabel("Aggiorna  " + binaryConsoleItem.getLabel());
                    de.setValue("");
                    de.setSize(this.getSize());
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setLabel("Attuale");
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                dati.add(de);
            }
            if (!readOnly) {
                de = new DataElement();
                de.setLabel("Nuovo Contenuto");
                de.setValue("");
                de.setType(DataElementType.FILE);
                de.setName("contenutoDocumento");
                de.setSize(this.getSize());
                de.setRequired(binaryConsoleItem.isRequired());
                dati.add(de);
            }
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("__fn__contenutoDocumento");
            de.setValue(contenutoDocumento != null ? contenutoDocumento.getFilename() : null);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("__fd__contenutoDocumento");
            de.setValue(contenutoDocumento != null ? contenutoDocumento.getId() : null);
            dati.add(de);
            if (!readOnly && contenutoDocumento != null && contenutoDocumento.getValue() != null && contenutoDocumento.getValue().length > 0 && !binaryConsoleItem.isRequired()) {
                de = new DataElement();
                de.setBold(true);
                de.setLabel("Warning: ");
                de.setValue("Se si desidera eliminare un contenuto precedentemente caricato cliccare su 'Salva' senza selezionare alcun file");
                de.setType(DataElementType.NOTE);
                de.setName("contenutoDocumentoWarn");
                de.setSize(this.getSize());
                dati.add(de);
            }
            if (!readOnly && noteAggiornamento != null) {
                de = new DataElement();
                de.setValue(noteAggiornamento);
                de.setType(DataElementType.NOTE);
                de.setName("contenutoDocumentoNote");
                de.setSize(this.getSize());
                dati.add(de);
            }
            if (readOnly) {
                this.pd.disableEditMode();
            }
        }
        return dati;
    }

    public ConsoleConfiguration getConsoleDynamicConfiguration(Object idOggettoProprietario, String idProprietario, String nomeProprietario, String nomeParentProprietario, ProprietariProtocolProperty tipoProprietario, String tipoAccordo, ConsoleOperationType consoleOperationType, IRegistryReader registryReader, IConfigIntegrationReader configRegistryReader, IConsoleDynamicConfiguration consoleDynamicConfiguration) throws ProtocolException {
        block17: {
            if (tipoProprietario == null || idProprietario == null || idOggettoProprietario == null) break block17;
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: {
                    IDAccordo idAccordoCooperazione = (IDAccordo)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigAccordoCooperazione(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idAccordoCooperazione);
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    IDAccordo idApc = (IDAccordo)idOggettoProprietario;
                    if (tipoAccordo.equals("apc")) {
                        return consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteComune(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idApc);
                    }
                    return consoleDynamicConfiguration.getDynamicConfigAccordoServizioComposto(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idApc);
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    IDServizio idAps = (IDServizio)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteSpecifica(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idAps);
                }
                case AZIONE_ACCORDO: {
                    IDAccordoAzione idAccordoAzione = (IDAccordoAzione)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigAzione(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idAccordoAzione);
                }
                case FRUITORE: {
                    IDFruizione idFruizione = (IDFruizione)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idFruizione);
                }
                case OPERATION: {
                    IDPortTypeAzione idAzionePt = (IDPortTypeAzione)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigOperation(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idAzionePt);
                }
                case PORT_TYPE: {
                    IDPortType idPt = (IDPortType)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigPortType(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idPt);
                }
                case RESOURCE: {
                    IDResource idAccordoRisorsa = (IDResource)idOggettoProprietario;
                    String httpMethod = null;
                    String path = null;
                    try {
                        Resource r = registryReader.getResourceAccordo(idAccordoRisorsa);
                        httpMethod = r.getMethod() != null ? r.getMethod().getValue() : null;
                        path = r.getPath();
                    }
                    catch (Exception r) {
                        // empty catch block
                    }
                    return consoleDynamicConfiguration.getDynamicConfigResource(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idAccordoRisorsa, httpMethod, path);
                }
                case SOGGETTO: {
                    IDSoggetto idSoggetto = (IDSoggetto)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigSoggetto(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idSoggetto);
                }
                case SERVIZIO_APPLICATIVO: {
                    IDServizioApplicativo idServizioApplicativo = (IDServizioApplicativo)idOggettoProprietario;
                    return consoleDynamicConfiguration.getDynamicConfigServizioApplicativo(consoleOperationType, (IConsoleHelper)this, registryReader, configRegistryReader, idServizioApplicativo);
                }
            }
        }
        return null;
    }

    public boolean isProtocolPropertiesRegistry(ProprietariProtocolProperty tipoProprietario) {
        if (tipoProprietario != null) {
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: 
                case ACCORDO_SERVIZIO_PARTE_COMUNE: 
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                case AZIONE_ACCORDO: 
                case FRUITORE: 
                case OPERATION: 
                case PORT_TYPE: 
                case RESOURCE: 
                case SOGGETTO: {
                    return true;
                }
                case SERVIZIO_APPLICATIVO: {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ProtocolProperty> getProtocolPropertiesRegistry(Object proprietario, String id, String nome, String idProprietario, String nomeProprietario, String nomeParentProprietario, ProprietariProtocolProperty tipoProprietario, String tipoAccordo) throws Exception {
        if (proprietario != null) {
            List protocolPropertyList = null;
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: {
                    AccordoCooperazione ac = (AccordoCooperazione)proprietario;
                    protocolPropertyList = ac.getProtocolPropertyList();
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    AccordoServizioParteComune as = (AccordoServizioParteComune)proprietario;
                    protocolPropertyList = as.getProtocolPropertyList();
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    AccordoServizioParteSpecifica aps = (AccordoServizioParteSpecifica)proprietario;
                    protocolPropertyList = aps.getProtocolPropertyList();
                    break;
                }
                case AZIONE_ACCORDO: {
                    Azione azione = (Azione)proprietario;
                    protocolPropertyList = azione.getProtocolPropertyList();
                    break;
                }
                case FRUITORE: {
                    Fruitore fruitore = (Fruitore)proprietario;
                    protocolPropertyList = fruitore.getProtocolPropertyList();
                    break;
                }
                case OPERATION: {
                    Operation azionePt = (Operation)proprietario;
                    protocolPropertyList = azionePt.getProtocolPropertyList();
                    break;
                }
                case PORT_TYPE: {
                    PortType pt = (PortType)proprietario;
                    protocolPropertyList = pt.getProtocolPropertyList();
                    break;
                }
                case RESOURCE: {
                    Resource risorsa = (Resource)proprietario;
                    protocolPropertyList = risorsa.getProtocolPropertyList();
                    break;
                }
                case SOGGETTO: {
                    Soggetto soggettoRegistro = (Soggetto)proprietario;
                    protocolPropertyList = soggettoRegistro.getProtocolPropertyList();
                    break;
                }
                case SERVIZIO_APPLICATIVO: {
                    throw new Exception("Con il TipoProprietario indicato (" + String.valueOf(tipoProprietario) + ") deve essere invocato il metodo 'getProtocolPropertiesConfig'");
                }
            }
            return protocolPropertyList;
        }
        return null;
    }

    public List<org.openspcoop2.core.config.ProtocolProperty> getProtocolPropertiesConfig(Object proprietario, String id, String nome, String idProprietario, String nomeProprietario, String nomeParentProprietario, ProprietariProtocolProperty tipoProprietario, String tipoAccordo) throws Exception {
        if (proprietario != null) {
            List protocolPropertyList = null;
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: 
                case ACCORDO_SERVIZIO_PARTE_COMUNE: 
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                case AZIONE_ACCORDO: 
                case FRUITORE: 
                case OPERATION: 
                case PORT_TYPE: 
                case RESOURCE: 
                case SOGGETTO: {
                    throw new Exception("Con il TipoProprietario indicato (" + String.valueOf(tipoProprietario) + ") deve essere invocato il metodo 'getProtocolPropertiesRegistry'");
                }
                case SERVIZIO_APPLICATIVO: {
                    ServizioApplicativo servizioApplicativo = (ServizioApplicativo)proprietario;
                    protocolPropertyList = servizioApplicativo.getProtocolPropertyList();
                }
            }
            return protocolPropertyList;
        }
        return null;
    }

    public void salvaPropertiesRegistry(String userLogin, boolean smista, Object proprietario, List<ProtocolProperty> protocolPropertiesAggiornate, String id, String nome, String idProprietario, String nomeProprietario, String nomeParentProprietario, ProprietariProtocolProperty tipoProprietario, String tipoAccordo) throws Exception {
        if (proprietario != null) {
            int idProp = Integer.parseInt(idProprietario);
            boolean save = false;
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: {
                    AccordoCooperazione ac = (AccordoCooperazione)proprietario;
                    ac.setProtocolPropertyList(protocolPropertiesAggiornate);
                    this.core.performUpdateOperation(userLogin, smista, proprietario);
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    AccordoServizioParteComune as = (AccordoServizioParteComune)proprietario;
                    as.setProtocolPropertyList(protocolPropertiesAggiornate);
                    this.core.performUpdateOperation(userLogin, smista, proprietario);
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    AccordoServizioParteSpecifica aps = (AccordoServizioParteSpecifica)proprietario;
                    aps.setProtocolPropertyList(protocolPropertiesAggiornate);
                    this.core.performUpdateOperation(userLogin, smista, proprietario);
                    break;
                }
                case AZIONE_ACCORDO: {
                    Azione newAzione = (Azione)proprietario;
                    AccordoServizioParteComune apca = this.apcCore.getAccordoServizioFull(idProp);
                    for (Azione azione : apca.getAzioneList()) {
                        if (!azione.getNome().equals(newAzione.getNome())) continue;
                        azione.setProtocolPropertyList(protocolPropertiesAggiornate);
                        save = true;
                        break;
                    }
                    if (!save) break;
                    this.core.performUpdateOperation(userLogin, smista, apca);
                    break;
                }
                case FRUITORE: {
                    Fruitore fruitore = (Fruitore)proprietario;
                    AccordoServizioParteSpecifica apsFrui = this.apsCore.getAccordoServizioParteSpecifica(fruitore.getIdServizio());
                    for (Fruitore fr : apsFrui.getFruitoreList()) {
                        if (!fr.getTipo().equals(fruitore.getTipo()) || !fr.getNome().equals(fruitore.getNome())) continue;
                        fr.setProtocolPropertyList(protocolPropertiesAggiornate);
                        save = true;
                        break;
                    }
                    if (!save) break;
                    this.core.performUpdateOperation(userLogin, smista, apsFrui);
                    break;
                }
                case OPERATION: {
                    Operation newAzionePt = (Operation)proprietario;
                    AccordoServizioParteComune apcop = this.apcCore.getAccordoServizioFull(idProp);
                    block16: for (PortType pt : apcop.getPortTypeList()) {
                        if (!pt.getNome().equals(nomeParentProprietario)) continue;
                        for (Operation azione : pt.getAzioneList()) {
                            if (!azione.getNome().equals(newAzionePt.getNome())) continue;
                            azione.setProtocolPropertyList(protocolPropertiesAggiornate);
                            save = true;
                            continue block16;
                        }
                    }
                    if (!save) break;
                    this.core.performUpdateOperation(userLogin, smista, apcop);
                    break;
                }
                case PORT_TYPE: {
                    AccordoServizioParteComune apc = this.apcCore.getAccordoServizioFull(idProp);
                    PortType newPt = (PortType)proprietario;
                    for (PortType pt : apc.getPortTypeList()) {
                        if (!pt.getNome().equals(newPt.getNome())) continue;
                        pt.setProtocolPropertyList(protocolPropertiesAggiornate);
                        save = true;
                        break;
                    }
                    if (!save) break;
                    this.core.performUpdateOperation(userLogin, smista, apc);
                    break;
                }
                case RESOURCE: {
                    Resource newResource = (Resource)proprietario;
                    AccordoServizioParteComune apcr = this.apcCore.getAccordoServizioFull(idProp);
                    for (Resource resource : apcr.getResourceList()) {
                        if (!resource.getNome().equals(newResource.getNome())) continue;
                        resource.setProtocolPropertyList(protocolPropertiesAggiornate);
                        save = true;
                        break;
                    }
                    if (!save) break;
                    this.core.performUpdateOperation(userLogin, smista, apcr);
                    break;
                }
                case SOGGETTO: {
                    Soggetto soggettoRegistro = (Soggetto)proprietario;
                    soggettoRegistro.setProtocolPropertyList(protocolPropertiesAggiornate);
                    this.core.performUpdateOperation(userLogin, smista, proprietario);
                    break;
                }
                case SERVIZIO_APPLICATIVO: {
                    throw new Exception("Con il TipoProprietario indicato (" + String.valueOf(tipoProprietario) + ") deve essere invocato il metodo 'salvaPropertiesRegistry'");
                }
            }
        }
    }

    public void salvaPropertiesConfig(String userLogin, boolean smista, Object proprietario, List<org.openspcoop2.core.config.ProtocolProperty> protocolPropertiesAggiornate, String id, String nome, String idProprietario, String nomeProprietario, String nomeParentProprietario, ProprietariProtocolProperty tipoProprietario, String tipoAccordo) throws Exception {
        if (proprietario != null) {
            int idProp = Integer.parseInt(idProprietario);
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: 
                case ACCORDO_SERVIZIO_PARTE_COMUNE: 
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                case AZIONE_ACCORDO: 
                case FRUITORE: 
                case OPERATION: 
                case PORT_TYPE: 
                case RESOURCE: 
                case SOGGETTO: {
                    throw new Exception("Con il TipoProprietario indicato (" + String.valueOf(tipoProprietario) + ") deve essere invocato il metodo 'salvaPropertiesRegistry'");
                }
                case SERVIZIO_APPLICATIVO: {
                    ServizioApplicativo servizioApplicativo = (ServizioApplicativo)proprietario;
                    servizioApplicativo.setProtocolPropertyList(protocolPropertiesAggiornate);
                    this.core.performUpdateOperation(userLogin, smista, proprietario);
                }
            }
        }
    }

    public void validateDynamicConfig(IConsoleDynamicConfiguration consoleDynamicConfiguration, Object idOggettoProprietario, String tipoAccordo, ProprietariProtocolProperty tipoProprietario, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties protocolProperties, IRegistryReader registryReader, IConfigIntegrationReader configRegistryReader) throws ProtocolException {
        block17: {
            if (idOggettoProprietario == null) break block17;
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: {
                    IDAccordo idAccordoCooperazione = (IDAccordo)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigCooperazione(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idAccordoCooperazione);
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    IDAccordo idApc = (IDAccordo)idOggettoProprietario;
                    if (tipoAccordo.equals("apc")) {
                        consoleDynamicConfiguration.validateDynamicConfigAccordoServizioParteComune(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idApc);
                        break;
                    }
                    consoleDynamicConfiguration.validateDynamicConfigAccordoServizioComposto(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idApc);
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    IDServizio idAps = (IDServizio)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idAps);
                    break;
                }
                case AZIONE_ACCORDO: {
                    IDAccordoAzione idAccordoAzione = (IDAccordoAzione)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigAzione(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idAccordoAzione);
                    break;
                }
                case FRUITORE: {
                    IDFruizione idFruizione = (IDFruizione)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idFruizione);
                    break;
                }
                case OPERATION: {
                    IDPortTypeAzione idAzionePt = (IDPortTypeAzione)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigOperation(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idAzionePt);
                    break;
                }
                case PORT_TYPE: {
                    IDPortType idPt = (IDPortType)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigPortType(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idPt);
                    break;
                }
                case RESOURCE: {
                    IDResource idAccordoRisorsa = (IDResource)idOggettoProprietario;
                    String httpMethod = null;
                    String path = null;
                    try {
                        Resource r = registryReader.getResourceAccordo(idAccordoRisorsa);
                        httpMethod = r.getMethod() != null ? r.getMethod().getValue() : null;
                        path = r.getPath();
                    }
                    catch (Exception r) {
                        // empty catch block
                    }
                    consoleDynamicConfiguration.validateDynamicConfigResource(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idAccordoRisorsa, httpMethod, path);
                    break;
                }
                case SOGGETTO: {
                    IDSoggetto idSoggetto = (IDSoggetto)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigSoggetto(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idSoggetto);
                    break;
                }
                case SERVIZIO_APPLICATIVO: {
                    IDServizioApplicativo idServizioApplicativo = (IDServizioApplicativo)idOggettoProprietario;
                    consoleDynamicConfiguration.validateDynamicConfigServizioApplicativo(consoleConfiguration, consoleOperationType, (IConsoleHelper)this, protocolProperties, registryReader, configRegistryReader, idServizioApplicativo);
                }
            }
        }
    }

    public List<Parameter> getTitolo(Object proprietario, ProprietariProtocolProperty tipoProprietario, String id, String nome, String idProprietario, String nomeProprietario, String nomeParentProprietario, String urlChange, String tipoAccordo) throws Exception {
        return this.getTitolo(proprietario, tipoProprietario, id, nome, idProprietario, nomeProprietario, nomeParentProprietario, urlChange, tipoAccordo, false);
    }

    public List<Parameter> getTitolo(Object proprietario, ProprietariProtocolProperty tipoProprietario, String id, String nome, String idProprietario, String nomeProprietario, String nomeParentProprietario, String urlChange, String tipoAccordo, boolean updateUrlChange) throws Exception {
        AccordiServizioParteComuneHelper apcHelper = null;
        AccordiServizioParteSpecificaHelper apsHelper = null;
        Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
        List<Parameter> lstParam = new ArrayList<Parameter>();
        String labelProprietario = nomeProprietario;
        String tipoProtocollo = null;
        IDAccordo idAccordoParteComune = null;
        String urlDecode = URLDecoder.decode(urlChange, "UTF-8");
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        if (tipologia != null && "fruizione".equals(tipologia)) {
            gestioneFruitori = true;
        }
        Parameter pTipoAccordo = new Parameter(AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getName(), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getValue());
        Parameter pIdApc = null;
        if (proprietario != null) {
            int idProp = Integer.parseInt(idProprietario);
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: {
                    AccordoCooperazione ac = (AccordoCooperazione)proprietario;
                    lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
                    labelProprietario = this.getLabelIdAccordoCooperazione(ac);
                    lstParam.add(new Parameter(labelProprietario, urlDecode));
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    apcHelper = new AccordiServizioParteComuneHelper(this.request, this.pd, this.session);
                    AccordoServizioParteComune as = (AccordoServizioParteComune)proprietario;
                    idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)as.getSoggettoReferente()), as.getVersione());
                    tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getSoggettoReferente().getTipo());
                    labelProprietario = this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune);
                    List parametriDaUrlAs = Parameter.estraiParametriDaUrl((String)urlDecode);
                    String parParz = null;
                    for (Parameter parameter : parametriDaUrlAs) {
                        if (!parameter.getName().equals("apiGestioneParziale")) continue;
                        parParz = parameter.getValue();
                        break;
                    }
                    lstParam = apcHelper.getTitoloApc(TipoOperazione.OTHER, as, tipoAccordo, labelProprietario, "accordiServizioParteComuneChange.do", parParz, true);
                    lstParam.get(lstParam.size() - 1).setValue(urlDecode);
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    apsHelper = new AccordiServizioParteSpecificaHelper(this.request, this.pd, this.session);
                    AccordoServizioParteSpecifica aps = (AccordoServizioParteSpecifica)proprietario;
                    List parametriDaUrlAps = Parameter.estraiParametriDaUrl((String)urlDecode);
                    String tipoSoggettoFruitore = null;
                    String nomeSoggettoFruitore = null;
                    for (Parameter parameter : parametriDaUrlAps) {
                        if (!parameter.getName().equals("tipoSoggFru")) continue;
                        tipoSoggettoFruitore = parameter.getValue();
                        break;
                    }
                    for (Parameter parameter : parametriDaUrlAps) {
                        if (!parameter.getName().equals("nomeSoggFru")) continue;
                        nomeSoggettoFruitore = parameter.getValue();
                        break;
                    }
                    tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(aps.getTipoSoggettoErogatore());
                    if (gestioneFruitori) {
                        IDSoggetto idSoggettoFruitore = null;
                        if (tipoSoggettoFruitore != null && !"".equals(tipoSoggettoFruitore) && nomeSoggettoFruitore != null && !"".equals(nomeSoggettoFruitore)) {
                            idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
                        }
                        labelProprietario = apsHelper.getLabelServizioFruizione(tipoProtocollo, idSoggettoFruitore, aps);
                    } else {
                        labelProprietario = apsHelper.getLabelServizioErogazione(tipoProtocollo, aps);
                    }
                    lstParam = apsHelper.getTitoloAps(TipoOperazione.OTHER, aps, gestioneFruitori, labelProprietario, "accordiServizioParteSpecificaChange.do", true, tipoSoggettoFruitore, nomeSoggettoFruitore);
                    lstParam.get(lstParam.size() - 1).setName("Profilo Interoperabilit\u00e0");
                    lstParam.get(lstParam.size() - 1).setValue(urlDecode);
                    break;
                }
                case AZIONE_ACCORDO: {
                    Azione newAzione = (Azione)proprietario;
                    AccordoServizioParteComune apca = this.apcCore.getAccordoServizioFull(idProp);
                    for (Azione azione : apca.getAzioneList()) {
                        if (!azione.getNome().equals(newAzione.getNome())) continue;
                        labelProprietario = azione.getNome();
                        break;
                    }
                    tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(apca.getSoggettoReferente().getTipo());
                    idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromValues(apca.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apca.getSoggettoReferente()), apca.getVersione());
                    pIdApc = new Parameter("id", "" + apca.getId());
                    lstParam.add(new Parameter(AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo), "accordiServizioParteComuneList.do", new Parameter[]{pTipoAccordo}));
                    lstParam.add(new Parameter("Azioni di " + this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune), "accordiServizioParteComuneAzioniList.do", new Parameter[]{pIdApc, pTipoAccordo}));
                    lstParam.add(new Parameter(labelProprietario, urlDecode));
                    break;
                }
                case FRUITORE: {
                    Integer parentPD;
                    Fruitore fruitore = (Fruitore)proprietario;
                    AccordoServizioParteSpecifica apsFrui = this.apsCore.getAccordoServizioParteSpecifica(fruitore.getIdServizio());
                    for (Fruitore fr : apsFrui.getFruitoreList()) {
                        if (!fr.getTipo().equals(fruitore.getTipo()) || !fr.getNome().equals(fruitore.getNome())) continue;
                        tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(fr.getTipo());
                        labelProprietario = this.getLabelNomeSoggetto(tipoProtocollo, fr.getTipo(), fr.getNome());
                        break;
                    }
                    if ((parentPD = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request)) == null) {
                        parentPD = 0;
                    }
                    PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
                    lstParam = porteDelegateHelper.getTitoloPD(2, "" + fruitore.getIdSoggetto(), "" + apsFrui.getId(), "" + fruitore.getId());
                    labelProprietario = "Profilo Interoperabilit\u00e0";
                    lstParam.set(lstParam.size() - 1, new Parameter(labelProprietario, urlDecode));
                    break;
                }
                case OPERATION: {
                    apcHelper = new AccordiServizioParteComuneHelper(this.request, this.pd, this.session);
                    Operation newAzionePt = (Operation)proprietario;
                    AccordoServizioParteComune apcop = this.apcCore.getAccordoServizioFull(idProp);
                    block19: for (PortType pt : apcop.getPortTypeList()) {
                        if (!pt.getNome().equals(nomeParentProprietario)) continue;
                        for (Operation azione : pt.getAzioneList()) {
                            if (!azione.getNome().equals(newAzionePt.getNome())) continue;
                            labelProprietario = azione.getNome();
                            continue block19;
                        }
                    }
                    tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(apcop.getSoggettoReferente().getTipo());
                    idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromValues(apcop.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apcop.getSoggettoReferente()), apcop.getVersione());
                    pIdApc = new Parameter("id", "" + apcop.getId());
                    Parameter pNomePt = new Parameter("nomept", nomeParentProprietario);
                    lstParam = apcHelper.getTitoloApc(TipoOperazione.OTHER, apcop, tipoAccordo, this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune), null, false);
                    String labelPortTypesOp = isModalitaVistaApiCustom != false ? "Servizi" : "Servizi di " + this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune);
                    lstParam.add(new Parameter(labelPortTypesOp, "accordiServizioParteComunePortTypesList.do", new Parameter[]{pIdApc, pTipoAccordo}));
                    lstParam.add(new Parameter("Azioni di " + nomeParentProprietario, "accordiServizioParteComunePortTypeOperationsList.do", new Parameter[]{pIdApc, pNomePt, pTipoAccordo}));
                    lstParam.add(new Parameter(labelProprietario, urlDecode));
                    break;
                }
                case PORT_TYPE: {
                    apcHelper = new AccordiServizioParteComuneHelper(this.request, this.pd, this.session);
                    AccordoServizioParteComune apc = this.apcCore.getAccordoServizioFull(idProp);
                    PortType newPt = (PortType)proprietario;
                    for (PortType pt : apc.getPortTypeList()) {
                        if (!pt.getNome().equals(newPt.getNome())) continue;
                        labelProprietario = pt.getNome();
                        break;
                    }
                    pIdApc = new Parameter("id", "" + apc.getId());
                    idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromValues(apc.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apc.getSoggettoReferente()), apc.getVersione());
                    tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(apc.getSoggettoReferente().getTipo());
                    lstParam = apcHelper.getTitoloApc(TipoOperazione.OTHER, apc, tipoAccordo, this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune), null, false);
                    String labelPortTypes = isModalitaVistaApiCustom != false ? "Servizi" : "Servizi di " + this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune);
                    lstParam.add(new Parameter(labelPortTypes, "accordiServizioParteComunePortTypesList.do", new Parameter[]{pIdApc, pTipoAccordo}));
                    lstParam.add(new Parameter(labelProprietario, urlDecode));
                    break;
                }
                case RESOURCE: {
                    apcHelper = new AccordiServizioParteComuneHelper(this.request, this.pd, this.session);
                    Resource newResource = (Resource)proprietario;
                    AccordoServizioParteComune apcr = this.apcCore.getAccordoServizioFull(idProp);
                    Long idRs = newResource.getId();
                    for (Resource resource : apcr.getResourceList()) {
                        if (!resource.getNome().equals(newResource.getNome())) continue;
                        labelProprietario = resource.getNome();
                        idRs = resource.getId();
                        break;
                    }
                    Parameter pLabelProprietario = new Parameter(labelProprietario, urlDecode);
                    if (updateUrlChange) {
                        List parametriDaUrl = Parameter.estraiParametriDaUrl((String)urlDecode);
                        String pathDaUrl = Parameter.estraiPathDaUrl((String)urlDecode);
                        for (Parameter parameter : parametriDaUrl) {
                            if (!parameter.getName().equals("idRs")) continue;
                            parameter.setValue("" + idRs);
                            break;
                        }
                        pLabelProprietario = new Parameter(labelProprietario, pathDaUrl, parametriDaUrl);
                    }
                    tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(apcr.getSoggettoReferente().getTipo());
                    idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromValues(apcr.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)apcr.getSoggettoReferente()), apcr.getVersione());
                    pIdApc = new Parameter("id", "" + apcr.getId());
                    lstParam = apcHelper.getTitoloApc(TipoOperazione.OTHER, apcr, tipoAccordo, this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune), null, false);
                    String labelRisorse = isModalitaVistaApiCustom != false ? "Risorse" : "Risorse di " + this.getLabelIdAccordo(tipoProtocollo, idAccordoParteComune);
                    lstParam.add(new Parameter(labelRisorse, "accordiServizioParteComuneResourcesList.do", new Parameter[]{pIdApc, pTipoAccordo}));
                    lstParam.add(pLabelProprietario);
                    break;
                }
                case SOGGETTO: {
                    Soggetto soggettoRegistro = (Soggetto)proprietario;
                    lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
                    tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggettoRegistro.getTipo());
                    labelProprietario = this.getLabelNomeSoggetto(tipoProtocollo, soggettoRegistro.getTipo(), soggettoRegistro.getNome());
                    lstParam.add(new Parameter(labelProprietario, urlDecode));
                    break;
                }
                case SERVIZIO_APPLICATIVO: {
                    ServizioApplicativo servizioApplicativo = (ServizioApplicativo)proprietario;
                    Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
                    if (parentSA == null) {
                        parentSA = 0;
                    }
                    Boolean useIdSogg = parentSA == 1;
                    String labelApplicativi = "Servizi Applicativi";
                    String labelApplicativiDi = "Servizi Applicativi di ";
                    if (!this.isModalitaCompleta()) {
                        labelApplicativi = "Applicativi";
                        labelApplicativiDi = "Applicativi di ";
                    }
                    if (useIdSogg.booleanValue()) {
                        tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(servizioApplicativo.getTipoSoggettoProprietario());
                        String tipoENomeSoggetto = this.getLabelNomeSoggetto(tipoProtocollo, servizioApplicativo.getTipoSoggettoProprietario(), servizioApplicativo.getNomeSoggettoProprietario());
                        lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
                        lstParam.add(new Parameter(labelApplicativiDi + tipoENomeSoggetto, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", "" + servizioApplicativo.getIdSoggetto())}));
                        lstParam.add(new Parameter(nome, urlDecode));
                        break;
                    }
                    lstParam.add(new Parameter(labelApplicativi, "serviziApplicativiList.do"));
                    lstParam.add(new Parameter(servizioApplicativo.getNome(), urlDecode));
                }
            }
        }
        return lstParam;
    }
}

