/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.scope;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCore;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeHelper;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeUtilities;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ScopeChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ScopeHelper scopeHelper = new ScopeHelper(request, pd, session);
            scopeHelper.makeMenu();
            String id = scopeHelper.getParametroLong("scopeId");
            long scopeId = Long.parseLong(id);
            String nome = scopeHelper.getParameter("scopeNome");
            String descrizione = scopeHelper.getParameter("scopeDescrizione");
            String tipologia = scopeHelper.getParameter("scopeTipologia");
            String nomeEsterno = scopeHelper.getParameter("scopeNomeEsterno");
            String contesto = scopeHelper.getParameter("scopeContesto");
            String resetElementoCacheS = scopeHelper.getParametroBoolean("rmElFromCache");
            boolean resetElementoCache = ServletUtils.isCheckBoxEnabled((String)resetElementoCacheS);
            ScopeCore scopeCore = new ScopeCore();
            Scope scope = scopeCore.getScope(scopeId);
            if (resetElementoCache) {
                List<String> aliases = scopeCore.getJmxPdDAliases();
                String alias = null;
                if (aliases != null && !aliases.isEmpty()) {
                    alias = aliases.get(0);
                }
                String labelScope = scope.getNome();
                scopeCore.invokeJmxMethodAllNodesAndSetResult(pd, scopeCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), scopeCore.getJmxPdDConfigurazioneSistemaNomeMetodoRipulisciRiferimentiCacheScope(alias), MessageFormat.format("{0} eliminato dalla cache", labelScope), MessageFormat.format("Eliminazione {0} dalla cache non riuscita: ", labelScope), scope.getId());
                String resetFromLista = scopeHelper.getParameter("resetFromLista");
                boolean arrivoDaLista = "true".equalsIgnoreCase(resetFromLista);
                if (arrivoDaLista) {
                    ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                    int idLista = Liste.SCOPE;
                    List<Scope> lista = null;
                    if (!ServletUtils.isSearchDone((IConsoleHelper)scopeHelper)) {
                        lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, Scope.class);
                    }
                    ricerca = scopeHelper.checkSearchParameters(idLista, ricerca);
                    scopeHelper.clearFiltroSoggettoByPostBackProtocollo(ScopeHelper.POSIZIONE_FILTRO_PROTOCOLLO, (ISearch)ricerca, idLista);
                    if (lista == null) {
                        boolean filtroSoggetto = false;
                        List<String> protocolli = scopeCore.getProtocolli(request, session, false);
                        if (protocolli != null && protocolli.size() == 1) {
                            filtroSoggetto = true;
                        }
                        if (filtroSoggetto) {
                            ricerca.addFilter(idLista, "filtroSoggetto", scopeHelper.getSoggettoMultitenantSelezionato());
                        }
                        lista = scopeCore.isVisioneOggettiGlobale(userLogin) ? scopeCore.scopeList(null, (ISearch)ricerca) : scopeCore.scopeList(userLogin, (ISearch)ricerca);
                    }
                    if (!scopeHelper.isPostBackFilterElement()) {
                        ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
                    }
                    scopeHelper.prepareScopeList((ISearch)ricerca, lista);
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.CHANGE());
                }
            }
            if (scopeHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitleServletChange((PageData)pd, (String)"Scope", (String)"scopeList.do", (String)scope.getNome());
                if (nome == null) {
                    nome = scope.getNome();
                }
                if (descrizione == null) {
                    descrizione = scope.getDescrizione();
                }
                if (tipologia == null) {
                    tipologia = scope.getTipologia();
                    nomeEsterno = scope.getNomeEsterno();
                }
                if (contesto == null) {
                    contesto = scope.getContestoUtilizzo().getValue();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = scopeHelper.addScopeToDati(TipoOperazione.CHANGE, scopeId, nome, descrizione, tipologia, nomeEsterno, contesto, dati, scope.getNome());
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = scopeHelper.scopeCheckData(TipoOperazione.CHANGE, scope);
            if (!isOk) {
                ServletUtils.setPageDataTitleServletChange((PageData)pd, (String)"Scope", (String)"scopeList.do", (String)scope.getNome());
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = scopeHelper.addScopeToDati(TipoOperazione.CHANGE, scopeId, nome, descrizione, tipologia, nomeEsterno, contesto, dati, scope.getNome());
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.CHANGE());
            }
            Scope scopeNEW = new Scope();
            scopeNEW.setNome(nome);
            scopeNEW.setDescrizione(descrizione);
            scopeNEW.setTipologia(tipologia);
            String n = nomeEsterno;
            if (n != null) {
                n = n.trim();
            }
            scopeNEW.setNomeEsterno(n);
            scopeNEW.setContestoUtilizzo(ScopeContesto.toEnumConstant((String)contesto, (boolean)true));
            scopeNEW.setSuperUser(userLogin);
            scopeNEW.setOldIDScopeForUpdate(new IDScope(nome));
            ArrayList<Object> listOggettiDaAggiornare = new ArrayList<Object>();
            listOggettiDaAggiornare.add(scopeNEW);
            if (!scope.getNome().equals(nome)) {
                IDScope oldIdScope = scopeNEW.getOldIDScopeForUpdate();
                oldIdScope.setNome(scope.getNome());
                ScopeUtilities.findOggettiDaAggiornare(oldIdScope, scopeNEW, scopeCore, listOggettiDaAggiornare);
            }
            scopeCore.performUpdateOperation(userLogin, scopeHelper.smista(), listOggettiDaAggiornare.toArray());
            if (!scope.getNome().equals(nome)) {
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.SCOPE);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Scope> lista = null;
            lista = scopeCore.isVisioneOggettiGlobale(userLogin) ? scopeCore.scopeList(null, (ISearch)ricerca) : scopeCore.scopeList(userLogin, (ISearch)ricerca);
            scopeHelper.prepareScopeList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

