/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaDelegataSoggettoErogatore;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaSoggetto;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;

public class SoggettoUpdateUtilities {
    private static final String REGEXP_FRUITORE_EROGATORE_OTHER = ".*\\/.*\\/.*";
    private static final String REGEXP_FRUITORE_EROGATORE_OTHER_MATCH = "(.*)\\/(.*)\\/(.*)";
    private static final String PATTERN_AZIONE_PREFIX_OLD = ".*/";
    private static final String PATTERN_AZIONE_SUFFIX_OLD = "/([^/|^?]*).*";
    private static final String PATTERN_AZIONE_PREFIX_NEW = "/";
    private static final String PATTERN_AZIONE_SUFFIX_NEW = "/([^/?]*).*";
    List<Object> oggettiDaAggiornare = null;
    private SoggettiCore soggettiCore;
    private ServiziApplicativiCore saCore;
    private AccordiServizioParteComuneCore apcCore;
    private AccordiServizioParteSpecificaCore apsCore;
    private PorteDelegateCore porteDelegateCore;
    private PorteApplicativeCore porteApplicativeCore;
    private AccordiCooperazioneCore acCore;
    private ConfigurazioneCore confCore;
    private SoggettoCtrlStat sog;
    private String oldnomeprov;
    private String nomeprov;
    private String oldtipoprov;
    private String tipoprov;
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private List<AccordoServizioParteSpecifica> accordiServizioParteSpecifica = null;

    public SoggettoUpdateUtilities(SoggettiCore soggettiCore, String oldnomeprov, String nomeprov, String oldtipoprov, String tipoprov, SoggettoCtrlStat sog) throws Exception {
        this.oggettiDaAggiornare = new ArrayList<Object>();
        this.soggettiCore = soggettiCore;
        this.saCore = new ServiziApplicativiCore(this.soggettiCore);
        this.apcCore = new AccordiServizioParteComuneCore(this.soggettiCore);
        this.apsCore = new AccordiServizioParteSpecificaCore(this.soggettiCore);
        this.porteDelegateCore = new PorteDelegateCore(this.soggettiCore);
        this.porteApplicativeCore = new PorteApplicativeCore(this.soggettiCore);
        this.acCore = new AccordiCooperazioneCore(this.soggettiCore);
        this.confCore = new ConfigurazioneCore(this.soggettiCore);
        this.oldnomeprov = oldnomeprov;
        this.nomeprov = nomeprov;
        this.oldtipoprov = oldtipoprov;
        this.tipoprov = tipoprov;
        this.sog = sog;
    }

    public List<Object> getOggettiDaAggiornare() {
        return this.oggettiDaAggiornare;
    }

    public void addSoggetto() {
        this.oggettiDaAggiornare.add(this.sog);
    }

    public void checkServiziApplicativi() throws DriverConfigurazioneException {
        if (!this.oldnomeprov.equals(this.nomeprov) || !this.oldtipoprov.equals(this.tipoprov)) {
            ArrayList<String> nomeListSA = new ArrayList<String>();
            ArrayList<ServizioApplicativo> listSA = new ArrayList<ServizioApplicativo>();
            List<IDServizioApplicativoDB> tmpListIDSA = this.saCore.getIdServiziApplicativiWithIdErogatore(this.sog.getId());
            for (IDServizioApplicativoDB idServizioApplicativo : tmpListIDSA) {
                if (nomeListSA.contains(idServizioApplicativo.getNome())) continue;
                nomeListSA.add(idServizioApplicativo.getNome());
                ServizioApplicativo servizioApplicativo = this.saCore.getServizioApplicativo((IDServizioApplicativo)idServizioApplicativo);
                servizioApplicativo.setTipoSoggettoProprietario(this.tipoprov);
                servizioApplicativo.setNomeSoggettoProprietario(this.nomeprov);
                IDServizioApplicativo oldIDServizioApplicativoForUpdate = new IDServizioApplicativo();
                oldIDServizioApplicativoForUpdate.setNome(servizioApplicativo.getNome());
                oldIDServizioApplicativoForUpdate.setIdSoggettoProprietario(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
                servizioApplicativo.setOldIDServizioApplicativoForUpdate(oldIDServizioApplicativoForUpdate);
                listSA.add(servizioApplicativo);
            }
            for (ServizioApplicativo sa : listSA) {
                this.oggettiDaAggiornare.add(sa);
            }
        }
    }

    public void checkAccordiCooperazione() throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (!(!this.soggettiCore.isRegistroServiziLocale() || this.oldnomeprov.equals(this.nomeprov) && this.oldtipoprov.equals(this.tipoprov))) {
            FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
            filtroRicercaAccordi.setTipoSoggettoReferente(this.oldtipoprov);
            filtroRicercaAccordi.setNomeSoggettoReferente(this.oldnomeprov);
            List<IDAccordoCooperazione> idAccordiCooperazione = null;
            try {
                idAccordiCooperazione = this.acCore.getAllIdAccordiCooperazione(filtroRicercaAccordi);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (idAccordiCooperazione != null) {
                for (int i = 0; i < idAccordiCooperazione.size(); ++i) {
                    AccordoCooperazione ac = this.acCore.getAccordoCooperazione(idAccordiCooperazione.get(i));
                    ac.getSoggettoReferente().setTipo(this.tipoprov);
                    ac.getSoggettoReferente().setNome(this.nomeprov);
                    if (ac.getElencoPartecipanti() != null) {
                        AccordoCooperazionePartecipanti partecipanti = ac.getElencoPartecipanti();
                        for (int j = 0; j < partecipanti.sizeSoggettoPartecipanteList(); ++j) {
                            if (!partecipanti.getSoggettoPartecipante(j).getTipo().equals(this.oldtipoprov) || !partecipanti.getSoggettoPartecipante(j).getNome().equals(this.oldnomeprov)) continue;
                            partecipanti.getSoggettoPartecipante(j).setTipo(this.tipoprov);
                            partecipanti.getSoggettoPartecipante(j).setNome(this.nomeprov);
                        }
                    }
                    this.oggettiDaAggiornare.add(ac);
                }
            }
            List<AccordoCooperazione> acs = this.acCore.accordiCoopWithSoggettoPartecipante(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
            for (int i = 0; i < acs.size(); ++i) {
                AccordoCooperazione ac = acs.get(i);
                boolean find = false;
                if (idAccordiCooperazione != null) {
                    for (int j = 0; j < idAccordiCooperazione.size(); ++j) {
                        if (!this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordiCooperazione.get(j)).equals(this.idAccordoCooperazioneFactory.getUriFromAccordo(ac))) continue;
                        find = true;
                        break;
                    }
                }
                if (find) continue;
                if (ac.getElencoPartecipanti() != null) {
                    AccordoCooperazionePartecipanti partecipanti = ac.getElencoPartecipanti();
                    for (int j = 0; j < partecipanti.sizeSoggettoPartecipanteList(); ++j) {
                        if (!partecipanti.getSoggettoPartecipante(j).getTipo().equals(this.oldtipoprov) || !partecipanti.getSoggettoPartecipante(j).getNome().equals(this.oldnomeprov)) continue;
                        partecipanti.getSoggettoPartecipante(j).setTipo(this.tipoprov);
                        partecipanti.getSoggettoPartecipante(j).setNome(this.nomeprov);
                    }
                }
                this.oggettiDaAggiornare.add(ac);
            }
        }
    }

    public void checkAccordiServizioParteComune() throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (!(!this.soggettiCore.isRegistroServiziLocale() || this.oldnomeprov.equals(this.nomeprov) && this.oldtipoprov.equals(this.tipoprov))) {
            FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
            filtroRicercaAccordi.setTipoSoggettoReferente(this.oldtipoprov);
            filtroRicercaAccordi.setNomeSoggettoReferente(this.oldnomeprov);
            List<IDAccordo> idAccordoServizio = null;
            try {
                idAccordoServizio = this.apcCore.getAllIdAccordiServizio(filtroRicercaAccordi);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (idAccordoServizio != null) {
                for (int i = 0; i < idAccordoServizio.size(); ++i) {
                    AccordoServizioParteComune as = this.apcCore.getAccordoServizioFull(idAccordoServizio.get(i));
                    as.getSoggettoReferente().setTipo(this.tipoprov);
                    as.getSoggettoReferente().setNome(this.nomeprov);
                    IDAccordo idAccordoOLD = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), this.oldtipoprov, this.oldnomeprov, as.getVersione());
                    as.setOldIDAccordoForUpdate(idAccordoOLD);
                    this.oggettiDaAggiornare.add(as);
                }
            }
            List<AccordoServizioParteComune> ass = this.apcCore.accordiServizioServiziComponentiConSoggettoErogatore(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
            for (int i = 0; i < ass.size(); ++i) {
                int j;
                AccordoServizioParteComune as = ass.get(i);
                boolean find = false;
                if (idAccordoServizio != null) {
                    for (j = 0; j < idAccordoServizio.size(); ++j) {
                        if (!this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizio.get(j)).equals(IDAccordoFactory.getInstance().getUriFromAccordo(as))) continue;
                        find = true;
                        break;
                    }
                }
                if (find || as.getServizioComposto() == null) continue;
                for (j = 0; j < as.getServizioComposto().sizeServizioComponenteList(); ++j) {
                    if (!as.getServizioComposto().getServizioComponente(j).getTipoSoggetto().equals(this.oldtipoprov) || !as.getServizioComposto().getServizioComponente(j).getNomeSoggetto().equals(this.oldnomeprov)) continue;
                    as.getServizioComposto().getServizioComponente(j).setTipoSoggetto(this.tipoprov);
                    as.getServizioComposto().getServizioComponente(j).setNomeSoggetto(this.nomeprov);
                }
                if (as.getSoggettoReferente() != null && this.oldtipoprov.equals(as.getSoggettoReferente().getTipo()) && this.oldnomeprov.equals(as.getSoggettoReferente().getNome())) {
                    as.getSoggettoReferente().setTipo(this.tipoprov);
                    as.getSoggettoReferente().setNome(this.nomeprov);
                    IDAccordo idAccordoOLD = IDAccordoFactory.getInstance().getIDAccordoFromValues(as.getNome(), this.oldtipoprov, this.oldnomeprov, as.getVersione());
                    as.setOldIDAccordoForUpdate(idAccordoOLD);
                }
                this.oggettiDaAggiornare.add(as);
            }
        }
    }

    public void checkAccordiServizioParteSpecifica() throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.accordiServizioParteSpecifica = new ArrayList<AccordoServizioParteSpecifica>();
        if (!this.oldnomeprov.equals(this.nomeprov) || !this.oldtipoprov.equals(this.tipoprov)) {
            FiltroRicercaServizi filtroRicercaServizi = new FiltroRicercaServizi();
            filtroRicercaServizi.setTipoSoggettoErogatore(this.oldtipoprov);
            filtroRicercaServizi.setNomeSoggettoErogatore(this.oldnomeprov);
            List<IDServizio> idServizio = null;
            try {
                idServizio = this.apsCore.getAllIdServizi(filtroRicercaServizi);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (idServizio != null) {
                for (int i = 0; i < idServizio.size(); ++i) {
                    AccordoServizioParteSpecifica asps = this.apsCore.getServizio(idServizio.get(i));
                    asps.setTipoSoggettoErogatore(this.tipoprov);
                    asps.setNomeSoggettoErogatore(this.nomeprov);
                    IDServizio oldIDServizioForUpdate = IDServizioFactory.getInstance().getIDServizioFromValues(asps.getTipo(), asps.getNome(), new IDSoggetto(this.oldtipoprov, this.oldnomeprov), asps.getVersione().intValue());
                    asps.setOldIDServizioForUpdate(oldIDServizioForUpdate);
                    IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                    if (idAccordo.getSoggettoReferente() != null && idAccordo.getSoggettoReferente().getTipo().equals(this.oldtipoprov) && idAccordo.getSoggettoReferente().getNome().equals(this.oldnomeprov)) {
                        idAccordo.getSoggettoReferente().setTipo(this.tipoprov);
                        idAccordo.getSoggettoReferente().setNome(this.nomeprov);
                        asps.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromIDAccordo(idAccordo));
                    }
                    for (int j = 0; j < asps.sizeFruitoreList(); ++j) {
                        if (!asps.getFruitore(j).getTipo().equals(this.oldtipoprov) || !asps.getFruitore(j).getNome().equals(this.oldnomeprov)) continue;
                        asps.getFruitore(j).setTipo(this.tipoprov);
                        asps.getFruitore(j).setNome(this.nomeprov);
                    }
                    if (this.soggettiCore.isRegistroServiziLocale()) {
                        this.oggettiDaAggiornare.add(asps);
                    }
                    this.accordiServizioParteSpecifica.add(asps);
                }
            }
        }
    }

    public void checkPorteDelegate() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        List<AttivazionePolicy> listaPolicies;
        HashMap<Long, PortaDelegata> listaPD = new HashMap<Long, PortaDelegata>();
        if (!this.oldnomeprov.equals(this.nomeprov) || !this.oldtipoprov.equals(this.tipoprov)) {
            IDPortaDelegata oldIDPortaDelegataForUpdate;
            ArrayList<PortaDelegata> list = new ArrayList<PortaDelegata>();
            FiltroRicercaPorteDelegate filtroRicerca = new FiltroRicercaPorteDelegate();
            filtroRicerca.setTipoSoggetto(this.oldtipoprov);
            filtroRicerca.setNomeSoggetto(this.oldnomeprov);
            List<IDPortaDelegata> listID = this.porteDelegateCore.getAllIdPorteDelegate(filtroRicerca);
            if (listID != null && !listID.isEmpty()) {
                for (IDPortaDelegata iDPortaDelegata : listID) {
                    list.add(this.porteDelegateCore.getPortaDelegata(iDPortaDelegata));
                }
            }
            filtroRicerca = new FiltroRicercaPorteDelegate();
            filtroRicerca.setTipoSoggettoErogatore(this.oldtipoprov);
            filtroRicerca.setNomeSoggettoErogatore(this.oldnomeprov);
            listID = this.porteDelegateCore.getAllIdPorteDelegate(filtroRicerca);
            if (listID != null && !listID.isEmpty()) {
                for (IDPortaDelegata iDPortaDelegata : listID) {
                    list.add(this.porteDelegateCore.getPortaDelegata(iDPortaDelegata));
                }
            }
            if (list != null && !list.isEmpty()) {
                ArrayList<CallSite> checkUnique = new ArrayList<CallSite>();
                for (PortaDelegata portaDelegata : list) {
                    String regex;
                    String nomeAttuale;
                    if (checkUnique.contains("" + portaDelegata.getId())) continue;
                    boolean modificatoNome = true;
                    boolean soggettoProprietarioCombaciaSoggettoInModifica = false;
                    String tipoNomeSoggettoFruitore = portaDelegata.getTipoSoggettoProprietario() + "_" + portaDelegata.getNomeSoggettoProprietario();
                    if (tipoNomeSoggettoFruitore.equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                        soggettoProprietarioCombaciaSoggettoInModifica = true;
                        portaDelegata.setTipoSoggettoProprietario(this.tipoprov);
                        portaDelegata.setNomeSoggettoProprietario(this.nomeprov);
                    }
                    if ((nomeAttuale = portaDelegata.getNome()).matches(regex = REGEXP_FRUITORE_EROGATORE_OTHER)) {
                        String tipoNomeSoggettoErogatore;
                        String[] tmp = nomeAttuale.split("\\/");
                        Object partFruitore = tmp[0];
                        Object partErogatore = tmp[1];
                        String rimanente = "";
                        int lengthParteRimanente = ((String)partFruitore + PATTERN_AZIONE_PREFIX_NEW + (String)partErogatore).length();
                        if (nomeAttuale.length() > lengthParteRimanente) {
                            rimanente = nomeAttuale.substring(lengthParteRimanente);
                        }
                        if (tipoNomeSoggettoFruitore.equals(partFruitore)) {
                            if (tipoNomeSoggettoFruitore.equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                                partFruitore = this.tipoprov + "_" + this.nomeprov;
                                modificatoNome = true;
                            }
                        } else if (("__" + tipoNomeSoggettoFruitore).equals(partFruitore) && tipoNomeSoggettoFruitore.equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                            partFruitore = "__" + this.tipoprov + "_" + this.nomeprov;
                            modificatoNome = true;
                        }
                        if (portaDelegata.getSoggettoErogatore() != null && portaDelegata.getSoggettoErogatore().getTipo() != null && !"".equals(portaDelegata.getSoggettoErogatore().getTipo()) && portaDelegata.getSoggettoErogatore().getNome() != null && !"".equals(portaDelegata.getSoggettoErogatore().getNome()) && (tipoNomeSoggettoErogatore = portaDelegata.getSoggettoErogatore().getTipo() + "_" + portaDelegata.getSoggettoErogatore().getNome()).equals(partErogatore) && tipoNomeSoggettoErogatore.equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                            partErogatore = this.tipoprov + "_" + this.nomeprov;
                            portaDelegata.getSoggettoErogatore().setTipo(this.tipoprov);
                            portaDelegata.getSoggettoErogatore().setNome(this.nomeprov);
                            modificatoNome = true;
                        }
                        if (modificatoNome) {
                            String regexDelegante;
                            PortaDelegataAzione pdAzione;
                            String nuovoNome = (String)partFruitore + PATTERN_AZIONE_PREFIX_NEW + (String)partErogatore + rimanente;
                            oldIDPortaDelegataForUpdate = new IDPortaDelegata();
                            oldIDPortaDelegataForUpdate.setNome(nomeAttuale);
                            portaDelegata.setOldIDPortaDelegataForUpdate(oldIDPortaDelegataForUpdate);
                            portaDelegata.setNome(nuovoNome);
                            String descrizionePD = portaDelegata.getDescrizione();
                            if (descrizionePD != null && !descrizionePD.equals("")) {
                                String matchCaso2testErogatore;
                                String matchCaso2testMittente;
                                String matchCaso1testService;
                                String matchCaso1testFrom = " " + this.oldtipoprov + PATTERN_AZIONE_PREFIX_NEW + this.oldnomeprov + " ";
                                if (descrizionePD.contains(matchCaso1testFrom)) {
                                    String replaceCaso1testFrom = " " + this.tipoprov + PATTERN_AZIONE_PREFIX_NEW + this.nomeprov + " ";
                                    descrizionePD = descrizionePD.replace(matchCaso1testFrom, replaceCaso1testFrom);
                                }
                                if (descrizionePD.contains(matchCaso1testService = " " + this.oldtipoprov + PATTERN_AZIONE_PREFIX_NEW + this.oldnomeprov + ":")) {
                                    String replaceCaso1testService = " " + this.tipoprov + PATTERN_AZIONE_PREFIX_NEW + this.nomeprov + ":";
                                    descrizionePD = descrizionePD.replace(matchCaso1testService, replaceCaso1testService);
                                }
                                if (descrizionePD.contains(matchCaso2testMittente = " " + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW)) {
                                    String replaceCaso2testMittente = " " + this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW;
                                    descrizionePD = descrizionePD.replace(matchCaso2testMittente, replaceCaso2testMittente);
                                }
                                if (descrizionePD.contains(matchCaso2testErogatore = PATTERN_AZIONE_PREFIX_NEW + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW)) {
                                    String replaceCaso2testErogatore = PATTERN_AZIONE_PREFIX_NEW + this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW;
                                    descrizionePD = descrizionePD.replace(matchCaso2testErogatore, replaceCaso2testErogatore);
                                }
                                portaDelegata.setDescrizione(descrizionePD);
                            }
                            PortaDelegataAzioneIdentificazione identificazione = (pdAzione = portaDelegata.getAzione()) != null ? pdAzione.getIdentificazione() : null;
                            String patterAzione = "";
                            if (pdAzione != null) {
                                patterAzione = pdAzione.getPattern() != null ? pdAzione.getPattern() : "";
                            }
                            String patternAzionePrefixOld = PATTERN_AZIONE_PREFIX_OLD;
                            String patternAzioneSuffix1Old = PATTERN_AZIONE_SUFFIX_OLD;
                            String patternAzionePrefixNew = PATTERN_AZIONE_PREFIX_NEW;
                            String patternAzioneSuffix1New = PATTERN_AZIONE_SUFFIX_NEW;
                            if (PortaDelegataAzioneIdentificazione.URL_BASED.equals((Object)identificazione)) {
                                int endidx;
                                int startidx;
                                String tmpPat;
                                boolean newPattern;
                                boolean oldPattern = patterAzione.startsWith(patternAzionePrefixOld) && patterAzione.endsWith(patternAzioneSuffix1Old);
                                boolean bl = newPattern = patterAzione.startsWith(patternAzionePrefixNew) && patterAzione.endsWith(patternAzioneSuffix1New);
                                if ((oldPattern || newPattern) && (tmpPat = patterAzione.substring(startidx = oldPattern ? patternAzionePrefixOld.length() : patternAzionePrefixNew.length(), endidx = oldPattern ? patterAzione.lastIndexOf(patternAzioneSuffix1Old) : patterAzione.lastIndexOf(patternAzioneSuffix1New))).matches(regex)) {
                                    String[] val = tmpPat.split(PATTERN_AZIONE_PREFIX_NEW);
                                    Object fruitore = val[0];
                                    Object erogatore = val[1];
                                    String rimanenteRegExp = "";
                                    int lengthParteRimanenteRegExp = ((String)fruitore + PATTERN_AZIONE_PREFIX_NEW + (String)erogatore).length();
                                    if (tmpPat.length() > lengthParteRimanenteRegExp) {
                                        rimanenteRegExp = tmpPat.substring(lengthParteRimanenteRegExp);
                                    }
                                    boolean match = false;
                                    String partOld = "(?:" + this.oldtipoprov + "_)?" + this.oldnomeprov;
                                    String partNew = "(?:" + this.tipoprov + "_)?" + this.nomeprov;
                                    if (((String)fruitore).equals(partOld)) {
                                        fruitore = partNew;
                                        match = true;
                                    }
                                    if (((String)erogatore).equals(partOld)) {
                                        erogatore = partNew;
                                        match = true;
                                    }
                                    if (match) {
                                        String newPatternAzione = patternAzionePrefixNew + (String)fruitore + PATTERN_AZIONE_PREFIX_NEW + (String)erogatore + rimanenteRegExp + patternAzioneSuffix1New;
                                        pdAzione.setPattern(newPatternAzione);
                                        portaDelegata.setAzione(pdAzione);
                                    }
                                }
                            }
                            String nomePortaDelegante = null;
                            if (pdAzione != null) {
                                String string = nomePortaDelegante = pdAzione.getNomePortaDelegante() != null ? pdAzione.getNomePortaDelegante() : null;
                            }
                            if (PortaDelegataAzioneIdentificazione.DELEGATED_BY.equals((Object)identificazione) && nomePortaDelegante != null && nomePortaDelegante.matches(regexDelegante = REGEXP_FRUITORE_EROGATORE_OTHER)) {
                                String[] tmpDelegante = nomePortaDelegante.split("\\/");
                                Object partFruitoreDelegante = tmpDelegante[0];
                                Object partErogatoreDelegante = tmpDelegante[1];
                                String rimanenteDelegante = "";
                                int lengthParteRimanenteDelegante = ((String)partFruitoreDelegante + PATTERN_AZIONE_PREFIX_NEW + (String)partErogatoreDelegante).length();
                                if (nomePortaDelegante.length() > lengthParteRimanenteDelegante) {
                                    rimanenteDelegante = nomePortaDelegante.substring(lengthParteRimanenteDelegante);
                                }
                                boolean modificatoNomeDelegante = false;
                                if (tipoNomeSoggettoFruitore.equals(partFruitoreDelegante)) {
                                    if (tipoNomeSoggettoFruitore.equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                                        partFruitoreDelegante = this.tipoprov + "_" + this.nomeprov;
                                        modificatoNomeDelegante = true;
                                    }
                                } else if (("__" + tipoNomeSoggettoFruitore).equals(partFruitoreDelegante) && tipoNomeSoggettoFruitore.equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                                    partFruitoreDelegante = "__" + this.tipoprov + "_" + this.nomeprov;
                                    modificatoNomeDelegante = true;
                                }
                                if (partErogatoreDelegante != null && ((String)partErogatoreDelegante).equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                                    partErogatoreDelegante = this.tipoprov + "_" + this.nomeprov;
                                    modificatoNomeDelegante = true;
                                }
                                if (modificatoNomeDelegante) {
                                    String nuovoNomeDelegante = (String)partFruitoreDelegante + PATTERN_AZIONE_PREFIX_NEW + (String)partErogatoreDelegante + rimanenteDelegante;
                                    portaDelegata.getAzione().setNomePortaDelegante(nuovoNomeDelegante);
                                }
                            }
                        }
                    }
                    if (!soggettoProprietarioCombaciaSoggettoInModifica && !modificatoNome) continue;
                    listaPD.put(portaDelegata.getId(), portaDelegata);
                    checkUnique.add((CallSite)((Object)("" + portaDelegata.getId())));
                }
            }
            for (int j = 0; j < this.accordiServizioParteSpecifica.size(); ++j) {
                PortaDelegataSoggettoErogatore sogErogatore;
                Long idPorta;
                AccordoServizioParteSpecifica accordoServizioParteSpecifica = this.accordiServizioParteSpecifica.get(j);
                List<PortaDelegata> tmpListPD = null;
                Object locationPrefix = "";
                String locationSuffix = PATTERN_AZIONE_PREFIX_NEW + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW + accordoServizioParteSpecifica.getTipo() + "_" + accordoServizioParteSpecifica.getNome() + "/v" + accordoServizioParteSpecifica.getVersione();
                for (Fruitore fruitore : accordoServizioParteSpecifica.getFruitoreList()) {
                    String regexDelegante;
                    locationPrefix = fruitore.getTipo() + "_" + fruitore.getNome();
                    String location = (String)locationPrefix + locationSuffix;
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(location);
                    PortaDelegata portaDelegata = null;
                    try {
                        portaDelegata = this.porteDelegateCore.getPortaDelegata(idPD);
                    }
                    catch (DriverConfigurazioneNotFound partErogatore) {
                        // empty catch block
                    }
                    if (portaDelegata == null) {
                        try {
                            String oldLocationSuffix = PATTERN_AZIONE_PREFIX_NEW + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW + accordoServizioParteSpecifica.getTipo() + "_" + accordoServizioParteSpecifica.getNome() + PATTERN_AZIONE_PREFIX_NEW + accordoServizioParteSpecifica.getVersione();
                            String oldLocation = (String)locationPrefix + oldLocationSuffix;
                            idPD.setNome(oldLocation);
                            portaDelegata = this.porteDelegateCore.getPortaDelegata(idPD);
                        }
                        catch (DriverConfigurazioneNotFound oldLocationSuffix) {
                            // empty catch block
                        }
                    }
                    if (portaDelegata == null) continue;
                    Long idPorta2 = portaDelegata.getId();
                    if (listaPD.containsKey(idPorta2)) {
                        portaDelegata = (PortaDelegata)listaPD.get(idPorta2);
                    }
                    String newLocationSuffix = PATTERN_AZIONE_PREFIX_NEW + this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW + accordoServizioParteSpecifica.getTipo() + "_" + accordoServizioParteSpecifica.getNome() + "/v" + accordoServizioParteSpecifica.getVersione();
                    String newLocationPrefix = null;
                    newLocationPrefix = fruitore.getTipo().equals(this.oldtipoprov) && fruitore.getNome().equals(this.oldnomeprov) ? this.tipoprov + "_" + this.nomeprov : fruitore.getTipo() + "_" + fruitore.getNome();
                    String newLocation = newLocationPrefix + newLocationSuffix;
                    if (portaDelegata.getOldIDPortaDelegataForUpdate() == null) {
                        oldIDPortaDelegataForUpdate = new IDPortaDelegata();
                        oldIDPortaDelegataForUpdate.setNome(portaDelegata.getNome());
                        portaDelegata.setOldIDPortaDelegataForUpdate(oldIDPortaDelegataForUpdate);
                    }
                    portaDelegata.setNome(newLocation);
                    String descrizionePD = portaDelegata.getDescrizione();
                    if (descrizionePD != null && !descrizionePD.equals("")) {
                        String matchCaso2testErogatore;
                        String matchCaso2testMittente;
                        String matchCaso1testService;
                        String matchCaso1testFrom = " " + this.oldtipoprov + PATTERN_AZIONE_PREFIX_NEW + this.oldnomeprov + " ";
                        if (descrizionePD.contains(matchCaso1testFrom)) {
                            String replaceCaso1testFrom = " " + this.tipoprov + PATTERN_AZIONE_PREFIX_NEW + this.nomeprov + " ";
                            descrizionePD = descrizionePD.replace(matchCaso1testFrom, replaceCaso1testFrom);
                        }
                        if (descrizionePD.contains(matchCaso1testService = " " + this.oldtipoprov + PATTERN_AZIONE_PREFIX_NEW + this.oldnomeprov + ":")) {
                            String replaceCaso1testService = " " + this.tipoprov + PATTERN_AZIONE_PREFIX_NEW + this.nomeprov + ":";
                            descrizionePD = descrizionePD.replace(matchCaso1testService, replaceCaso1testService);
                        }
                        if (descrizionePD.contains(matchCaso2testMittente = " " + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW)) {
                            String replaceCaso2testMittente = " " + this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW;
                            descrizionePD = descrizionePD.replace(matchCaso2testMittente, replaceCaso2testMittente);
                        }
                        if (descrizionePD.contains(matchCaso2testErogatore = PATTERN_AZIONE_PREFIX_NEW + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW)) {
                            String replaceCaso2testErogatore = PATTERN_AZIONE_PREFIX_NEW + this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW;
                            descrizionePD = descrizionePD.replace(matchCaso2testErogatore, replaceCaso2testErogatore);
                        }
                        portaDelegata.setDescrizione(descrizionePD);
                    }
                    PortaDelegataSoggettoErogatore sogErogatore2 = portaDelegata.getSoggettoErogatore();
                    sogErogatore2.setTipo(this.sog.getTipo());
                    sogErogatore2.setNome(this.sog.getNome());
                    portaDelegata.setSoggettoErogatore(sogErogatore2);
                    String regex = REGEXP_FRUITORE_EROGATORE_OTHER_MATCH;
                    PortaDelegataAzione pdAzione = portaDelegata.getAzione();
                    PortaDelegataAzioneIdentificazione identificazione = pdAzione != null ? pdAzione.getIdentificazione() : null;
                    String patterAzione = "";
                    if (pdAzione != null) {
                        patterAzione = pdAzione.getPattern() != null ? pdAzione.getPattern() : "";
                    }
                    String patternAzionePrefixOld = PATTERN_AZIONE_PREFIX_OLD;
                    String patternAzioneSuffixOld = PATTERN_AZIONE_SUFFIX_OLD;
                    String patternAzionePrefixNew = PATTERN_AZIONE_PREFIX_NEW;
                    String patternAzioneSuffixNew = PATTERN_AZIONE_SUFFIX_NEW;
                    if (PortaDelegataAzioneIdentificazione.URL_BASED.equals((Object)identificazione)) {
                        int endidx;
                        int startidx;
                        String tmpPat;
                        boolean newPattern;
                        boolean oldPattern = patterAzione.startsWith(patternAzionePrefixOld) && patterAzione.endsWith(patternAzioneSuffixOld);
                        boolean bl = newPattern = patterAzione.startsWith(patternAzionePrefixNew) && patterAzione.endsWith(patternAzioneSuffixNew);
                        if ((oldPattern || newPattern) && (tmpPat = patterAzione.substring(startidx = oldPattern ? patternAzionePrefixOld.length() : patternAzionePrefixNew.length(), endidx = oldPattern ? patterAzione.lastIndexOf(patternAzioneSuffixOld) : patterAzione.lastIndexOf(patternAzioneSuffixNew))).matches(regex)) {
                            String[] val = tmpPat.split(PATTERN_AZIONE_PREFIX_NEW);
                            Object fruitoreA = val[0];
                            Object erogatore = val[1];
                            String rimanenteRegExp = "";
                            int lengthParteRimanenteRegExp = ((String)fruitoreA + PATTERN_AZIONE_PREFIX_NEW + (String)erogatore).length();
                            if (tmpPat.length() > lengthParteRimanenteRegExp) {
                                rimanenteRegExp = tmpPat.substring(lengthParteRimanenteRegExp);
                            }
                            boolean match = false;
                            String partOld = "(?:" + this.oldtipoprov + "_)?" + this.oldnomeprov;
                            String partNew = "(?:" + this.tipoprov + "_)?" + this.nomeprov;
                            if (((String)fruitoreA).equals(partOld)) {
                                fruitoreA = partNew;
                                match = true;
                            }
                            if (((String)erogatore).equals(partOld)) {
                                erogatore = partNew;
                                match = true;
                            }
                            if (match) {
                                String newPatternAzione = patternAzionePrefixNew + (String)fruitoreA + PATTERN_AZIONE_PREFIX_NEW + (String)erogatore + rimanenteRegExp + patternAzioneSuffixNew;
                                pdAzione.setPattern(newPatternAzione);
                                portaDelegata.setAzione(pdAzione);
                            }
                        }
                    }
                    String nomePortaDelegante = null;
                    if (pdAzione != null) {
                        String string = nomePortaDelegante = pdAzione.getNomePortaDelegante() != null ? pdAzione.getNomePortaDelegante() : null;
                    }
                    if (PortaDelegataAzioneIdentificazione.DELEGATED_BY.equals((Object)identificazione) && nomePortaDelegante != null && nomePortaDelegante.matches(regexDelegante = REGEXP_FRUITORE_EROGATORE_OTHER)) {
                        String[] tmpDelegante = nomePortaDelegante.split("\\/");
                        Object partFruitoreDelegante = tmpDelegante[0];
                        Object partErogatoreDelegante = tmpDelegante[1];
                        String rimanenteDelegante = "";
                        int lengthParteRimanenteDelegante = ((String)partFruitoreDelegante + PATTERN_AZIONE_PREFIX_NEW + (String)partErogatoreDelegante).length();
                        if (nomePortaDelegante.length() > lengthParteRimanenteDelegante) {
                            rimanenteDelegante = nomePortaDelegante.substring(lengthParteRimanenteDelegante);
                        }
                        boolean modificatoNomeDelegante = false;
                        if ((this.oldtipoprov + "_" + this.oldnomeprov).equals(partFruitoreDelegante)) {
                            partFruitoreDelegante = this.tipoprov + "_" + this.nomeprov;
                            modificatoNomeDelegante = true;
                        } else if (("__" + this.oldtipoprov + "_" + this.oldnomeprov).equals(partFruitoreDelegante)) {
                            partFruitoreDelegante = "__" + this.tipoprov + "_" + this.nomeprov;
                            modificatoNomeDelegante = true;
                        }
                        if (partErogatoreDelegante != null && ((String)partErogatoreDelegante).equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                            partErogatoreDelegante = this.tipoprov + "_" + this.nomeprov;
                            modificatoNomeDelegante = true;
                        }
                        if (modificatoNomeDelegante) {
                            String nuovoNomeDelegante = (String)partFruitoreDelegante + PATTERN_AZIONE_PREFIX_NEW + (String)partErogatoreDelegante + rimanenteDelegante;
                            portaDelegata.getAzione().setNomePortaDelegante(nuovoNomeDelegante);
                        }
                    }
                    listaPD.put(idPorta2, portaDelegata);
                }
                tmpListPD = this.porteDelegateCore.porteDelegateWithSoggettoErogatoreList(this.sog.getId());
                if (tmpListPD != null && !tmpListPD.isEmpty()) {
                    for (PortaDelegata portaDelegata : tmpListPD) {
                        idPorta = portaDelegata.getId();
                        if (listaPD.containsKey(idPorta)) {
                            portaDelegata = (PortaDelegata)listaPD.get(idPorta);
                        }
                        sogErogatore = portaDelegata.getSoggettoErogatore();
                        sogErogatore.setTipo(this.sog.getTipo());
                        sogErogatore.setNome(this.sog.getNome());
                        portaDelegata.setSoggettoErogatore(sogErogatore);
                        listaPD.put(idPorta, portaDelegata);
                    }
                }
                if ((tmpListPD = this.porteDelegateCore.porteDelegateWithTipoNomeErogatoreList(this.sog.getOldTipoForUpdate(), this.sog.getOldNomeForUpdate())) == null || tmpListPD.isEmpty()) continue;
                for (PortaDelegata portaDelegata2 : tmpListPD) {
                    idPorta = portaDelegata2.getId();
                    if (listaPD.containsKey(idPorta)) {
                        portaDelegata2 = (PortaDelegata)listaPD.get(idPorta);
                    }
                    sogErogatore = portaDelegata2.getSoggettoErogatore();
                    sogErogatore.setTipo(this.sog.getTipo());
                    sogErogatore.setNome(this.sog.getNome());
                    portaDelegata2.setSoggettoErogatore(sogErogatore);
                    listaPD.put(idPorta, portaDelegata2);
                }
            }
        }
        HashMap<String, AttivazionePolicy> listaPolicyPD = new HashMap<String, AttivazionePolicy>();
        HashMap<String, ConfigurazioneAllarmeBean> listaAllarmiPD = new HashMap<String, ConfigurazioneAllarmeBean>();
        if (listaPD != null && !listaPD.isEmpty()) {
            for (PortaDelegata portaDelegata : listaPD.values()) {
                this.updateSoggettoInlisteEngine(portaDelegata);
                this.oggettiDaAggiornare.add(portaDelegata);
                ConsoleSearch consoleSearch = new ConsoleSearch(true);
                listaPolicies = null;
                String oldNomePorta = portaDelegata.getNome();
                try {
                    if (portaDelegata.getOldIDPortaDelegataForUpdate() != null && portaDelegata.getOldIDPortaDelegataForUpdate().getNome() != null) {
                        oldNomePorta = portaDelegata.getOldIDPortaDelegataForUpdate().getNome();
                    }
                    listaPolicies = this.confCore.attivazionePolicyList(consoleSearch, RuoloPolicy.DELEGATA, oldNomePorta);
                }
                catch (Exception locationSuffix) {
                    // empty catch block
                }
                if (listaPolicies != null && !listaPolicies.isEmpty()) {
                    for (AttivazionePolicy ap : listaPolicies) {
                        if (ap.getFiltro() == null || !oldNomePorta.equals(ap.getFiltro().getNomePorta())) continue;
                        ap.getFiltro().setNomePorta(portaDelegata.getNome());
                        this.updateFiltroSoggettoEngine(ap);
                        listaPolicyPD.put(ap.getIdActivePolicy(), ap);
                    }
                }
                if (!this.confCore.isConfigurazioneAllarmiEnabled()) continue;
                ConsoleSearch ricercaAllarmi = new ConsoleSearch(true);
                List<ConfigurazioneAllarmeBean> listaAllarmi = null;
                oldNomePorta = portaDelegata.getNome();
                try {
                    if (portaDelegata.getOldIDPortaDelegataForUpdate() != null && portaDelegata.getOldIDPortaDelegataForUpdate().getNome() != null) {
                        oldNomePorta = portaDelegata.getOldIDPortaDelegataForUpdate().getNome();
                    }
                    listaAllarmi = this.confCore.allarmiList(ricercaAllarmi, RuoloPorta.DELEGATA, oldNomePorta);
                }
                catch (Exception portaDelegata2) {
                    // empty catch block
                }
                if (listaAllarmi == null || listaAllarmi.isEmpty()) continue;
                for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                    if (allarme.getFiltro() == null || !oldNomePorta.equals(allarme.getFiltro().getNomePorta())) continue;
                    allarme.getFiltro().setNomePorta(portaDelegata.getNome());
                    this.updateFiltroSoggettoEngine(allarme);
                    listaAllarmiPD.put(allarme.getNome(), allarme);
                }
            }
        }
        ArrayList<AttivazionePolicy> listPolicyDaVerificare = new ArrayList<AttivazionePolicy>();
        IDSoggetto filtroSoggettoFruitore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
        ConsoleSearch consoleSearch = new ConsoleSearch(true);
        listaPolicies = null;
        try {
            listaPolicies = this.confCore.attivazionePolicyListByFilter(consoleSearch, RuoloPolicy.DELEGATA, null, filtroSoggettoFruitore, null, null, null, null, null, null);
        }
        catch (Exception oldNomePorta) {
            // empty catch block
        }
        if (listaPolicies != null && !listaPolicies.isEmpty()) {
            for (AttivazionePolicy ap : listaPolicies) {
                if (listaPolicyPD.containsKey(ap.getIdActivePolicy())) continue;
                listPolicyDaVerificare.add(ap);
            }
        }
        IDSoggetto filtroSoggettoErogatore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
        ConsoleSearch consoleSearch2 = new ConsoleSearch(true);
        listaPolicies = null;
        try {
            listaPolicies = this.confCore.attivazionePolicyListByFilter(consoleSearch2, RuoloPolicy.DELEGATA, null, null, null, null, filtroSoggettoErogatore, null, null, null);
        }
        catch (Exception ap) {
            // empty catch block
        }
        if (listaPolicies != null && !listaPolicies.isEmpty()) {
            for (AttivazionePolicy ap : listaPolicies) {
                if (listaPolicyPD.containsKey(ap.getIdActivePolicy())) continue;
                listPolicyDaVerificare.add(ap);
            }
        }
        if (listPolicyDaVerificare != null && !listPolicyDaVerificare.isEmpty()) {
            for (AttivazionePolicy ap : listPolicyDaVerificare) {
                if (listaPolicyPD.containsKey(ap.getIdActivePolicy()) || ap.getFiltro() == null) continue;
                this.updateFiltroSoggettoEngine(ap);
                listaPolicyPD.put(ap.getIdActivePolicy(), ap);
            }
        }
        if (listaPolicyPD != null && !listaPolicyPD.isEmpty()) {
            for (AttivazionePolicy ap : listaPolicyPD.values()) {
                this.oggettiDaAggiornare.add(ap);
            }
        }
        if (this.confCore.isConfigurazioneAllarmiEnabled()) {
            ArrayList<ConfigurazioneAllarmeBean> listAllarmiDaVerificare = new ArrayList<ConfigurazioneAllarmeBean>();
            filtroSoggettoFruitore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
            ConsoleSearch ricercaAllarmi = new ConsoleSearch(true);
            List<ConfigurazioneAllarmeBean> listaAllarmi = null;
            try {
                listaAllarmi = this.confCore.allarmiListByFilter(ricercaAllarmi, RuoloPorta.DELEGATA, null, filtroSoggettoFruitore, null, null, null, null, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                    if (listaAllarmiPD.containsKey(allarme.getNome())) continue;
                    listAllarmiDaVerificare.add(allarme);
                }
            }
            filtroSoggettoErogatore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
            ricercaAllarmi = new ConsoleSearch(true);
            listaAllarmi = null;
            try {
                listaAllarmi = this.confCore.allarmiListByFilter(ricercaAllarmi, RuoloPorta.DELEGATA, null, null, null, null, filtroSoggettoErogatore, null, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                    if (listaAllarmiPD.containsKey(allarme.getNome())) continue;
                    listAllarmiDaVerificare.add(allarme);
                }
            }
            if (listAllarmiDaVerificare != null && !listAllarmiDaVerificare.isEmpty()) {
                for (ConfigurazioneAllarmeBean allarme : listAllarmiDaVerificare) {
                    if (listaAllarmiPD.containsKey(allarme.getNome()) || allarme.getFiltro() == null) continue;
                    this.updateFiltroSoggettoEngine(allarme);
                    listaAllarmiPD.put(allarme.getNome(), allarme);
                }
            }
            if (listaAllarmiPD != null && !listaAllarmiPD.isEmpty()) {
                for (ConfigurazioneAllarmeBean allarme : listaAllarmiPD.values()) {
                    this.oggettiDaAggiornare.add(allarme);
                }
            }
        }
    }

    private void updateSoggettoInlisteEngine(PortaDelegata portaDelegata) {
        if (portaDelegata.getTrasformazioni() != null && portaDelegata.getTrasformazioni().sizeRegolaList() > 0) {
            block0: for (TrasformazioneRegola trRegola : portaDelegata.getTrasformazioni().getRegolaList()) {
                if (trRegola.getApplicabilita() == null || trRegola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                for (TrasformazioneRegolaApplicabilitaServizioApplicativo trSA : trRegola.getApplicabilita().getServizioApplicativoList()) {
                    if (!this.oldtipoprov.equals(trSA.getTipoSoggettoProprietario()) || !this.oldnomeprov.equals(trSA.getNomeSoggettoProprietario())) continue;
                    trSA.setTipoSoggettoProprietario(this.tipoprov);
                    trSA.setNomeSoggettoProprietario(this.nomeprov);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkPorteApplicative() throws DriverConfigurazioneException {
        if (this.soggettiCore.isRegistroServiziLocale()) {
            HashMap<String, PortaApplicativa> listaPA = new HashMap<String, PortaApplicativa>();
            HashMap<String, ServizioApplicativo> listaPAeSA = new HashMap<String, ServizioApplicativo>();
            HashMap<String, AttivazionePolicy> listaPolicyPA = new HashMap<String, AttivazionePolicy>();
            HashMap<String, ConfigurazioneAllarmeBean> listaAllarmiPA = new HashMap<String, ConfigurazioneAllarmeBean>();
            if (!this.oldnomeprov.equals(this.nomeprov) || !this.oldtipoprov.equals(this.tipoprov)) {
                List<PortaApplicativa> tmpList = this.porteApplicativeCore.porteAppList(this.sog.getId().intValue(), (ISearch)new ConsoleSearch(true));
                for (PortaApplicativa portaApplicativa : tmpList) {
                    void var11_11;
                    IDPortaApplicativa oldIDPortaApplicativaForUpdate = null;
                    String nomeAttuale = portaApplicativa.getNome();
                    String regex = REGEXP_FRUITORE_EROGATORE_OTHER_MATCH;
                    Object var11_12 = null;
                    if (nomeAttuale.matches(regex)) {
                        String regexDelegante;
                        PortaApplicativaAzione paAzione;
                        void var11_15;
                        String[] stringArray = nomeAttuale.split("\\/");
                        Object patErogatore = stringArray[0];
                        String patServizio = stringArray[1];
                        String patVersioneServizio = stringArray[2];
                        StringBuilder stringBuilder = new StringBuilder();
                        if (stringArray.length > 3) {
                            for (int i = 3; i < stringArray.length; ++i) {
                                if (i > 3) {
                                    stringBuilder.append(PATTERN_AZIONE_PREFIX_NEW);
                                }
                                stringBuilder.append(stringArray[i]);
                            }
                        }
                        String patAzione = stringBuilder.toString();
                        if (((String)patErogatore).equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                            patErogatore = this.tipoprov + "_" + this.nomeprov;
                        } else if (((String)patErogatore).equals("__" + this.oldtipoprov + "_" + this.oldnomeprov)) {
                            patErogatore = "__" + this.tipoprov + "_" + this.nomeprov;
                        }
                        String string = (String)patErogatore + PATTERN_AZIONE_PREFIX_NEW + patServizio + PATTERN_AZIONE_PREFIX_NEW + patVersioneServizio;
                        if (patAzione != null && StringUtils.isNotEmpty((CharSequence)patAzione)) {
                            String string2 = string + PATTERN_AZIONE_PREFIX_NEW + patAzione;
                        }
                        portaApplicativa.setNome((String)var11_15);
                        oldIDPortaApplicativaForUpdate = new IDPortaApplicativa();
                        oldIDPortaApplicativaForUpdate.setNome(nomeAttuale);
                        portaApplicativa.setOldIDPortaApplicativaForUpdate(oldIDPortaApplicativaForUpdate);
                        String descrizionePA = portaApplicativa.getDescrizione();
                        if (descrizionePA != null && !descrizionePA.equals("")) {
                            String matchCaso2testService;
                            String matchCaso1testService = " " + this.oldtipoprov + PATTERN_AZIONE_PREFIX_NEW + this.oldnomeprov + ":";
                            if (descrizionePA.contains(matchCaso1testService)) {
                                String replaceCaso1testService = " " + this.tipoprov + PATTERN_AZIONE_PREFIX_NEW + this.nomeprov + ":";
                                descrizionePA = descrizionePA.replace(matchCaso1testService, replaceCaso1testService);
                            }
                            if (descrizionePA.contains(matchCaso2testService = " " + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW)) {
                                String replaceCaso2testService = " " + this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW;
                                descrizionePA = descrizionePA.replace(matchCaso2testService, replaceCaso2testService);
                            }
                            portaApplicativa.setDescrizione(descrizionePA);
                        }
                        PortaApplicativaAzioneIdentificazione identificazione = (paAzione = portaApplicativa.getAzione()) != null ? paAzione.getIdentificazione() : null;
                        String patterAzione = "";
                        if (paAzione != null) {
                            patterAzione = paAzione.getPattern() != null ? paAzione.getPattern() : "";
                        }
                        String patternAzionePrefixOld = PATTERN_AZIONE_PREFIX_OLD;
                        String patternAzioneSuffix1Old = PATTERN_AZIONE_SUFFIX_OLD;
                        String patternAzionePrefixNew = PATTERN_AZIONE_PREFIX_NEW;
                        String patternAzioneSuffix1New = PATTERN_AZIONE_SUFFIX_NEW;
                        if (PortaApplicativaAzioneIdentificazione.URL_BASED.equals((Object)identificazione)) {
                            int endidx;
                            int startidx;
                            String tmpPat;
                            boolean newPattern;
                            boolean oldPattern = patterAzione.startsWith(patternAzionePrefixOld) && patterAzione.endsWith(patternAzioneSuffix1Old);
                            boolean bl = newPattern = patterAzione.startsWith(patternAzionePrefixNew) && patterAzione.endsWith(patternAzioneSuffix1New);
                            if ((oldPattern || newPattern) && (tmpPat = patterAzione.substring(startidx = oldPattern ? patternAzionePrefixOld.length() : patternAzionePrefixNew.length(), endidx = oldPattern ? patterAzione.lastIndexOf(patternAzioneSuffix1Old) : patterAzione.lastIndexOf(patternAzioneSuffix1New))).matches(regex)) {
                                String[] stringArray2 = tmpPat.split(PATTERN_AZIONE_PREFIX_NEW);
                                Object partErogatore = stringArray2[0];
                                String partServizio = stringArray2[1];
                                String partVersione = stringArray2[2];
                                String rimanenteRegExp = "";
                                int lengthParteRimanenteRegExp = ((String)partErogatore + PATTERN_AZIONE_PREFIX_NEW + partServizio + PATTERN_AZIONE_PREFIX_NEW + partVersione).length();
                                if (tmpPat.length() > lengthParteRimanenteRegExp) {
                                    rimanenteRegExp = tmpPat.substring(lengthParteRimanenteRegExp);
                                }
                                boolean matchURL = false;
                                String partOld = "(?:" + this.oldtipoprov + "_)?" + this.oldnomeprov;
                                String partNew = "(?:" + this.tipoprov + "_)?" + this.nomeprov;
                                if (((String)partErogatore).equals(partOld)) {
                                    partErogatore = partNew;
                                    matchURL = true;
                                }
                                if (matchURL) {
                                    String newPatternAzione = patternAzionePrefixNew + (String)partErogatore + PATTERN_AZIONE_PREFIX_NEW + partServizio + PATTERN_AZIONE_PREFIX_NEW + partVersione + rimanenteRegExp + patternAzioneSuffix1New;
                                    paAzione.setPattern(newPatternAzione);
                                    portaApplicativa.setAzione(paAzione);
                                }
                            }
                        }
                        String nomePortaDelegante = null;
                        if (paAzione != null) {
                            String string3 = nomePortaDelegante = paAzione.getNomePortaDelegante() != null ? paAzione.getNomePortaDelegante() : null;
                        }
                        if (PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals((Object)identificazione) && nomePortaDelegante != null && nomePortaDelegante.matches(regexDelegante = REGEXP_FRUITORE_EROGATORE_OTHER_MATCH)) {
                            String[] valDelegante = nomePortaDelegante.split("\\/");
                            Object patErogatoreDelegante = valDelegante[0];
                            String patServizioDelegante = valDelegante[1];
                            String patVersioneServizioDelegante = valDelegante[2];
                            StringBuilder sbPatAzioneDelegante = new StringBuilder();
                            if (valDelegante.length > 3) {
                                for (int i = 3; i < valDelegante.length; ++i) {
                                    if (i > 3) {
                                        sbPatAzioneDelegante.append(PATTERN_AZIONE_PREFIX_NEW);
                                    }
                                    sbPatAzioneDelegante.append(valDelegante[i]);
                                }
                            }
                            String patAzioneDelegante = sbPatAzioneDelegante.toString();
                            if (((String)patErogatoreDelegante).equals(this.oldtipoprov + "_" + this.oldnomeprov)) {
                                patErogatoreDelegante = this.tipoprov + "_" + this.nomeprov;
                            } else if (((String)patErogatoreDelegante).equals("__" + this.oldtipoprov + "_" + this.oldnomeprov)) {
                                patErogatoreDelegante = "__" + this.tipoprov + "_" + this.nomeprov;
                            }
                            String newNomeDelegante = (String)patErogatoreDelegante + PATTERN_AZIONE_PREFIX_NEW + patServizioDelegante + PATTERN_AZIONE_PREFIX_NEW + patVersioneServizioDelegante;
                            if (patAzioneDelegante != null && StringUtils.isNotEmpty((CharSequence)patAzioneDelegante)) {
                                newNomeDelegante = newNomeDelegante + PATTERN_AZIONE_PREFIX_NEW + patAzioneDelegante;
                            }
                            portaApplicativa.getAzione().setNomePortaDelegante(newNomeDelegante);
                        }
                    }
                    this.updateSoggettoInListeEngine(portaApplicativa);
                    portaApplicativa.setTipoSoggettoProprietario(this.tipoprov);
                    portaApplicativa.setNomeSoggettoProprietario(this.nomeprov);
                    listaPA.put(nomeAttuale, portaApplicativa);
                    if (oldIDPortaApplicativaForUpdate != null && portaApplicativa.sizeServizioApplicativoList() > 0) {
                        for (PortaApplicativaServizioApplicativo portaApplicativaSA : portaApplicativa.getServizioApplicativoList()) {
                            boolean nameEquals = portaApplicativaSA.getNome().equals(oldIDPortaApplicativaForUpdate.getNome());
                            boolean nameConnettoreMultiplo = portaApplicativaSA.getNome().startsWith(oldIDPortaApplicativaForUpdate.getNome() + "__SA");
                            if (!nameEquals && !nameConnettoreMultiplo) continue;
                            IDServizioApplicativo iDServizioApplicativo = new IDServizioApplicativo();
                            iDServizioApplicativo.setNome(portaApplicativaSA.getNome());
                            iDServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
                            ServizioApplicativo sa = this.saCore.getServizioApplicativo(iDServizioApplicativo);
                            IDServizioApplicativo oldIDServizioApplicativoForUpdate = new IDServizioApplicativo();
                            oldIDServizioApplicativoForUpdate.setNome(sa.getNome());
                            oldIDServizioApplicativoForUpdate.setIdSoggettoProprietario(iDServizioApplicativo.getIdSoggettoProprietario());
                            sa.setOldIDServizioApplicativoForUpdate(oldIDServizioApplicativoForUpdate);
                            sa.setTipoSoggettoProprietario(this.tipoprov);
                            sa.setNomeSoggettoProprietario(this.nomeprov);
                            if (nameEquals || nameConnettoreMultiplo) {
                                if (sa.getNome().startsWith(this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW)) {
                                    sa.setNome(sa.getNome().replace(this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW, this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW));
                                } else if (sa.getNome().startsWith("__" + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW)) {
                                    sa.setNome(sa.getNome().replace("__" + this.oldtipoprov + "_" + this.oldnomeprov + PATTERN_AZIONE_PREFIX_NEW, "__" + this.tipoprov + "_" + this.nomeprov + PATTERN_AZIONE_PREFIX_NEW));
                                }
                            }
                            listaPAeSA.put(sa.getNome(), sa);
                        }
                    }
                    ConsoleSearch consoleSearch = new ConsoleSearch(true);
                    List<AttivazionePolicy> listaPolicies = null;
                    try {
                        listaPolicies = this.confCore.attivazionePolicyList(consoleSearch, RuoloPolicy.APPLICATIVA, nomeAttuale);
                    }
                    catch (Exception nameEquals) {
                        // empty catch block
                    }
                    if (listaPolicies != null && !listaPolicies.isEmpty()) {
                        for (AttivazionePolicy ap : listaPolicies) {
                            if (ap.getFiltro() == null || !nomeAttuale.equals(ap.getFiltro().getNomePorta())) continue;
                            if (var11_11 != null) {
                                ap.getFiltro().setNomePorta((String)var11_11);
                            }
                            this.updateFiltroSoggettoEngine(ap);
                            listaPolicyPA.put(ap.getIdActivePolicy(), ap);
                        }
                    }
                    if (!this.confCore.isConfigurazioneAllarmiEnabled()) continue;
                    ConsoleSearch ricercaAllarmi = new ConsoleSearch(true);
                    Object listaAllarmi = null;
                    try {
                        listaAllarmi = this.confCore.allarmiList(ricercaAllarmi, RuoloPorta.APPLICATIVA, nomeAttuale);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (listaAllarmi == null || listaAllarmi.isEmpty()) continue;
                    Iterator<ConfigurazioneAllarmeBean> iterator = listaAllarmi.iterator();
                    while (iterator.hasNext()) {
                        ConfigurazioneAllarmeBean allarme = iterator.next();
                        if (allarme.getFiltro() == null || !nomeAttuale.equals(allarme.getFiltro().getNomePorta())) continue;
                        if (var11_11 != null) {
                            allarme.getFiltro().setNomePorta((String)var11_11);
                        }
                        this.updateFiltroSoggettoEngine(allarme);
                        listaAllarmiPA.put(allarme.getNome(), allarme);
                    }
                }
                ArrayList<Object> listDaVerificare = new ArrayList<Object>();
                List<PortaApplicativa> tmpListSoggettiVirtuali = this.porteApplicativeCore.getPorteApplicativeBySoggettoVirtuale(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
                if (tmpListSoggettiVirtuali != null && !tmpListSoggettiVirtuali.isEmpty()) {
                    for (PortaApplicativa portaApplicativa : tmpListSoggettiVirtuali) {
                        if (listaPA.containsKey(portaApplicativa.getNome())) continue;
                        IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                        idPortaApplicativa.setNome(portaApplicativa.getNome());
                        listDaVerificare.add(idPortaApplicativa);
                    }
                }
                FiltroRicercaPorteApplicative filtroRicercaPAConAuthSoggetti = new FiltroRicercaPorteApplicative();
                filtroRicercaPAConAuthSoggetti.setIdSoggettoAutorizzato(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
                List<IDPortaApplicativa> list = this.porteApplicativeCore.getAllIdPorteApplicative(filtroRicercaPAConAuthSoggetti);
                if (list != null && !list.isEmpty()) {
                    for (IDPortaApplicativa iDPortaApplicativa : list) {
                        if (listaPA.containsKey(iDPortaApplicativa.getNome())) continue;
                        listDaVerificare.add(iDPortaApplicativa);
                    }
                }
                FiltroRicercaPorteApplicative filtroRicercaPAConTrasformazioneSoggetti = new FiltroRicercaPorteApplicative();
                filtroRicercaPAConTrasformazioneSoggetti.setIdSoggettoRiferitoApplicabilitaTrasformazione(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
                list = this.porteApplicativeCore.getAllIdPorteApplicative(filtroRicercaPAConTrasformazioneSoggetti);
                if (list != null && !list.isEmpty()) {
                    for (IDPortaApplicativa iDPortaApplicativa : list) {
                        if (listaPA.containsKey(iDPortaApplicativa.getNome())) continue;
                        listDaVerificare.add(iDPortaApplicativa);
                    }
                }
                if (listDaVerificare != null && !listDaVerificare.isEmpty()) {
                    for (IDPortaApplicativa iDPortaApplicativa : listDaVerificare) {
                        if (listaPA.containsKey(iDPortaApplicativa.getNome())) continue;
                        PortaApplicativa pa = null;
                        try {
                            pa = this.porteApplicativeCore.getPortaApplicativa(iDPortaApplicativa);
                        }
                        catch (DriverConfigurazioneNotFound ricercaAllarmi) {
                            // empty catch block
                        }
                        if (pa == null) continue;
                        if (pa.getSoggettoVirtuale() != null && this.oldtipoprov.equals(pa.getSoggettoVirtuale().getTipo()) && this.oldnomeprov.equals(pa.getSoggettoVirtuale().getNome())) {
                            pa.getSoggettoVirtuale().setTipo(this.tipoprov);
                            pa.getSoggettoVirtuale().setNome(this.nomeprov);
                        }
                        this.updateSoggettoInListeEngine(pa);
                        listaPA.put(pa.getNome(), pa);
                    }
                }
                ArrayList<AttivazionePolicy> arrayList = new ArrayList<AttivazionePolicy>();
                IDSoggetto iDSoggetto = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
                ConsoleSearch ricercaPolicies = new ConsoleSearch(true);
                List<AttivazionePolicy> listaPolicies = null;
                try {
                    listaPolicies = this.confCore.attivazionePolicyListByFilter(ricercaPolicies, RuoloPolicy.APPLICATIVA, null, iDSoggetto, null, null, null, null, null, null);
                }
                catch (Exception listaAllarmi) {
                    // empty catch block
                }
                if (listaPolicies != null && !listaPolicies.isEmpty()) {
                    for (AttivazionePolicy attivazionePolicy : listaPolicies) {
                        if (listaPolicyPA.containsKey(attivazionePolicy.getIdActivePolicy())) continue;
                        arrayList.add(attivazionePolicy);
                    }
                }
                IDSoggetto filtroSoggettoErogatore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
                ricercaPolicies = new ConsoleSearch(true);
                listaPolicies = null;
                try {
                    listaPolicies = this.confCore.attivazionePolicyListByFilter(ricercaPolicies, RuoloPolicy.APPLICATIVA, null, null, null, null, filtroSoggettoErogatore, null, null, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (listaPolicies != null && !listaPolicies.isEmpty()) {
                    for (AttivazionePolicy ap : listaPolicies) {
                        if (listaPolicyPA.containsKey(ap.getIdActivePolicy())) continue;
                        arrayList.add(ap);
                    }
                }
                if (arrayList != null && !arrayList.isEmpty()) {
                    for (AttivazionePolicy ap : arrayList) {
                        if (listaPolicyPA.containsKey(ap.getIdActivePolicy()) || ap.getFiltro() == null) continue;
                        this.updateFiltroSoggettoEngine(ap);
                        listaPolicyPA.put(ap.getIdActivePolicy(), ap);
                    }
                }
                if (this.confCore.isConfigurazioneAllarmiEnabled()) {
                    ArrayList<ConfigurazioneAllarmeBean> arrayList2 = new ArrayList<ConfigurazioneAllarmeBean>();
                    IDSoggetto iDSoggetto2 = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
                    ConsoleSearch ricercaAllarmi = new ConsoleSearch(true);
                    List<ConfigurazioneAllarmeBean> listaAllarmi = null;
                    try {
                        listaAllarmi = this.confCore.allarmiListByFilter(ricercaAllarmi, RuoloPorta.APPLICATIVA, null, iDSoggetto2, null, null, null, null, null, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                        for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                            if (listaAllarmiPA.containsKey(allarme.getNome())) continue;
                            arrayList2.add(allarme);
                        }
                    }
                    filtroSoggettoErogatore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
                    ricercaAllarmi = new ConsoleSearch(true);
                    listaAllarmi = null;
                    try {
                        listaAllarmi = this.confCore.allarmiListByFilter(ricercaAllarmi, RuoloPorta.APPLICATIVA, null, null, null, null, filtroSoggettoErogatore, null, null, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                        for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                            if (listaAllarmiPA.containsKey(allarme.getNome())) continue;
                            arrayList2.add(allarme);
                        }
                    }
                    if (arrayList2 != null && !arrayList2.isEmpty()) {
                        for (ConfigurazioneAllarmeBean allarme : arrayList2) {
                            if (listaAllarmiPA.containsKey(allarme.getNome()) || allarme.getFiltro() == null) continue;
                            this.updateFiltroSoggettoEngine(allarme);
                            listaAllarmiPA.put(allarme.getNome(), allarme);
                        }
                    }
                }
            }
            if (listaPA != null && !listaPA.isEmpty()) {
                for (PortaApplicativa portaApplicativa : listaPA.values()) {
                    this.oggettiDaAggiornare.add(portaApplicativa);
                }
            }
            if (listaPAeSA != null && !listaPAeSA.isEmpty()) {
                for (ServizioApplicativo sa : listaPAeSA.values()) {
                    this.oggettiDaAggiornare.add(sa);
                }
            }
            if (listaPolicyPA != null && !listaPolicyPA.isEmpty()) {
                for (AttivazionePolicy ap : listaPolicyPA.values()) {
                    this.oggettiDaAggiornare.add(ap);
                }
            }
            if (this.confCore.isConfigurazioneAllarmiEnabled() && listaAllarmiPA != null && !listaAllarmiPA.isEmpty()) {
                for (ConfigurazioneAllarmeBean allarme : listaAllarmiPA.values()) {
                    this.oggettiDaAggiornare.add(allarme);
                }
            }
        }
    }

    private void updateSoggettoInListeEngine(PortaApplicativa portaApplicativa) {
        if (portaApplicativa.getSoggetti() != null && portaApplicativa.getSoggetti().sizeSoggettoList() > 0) {
            for (PortaApplicativaAutorizzazioneSoggetto portaApplicativaAuthSoggetto : portaApplicativa.getSoggetti().getSoggettoList()) {
                if (!this.oldtipoprov.equals(portaApplicativaAuthSoggetto.getTipo()) || !this.oldnomeprov.equals(portaApplicativaAuthSoggetto.getNome())) continue;
                portaApplicativaAuthSoggetto.setTipo(this.tipoprov);
                portaApplicativaAuthSoggetto.setNome(this.nomeprov);
                break;
            }
        }
        if (portaApplicativa.getServiziApplicativiAutorizzati() != null && portaApplicativa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
            for (PortaApplicativaAutorizzazioneServizioApplicativo portaApplicativaAuthSa : portaApplicativa.getServiziApplicativiAutorizzati().getServizioApplicativoList()) {
                if (!this.oldtipoprov.equals(portaApplicativaAuthSa.getTipoSoggettoProprietario()) || !this.oldnomeprov.equals(portaApplicativaAuthSa.getNomeSoggettoProprietario())) continue;
                portaApplicativaAuthSa.setTipoSoggettoProprietario(this.tipoprov);
                portaApplicativaAuthSa.setNomeSoggettoProprietario(this.nomeprov);
                break;
            }
        }
        if (portaApplicativa.getTrasformazioni() != null && portaApplicativa.getTrasformazioni().sizeRegolaList() > 0) {
            block2: for (TrasformazioneRegola trRegola : portaApplicativa.getTrasformazioni().getRegolaList()) {
                if (trRegola.getApplicabilita() == null || trRegola.getApplicabilita().sizeSoggettoList() <= 0) continue;
                for (TrasformazioneRegolaApplicabilitaSoggetto trSoggetto : trRegola.getApplicabilita().getSoggettoList()) {
                    if (!this.oldtipoprov.equals(trSoggetto.getTipo()) || !this.oldnomeprov.equals(trSoggetto.getNome())) continue;
                    trSoggetto.setTipo(this.tipoprov);
                    trSoggetto.setNome(this.nomeprov);
                    continue block2;
                }
            }
        }
        if (portaApplicativa.getTrasformazioni() != null && portaApplicativa.getTrasformazioni().sizeRegolaList() > 0) {
            block4: for (TrasformazioneRegola trRegola : portaApplicativa.getTrasformazioni().getRegolaList()) {
                if (trRegola.getApplicabilita() == null || trRegola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                for (TrasformazioneRegolaApplicabilitaServizioApplicativo trSA : trRegola.getApplicabilita().getServizioApplicativoList()) {
                    if (!this.oldtipoprov.equals(trSA.getTipoSoggettoProprietario()) || !this.oldnomeprov.equals(trSA.getNomeSoggettoProprietario())) continue;
                    trSA.setTipoSoggettoProprietario(this.tipoprov);
                    trSA.setNomeSoggettoProprietario(this.nomeprov);
                    continue block4;
                }
            }
        }
    }

    private void updateFiltroSoggettoEngine(AttivazionePolicy ap) {
        if (ap.getFiltro() != null) {
            if (ap.getFiltro().getTipoFruitore() != null && ap.getFiltro().getNomeFruitore() != null && this.oldtipoprov.equals(ap.getFiltro().getTipoFruitore()) && this.oldnomeprov.equals(ap.getFiltro().getNomeFruitore())) {
                ap.getFiltro().setTipoFruitore(this.tipoprov);
                ap.getFiltro().setNomeFruitore(this.nomeprov);
            }
            if (ap.getFiltro().getTipoErogatore() != null && ap.getFiltro().getNomeErogatore() != null && this.oldtipoprov.equals(ap.getFiltro().getTipoErogatore()) && this.oldnomeprov.equals(ap.getFiltro().getNomeErogatore())) {
                ap.getFiltro().setTipoErogatore(this.tipoprov);
                ap.getFiltro().setNomeErogatore(this.nomeprov);
            }
        }
    }

    private void updateFiltroSoggettoEngine(ConfigurazioneAllarmeBean allarme) {
        if (allarme.getFiltro() != null) {
            if (allarme.getFiltro().getTipoFruitore() != null && allarme.getFiltro().getNomeFruitore() != null && this.oldtipoprov.equals(allarme.getFiltro().getTipoFruitore()) && this.oldnomeprov.equals(allarme.getFiltro().getNomeFruitore())) {
                allarme.getFiltro().setTipoFruitore(this.tipoprov);
                allarme.getFiltro().setNomeFruitore(this.nomeprov);
            }
            if (allarme.getFiltro().getTipoErogatore() != null && allarme.getFiltro().getNomeErogatore() != null && this.oldtipoprov.equals(allarme.getFiltro().getTipoErogatore()) && this.oldnomeprov.equals(allarme.getFiltro().getNomeErogatore())) {
                allarme.getFiltro().setTipoErogatore(this.tipoprov);
                allarme.getFiltro().setNomeErogatore(this.nomeprov);
            }
        }
    }

    public void checkFruitori() throws DriverRegistroServiziException {
        if (!(!this.soggettiCore.isRegistroServiziLocale() || this.oldnomeprov.equals(this.nomeprov) && this.oldtipoprov.equals(this.tipoprov))) {
            List<AccordoServizioParteSpecifica> sfruitori = this.apsCore.servizioWithSoggettoFruitore(new IDSoggetto(this.oldtipoprov, this.oldnomeprov));
            for (int i = 0; i < sfruitori.size(); ++i) {
                IDAccordo idAccordo;
                AccordoServizioParteSpecifica asps = sfruitori.get(i);
                if (asps.getTipoSoggettoErogatore().equals(this.oldtipoprov) && asps.getNomeSoggettoErogatore().equals(this.oldnomeprov)) {
                    asps.setTipoSoggettoErogatore(this.tipoprov);
                    asps.setNomeSoggettoErogatore(this.nomeprov);
                }
                if ((idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune())).getSoggettoReferente() != null && idAccordo.getSoggettoReferente().getTipo().equals(this.oldtipoprov) && idAccordo.getSoggettoReferente().getNome().equals(this.oldnomeprov)) {
                    idAccordo.getSoggettoReferente().setTipo(this.tipoprov);
                    idAccordo.getSoggettoReferente().setNome(this.nomeprov);
                    asps.setAccordoServizioParteComune(IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordo));
                }
                for (int j = 0; j < asps.sizeFruitoreList(); ++j) {
                    if (!asps.getFruitore(j).getTipo().equals(this.oldtipoprov) || !asps.getFruitore(j).getNome().equals(this.oldnomeprov)) continue;
                    asps.getFruitore(j).setTipo(this.tipoprov);
                    asps.getFruitore(j).setNome(this.nomeprov);
                }
                this.oggettiDaAggiornare.add(asps);
            }
        }
    }

    public void checkPolicyGlobali() {
        if (!(!this.soggettiCore.isRegistroServiziLocale() || this.oldnomeprov.equals(this.nomeprov) && this.oldtipoprov.equals(this.tipoprov))) {
            HashMap<String, AttivazionePolicy> listaPolicyPA = new HashMap<String, AttivazionePolicy>();
            IDSoggetto filtroSoggettoFruitore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
            ConsoleSearch ricercaPolicies = new ConsoleSearch(true);
            List<AttivazionePolicy> listaPolicies = null;
            try {
                listaPolicies = this.confCore.attivazionePolicyListByFilter(ricercaPolicies, null, null, filtroSoggettoFruitore, null, null, null, null, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (listaPolicies != null && !listaPolicies.isEmpty()) {
                for (AttivazionePolicy ap : listaPolicies) {
                    if (listaPolicyPA.containsKey(ap.getIdActivePolicy()) || ap.getFiltro() == null) continue;
                    this.updateFiltroSoggettoEngine(ap);
                    listaPolicyPA.put(ap.getIdActivePolicy(), ap);
                }
            }
            IDSoggetto filtroSoggettoErogatore = new IDSoggetto(this.oldtipoprov, this.oldnomeprov);
            ricercaPolicies = new ConsoleSearch(true);
            listaPolicies = null;
            try {
                listaPolicies = this.confCore.attivazionePolicyListByFilter(ricercaPolicies, null, null, null, null, null, filtroSoggettoErogatore, null, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (listaPolicies != null && !listaPolicies.isEmpty()) {
                for (AttivazionePolicy ap : listaPolicies) {
                    if (listaPolicyPA.containsKey(ap.getIdActivePolicy()) || ap.getFiltro() == null) continue;
                    this.updateFiltroSoggettoEngine(ap);
                    listaPolicyPA.put(ap.getIdActivePolicy(), ap);
                }
            }
            if (listaPolicyPA != null && !listaPolicyPA.isEmpty()) {
                for (AttivazionePolicy ap : listaPolicyPA.values()) {
                    this.oggettiDaAggiornare.add(ap);
                }
            }
        }
    }

    public void checkConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (!(!this.soggettiCore.isRegistroServiziLocale() || this.oldnomeprov.equals(this.nomeprov) && this.oldtipoprov.equals(this.tipoprov))) {
            Configurazione configurazioneGenerale = this.confCore.getConfigurazioneGenerale();
            boolean updated = false;
            if (configurazioneGenerale != null && configurazioneGenerale.getUrlInvocazione() != null && configurazioneGenerale.getUrlInvocazione().sizeRegolaList() > 0) {
                for (ConfigurazioneUrlInvocazioneRegola regola : configurazioneGenerale.getUrlInvocazione().getRegolaList()) {
                    if (regola.getSoggetto() == null || !this.oldtipoprov.equals(regola.getSoggetto().getTipo()) || !this.oldnomeprov.equals(regola.getSoggetto().getNome())) continue;
                    regola.getSoggetto().setTipo(this.tipoprov);
                    regola.getSoggetto().setNome(this.nomeprov);
                    updated = true;
                }
            }
            if (updated) {
                this.oggettiDaAggiornare.add(configurazioneGenerale);
            }
        }
    }
}

