/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utils;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.utils.UtilsHelper;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.byok.LockUtilities;

public class SecretDecoder
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)baos);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la ricerca delle informazioni oggetto: " + e.getMessage(), e);
            return;
        }
        this.processRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        block24: {
            String risposta = "";
            String messaggioEsito = null;
            String messageType = null;
            response.setContentType("application/json");
            try (ByteArrayOutputStream baosPayload = new ByteArrayOutputStream();){
                HttpRequestMethod httpRequestMethod = HttpRequestMethod.valueOf((String)request.getMethod().toUpperCase());
                if (httpRequestMethod.equals((Object)HttpRequestMethod.POST)) {
                    IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)baosPayload);
                }
                HttpSession session = request.getSession(true);
                PageData pd = new PageData();
                UtilsHelper registroHelper = new UtilsHelper(request, pd, session);
                ControlStationCore core = registroHelper.getCore();
                String secretToUnwrap = registroHelper.getParameter("secret");
                if (core.getDriverBYOKUtilities().isEnabledBYOK()) {
                    StringBuilder sb = new StringBuilder();
                    ControlStationCore.logInfo("SecretDecoder: secretToUnwrap: " + secretToUnwrap);
                    String messaggioInformativoInformazioneNonCifrata = core.getNotaInformativaInformazioneMemorizzataInChiaro();
                    if (BYOKUtilities.isWrappedValue((String)secretToUnwrap)) {
                        if (!core.getDriverBYOKUtilities().isWrappedWithActivePolicy(secretToUnwrap)) {
                            LockUtilities.appendErrorMessageSecurityPolicyDifferente((String)core.getNotaInformativaInformazioneCifrataSecurityPolicyDifferente(), (StringBuilder)sb, (String)secretToUnwrap);
                        }
                    } else if (messaggioInformativoInformazioneNonCifrata != null && StringUtils.isNotEmpty((CharSequence)messaggioInformativoInformazioneNonCifrata)) {
                        sb.append(messaggioInformativoInformazioneNonCifrata);
                    }
                    if (sb.length() > 0) {
                        sb.append("\n\nValore in chiaro: ");
                    }
                    messaggioEsito = core.getDriverBYOKUtilities().unwrap(secretToUnwrap);
                    messageType = MessageType.INFO.toString();
                } else {
                    messaggioEsito = "ERROR: BYOK Unitialized";
                    messageType = MessageType.ERROR.toString();
                }
            }
            risposta = ServletUtils.getJson((String[])new String[]{ServletUtils.getJsonPair((String)"esito", (String)messageType), ServletUtils.getJsonPair((String)"dettaglioEsito", (String)messaggioEsito)});
            try {
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(risposta.getBytes());
            }
            catch (Exception eErr) {
                ControlStationCore.logError("Errore durante la serializzazione dell'errore di decodifica: " + eErr.getMessage(), eErr);
            }
            break block24;
            catch (Exception e) {
                try {
                    ControlStationCore.logError("Errore durante la decodifica: " + e.getMessage(), e);
                    messaggioEsito = "Si &egrave; verificato un errore durante la decodifica. Si prega di riprovare pi&ugrave; tardi.";
                    messageType = MessageType.ERROR.toString();
                }
                catch (Throwable throwable) {
                    risposta = ServletUtils.getJson((String[])new String[]{ServletUtils.getJsonPair((String)"esito", messageType), ServletUtils.getJsonPair((String)"dettaglioEsito", (String)messaggioEsito)});
                    try {
                        ServletOutputStream outputStream = response.getOutputStream();
                        outputStream.write(risposta.getBytes());
                    }
                    catch (Exception eErr) {
                        ControlStationCore.logError("Errore durante la serializzazione dell'errore di decodifica: " + eErr.getMessage(), eErr);
                    }
                    throw throwable;
                }
                risposta = ServletUtils.getJson((String[])new String[]{ServletUtils.getJsonPair((String)"esito", (String)messageType), ServletUtils.getJsonPair((String)"dettaglioEsito", (String)messaggioEsito)});
                try {
                    ServletOutputStream outputStream = response.getOutputStream();
                    outputStream.write(risposta.getBytes());
                }
                catch (Exception eErr) {
                    ControlStationCore.logError("Errore durante la serializzazione dell'errore di decodifica: " + eErr.getMessage(), eErr);
                }
            }
        }
    }
}

