/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utils;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.utils.UtilsHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class VerificaCertificati
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)baos);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la ricerca delle informazioni oggetto: " + e.getMessage(), e);
            return;
        }
        this.processRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        block30: {
            risposta = "";
            messaggioEsito = null;
            messageType = null;
            response.setContentType("application/json");
            baosPayload = new ByteArrayOutputStream();
            try {
                httpRequestMethod = HttpRequestMethod.valueOf((String)request.getMethod().toUpperCase());
                if (httpRequestMethod.equals((Object)HttpRequestMethod.POST)) {
                    IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)baosPayload);
                }
                session = request.getSession(true);
                pd = new PageData();
                registroHelper = new UtilsHelper(request, pd, session);
                tipoOggetto = registroHelper.getParameter("tipoOggetto");
                inUsoType = InUsoType.valueOf(tipoOggetto);
                switch (1.$SwitchMap$org$openspcoop2$web$ctrlstat$costanti$InUsoType[inUsoType.ordinal()]) {
                    case 1: 
                    case 2: {
                        apsHelper = new ErogazioniHelper(request, pd, session);
                        apsCore = new AccordiServizioParteSpecificaCore();
                        soggettiCore = new SoggettiCore(apsCore);
                        verificaCertificatiFromLista = apsHelper.getParametroBoolean("certVerFromLista");
                        arrivoDaLista = "true".equalsIgnoreCase(verificaCertificatiFromLista);
                        soloModI = false;
                        if (!arrivoDaLista) {
                            par = apsHelper.getParametroBoolean("modificaProfilo");
                            soloModI = "true".equalsIgnoreCase(par);
                        }
                        id = apsHelper.getParametroLong("id");
                        idInt = Long.parseLong(id);
                        asps = apsCore.getAccordoServizioParteSpecifica(idInt);
                        tipoSoggettoFruitore = apsHelper.getParameter("tipoSoggFru");
                        nomeSoggettoFruitore = apsHelper.getParameter("nomeSoggFru");
                        idSoggettoFruitore = null;
                        if (tipoSoggettoFruitore != null && !"".equals(tipoSoggettoFruitore) && nomeSoggettoFruitore != null && !"".equals(nomeSoggettoFruitore)) {
                            idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
                        }
                        alias = apsHelper.getParameter("aliasNodo");
                        tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
                        gestioneFruitori = false;
                        gestioneErogatori = false;
                        if (tipologia != null) {
                            if ("fruizione".equals(tipologia)) {
                                gestioneFruitori = true;
                            } else if ("erogazione".equals(tipologia)) {
                                gestioneErogatori = true;
                            }
                        }
                        fruitore = null;
                        if (gestioneFruitori) {
                            for (Fruitore check : asps.getFruitoreList()) {
                                if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                                fruitore = check;
                                break;
                            }
                        }
                        if (verificaCertificatiEffettuata = apsHelper.eseguiVerificaCertificati(soloModI, asps, idSoggettoFruitore, alias, gestioneFruitori, gestioneErogatori, fruitore, idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps), tipoProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore()), dati = new ArrayList<DataElement>())) {
                            ControlStationCore.logInfo("Verifica dei certificati completata.");
                            messaggioEsito = pd.getMessage();
                            messageType = pd.getMessageType();
                            ** break;
lbl57:
                            // 1 sources

                        } else {
                            ControlStationCore.logInfo("Verifica dei certificati non completata.");
                            messaggioEsito = "Verifica dei certificati non eseguita";
                            messageType = MessageType.INFO.toString();
                            ** break;
                        }
lbl62:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new CoreException("TipoOggetto non gestito.");
                    }
                }
            }
            finally {
                baosPayload.close();
            }
            risposta = ServletUtils.getJson((String[])new String[]{ServletUtils.getJsonPair((String)"esito", (String)messageType), ServletUtils.getJsonPair((String)"dettaglioEsito", (String)messaggioEsito)});
            try {
                outputStream = response.getOutputStream();
                outputStream.write(risposta.getBytes());
            }
            catch (Exception eErr) {
                ControlStationCore.logError("Errore durante la serializzazione dell'errore di decodifica: " + eErr.getMessage(), eErr);
            }
            break block30;
            catch (Exception e) {
                try {
                    ControlStationCore.logError("Errore durante la decodifica: " + e.getMessage(), e);
                    messaggioEsito = "Si &egrave; verificato un errore durante la verifica dei certificati. Si prega di riprovare pi&ugrave; tardi.";
                    messageType = MessageType.ERROR.toString();
                }
                catch (Throwable var35_40) {
                    risposta = ServletUtils.getJson((String[])new String[]{ServletUtils.getJsonPair((String)"esito", messageType), ServletUtils.getJsonPair((String)"dettaglioEsito", (String)messaggioEsito)});
                    try {
                        outputStream = response.getOutputStream();
                        outputStream.write(risposta.getBytes());
                    }
                    catch (Exception eErr) {
                        ControlStationCore.logError("Errore durante la serializzazione dell'errore di decodifica: " + eErr.getMessage(), eErr);
                    }
                    throw var35_40;
                }
                risposta = ServletUtils.getJson((String[])new String[]{ServletUtils.getJsonPair((String)"esito", (String)messageType), ServletUtils.getJsonPair((String)"dettaglioEsito", (String)messaggioEsito)});
                try {
                    outputStream = response.getOutputStream();
                    outputStream.write(risposta.getBytes());
                }
                catch (Exception eErr) {
                    ControlStationCore.logError("Errore durante la serializzazione dell'errore di decodifica: " + eErr.getMessage(), eErr);
                }
            }
        }
    }
}

