/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.config.AttributeConfig;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.extractor.ValueExtractor;
import com.hazelcast.query.impl.DefaultArgumentParser;
import com.hazelcast.query.impl.getters.CompactGetter;
import com.hazelcast.query.impl.getters.ExtractorGetter;
import com.hazelcast.query.impl.getters.ExtractorHelper;
import com.hazelcast.query.impl.getters.Getter;
import com.hazelcast.query.impl.getters.GetterCache;
import com.hazelcast.query.impl.getters.JsonDataGetter;
import com.hazelcast.query.impl.getters.JsonGetter;
import com.hazelcast.query.impl.getters.PortableGetter;
import com.hazelcast.query.impl.getters.ReflectionHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class Extractors {
    final GetterCache getterCache;
    private volatile PortableGetter portableGetter;
    private volatile JsonDataGetter jsonDataGetter;
    private volatile CompactGetter compactGetter;
    private final Map<String, ValueExtractor> extractors;
    private final InternalSerializationService ss;
    private final DefaultArgumentParser argumentsParser;

    private Extractors(List<AttributeConfig> attributeConfigs, ClassLoader classLoader, InternalSerializationService ss, Supplier<GetterCache> getterCacheSupplier) {
        this.extractors = attributeConfigs == null ? Collections.emptyMap() : ExtractorHelper.instantiateExtractors(attributeConfigs, classLoader);
        this.getterCache = getterCacheSupplier.get();
        this.argumentsParser = new DefaultArgumentParser();
        this.ss = ss;
    }

    public Object extract(Object target, String attributeName, Object metadata) {
        return this.extract(target, attributeName, metadata, true);
    }

    public Object extract(Object target, String attributeName, Object metadata, boolean failOnMissingReflectiveAttribute) {
        Object targetObject = this.getTargetObject(target);
        if (targetObject != null) {
            Getter getter = this.getGetter(targetObject, attributeName, failOnMissingReflectiveAttribute);
            try {
                return getter.getValue(targetObject, attributeName, metadata);
            }
            catch (Exception ex) {
                throw new QueryException(ex);
            }
        }
        return null;
    }

    private Object getTargetObject(Object target) {
        Object targetData;
        if (target instanceof Portable && (targetData = this.ss.toData(target)).isPortable()) {
            return targetData;
        }
        if (target instanceof Data) {
            targetData = (Data)target;
            if (targetData.isPortable() || targetData.isJson() || targetData.isCompact()) {
                return targetData;
            }
            return this.ss.toObject(target);
        }
        return target;
    }

    Getter getGetter(Object targetObject, String attributeName, boolean failOnMissingReflectiveAttribute) {
        Getter getter = this.getterCache.getGetter(targetObject.getClass(), attributeName);
        if (getter == null && (getter = this.instantiateGetter(targetObject, attributeName, failOnMissingReflectiveAttribute)).isCacheable()) {
            this.getterCache.putGetter(targetObject.getClass(), attributeName, getter);
        }
        return getter;
    }

    private Getter instantiateGetter(Object targetObject, String attributeName, boolean failOnMissingReflectiveAttribute) {
        String attributeNameWithoutArguments = ExtractorHelper.extractAttributeNameNameWithoutArguments(attributeName);
        ValueExtractor valueExtractor = this.extractors.get(attributeNameWithoutArguments);
        if (valueExtractor != null) {
            Object arguments = this.argumentsParser.parse(ExtractorHelper.extractArgumentsFromAttributeName(attributeName));
            return new ExtractorGetter(this.ss, valueExtractor, arguments);
        }
        if (targetObject instanceof Data) {
            return this.instantiateGetterForData((Data)targetObject);
        }
        if (targetObject instanceof HazelcastJsonValue) {
            return JsonGetter.INSTANCE;
        }
        if (targetObject instanceof PortableGenericRecord) {
            if (this.portableGetter == null) {
                this.portableGetter = new PortableGetter(this.ss);
            }
            return this.portableGetter;
        }
        if (targetObject instanceof CompactGenericRecord) {
            if (this.compactGetter == null) {
                this.compactGetter = new CompactGetter(this.ss);
            }
            return this.compactGetter;
        }
        return ReflectionHelper.createGetter(targetObject, attributeName, failOnMissingReflectiveAttribute);
    }

    private Getter instantiateGetterForData(Data data) {
        if (data.isPortable()) {
            if (this.portableGetter == null) {
                this.portableGetter = new PortableGetter(this.ss);
            }
            return this.portableGetter;
        }
        if (data.isJson()) {
            if (this.jsonDataGetter == null) {
                this.jsonDataGetter = new JsonDataGetter(this.ss);
            }
            return this.jsonDataGetter;
        }
        if (data.isCompact()) {
            if (this.compactGetter == null) {
                this.compactGetter = new CompactGetter(this.ss);
            }
            return this.compactGetter;
        }
        throw new HazelcastSerializationException("No Data getter found for type " + data.getType());
    }

    public static Builder newBuilder(InternalSerializationService ss) {
        return new Builder(ss);
    }

    public static final class Builder {
        private ClassLoader classLoader;
        private List<AttributeConfig> attributeConfigs;
        private Supplier<GetterCache> getterCacheSupplier = GetterCache.EVICTABLE_GETTER_CACHE_SUPPLIER;
        private final InternalSerializationService ss;

        public Builder(InternalSerializationService ss) {
            this.ss = Preconditions.checkNotNull(ss);
        }

        public Builder setGetterCacheSupplier(Supplier<GetterCache> getterCacheSupplier) {
            this.getterCacheSupplier = getterCacheSupplier;
            return this;
        }

        public Builder setAttributeConfigs(List<AttributeConfig> attributeConfigs) {
            this.attributeConfigs = attributeConfigs;
            return this;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Extractors build() {
            return new Extractors(this.attributeConfigs, this.classLoader, this.ss, this.getterCacheSupplier);
        }
    }
}

