/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.allarmi.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.allarmi.dao.IAllarmeHistoryService;
import org.openspcoop2.core.allarmi.dao.IAllarmeHistoryServiceSearch;
import org.openspcoop2.core.allarmi.dao.IAllarmeService;
import org.openspcoop2.core.allarmi.dao.IAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.allarmi.dao.jdbc.converter.AllarmeFieldConverter;
import org.openspcoop2.core.allarmi.dao.jdbc.converter.AllarmeHistoryFieldConverter;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class AllarmiDriverUtils {
    private static String FREE_COUNTER_SEPARATOR_CHAR = "@";
    private static int FREE_COUNTER_SEPARATOR_CHAR_PAD = 19;

    public static List<Allarme> allarmiList(ISearch ricerca, RuoloPorta ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "allarmiList";
        int idLista = Liste.CONFIGURAZIONE_ALLARMI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterStato = SearchUtils.getFilter(ricerca, idLista, "filtroStato");
        log.debug("search : " + search);
        log.debug("filterStato : " + filterStato);
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeServiceSearch();
            IExpression expr = allarmiServiceSearch.newExpression();
            boolean addAnd = false;
            if (ruoloPorta != null && nomePorta != null) {
                expr.equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta.getValue()).and().equals(Allarme.model().FILTRO.NOME_PORTA, (Object)nomePorta);
                addAnd = true;
            } else {
                expr.isNull(Allarme.model().FILTRO.NOME_PORTA);
                addAnd = true;
            }
            if (!search.equals("")) {
                if (addAnd) {
                    expr.and();
                }
                expr.ilike(Allarme.model().ALIAS, search, LikeMode.ANYWHERE);
                addAnd = true;
            }
            if (filterStato != null && !filterStato.equals("")) {
                if (addAnd) {
                    expr.and();
                }
                if ("Abilitato".equals(filterStato)) {
                    expr.equals(Allarme.model().ENABLED, (Object)1);
                    addAnd = true;
                } else if ("Disabilitato".equals(filterStato)) {
                    expr.equals(Allarme.model().ENABLED, (Object)0);
                    addAnd = true;
                } else if ("Ok".equals(filterStato)) {
                    expr.equals(Allarme.model().ENABLED, (Object)1);
                    expr.and();
                    expr.equals(Allarme.model().STATO, (Object)AllarmiConverterUtils.toIntegerValue(StatoAllarme.OK));
                    addAnd = true;
                } else if ("Warning".equals(filterStato)) {
                    expr.equals(Allarme.model().ENABLED, (Object)1);
                    expr.and();
                    expr.equals(Allarme.model().STATO, (Object)AllarmiConverterUtils.toIntegerValue(StatoAllarme.WARNING));
                    addAnd = true;
                } else if ("Error".equals(filterStato)) {
                    expr.equals(Allarme.model().ENABLED, (Object)1);
                    expr.and();
                    expr.equals(Allarme.model().STATO, (Object)AllarmiConverterUtils.toIntegerValue(StatoAllarme.ERROR));
                    addAnd = true;
                }
                addAnd = true;
            }
            NonNegativeNumber count = allarmiServiceSearch.count(expr);
            ricerca.setNumEntries(idLista, (int)count.longValue());
            if (limit == 0) {
                limit = 1000;
            }
            IPaginatedExpression pagExpr = allarmiServiceSearch.toPaginatedExpression(expr);
            pagExpr.limit(limit).offset(offset);
            pagExpr.addOrder(Allarme.model().ALIAS, SortOrder.ASC);
            return allarmiServiceSearch.findAll(pagExpr);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void createAllarme(Allarme allarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "createAllarme";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeService allarmiService = jdbcServiceManager.getAllarmeService();
            allarmiService.create(allarme);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void updateAllarme(Allarme allarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "updateAllarme";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeService allarmiService = jdbcServiceManager.getAllarmeService();
            IdAllarme idAll = new IdAllarme();
            idAll.setNome(allarme.getNome());
            allarmiService.update(idAll, allarme);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void deleteAllarme(Allarme allarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "deleteAllarme";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeService allarmiService = jdbcServiceManager.getAllarmeService();
            allarmiService.delete(allarme);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static boolean existsAllarme(String nome, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "existsAllarme";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeServiceSearch();
            IExpression expr = allarmiServiceSearch.newExpression();
            expr.equals(Allarme.model().NOME, (Object)nome);
            NonNegativeNumber count = allarmiServiceSearch.count(expr);
            return count.longValue() > 0L;
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static Allarme getAllarme(String nome, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getAllarmeByNome";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeServiceSearch();
            IdAllarme id = new IdAllarme();
            id.setNome(nome);
            return (Allarme)allarmiServiceSearch.get(id);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static Allarme getAllarme(Long id, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getAllarme";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeServiceSearch();
            IExpression expr = allarmiServiceSearch.newExpression();
            AllarmeFieldConverter converter = new AllarmeFieldConverter(tipoDB);
            expr.equals((IField)new CustomField("id", Long.class, "id", converter.toTable((IModel)Allarme.model())), (Object)id);
            return (Allarme)allarmiServiceSearch.find(expr);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static Allarme getAllarmeByAlias(String alias, RuoloPorta ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getAllarmeByAlias";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expression = serviceManager.getAllarmeServiceSearch().newExpression();
            expression.and();
            expression.ilike(Allarme.model().ALIAS, alias, LikeMode.EXACT);
            if (ruoloPorta != null && nomePorta != null) {
                expression.equals(Allarme.model().FILTRO.ENABLED, (Object)true);
                expression.equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta);
                expression.equals(Allarme.model().FILTRO.NOME_PORTA, (Object)nomePorta);
            } else {
                expression.isNull(Allarme.model().FILTRO.NOME_PORTA);
            }
            return (Allarme)serviceManager.getAllarmeServiceSearch().find(expression);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Allarme non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static boolean existsAllarmi(TipoAllarme tipoAllarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "existsAllarmi";
        try {
            NonNegativeNumber count;
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeServiceSearch();
            IExpression expr = allarmiServiceSearch.newExpression();
            if (tipoAllarme != null) {
                expr.equals(Allarme.model().TIPO_ALLARME, (Object)tipoAllarme.getValue());
            }
            return (count = allarmiServiceSearch.count(expr)).longValue() > 0L;
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static long countAllarmi(TipoAllarme tipoAllarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "countAllarmi";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeServiceSearch();
            IExpression expr = allarmiServiceSearch.newExpression();
            if (tipoAllarme != null) {
                expr.equals(Allarme.model().TIPO_ALLARME, (Object)tipoAllarme.getValue());
            }
            NonNegativeNumber count = allarmiServiceSearch.count(expr);
            return count.longValue();
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void createHistoryAllarme(AllarmeHistory allarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "createHistoryAllarme";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeHistoryService allarmiService = jdbcServiceManager.getAllarmeHistoryService();
            allarmiService.create(allarme);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static List<AllarmeHistory> allarmiHistoryList(ISearch ricerca, Long idAllarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "allarmiHistoryList";
        int idLista = Liste.CONFIGURAZIONE_ALLARMI_HISTORY;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeHistoryServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeHistoryServiceSearch();
            IExpression expr = allarmiServiceSearch.newExpression();
            AllarmeHistoryFieldConverter converter = new AllarmeHistoryFieldConverter(tipoDB);
            CustomField cf = new CustomField("id_allarme", Long.class, "id_allarme", converter.toTable((IModel)AllarmeHistory.model()));
            expr.equals((IField)cf, (Object)idAllarme);
            NonNegativeNumber count = allarmiServiceSearch.count(expr);
            ricerca.setNumEntries(idLista, (int)count.longValue());
            if (limit == 0) {
                limit = 1000;
            }
            IPaginatedExpression pagExpr = allarmiServiceSearch.toPaginatedExpression(expr);
            pagExpr.limit(limit).offset(offset);
            pagExpr.addOrder(AllarmeHistory.model().TIMESTAMP_UPDATE, SortOrder.DESC);
            return allarmiServiceSearch.findAll(pagExpr);
        }
        catch (Exception qe) {
            throw new ServiceException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static String buildIdAlarm(String tipoPlugin, String serialId) {
        String idAlarm = tipoPlugin + FREE_COUNTER_SEPARATOR_CHAR + serialId;
        return idAlarm;
    }

    private static String normalizeAlarmInstanceSerialId(int value) {
        return StringUtils.leftPad((String)("" + value), (int)FREE_COUNTER_SEPARATOR_CHAR_PAD, (String)"0");
    }

    public static String incrementAlarmInstanceSerialId(String value) {
        int valueInt = 0;
        if (value != null && !"".equals(value)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if ('0' == c && sb.length() <= 0) continue;
                sb.append(c);
            }
            valueInt = Integer.valueOf(sb.toString());
        }
        return StringUtils.leftPad((String)("" + ++valueInt), (int)FREE_COUNTER_SEPARATOR_CHAR_PAD, (String)"0");
    }

    public static String getNextAlarmInstanceSerialId(String tipoPlugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getNextAlarmInstanceSerialId";
        try {
            int last;
            String s;
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IExpression pagExpr = jdbcServiceManager.getAllarmeServiceSearch().newExpression();
            pagExpr.and();
            pagExpr.equals(Allarme.model().TIPO, (Object)tipoPlugin);
            FunctionField ff = new FunctionField(Allarme.model().NOME, Function.MAX, "maxAlarmId");
            Object maxValue = null;
            try {
                maxValue = jdbcServiceManager.getAllarmeServiceSearch().aggregate(pagExpr, ff);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (maxValue != null && maxValue instanceof String && (s = (String)maxValue).contains(FREE_COUNTER_SEPARATOR_CHAR) && (last = s.lastIndexOf(FREE_COUNTER_SEPARATOR_CHAR)) < s.length() - 1) {
                String actualMaxValue = s.substring(s.lastIndexOf(FREE_COUNTER_SEPARATOR_CHAR) + 1, s.length());
                return AllarmiDriverUtils.incrementAlarmInstanceSerialId(actualMaxValue);
            }
            return AllarmiDriverUtils.normalizeAlarmInstanceSerialId(1);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static List<Allarme> configurazioneAllarmiList(ISearch ricerca, RuoloPorta ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB, String nomeMetodo, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws ServiceException {
        int idLista = Liste.CONFIGURAZIONE_ALLARMI;
        String search = null;
        int offset = 0;
        int limit = 0;
        if (ricerca != null) {
            search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            limit = ricerca.getPageSize(idLista);
            offset = ricerca.getIndexIniziale(idLista);
        }
        if (limit == 0) {
            limit = 1000;
        }
        log.debug("search : " + search);
        ArrayList<Allarme> listaAllarmi = new ArrayList<Allarme>();
        long count = 0L;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            if (ricerca != null) {
                ISQLQueryObject sqlQueryObject = AllarmiDriverUtils._prepareSqlQueryObjectAllarmi(tipoDB, ruoloPorta, nomePorta, search, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
                sqlQueryObject.addSelectCountField("nome", "allarmi");
                String query = sqlQueryObject.createSQLQuery();
                pstmt = con.prepareStatement(query);
                AllarmiDriverUtils._prepareStatementAllarmi(tipoDB, (PreparedStatement)pstmt, ruoloPorta, nomePorta, search, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getLong("allarmi");
                }
                rs.close();
                pstmt.close();
            }
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            ISQLQueryObject sqlQueryObject = AllarmiDriverUtils._prepareSqlQueryObjectAllarmi(tipoDB, ruoloPorta, nomePorta, search, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
            sqlQueryObject.addSelectField("allarmi", "nome");
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.addOrderBy("allarmi.nome", true);
            String query = sqlQueryObject.createSQLQuery();
            pstmt = con.prepareStatement(query);
            AllarmiDriverUtils._prepareStatementAllarmi(tipoDB, (PreparedStatement)pstmt, ruoloPorta, nomePorta, search, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String nomeAllarme = rs.getString("nome");
                IdAllarme idAllarmeAsObject = new IdAllarme();
                idAllarmeAsObject.setNome(nomeAllarme);
                Allarme allarme = (Allarme)serviceManager.getAllarmeServiceSearch().get(idAllarmeAsObject);
                listaAllarmi.add(allarme);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
        if (ricerca != null) {
            ricerca.setNumEntries(idLista, (int)count);
        }
        return listaAllarmi;
    }

    private static ISQLQueryObject _prepareSqlQueryObjectAllarmi(String tipoDB, RuoloPorta ruoloPorta, String nomePorta, String search, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable("allarmi");
        if (ruoloPorta != null && nomePorta != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo=?");
            sqlQueryObject.addWhereCondition("filtro_porta=?");
        } else if (ruoloPorta != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo=?");
        } else {
            sqlQueryObject.addWhereIsNullCondition("filtro_porta");
        }
        if (search != null && !"".equals(search)) {
            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("alias", search, false, true, true)});
        }
        if (filtroSoggettoFruitore != null) {
            if (filtroSoggettoFruitore.getTipo() != null) {
                sqlQueryObject.addWhereCondition("filtro_tipo_fruitore=?");
            }
            if (filtroSoggettoFruitore.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_nome_fruitore=?");
            }
        }
        if (filtroApplicativoFruitore != null) {
            if (filtroApplicativoFruitore.getIdSoggettoProprietario() != null) {
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getTipo() != null) {
                    sqlQueryObject.addWhereCondition("filtro_tipo_fruitore=?");
                }
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getNome() != null) {
                    sqlQueryObject.addWhereCondition("filtro_nome_fruitore=?");
                }
            }
            if (filtroApplicativoFruitore.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_sa_fruitore=?");
            }
        }
        if (filtroRuoloFruitore != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo_fruitore=?");
        }
        if (filtroSoggettoErogatore != null) {
            if (filtroSoggettoErogatore.getTipo() != null) {
                sqlQueryObject.addWhereCondition("filtro_tipo_erogatore=?");
            }
            if (filtroSoggettoErogatore.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_nome_erogatore=?");
            }
        }
        if (filtroRuoloErogatore != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo_erogatore=?");
        }
        if (filtroServizioAzione != null) {
            if (filtroServizioAzione.getSoggettoErogatore() != null) {
                if (filtroServizioAzione.getSoggettoErogatore().getTipo() != null) {
                    sqlQueryObject.addWhereCondition("filtro_tipo_erogatore=?");
                }
                if (filtroServizioAzione.getSoggettoErogatore().getNome() != null) {
                    sqlQueryObject.addWhereCondition("filtro_nome_erogatore=?");
                }
            }
            if (filtroServizioAzione.getTipo() != null) {
                sqlQueryObject.addWhereCondition("filtro_tipo_servizio=?");
            }
            if (filtroServizioAzione.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_nome_servizio=?");
            }
            if (filtroServizioAzione.getVersione() != null) {
                sqlQueryObject.addWhereCondition("filtro_versione_servizio=?");
            }
            if (filtroServizioAzione.getAzione() != null) {
                ISQLQueryObject sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObjectOr.setANDLogicOperator(false);
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", filtroServizioAzione.getAzione(), false, false);
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", filtroServizioAzione.getAzione() + ",", LikeConfig.startsWith((boolean)false));
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", "," + filtroServizioAzione.getAzione(), LikeConfig.endsWith((boolean)false));
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", "," + filtroServizioAzione.getAzione() + ",", true, false);
                sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
            }
        }
        if (filtroRuolo != null) {
            sqlQueryObject.addWhereCondition(false, new String[]{"filtro_ruolo_fruitore=?", "filtro_ruolo_erogatore=?"});
        }
        return sqlQueryObject;
    }

    private static void _prepareStatementAllarmi(String tipoDB, PreparedStatement pstmt, RuoloPorta ruoloPorta, String nomePorta, String search, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws Exception {
        int index = 1;
        if (ruoloPorta != null && nomePorta != null) {
            pstmt.setString(index++, ruoloPorta.getValue());
            pstmt.setString(index++, nomePorta);
        } else if (ruoloPorta != null) {
            pstmt.setString(index++, ruoloPorta.getValue());
        }
        if (filtroSoggettoFruitore != null) {
            if (filtroSoggettoFruitore.getTipo() != null) {
                pstmt.setString(index++, filtroSoggettoFruitore.getTipo());
            }
            if (filtroSoggettoFruitore.getNome() != null) {
                pstmt.setString(index++, filtroSoggettoFruitore.getNome());
            }
        }
        if (filtroApplicativoFruitore != null) {
            if (filtroApplicativoFruitore.getIdSoggettoProprietario() != null) {
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getTipo() != null) {
                    pstmt.setString(index++, filtroApplicativoFruitore.getIdSoggettoProprietario().getTipo());
                }
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getNome() != null) {
                    pstmt.setString(index++, filtroApplicativoFruitore.getIdSoggettoProprietario().getNome());
                }
            }
            if (filtroApplicativoFruitore.getNome() != null) {
                pstmt.setString(index++, filtroApplicativoFruitore.getNome());
            }
        }
        if (filtroRuoloFruitore != null) {
            pstmt.setString(index++, filtroRuoloFruitore);
        }
        if (filtroSoggettoErogatore != null) {
            if (filtroSoggettoErogatore.getTipo() != null) {
                pstmt.setString(index++, filtroSoggettoErogatore.getTipo());
            }
            if (filtroSoggettoErogatore.getNome() != null) {
                pstmt.setString(index++, filtroSoggettoErogatore.getNome());
            }
        }
        if (filtroRuoloErogatore != null) {
            pstmt.setString(index++, filtroRuoloErogatore);
        }
        if (filtroServizioAzione != null) {
            if (filtroServizioAzione.getSoggettoErogatore() != null) {
                if (filtroServizioAzione.getSoggettoErogatore().getTipo() != null) {
                    pstmt.setString(index++, filtroServizioAzione.getSoggettoErogatore().getTipo());
                }
                if (filtroServizioAzione.getSoggettoErogatore().getNome() != null) {
                    pstmt.setString(index++, filtroServizioAzione.getSoggettoErogatore().getNome());
                }
            }
            if (filtroServizioAzione.getTipo() != null) {
                pstmt.setString(index++, filtroServizioAzione.getTipo());
            }
            if (filtroServizioAzione.getNome() != null) {
                pstmt.setString(index++, filtroServizioAzione.getNome());
            }
            if (filtroServizioAzione.getVersione() != null) {
                pstmt.setInt(index++, filtroServizioAzione.getVersione());
            }
            if (filtroServizioAzione.getAzione() != null) {
                // empty if block
            }
        }
        if (filtroRuolo != null) {
            pstmt.setString(index++, filtroRuolo);
            pstmt.setString(index++, filtroRuolo);
        }
    }

    public static List<Allarme> allarmiForPolicyRateLimiting(String activeIdPolicy, RuoloPorta ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "allarmiForPolicyRateLimiting";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManager = new JDBCServiceManager(con, properties, log);
            IAllarmeServiceSearch allarmiServiceSearch = jdbcServiceManager.getAllarmeServiceSearch();
            IExpression expr = allarmiServiceSearch.newExpression();
            expr.and();
            if (ruoloPorta != null && nomePorta != null) {
                expr.equals(Allarme.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta.getValue()).and().equals(Allarme.model().FILTRO.NOME_PORTA, (Object)nomePorta);
            } else {
                expr.isNull(Allarme.model().FILTRO.NOME_PORTA);
            }
            expr.equals(Allarme.model().ALLARME_PARAMETRO.ID_PARAMETRO, (Object)"aPluginPolicyId");
            if (activeIdPolicy != null) {
                expr.like(Allarme.model().ALLARME_PARAMETRO.VALORE, activeIdPolicy, LikeMode.EXACT);
            } else {
                expr.isNull(Allarme.model().ALLARME_PARAMETRO.VALORE);
            }
            IPaginatedExpression pagExpr = allarmiServiceSearch.toPaginatedExpression(expr);
            pagExpr.addOrder(Allarme.model().ALIAS, SortOrder.ASC);
            return allarmiServiceSearch.findAll(pagExpr);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }
}

