/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.resources.MapReader;
import org.slf4j.Logger;

public class ProtocolFactoryReflectionUtils {
    public static void initializeProtocolManager(String protocolloDefault, Logger log) throws CoreException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = null;
            try {
                protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (protocolFactoryManager == null) {
                Class<?> cConfigurazionePdD = Class.forName("org.openspcoop2.protocol.sdk.ConfigurazionePdD");
                Object configurazionePdD = ClassLoaderUtilities.newInstance(cConfigurazionePdD);
                Object confDir = null;
                cConfigurazionePdD.getMethod("setConfigurationDir", String.class).invoke(configurazionePdD, confDir);
                cConfigurazionePdD.getMethod("setAttesaAttivaJDBC", Long.TYPE).invoke(configurazionePdD, 60);
                cConfigurazionePdD.getMethod("setCheckIntervalJDBC", Integer.TYPE).invoke(configurazionePdD, 100);
                cConfigurazionePdD.getMethod("setLoader", Loader.class).invoke(configurazionePdD, new Loader());
                cConfigurazionePdD.getMethod("setLog", Logger.class).invoke(configurazionePdD, log);
                cProtocolFactoryManager.getMethod("initialize", Logger.class, cConfigurazionePdD, String.class).invoke(null, log, configurazionePdD, protocolloDefault);
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }

    public static List<String> getProtocolli() throws Exception {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Enumeration protocolli = (Enumeration)cProtocolFactoryManager.getMethod("getProtocolNames", new Class[0]).invoke(protocolFactoryManager, new Object[0]);
            ArrayList<String> l = new ArrayList<String>();
            while (protocolli.hasMoreElements()) {
                String protocollo = (String)protocolli.nextElement();
                l.add(protocollo);
            }
            return l;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }

    public static String getCodiceIPADefault(IDSoggetto idSoggetto) throws CoreException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            String protocollo = (String)cProtocolFactoryManager.getMethod("getProtocolByOrganizationType", String.class).invoke(protocolFactoryManager, idSoggetto.getTipo());
            Class<?> cProtocolFactory = Class.forName("org.openspcoop2.protocol.sdk.IProtocolFactory");
            Object protocolFactory = cProtocolFactoryManager.getMethod("getProtocolFactoryByName", String.class).invoke(protocolFactoryManager, protocollo);
            Class<?> cProtocolTraduttore = Class.forName("org.openspcoop2.protocol.sdk.config.ITraduttore");
            Object protocolTraduttore = cProtocolFactory.getMethod("createTraduttore", new Class[0]).invoke(protocolFactory, new Object[0]);
            return (String)cProtocolTraduttore.getMethod("getIdentificativoCodiceIPADefault", IDSoggetto.class, Boolean.TYPE).invoke(protocolTraduttore, idSoggetto, false);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }

    public static String getIdentificativoPortaDefault(IDSoggetto idSoggetto) throws CoreException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            String protocollo = (String)cProtocolFactoryManager.getMethod("getProtocolByOrganizationType", String.class).invoke(protocolFactoryManager, idSoggetto.getTipo());
            Class<?> cProtocolFactory = Class.forName("org.openspcoop2.protocol.sdk.IProtocolFactory");
            Object protocolFactory = cProtocolFactoryManager.getMethod("getProtocolFactoryByName", String.class).invoke(protocolFactoryManager, protocollo);
            Class<?> cProtocolTraduttore = Class.forName("org.openspcoop2.protocol.sdk.config.ITraduttore");
            Object protocolTraduttore = cProtocolFactory.getMethod("createTraduttore", new Class[0]).invoke(protocolFactory, new Object[0]);
            return (String)cProtocolTraduttore.getMethod("getIdentificativoPortaDefault", IDSoggetto.class).invoke(protocolTraduttore, idSoggetto);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }

    public static List<String> getOrganizationTypes(String protocollo) throws CoreException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            MapReader map = (MapReader)cProtocolFactoryManager.getMethod("getOrganizationTypes", new Class[0]).invoke(protocolFactoryManager, new Object[0]);
            return (List)map.get((Object)protocollo);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }

    public static List<String> getServiceTypes(String protocollo) throws CoreException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            HashMap map = (HashMap)cProtocolFactoryManager.getMethod("_getServiceTypes", new Class[0]).invoke(protocolFactoryManager, new Object[0]);
            return (List)map.get(protocollo);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }
}

