/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class SQLScriptBuilder {
    private static final String UPGRADE_PREFIX = "upgrade_";

    public static void main(String[] args) throws Exception {
        String sqlSourceDir = args[0];
        String sqlDestDir = args[1];
        String sqlScriptName = args[2];
        String modalitaInstallazione = args[3];
        boolean splitDdlDml = true;
        String versionePrecedente = null;
        String versioneAttuale = null;
        String tipoDatabase = null;
        String configurazioneUpgrade = null;
        boolean configurazioneUpgradeRuntime = true;
        boolean configurazioneUpgradeConfig = true;
        boolean configurazioneUpgradeTracce = true;
        boolean configurazioneUpgradeStatistiche = true;
        boolean configurazioneUpgradeMonitoraggio = true;
        if (args.length > 4) {
            File f;
            versionePrecedente = args[4];
            versioneAttuale = args[5];
            tipoDatabase = args[6];
            if ("aggiornamento".equals(modalitaInstallazione) && args.length > 7 && (f = new File(configurazioneUpgrade = args[7])).exists()) {
                try (FileInputStream fin = new FileInputStream(f);){
                    Properties p = new Properties();
                    p.load(fin);
                    configurazioneUpgradeRuntime = SQLScriptBuilder.readBooleanProperty(p, "upgrade.runtime");
                    configurazioneUpgradeConfig = SQLScriptBuilder.readBooleanProperty(p, "upgrade.configurazione");
                    configurazioneUpgradeTracce = SQLScriptBuilder.readBooleanProperty(p, "upgrade.tracciamento");
                    configurazioneUpgradeStatistiche = SQLScriptBuilder.readBooleanProperty(p, "upgrade.statistiche");
                    configurazioneUpgradeMonitoraggio = SQLScriptBuilder.readBooleanProperty(p, "upgrade.monitoraggio");
                }
            }
        }
        if ("nuova".equals(modalitaInstallazione)) {
            SQLScriptBuilder.buildSqlNuovaInstallazione(new File(sqlSourceDir), new File(sqlDestDir), sqlScriptName, splitDdlDml);
        } else if ("aggiornamento".equals(modalitaInstallazione)) {
            SQLScriptBuilder.buildSqlAggiornamento(new File(sqlSourceDir), new File(sqlDestDir), sqlScriptName, versionePrecedente, versioneAttuale, tipoDatabase, configurazioneUpgradeRuntime, configurazioneUpgradeConfig, configurazioneUpgradeTracce, configurazioneUpgradeStatistiche, configurazioneUpgradeMonitoraggio);
        } else {
            throw new CoreException("Modalit\u00e0 installazione [" + modalitaInstallazione + "] sconosciuta");
        }
    }

    private static boolean readBooleanProperty(Properties p, String name) throws CoreException {
        String tmp = p.getProperty(name);
        if (tmp == null) {
            throw new CoreException("Configurazione Upgrade non corretta, propriet\u00e0 [" + name + "] non presente");
        }
        tmp = tmp.trim();
        try {
            return Boolean.valueOf(tmp);
        }
        catch (Exception e) {
            throw new CoreException("Configurazione Upgrade non corretta, propriet\u00e0 [" + name + "] non corretta: " + e.getMessage(), e);
        }
    }

    private static void buildSqlNuovaInstallazione(File sqlSourceDir, File sqlDestDir, String sqlScriptName, boolean splitDdlDml) throws CoreException, UtilsException, IOException {
        if (!sqlSourceDir.exists()) {
            throw new CoreException("Source dir [" + sqlSourceDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlSourceDir.canRead()) {
            throw new CoreException("Source dir [" + sqlSourceDir.getAbsolutePath() + "] cannot read");
        }
        if (!sqlDestDir.exists()) {
            throw new CoreException("Dest dir [" + sqlDestDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlDestDir.canWrite()) {
            throw new CoreException("Dest dir [" + sqlDestDir.getAbsolutePath() + "] cannot write");
        }
        int prefix = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        File[] f = sqlSourceDir.listFiles();
        if (f != null) {
            for (int i = 0; i < f.length; ++i) {
                if (!f[i].isFile()) continue;
                SQLScriptBuilder.createSqlEngine(sqlSourceDir, f[i].getName(), sqlDestDir, sqlScriptName, prefix, bout, splitDdlDml);
            }
        }
        File dest = new File(sqlDestDir, sqlScriptName);
        bout.flush();
        bout.close();
        FileSystemUtilities.writeFile((File)dest, (byte[])bout.toByteArray());
        if (splitDdlDml) {
            File destInit = new File(sqlDestDir, dest.getName().replace(".sql", "_init.sql"));
            SQLScriptBuilder.splitFileForDDLtoDML(dest, dest, destInit);
        }
    }

    private static void buildSqlAggiornamento(File sqlSourceDir, File sqlDestDir, String sqlScriptName, String precedenteVersione, String versioneAttuale, String tipoDatabase, boolean configurazioneUpgradeRuntime, boolean configurazioneUpgradeConfig, boolean configurazioneUpgradeTracce, boolean configurazioneUpgradeStatistiche, boolean configurazioneUpgradeMonitoraggio) throws CoreException, IOException, UtilsException {
        if (!sqlSourceDir.exists()) {
            throw new CoreException("Source dir [" + sqlSourceDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlSourceDir.canRead()) {
            throw new CoreException("Source dir [" + sqlSourceDir.getAbsolutePath() + "] cannot read");
        }
        if (!sqlDestDir.exists()) {
            throw new CoreException("Dest dir [" + sqlDestDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlDestDir.canWrite()) {
            throw new CoreException("Dest dir [" + sqlDestDir.getAbsolutePath() + "] cannot write");
        }
        if (precedenteVersione == null) {
            throw new CoreException("Precedente versione non fornita");
        }
        if (!precedenteVersione.contains(".")) {
            throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] ('.' not found)");
        }
        int indexOfFirstPoint = precedenteVersione.indexOf(".");
        if (indexOfFirstPoint <= 0) {
            throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] ('.' not found with index)");
        }
        String productVersionString = precedenteVersione.substring(0, indexOfFirstPoint);
        int productVersion = -1;
        try {
            productVersion = Integer.parseInt(productVersionString);
        }
        catch (Exception e) {
            throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] (productVersion:" + productVersionString + "): " + e.getMessage(), e);
        }
        int indexOfSecondPoint = precedenteVersione.indexOf(".", indexOfFirstPoint + 1);
        if (indexOfSecondPoint <= 0 || indexOfSecondPoint <= indexOfFirstPoint) {
            throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] (second '.' not found)");
        }
        String majorVersionString = precedenteVersione.substring(indexOfFirstPoint + 1, indexOfSecondPoint);
        int majorVersion = -1;
        try {
            majorVersion = Integer.parseInt(majorVersionString);
        }
        catch (Exception e) {
            throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] (majorVersion:" + majorVersionString + "): " + e.getMessage(), e);
        }
        if (precedenteVersione.length() <= indexOfSecondPoint) {
            throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] (length)");
        }
        String minorVersionString = precedenteVersione.substring(indexOfSecondPoint + 1, precedenteVersione.length());
        int minorVersion = -1;
        try {
            minorVersion = Integer.parseInt(minorVersionString);
        }
        catch (Exception e) {
            if (minorVersionString.contains("_")) {
                String newMinor = minorVersionString.split("_")[0];
                try {
                    minorVersion = Integer.parseInt(newMinor);
                }
                catch (Exception eInternal) {
                    throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] (minorVersion:" + minorVersionString + " minorVersionBuildNumber:" + newMinor + "): " + eInternal.getMessage(), eInternal);
                }
            }
            throw new CoreException("Precedente versione in un formato non corretto [" + precedenteVersione + "] (minorVersion:" + minorVersionString + "): " + e.getMessage(), e);
        }
        int tmpMajorVersion = majorVersion;
        int tmpMinorVersion = minorVersion;
        if (tipoDatabase == null) {
            throw new CoreException("TipoDatabase non fornito");
        }
        TipiDatabase tipiDatabase = TipiDatabase.toEnumConstant((String)tipoDatabase);
        if (TipiDatabase.DEFAULT.equals((Object)tipiDatabase)) {
            throw new CoreException("TipoDatabase fornito [" + tipoDatabase + "] non valido");
        }
        HashSet<String> processedSqlFiles = new HashSet<String>();
        SQLScriptBuilder.populateProcessedFilesFromPreviousVersions(sqlSourceDir, productVersion, majorVersion, minorVersion, tipoDatabase, processedSqlFiles);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        File infoVersion = null;
        while (true) {
            File tmp;
            String nextVersion;
            String actualVersion;
            File version;
            if ((version = new File(sqlSourceDir, UPGRADE_PREFIX + (actualVersion = productVersion + "." + tmpMajorVersion + "." + tmpMinorVersion) + "_to_" + (nextVersion = productVersion + "." + tmpMajorVersion + "." + (tmpMinorVersion + 1)))).exists()) {
                if (!version.canRead()) {
                    throw new CoreException("Source version dir [" + version.getAbsolutePath() + "] cannot read");
                }
                tmp = SQLScriptBuilder.createSqlAggiornamentoEngine(version, sqlDestDir, bout, nextVersion, tipoDatabase, configurazioneUpgradeRuntime, configurazioneUpgradeConfig, configurazioneUpgradeTracce, configurazioneUpgradeStatistiche, configurazioneUpgradeMonitoraggio, processedSqlFiles);
                if (tmp != null) {
                    infoVersion = tmp;
                }
                ++tmpMinorVersion;
                continue;
            }
            actualVersion = productVersion + "." + tmpMajorVersion + ".x";
            version = new File(sqlSourceDir, UPGRADE_PREFIX + actualVersion + "_to_" + (nextVersion = productVersion + "." + (tmpMajorVersion + 1) + ".0"));
            if (!version.exists()) break;
            if (!version.canRead()) {
                throw new CoreException("Source version dir [" + version.getAbsolutePath() + "] cannot read");
            }
            tmp = SQLScriptBuilder.createSqlAggiornamentoEngine(version, sqlDestDir, bout, nextVersion, tipoDatabase, configurazioneUpgradeRuntime, configurazioneUpgradeConfig, configurazioneUpgradeTracce, configurazioneUpgradeStatistiche, configurazioneUpgradeMonitoraggio, processedSqlFiles);
            if (tmp != null) {
                infoVersion = tmp;
            }
            ++tmpMajorVersion;
            tmpMinorVersion = 0;
        }
        if (infoVersion != null) {
            byte[] content = FileSystemUtilities.readBytesFromFile((File)infoVersion);
            bout.write("\n\n".getBytes());
            bout.write(content);
        }
        bout.flush();
        bout.close();
        String destFileScriptSql = sqlScriptName.replace(".sql", "_upgrade_" + versioneAttuale + ".sql");
        FileSystemUtilities.writeFile((File)new File(sqlDestDir, destFileScriptSql), (byte[])bout.toByteArray());
    }

    private static File createSqlAggiornamentoEngine(File sqlVersionSourceDir, File sqlDestDir, ByteArrayOutputStream bout, String nextVersion, String tipoDatabase, boolean configurazioneUpgradeRuntime, boolean configurazioneUpgradeConfig, boolean configurazioneUpgradeTracce, boolean configurazioneUpgradeStatistiche, boolean configurazioneUpgradeMonitoraggio, Set<String> processedSqlFiles) throws IOException, CoreException, UtilsException {
        File sqlVersionSourceDirInfoVersioneUpgrade;
        File sqlVersionSourceDirDatabase;
        Object[] files;
        if (sqlDestDir != null) {
            // empty if block
        }
        if ((files = (sqlVersionSourceDirDatabase = new File(sqlVersionSourceDir, tipoDatabase)).listFiles()) != null && files.length > 0) {
            boolean writeUpgrade = false;
            boolean atLeastOneFileProcessed = false;
            Arrays.sort(files);
            for (Object upgradeFile : files) {
                String fileChecksum;
                if ((!((File)upgradeFile).getName().contains("-runtimePdD-") ? (!((File)upgradeFile).getName().contains("-archiviComunicazioni-") ? (!((File)upgradeFile).getName().contains("-informazioniStatistiche-") ? (!((File)upgradeFile).getName().contains("-monitoraggio-") ? !configurazioneUpgradeConfig : !configurazioneUpgradeMonitoraggio) : !configurazioneUpgradeStatistiche) : !configurazioneUpgradeTracce) : !configurazioneUpgradeRuntime) || processedSqlFiles.contains(fileChecksum = SQLScriptBuilder.calculateFileChecksum((File)upgradeFile))) continue;
                if (!writeUpgrade) {
                    if (bout != null) {
                        if (bout.size() > 0) {
                            bout.write("\n\n".getBytes());
                        }
                        bout.write("-- Upgrade to ".getBytes());
                        bout.write(nextVersion.getBytes());
                        bout.write("\n".getBytes());
                    }
                    writeUpgrade = true;
                }
                SQLScriptBuilder.createSqlAggiornamentoEngine((File)upgradeFile, bout);
                processedSqlFiles.add(fileChecksum);
                atLeastOneFileProcessed = true;
            }
            if (!atLeastOneFileProcessed && bout != null) {
                if (bout.size() > 0) {
                    bout.write("\n\n".getBytes());
                }
                bout.write("-- Upgrade to ".getBytes());
                bout.write(nextVersion.getBytes());
                bout.write("\n".getBytes());
            }
        }
        if ((sqlVersionSourceDirInfoVersioneUpgrade = new File(sqlVersionSourceDir, "info-patch.sql")).exists()) {
            return sqlVersionSourceDirInfoVersioneUpgrade;
        }
        return null;
    }

    private static void createSqlEngine(File sqlSourceDir, String sourceFile, File sqlDestDir, String destFile, int prefix, ByteArrayOutputStream bout, boolean splitDdlDml) throws UtilsException, IOException {
        File src = new File(sqlSourceDir, sourceFile);
        if (bout != null) {
            byte[] b = FileSystemUtilities.readBytesFromFile((File)src);
            if (bout.size() > 0) {
                bout.write("\n\n".getBytes());
            }
            bout.write(b);
        } else {
            File dest = new File(sqlDestDir, SQLScriptBuilder.parsePrefix(prefix) + destFile);
            FileSystemUtilities.copy((File)src, (File)dest);
            if (splitDdlDml) {
                File destInit = new File(sqlDestDir, dest.getName().replace(".sql", "_init.sql"));
                SQLScriptBuilder.splitFileForDDLtoDML(dest, dest, destInit);
            }
        }
    }

    private static void createSqlAggiornamentoEngine(File upgradeFile, ByteArrayOutputStream bout) throws CoreException, UtilsException, IOException {
        if (bout == null) {
            throw new CoreException("Param bout is null");
        }
        byte[] b = FileSystemUtilities.readBytesFromFile((File)upgradeFile);
        if (bout.size() > 0) {
            bout.write("\n\n".getBytes());
        }
        bout.write(b);
    }

    private static String parsePrefix(int prefix) {
        if (prefix < 10) {
            return "0" + prefix + "_";
        }
        return prefix + "_";
    }

    private static String calculateFileChecksum(File file) throws CoreException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] fileBytes = FileSystemUtilities.readBytesFromFile((File)file);
            byte[] hashBytes = digest.digest(fileBytes);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new CoreException("Errore nel calcolo del checksum del file [" + file.getAbsolutePath() + "]: " + e.getMessage(), e);
        }
    }

    private static void populateProcessedFilesFromPreviousVersions(File sqlSourceDir, int productVersion, int startMajorVersion, int startMinorVersion, String tipoDatabase, Set<String> processedSqlFiles) throws CoreException {
        int[] baselineVersion = SQLScriptBuilder.readBaselineVersionFromCurrentUpgradeDir(sqlSourceDir, productVersion, startMajorVersion, startMinorVersion);
        int effectiveMajorVersion = baselineVersion[0];
        int effectiveMinorVersion = baselineVersion[1];
        int tmpMajorVersion = 0;
        int tmpMinorVersion = 0;
        boolean continueScanning = true;
        while (continueScanning) {
            if (tmpMajorVersion == effectiveMajorVersion && tmpMinorVersion == effectiveMinorVersion) {
                continueScanning = false;
                continue;
            }
            boolean processed = SQLScriptBuilder.scanMinorVersionUpgrade(sqlSourceDir, productVersion, tmpMajorVersion, tmpMinorVersion, tipoDatabase, processedSqlFiles);
            if (processed) {
                ++tmpMinorVersion;
                continue;
            }
            if (tmpMajorVersion > effectiveMajorVersion || tmpMajorVersion == effectiveMajorVersion && tmpMinorVersion > effectiveMinorVersion) {
                continueScanning = false;
                continue;
            }
            if (++tmpMinorVersion <= 200) continue;
            tmpMinorVersion = 0;
            if (++tmpMajorVersion <= effectiveMajorVersion) continue;
            continueScanning = false;
        }
    }

    private static int[] readBaselineVersionFromCurrentUpgradeDir(File sqlSourceDir, int productVersion, int startMajorVersion, int startMinorVersion) throws CoreException {
        File baselineFile;
        String toVersion;
        String fromVersion = productVersion + "." + startMajorVersion + "." + startMinorVersion;
        File currentUpgradeDir = new File(sqlSourceDir, UPGRADE_PREFIX + fromVersion + "_to_" + (toVersion = productVersion + "." + startMajorVersion + "." + (startMinorVersion + 1)));
        if (!currentUpgradeDir.exists()) {
            fromVersion = productVersion + "." + startMajorVersion + ".x";
            toVersion = productVersion + "." + (startMajorVersion + 1) + ".0";
            currentUpgradeDir = new File(sqlSourceDir, UPGRADE_PREFIX + fromVersion + "_to_" + toVersion);
        }
        if (!(baselineFile = new File(currentUpgradeDir, "baseline-version.txt")).exists()) {
            return new int[]{startMajorVersion, startMinorVersion};
        }
        return SQLScriptBuilder.parseBaselineVersionFile(baselineFile, productVersion);
    }

    private static int[] parseBaselineVersionFile(File baselineFile, int productVersion) throws CoreException {
        BufferedReader br = null;
        try {
            int baselineMinor;
            int baselineMajor;
            int baselineProductVersion;
            br = new BufferedReader(new FileReader(baselineFile));
            String baselineVersionString = br.readLine();
            if (baselineVersionString == null || baselineVersionString.trim().isEmpty()) {
                throw new CoreException("File baseline-version.txt [" + baselineFile.getAbsolutePath() + "] vuoto o non contiene una versione valida");
            }
            if (!(baselineVersionString = baselineVersionString.trim()).contains(".")) {
                throw new CoreException("Baseline version [" + baselineVersionString + "] in formato non corretto: '.' non trovato");
            }
            int firstDot = baselineVersionString.indexOf(".");
            int secondDot = baselineVersionString.indexOf(".", firstDot + 1);
            if (secondDot <= firstDot) {
                throw new CoreException("Baseline version [" + baselineVersionString + "] in formato non corretto: secondo '.' non trovato");
            }
            String productVersionString = baselineVersionString.substring(0, firstDot);
            try {
                baselineProductVersion = Integer.parseInt(productVersionString);
            }
            catch (Exception e) {
                throw new CoreException("Baseline version [" + baselineVersionString + "] product version [" + productVersionString + "] non valida: " + e.getMessage(), e);
            }
            if (baselineProductVersion != productVersion) {
                throw new CoreException("Baseline version [" + baselineVersionString + "] ha product version [" + baselineProductVersion + "] diversa da quella attesa [" + productVersion + "]");
            }
            String majorString = baselineVersionString.substring(firstDot + 1, secondDot);
            String minorString = baselineVersionString.substring(secondDot + 1);
            try {
                baselineMajor = Integer.parseInt(majorString);
            }
            catch (Exception e) {
                throw new CoreException("Baseline version [" + baselineVersionString + "] major version [" + majorString + "] non valida: " + e.getMessage(), e);
            }
            try {
                baselineMinor = Integer.parseInt(minorString);
            }
            catch (Exception e) {
                throw new CoreException("Baseline version [" + baselineVersionString + "] minor version [" + minorString + "] non valida: " + e.getMessage(), e);
            }
            int[] nArray = new int[]{baselineMajor, baselineMinor};
            return nArray;
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CoreException("Errore nella lettura del file baseline-version.txt [" + baselineFile.getAbsolutePath() + "]: " + e.getMessage(), e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static boolean scanMinorVersionUpgrade(File sqlSourceDir, int productVersion, int tmpMajorVersion, int tmpMinorVersion, String tipoDatabase, Set<String> processedSqlFiles) throws CoreException {
        String nextVersion;
        String actualVersion = productVersion + "." + tmpMajorVersion + "." + tmpMinorVersion;
        File version = new File(sqlSourceDir, UPGRADE_PREFIX + actualVersion + "_to_" + (nextVersion = productVersion + "." + tmpMajorVersion + "." + (tmpMinorVersion + 1)));
        if (version.exists() && version.canRead()) {
            SQLScriptBuilder.addChecksumsFromDirectory(version, tipoDatabase, processedSqlFiles);
            return true;
        }
        return false;
    }

    private static void addChecksumsFromDirectory(File versionDir, String tipoDatabase, Set<String> processedSqlFiles) throws CoreException {
        File sqlVersionSourceDirDatabase = new File(versionDir, tipoDatabase);
        File[] files = sqlVersionSourceDirDatabase.listFiles();
        if (files != null && files.length > 0) {
            for (File upgradeFile : files) {
                String fileChecksum = SQLScriptBuilder.calculateFileChecksum(upgradeFile);
                processedSqlFiles.add(fileChecksum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void splitFileForDDLtoDML(File sqlFile, File sqlFileDest, File sqlFileInitDest) throws IOException, UtilsException {
        boolean dmlOpen = false;
        ByteArrayOutputStream boutDDL = new ByteArrayOutputStream();
        ByteArrayOutputStream boutDML = new ByteArrayOutputStream();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(sqlFile));
            while ((line = br.readLine()) != null) {
                if (dmlOpen) {
                    boutDML.write(line.getBytes());
                    boutDML.write("\n".getBytes());
                    if (!line.contains(";")) continue;
                    dmlOpen = false;
                    continue;
                }
                if (SQLScriptBuilder.isDML(line)) {
                    dmlOpen = true;
                    boutDML.write(line.getBytes());
                    boutDML.write("\n".getBytes());
                    if (!line.contains(";")) continue;
                    dmlOpen = false;
                    continue;
                }
                boutDDL.write(line.getBytes());
                boutDDL.write("\n".getBytes());
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Throwable throwable) {}
        }
        if (boutDDL.size() > 0) {
            FileSystemUtilities.writeFile((File)sqlFileDest, (byte[])boutDDL.toByteArray());
        }
        if (boutDML.size() > 0) {
            FileSystemUtilities.writeFile((File)sqlFileInitDest, (byte[])boutDML.toByteArray());
        }
    }

    private static boolean isDML(String line) {
        Object tmp = line;
        if (((String)(tmp = ((String)tmp).trim().toLowerCase())).startsWith("insert ")) {
            if (((String)tmp).contains("_init_seq ") && ((String)tmp).contains("next value ")) {
                return false;
            }
            return !((String)tmp).contains("insert on ");
        }
        if (((String)tmp).startsWith("update ")) {
            return true;
        }
        if (((String)tmp).startsWith("delete ")) {
            return !((String)tmp).contains("on delete cascade");
        }
        return false;
    }
}

