/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.constants;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.beans.IEnumeration;
import org.openspcoop2.generic_project.exception.NotFoundException;

public enum TipoBehaviour implements IEnumeration,
Serializable,
Cloneable
{
    CONSEGNA_LOAD_BALANCE("__loadBalance", "Load Balance"),
    CONSEGNA_MULTIPLA("__multi", "Consegna Multipla"),
    CONSEGNA_CONDIZIONALE("__conditional", "Consegna Condizionale"),
    CONSEGNA_CON_NOTIFICHE("__notify", "Consegna con Notifiche"),
    CUSTOM("__custom", "Personalizzata");

    private String value;
    private String label;

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    private TipoBehaviour(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(String object) {
        if (object == null) {
            return false;
        }
        return object.equals(this.getValue());
    }

    public boolean equals(Object object, List<String> fieldsNotCheck) {
        if (!(object instanceof TipoBehaviour)) {
            throw new RuntimeException("Wrong type: " + object.getClass().getName());
        }
        return this.equals((TipoBehaviour)object);
    }

    public String toString(boolean reportHTML) {
        return this.toString();
    }

    public String toString(boolean reportHTML, List<String> fieldsNotIncluded) {
        return this.toString();
    }

    public String diff(Object object, StringBuilder bf, boolean reportHTML) {
        return bf.toString();
    }

    public String diff(Object object, StringBuilder bf, boolean reportHTML, List<String> fieldsNotIncluded) {
        return bf.toString();
    }

    public static List<TipoBehaviour> getEnums(boolean consegnaMultiplaEnabled, boolean soapOneway) {
        ArrayList<TipoBehaviour> l = new ArrayList<TipoBehaviour>();
        l.add(CONSEGNA_LOAD_BALANCE);
        l.add(CONSEGNA_CONDIZIONALE);
        if (consegnaMultiplaEnabled) {
            l.add(CONSEGNA_CON_NOTIFICHE);
            if (soapOneway) {
                l.add(CONSEGNA_MULTIPLA);
            }
        }
        l.add(CUSTOM);
        return l;
    }

    public static List<String> getLabels(boolean consegnaMultiplaEnabled, boolean soapOneway) {
        List<TipoBehaviour> l = TipoBehaviour.getEnums(consegnaMultiplaEnabled, soapOneway);
        ArrayList<String> newL = new ArrayList<String>();
        for (TipoBehaviour behaviourType : l) {
            newL.add(behaviourType.getLabel());
        }
        return newL;
    }

    public static List<String> getValues(boolean consegnaMultiplaEnabled, boolean soapOneway) {
        List<TipoBehaviour> l = TipoBehaviour.getEnums(consegnaMultiplaEnabled, soapOneway);
        ArrayList<String> newL = new ArrayList<String>();
        for (TipoBehaviour behaviourType : l) {
            newL.add(behaviourType.getValue());
        }
        return newL;
    }

    public static String[] toArray() {
        String[] res = new String[TipoBehaviour.values().length];
        int i = 0;
        for (TipoBehaviour tmp : TipoBehaviour.values()) {
            res[i] = tmp.getValue();
            ++i;
        }
        return res;
    }

    public static String[] toStringArray() {
        String[] res = new String[TipoBehaviour.values().length];
        int i = 0;
        for (TipoBehaviour tmp : TipoBehaviour.values()) {
            res[i] = tmp.toString();
            ++i;
        }
        return res;
    }

    public static String[] toEnumNameArray() {
        String[] res = new String[TipoBehaviour.values().length];
        int i = 0;
        for (TipoBehaviour tmp : TipoBehaviour.values()) {
            res[i] = tmp.name();
            ++i;
        }
        return res;
    }

    public static boolean contains(String value) {
        return TipoBehaviour.toEnumConstant(value) != null;
    }

    public static TipoBehaviour toEnumConstant(String value) {
        try {
            return TipoBehaviour.toEnumConstant(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static TipoBehaviour toEnumConstant(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoBehaviour res = null;
        for (TipoBehaviour tmp : TipoBehaviour.values()) {
            if (!tmp.getValue().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && value != null && !"".equals(value)) {
            return CUSTOM;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }

    public static IEnumeration toEnumConstantFromString(String value) {
        try {
            return TipoBehaviour.toEnumConstantFromString(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static IEnumeration toEnumConstantFromString(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoBehaviour res = null;
        for (TipoBehaviour tmp : TipoBehaviour.values()) {
            if (!tmp.toString().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && value != null && !"".equals(value)) {
            return CUSTOM;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }
}

