/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.byok.IDriverBYOKConfig;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.IDriverWS;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoDatiAttributeAuthority;
import org.openspcoop2.core.config.AccessoDatiAutenticazione;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoDatiConsegnaApplicativi;
import org.openspcoop2.core.config.AccessoDatiGestioneToken;
import org.openspcoop2.core.config.AccessoDatiKeystore;
import org.openspcoop2.core.config.AccessoDatiRichieste;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaleConfigurazioneNodo;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneGestioneErrore;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.RegistroPlugins;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaSoggetto;
import org.openspcoop2.core.config.TrasformazioneRegolaParametro;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.PluginSorgenteArchivio;
import org.openspcoop2.core.config.constants.RicercaTipologiaErogazione;
import org.openspcoop2.core.config.constants.RicercaTipologiaFruizione;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.driver.BeanUtilities;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneCRUD;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.TipologiaServizioApplicativo;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBServiziApplicativiSearch;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBSoggetti;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBSoggettiSearch;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_allarmiDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_configDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_configSearchDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_connettoriDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_genericPropertiesDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_gestioneErroreDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_pluginsDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteApplicativeDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteApplicativeSearchDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteDelegateDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteDelegateSearchDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteTrasformazioniDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_protocolPropertiesDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_routingTableDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_serviziApplicativiDriver;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDConnettore;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsAlreadyExistsException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.datasource.DataSourceFactory;
import org.openspcoop2.utils.datasource.DataSourceParams;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class DriverConfigurazioneDB
extends BeanUtilities
implements IDriverConfigurazioneGet,
IDriverConfigurazioneCRUD,
IDriverWS,
IMonitoraggioRisorsa,
IDriverBYOKConfig {
    public boolean create = false;
    private DataSource datasource = null;
    protected Connection globalConnection = null;
    protected boolean atomica = true;
    private static Logger checkLogger = null;
    private static boolean checkIsClosed = true;
    private static boolean checkAutocommit = true;
    protected Logger log = null;
    protected String tipoDB = null;
    protected String tabellaSoggetti = "soggetti";
    protected boolean useSuperUser = true;
    private DriverConfigurazioneDBSoggetti soggettiDriver = null;
    private DriverConfigurazioneDBSoggettiSearch soggettiSearchDriver = null;
    private DriverConfigurazioneDB_connettoriDriver connettoriDriver = null;
    private DriverConfigurazioneDB_porteDelegateDriver porteDelegateDriver = null;
    private DriverConfigurazioneDB_porteDelegateSearchDriver porteDelegateSearchDriver = null;
    private DriverConfigurazioneDB_porteApplicativeDriver porteApplicativeDriver = null;
    private DriverConfigurazioneDB_porteApplicativeSearchDriver porteApplicativeSearchDriver = null;
    private DriverConfigurazioneDB_porteTrasformazioniDriver porteTrasformazioniDriver = null;
    private DriverConfigurazioneDB_porteDriver porteDriver = null;
    private DriverConfigurazioneDB_serviziApplicativiDriver serviziApplicativiDriver = null;
    private DriverConfigurazioneDBServiziApplicativiSearch serviziApplicativiSearchDriver = null;
    private DriverConfigurazioneDB_protocolPropertiesDriver protocolPropertiesDriver = null;
    private DriverConfigurazioneDB_routingTableDriver routingTableDriver = null;
    private DriverConfigurazioneDB_gestioneErroreDriver gestioneErroreDriver = null;
    private DriverConfigurazioneDB_genericPropertiesDriver genericPropertiesDriver = null;
    private DriverConfigurazioneDB_configDriver configDriver = null;
    private DriverConfigurazioneDB_configSearchDriver configSearchDriver = null;
    private DriverConfigurazioneDB_pluginsDriver pluginsDriver = null;
    private DriverConfigurazioneDB_allarmiDriver allarmiDriver = null;
    private DriverConfigurazioneDBUtils utilsDriver = null;
    private IDriverBYOK driverBYOK = null;
    private boolean wrapBYOK;
    private boolean unwrapBYOK;

    public boolean isAtomica() {
        return this.atomica;
    }

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        DriverConfigurazioneDB.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        DriverConfigurazioneDB.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        DriverConfigurazioneDB.checkLogger = checkLogger;
    }

    void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    void logDebug(String msg, Exception e) {
        if (this.log != null) {
            this.log.debug(msg, (Throwable)e);
        }
    }

    void logInfo(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
    }

    void logError(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
    }

    void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    public String getTipoDB() {
        return this.tipoDB;
    }

    public boolean isUseSuperUser() {
        return this.useSuperUser;
    }

    public void setUseSuperUser(boolean useSuperUser) {
        this.useSuperUser = useSuperUser;
    }

    public DriverConfigurazioneDB() {
        this.soggettiDriver = new DriverConfigurazioneDBSoggetti(this);
        this.soggettiSearchDriver = new DriverConfigurazioneDBSoggettiSearch(this);
        this.connettoriDriver = new DriverConfigurazioneDB_connettoriDriver(this);
        this.porteDelegateDriver = new DriverConfigurazioneDB_porteDelegateDriver(this);
        this.porteDelegateSearchDriver = new DriverConfigurazioneDB_porteDelegateSearchDriver(this);
        this.porteApplicativeDriver = new DriverConfigurazioneDB_porteApplicativeDriver(this);
        this.porteApplicativeSearchDriver = new DriverConfigurazioneDB_porteApplicativeSearchDriver(this);
        this.porteTrasformazioniDriver = new DriverConfigurazioneDB_porteTrasformazioniDriver(this);
        this.porteDriver = new DriverConfigurazioneDB_porteDriver(this);
        this.serviziApplicativiDriver = new DriverConfigurazioneDB_serviziApplicativiDriver(this);
        this.serviziApplicativiSearchDriver = new DriverConfigurazioneDBServiziApplicativiSearch(this);
        this.protocolPropertiesDriver = new DriverConfigurazioneDB_protocolPropertiesDriver(this);
        this.routingTableDriver = new DriverConfigurazioneDB_routingTableDriver(this);
        this.gestioneErroreDriver = new DriverConfigurazioneDB_gestioneErroreDriver(this);
        this.genericPropertiesDriver = new DriverConfigurazioneDB_genericPropertiesDriver(this);
        this.configDriver = new DriverConfigurazioneDB_configDriver(this);
        this.configSearchDriver = new DriverConfigurazioneDB_configSearchDriver(this);
        this.pluginsDriver = new DriverConfigurazioneDB_pluginsDriver(this);
        this.allarmiDriver = new DriverConfigurazioneDB_allarmiDriver(this);
        this.utilsDriver = new DriverConfigurazioneDBUtils(this);
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, String tipoDB) {
        this(nomeDataSource, context, null, tipoDB);
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB) {
        this(nomeDataSource, context, alog, tipoDB, false);
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) {
        this.initDriverConfigurazioneDB(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD, false, false);
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD, boolean useOp2UtilsDatasource, boolean bindJMX) {
        this.initDriverConfigurazioneDB(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD, useOp2UtilsDatasource, bindJMX);
    }

    /*
     * Unable to fully structure code
     */
    public void initDriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD, boolean useOp2UtilsDatasource, boolean bindJMX) {
        try {
            if (alog == null) {
                this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
            } else {
                this.log = alog;
                DriverConfigurazioneDBLib.initStaticLogger(this.log);
            }
            if (useOp2UtilsDatasource) {
                dsParams = Costanti.getDataSourceParamsPdD(bindJMX, tipoDB);
                try {
                    this.datasource = DataSourceFactory.newInstance((String)nomeDataSource, (Properties)context, (DataSourceParams)dsParams);
                }
                catch (UtilsAlreadyExistsException exists) {
                    this.datasource = DataSourceFactory.getInstance((String)nomeDataSource);
                    if (this.datasource != null) ** GOTO lbl18
                    throw new DriverConfigurazioneException("Lookup datasource non riuscita (" + exists.getMessage() + ")", exists);
                }
            } else {
                gestoreJNDI = new GestoreJNDI(context);
                this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            }
lbl18:
            // 3 sources

            if (this.datasource != null) {
                this.create = true;
            }
        }
        catch (Exception ne) {
            this.create = false;
            this.log.error("Impossibile recuperare il context: " + ne.getMessage(), (Throwable)ne);
        }
        if (tipoDB == null) {
            this.log.error("Il tipoDatabase non puo essere null.");
            this.create = false;
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
        this.tabellaSoggetti = tabellaSoggettiPDD != false ? "soggetti_pdd" : "soggetti";
        DriverConfigurazioneDBLib.setTipoDB(tipoDB);
        DriverConfigurazioneDBLib.setTabellaSoggetti(this.tabellaSoggetti);
        this.soggettiDriver = new DriverConfigurazioneDBSoggetti(this);
        this.soggettiSearchDriver = new DriverConfigurazioneDBSoggettiSearch(this);
        this.connettoriDriver = new DriverConfigurazioneDB_connettoriDriver(this);
        this.porteDelegateDriver = new DriverConfigurazioneDB_porteDelegateDriver(this);
        this.porteDelegateSearchDriver = new DriverConfigurazioneDB_porteDelegateSearchDriver(this);
        this.porteApplicativeDriver = new DriverConfigurazioneDB_porteApplicativeDriver(this);
        this.porteApplicativeSearchDriver = new DriverConfigurazioneDB_porteApplicativeSearchDriver(this);
        this.porteTrasformazioniDriver = new DriverConfigurazioneDB_porteTrasformazioniDriver(this);
        this.porteDriver = new DriverConfigurazioneDB_porteDriver(this);
        this.serviziApplicativiDriver = new DriverConfigurazioneDB_serviziApplicativiDriver(this);
        this.serviziApplicativiSearchDriver = new DriverConfigurazioneDBServiziApplicativiSearch(this);
        this.protocolPropertiesDriver = new DriverConfigurazioneDB_protocolPropertiesDriver(this);
        this.routingTableDriver = new DriverConfigurazioneDB_routingTableDriver(this);
        this.gestioneErroreDriver = new DriverConfigurazioneDB_gestioneErroreDriver(this);
        this.genericPropertiesDriver = new DriverConfigurazioneDB_genericPropertiesDriver(this);
        this.configDriver = new DriverConfigurazioneDB_configDriver(this);
        this.configSearchDriver = new DriverConfigurazioneDB_configSearchDriver(this);
        this.pluginsDriver = new DriverConfigurazioneDB_pluginsDriver(this);
        this.allarmiDriver = new DriverConfigurazioneDB_allarmiDriver(this);
        this.utilsDriver = new DriverConfigurazioneDBUtils(this);
    }

    public DriverConfigurazioneDB(Connection connection, String tipoDB) throws DriverConfigurazioneException {
        this(connection, null, tipoDB);
    }

    public DriverConfigurazioneDB(Connection connection, Logger alog, String tipoDB) throws DriverConfigurazioneException {
        this(connection, alog, tipoDB, false);
    }

    public DriverConfigurazioneDB(Connection connection, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws DriverConfigurazioneException {
        if (alog == null) {
            this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
        } else {
            this.log = alog;
            DriverConfigurazioneDBLib.initStaticLogger(this.log);
        }
        if (connection == null) {
            this.create = false;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection con, Properties context) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            this.create = false;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.create = true;
        this.atomica = false;
        this.tipoDB = tipoDB;
        this.tabellaSoggetti = tabellaSoggettiPDD ? "soggetti_pdd" : "soggetti";
        DriverConfigurazioneDBLib.setTipoDB(tipoDB);
        DriverConfigurazioneDBLib.setTabellaSoggetti(this.tabellaSoggetti);
        this.soggettiDriver = new DriverConfigurazioneDBSoggetti(this);
        this.soggettiSearchDriver = new DriverConfigurazioneDBSoggettiSearch(this);
        this.connettoriDriver = new DriverConfigurazioneDB_connettoriDriver(this);
        this.porteDelegateDriver = new DriverConfigurazioneDB_porteDelegateDriver(this);
        this.porteDelegateSearchDriver = new DriverConfigurazioneDB_porteDelegateSearchDriver(this);
        this.porteApplicativeDriver = new DriverConfigurazioneDB_porteApplicativeDriver(this);
        this.porteApplicativeSearchDriver = new DriverConfigurazioneDB_porteApplicativeSearchDriver(this);
        this.porteTrasformazioniDriver = new DriverConfigurazioneDB_porteTrasformazioniDriver(this);
        this.porteDriver = new DriverConfigurazioneDB_porteDriver(this);
        this.serviziApplicativiDriver = new DriverConfigurazioneDB_serviziApplicativiDriver(this);
        this.serviziApplicativiSearchDriver = new DriverConfigurazioneDBServiziApplicativiSearch(this);
        this.protocolPropertiesDriver = new DriverConfigurazioneDB_protocolPropertiesDriver(this);
        this.routingTableDriver = new DriverConfigurazioneDB_routingTableDriver(this);
        this.gestioneErroreDriver = new DriverConfigurazioneDB_gestioneErroreDriver(this);
        this.genericPropertiesDriver = new DriverConfigurazioneDB_genericPropertiesDriver(this);
        this.configDriver = new DriverConfigurazioneDB_configDriver(this);
        this.configSearchDriver = new DriverConfigurazioneDB_configSearchDriver(this);
        this.pluginsDriver = new DriverConfigurazioneDB_pluginsDriver(this);
        this.allarmiDriver = new DriverConfigurazioneDB_allarmiDriver(this);
        this.utilsDriver = new DriverConfigurazioneDBUtils(this);
    }

    public Connection getConnection(String methodName) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(methodName);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConnection] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        return con;
    }

    public void releaseConnection(Connection con) {
        this.releaseConnection(null, con);
    }

    public void releaseConnection(String methodName, Connection con) {
        if (this.atomica) {
            try {
                if (methodName != null) {
                    // empty if block
                }
                JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Connection getConnectionFromDatasource(String methodName) throws DriverConfigurazioneException {
        try {
            if (this.datasource instanceof org.openspcoop2.utils.datasource.DataSource) {
                return ((org.openspcoop2.utils.datasource.DataSource)this.datasource).getWrappedConnection(null, (Object)("DriverConfigurazione." + methodName));
            }
            return this.datasource.getConnection();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
    }

    public List<List<Object>> readCustom(ISQLQueryObject sqlQueryObject, List<Class<?>> returnTypes, List<JDBCObject> paramTypes) throws DriverConfigurazioneException {
        Connection con = null;
        try {
            this.logDebug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("readCustom") : this.globalConnection;
            List<List<Object>> list = DBUtils.readCustom(this.log, con, this.tipoDB, sqlQueryObject, returnTypes, paramTypes);
            this.closeConnection(con);
            return list;
        }
        catch (Exception se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::readCustom]: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                this.closeConnection(con);
                throw throwable;
            }
        }
    }

    public void closeConnection(Connection conParam, Connection con) {
        try {
            if (conParam == null && this.atomica) {
                this.log.debug("rilascio connessione al db...");
                JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeConnection(Connection con) {
        try {
            if (this.atomica) {
                this.log.debug("rilascio connessioni al db...");
                JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeConnection(boolean error, Connection con) {
        try {
            if (error && this.atomica) {
                this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                if (con != null) {
                    con.rollback();
                    con.setAutoCommit(true);
                    JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
                }
            } else if (!error && this.atomica) {
                this.log.debug("eseguo commit e rilascio connessioni...");
                if (con != null) {
                    con.commit();
                    con.setAutoCommit(true);
                    JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void initialize(IDriverBYOK driver, boolean wrap, boolean unwrap) throws UtilsException {
        this.driverBYOK = driver;
        this.wrapBYOK = wrap;
        this.unwrapBYOK = unwrap;
    }

    public IDriverBYOK getDriverWrapBYOK() {
        return this.wrapBYOK ? this.driverBYOK : null;
    }

    public IDriverBYOK getDriverUnwrapBYOK() {
        return this.unwrapBYOK ? this.driverBYOK : null;
    }

    public IDSoggetto getIdSoggetto(long idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getIdSoggetto(idSoggetto);
    }

    public IDSoggetto getIdSoggetto(long idSoggetto, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getIdSoggetto(idSoggetto, conParam);
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getSoggetto(aSoggetto);
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        this.soggettiDriver.createSoggetto(soggetto);
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        this.soggettiDriver.updateSoggetto(soggetto);
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        this.soggettiDriver.deleteSoggetto(soggetto);
    }

    @Override
    public Soggetto getRouter() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getRouter();
    }

    public List<IDSoggetto> getSoggettiWithSuperuser(String user) throws DriverConfigurazioneException {
        return this.soggettiDriver.getSoggettiWithSuperuser(user);
    }

    @Override
    public List<IDSoggetto> getSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getSoggettiVirtuali();
    }

    public Soggetto getSoggetto(long idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getSoggetto(idSoggetto);
    }

    public Soggetto getSoggetto(long idSoggetto, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getSoggetto(idSoggetto, conParam);
    }

    public List<Soggetto> soggettiList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        return this.soggettiSearchDriver.soggettiList(superuser, ricerca);
    }

    public List<Soggetto> soggettiWithServiziList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.soggettiSearchDriver.soggettiWithServiziList(ricerca);
    }

    public List<Soggetto> soggettiWithServiziList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        return this.soggettiSearchDriver.soggettiWithServiziList(superuser, ricerca);
    }

    @Override
    public List<IDServizio> getServiziSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getServiziSoggettiVirtuali();
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        return this.soggettiDriver.existsSoggetto(idSoggetto);
    }

    public List<Soggetto> getAllSoggetti() throws DriverConfigurazioneException {
        return this.soggettiDriver.getAllSoggetti();
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.soggettiDriver.getAllIdSoggetti(filtroRicerca);
    }

    public void createConnettore(Connettore connettore) throws DriverConfigurazioneException {
        this.connettoriDriver.createConnettore(connettore);
    }

    public void updateConnettore(Connettore connettore) throws DriverConfigurazioneException {
        this.connettoriDriver.updateConnettore(connettore);
    }

    public void deleteConnettore(Connettore connettore) throws DriverConfigurazioneException {
        this.connettoriDriver.deleteConnettore(connettore);
    }

    public List<String> connettoriList() throws DriverConfigurazioneException {
        return this.connettoriDriver.connettoriList();
    }

    public Property[] getPropertiesConnettore(String nomeConnettore) throws DriverConfigurazioneException {
        return this.connettoriDriver.getPropertiesConnettore(nomeConnettore);
    }

    public Property[] getPropertiesConnettore(String nomeConnettore, Connection connection) throws DriverConfigurazioneException {
        return this.connettoriDriver.getPropertiesConnettore(nomeConnettore, connection);
    }

    public boolean isPolicyNegoziazioneTokenUsedInConnettore(String nome) throws DriverConfigurazioneException {
        return this.connettoriDriver.isPolicyNegoziazioneTokenUsedInConnettore(nome);
    }

    public Connettore getConnettore(long idConnettore) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.connettoriDriver.getConnettore(idConnettore);
    }

    public Connettore getConnettore(String nomeConnettore) throws DriverConfigurazioneException {
        return this.connettoriDriver.getConnettore(nomeConnettore);
    }

    @Override
    public IDPortaDelegata getIDPortaDelegata(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getIDPortaDelegata(nome);
    }

    @Override
    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getPortaDelegata(idPD);
    }

    public PortaDelegata getPortaDelegata(long id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getPortaDelegata(id);
    }

    public PortaDelegata getPortaDelegata(long id, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getPortaDelegata(id, conParam);
    }

    @Override
    public void createPortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        this.porteDelegateDriver.createPortaDelegata(aPD);
    }

    @Override
    public void updatePortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        this.porteDelegateDriver.updatePortaDelegata(aPD);
    }

    @Override
    public void deletePortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        this.porteDelegateDriver.deletePortaDelegata(aPD);
    }

    public List<String> portaDelegataRuoliList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.portaDelegataRuoliList(idPD, ricerca);
    }

    public List<String> portaDelegataRuoliTokenList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.portaDelegataRuoliTokenList(idPD, ricerca);
    }

    public List<String> portaDelegataScopeList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.portaDelegataScopeList(idPD, ricerca);
    }

    public List<TrasformazioneRegola> porteDelegateTrasformazioniList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteDelegateTrasformazioniList(idPA, ricerca);
    }

    public boolean azioneUsataInTrasformazioniPortaDelegata(String azione) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.azioneUsataInTrasformazioniPortaDelegata(azione);
    }

    public TrasformazioneRegola getPortaDelegataTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, List<TrasformazioneRegolaApplicabilitaServizioApplicativo> applicativi) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaDelegataTrasformazione(idPorta, azioni, pattern, contentType, connettori, applicativi);
    }

    public TrasformazioneRegola getPortaDelegataTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaDelegataTrasformazione(idPorta, nome);
    }

    public boolean existsPortaDelegataTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaDelegataTrasformazione(idPorta, azioni, pattern, contentType, connettori);
    }

    public boolean existsPortaDelegataTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaDelegataTrasformazione(idPorta, nome);
    }

    public List<TrasformazioneRegolaRisposta> porteDelegateTrasformazioniRispostaList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteDelegateTrasformazioniRispostaList(idPD, idTrasformazione, ricerca);
    }

    public TrasformazioneRegolaRisposta getPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
    }

    public TrasformazioneRegolaRisposta getPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, nome);
    }

    public boolean existsPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
    }

    public boolean existsPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaDelegataTrasformazioneRisposta(idPorta, idTrasformazione, nome);
    }

    public List<TrasformazioneRegolaApplicabilitaServizioApplicativo> porteDelegateTrasformazioniServiziApplicativiList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteDelegateTrasformazioniServiziApplicativiList(idPD, idTrasformazione, ricerca);
    }

    public List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRispostaHeaderList(long idPD, long idTrasformazione, long idTrasformazioneRisposta, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteDelegateTrasformazioniRispostaHeaderList(idPD, idTrasformazione, idTrasformazioneRisposta, ricerca);
    }

    public List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRichiestaHeaderList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteDelegateTrasformazioniRichiestaHeaderList(idPD, idTrasformazione, ricerca);
    }

    public boolean existsPortaDelegataTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaDelegataTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public TrasformazioneRegolaParametro getPortaDelegataTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaDelegataTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRichiestaUrlParameterList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteDelegateTrasformazioniRichiestaUrlParameterList(idPD, idTrasformazione, ricerca);
    }

    public boolean existsPortaDelegataTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaDelegataTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public TrasformazioneRegolaParametro getPortaDelegataTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaDelegataTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public List<ResponseCachingConfigurazioneRegola> portaDelegataResponseCachingConfigurazioneRegolaList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDriver.portaDelegataResponseCachingConfigurazioneRegolaList(idPD, ricerca);
    }

    public boolean existsPortaDelegataResponseCachingConfigurazioneRegola(long idPA, Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        return this.porteDriver.existsPortaDelegataResponseCachingConfigurazioneRegola(idPA, statusMin, statusMax, fault);
    }

    public List<String> porteDelegateRateLimitingValoriUnivoci(String pName) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.porteDelegateRateLimitingValoriUnivoci(pName);
    }

    public List<PortaDelegata> porteDelegateList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateList(idSoggetto, ricerca);
    }

    public List<Proprieta> porteDelegatePropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegatePropList(idPortaDelegata, ricerca);
    }

    public List<String> nomiProprietaPD(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoServiziProtocollo) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.nomiProprietaPD(filterSoggettoTipo, filterSoggettoNome, tipoServiziProtocollo);
    }

    public List<Proprieta> porteDelegateAutenticazioneCustomPropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateAutenticazioneCustomPropList(idPortaDelegata, ricerca);
    }

    public List<Proprieta> porteDelegateAutorizzazioneCustomPropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateAutorizzazioneCustomPropList(idPortaDelegata, ricerca);
    }

    public List<Proprieta> porteDelegateAutorizzazioneContenutoCustomPropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateAutorizzazioneContenutoCustomPropList(idPortaDelegata, ricerca);
    }

    public List<PortaDelegata> porteDelegateList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateList(superuser, ricerca);
    }

    public List<PortaDelegata> porteDelegateWithSoggettoErogatoreList(long idSoggettoErogatore) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.porteDelegateWithSoggettoErogatoreList(idSoggettoErogatore);
    }

    public List<PortaDelegata> porteDelegateWithTipoNomeErogatoreList(String tipoSoggettoErogatore, String nomeSoggettoErogatore) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.porteDelegateWithTipoNomeErogatoreList(tipoSoggettoErogatore, nomeSoggettoErogatore);
    }

    public List<ServizioApplicativo> porteDelegateServizioApplicativoList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateServizioApplicativoList(idPortaDelegata, ricerca);
    }

    public List<ServizioApplicativo> porteDelegateServizioApplicativoTokenList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateServizioApplicativoTokenList(idPortaDelegata, ricerca);
    }

    public List<MessageSecurityFlowParameter> porteDelegateMessageSecurityRequestList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateMessageSecurityRequestList(idPortaDelegata, ricerca);
    }

    public List<MessageSecurityFlowParameter> porteDelegateMessageSecurityResponseList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateMessageSecurityResponseList(idPortaDelegata, ricerca);
    }

    public List<CorrelazioneApplicativaElemento> porteDelegateCorrelazioneApplicativaList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateCorrelazioneApplicativaList(idPortaDelegata, ricerca);
    }

    public List<CorrelazioneApplicativaRispostaElemento> porteDelegateCorrelazioneApplicativaRispostaList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateCorrelazioneApplicativaRispostaList(idPortaDelegata, ricerca);
    }

    @Override
    public boolean existsPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.existsPortaDelegata(idPD);
    }

    public List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio, String tiposervizio, String nomeservizio, Integer versioneServizio, Long idSoggetto, String tiposoggetto, String nomesoggetto) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.getPorteDelegateWithServizio(idServizio, tiposervizio, nomeservizio, versioneServizio, idSoggetto, tiposoggetto, nomesoggetto);
    }

    public List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.getPorteDelegateWithServizio(idServizio);
    }

    public List<IDPortaDelegata> getPortaDelegataAzione(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getPortaDelegataAzione(nome);
    }

    public boolean existsPortaDelegataAzione(String nome) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.existsPortaDelegataAzione(nome);
    }

    public List<PortaDelegata> serviziFruitoriPorteDelegateList(long idSoggetto, String tipoServizio, String nomeServizio, Long idServizio, String tipoSoggettoErogatore, String nomeSoggettoErogatore, Long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.serviziFruitoriPorteDelegateList(idSoggetto, tipoServizio, nomeServizio, idServizio, tipoSoggettoErogatore, nomeSoggettoErogatore, idSoggettoErogatore, ricerca);
    }

    public List<PortaDelegata> getPorteDelegateByFruitore(IDSoggetto fruitore, ISearch filters) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.getPorteDelegateByFruitore(fruitore, filters);
    }

    public List<PortaDelegata> getPorteDelegate(IDServizio idSE, IDSoggetto fruitore, ISearch filters) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.getPorteDelegate(idSE, fruitore, filters);
    }

    public List<PortaDelegata> getPorteDelegateBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.getPorteDelegateBySoggetto(idSoggetto);
    }

    @Override
    public List<IDPortaDelegata> getAllIdPorteDelegate(FiltroRicercaPorteDelegate filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getAllIdPorteDelegate(filtroRicerca);
    }

    public List<MtomProcessorFlowParameter> porteDelegateMTOMRequestList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateMTOMRequestList(idPortaDelegata, ricerca);
    }

    public List<MtomProcessorFlowParameter> porteDelegateMTOMResponseList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDelegateSearchDriver.porteDelegateMTOMResponseList(idPortaDelegata, ricerca);
    }

    public List<PortaDelegata> getPorteDelegateByPolicyGestioneToken(String nome) throws DriverConfigurazioneException {
        return this.porteDelegateDriver.getPorteDelegateByPolicyGestioneToken(nome);
    }

    public MappingFruizionePortaDelegata getMappingFruizione(IDServizio idServizio, IDSoggetto idSoggetto, IDPortaDelegata idPortaDelegata) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getMappingFruizione(idServizio, idSoggetto, idPortaDelegata);
    }

    public ProprietaOggetto getProprietaOggetto(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteDelegateDriver.getProprietaOggetto(idPD);
    }

    public void updateProprietaOggetto(IDPortaDelegata idPD, String user) throws DriverConfigurazioneException {
        this.porteDelegateDriver.updateProprietaOggetto(idPD, user);
    }

    @Override
    public IDPortaApplicativa getIDPortaApplicativa(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getIDPortaApplicativa(nome);
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getPortaApplicativa(idPA);
    }

    public PortaApplicativa getPortaApplicativa(long id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getPortaApplicativa(id);
    }

    public PortaApplicativa getPortaApplicativa(long id, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getPortaApplicativa(id, conParam);
    }

    @Override
    public List<PortaApplicativa> getPorteApplicative(IDServizio idServizio, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getPorteApplicative(idServizio, ricercaPuntuale);
    }

    @Override
    public List<PortaApplicativa> getPorteApplicativeVirtuali(IDSoggetto soggettoVirtuale, IDServizio idServizio, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getPorteApplicativeVirtuali(soggettoVirtuale, idServizio, ricercaPuntuale);
    }

    @Override
    public void createPortaApplicativa(PortaApplicativa aPA) throws DriverConfigurazioneException {
        this.porteApplicativeDriver.createPortaApplicativa(aPA);
    }

    @Override
    public void updatePortaApplicativa(PortaApplicativa aPA) throws DriverConfigurazioneException {
        this.porteApplicativeDriver.updatePortaApplicativa(aPA);
    }

    @Override
    public void deletePortaApplicativa(PortaApplicativa aPA) throws DriverConfigurazioneException {
        this.porteApplicativeDriver.deletePortaApplicativa(aPA);
    }

    @Override
    public Map<IDSoggetto, PortaApplicativa> getPorteApplicativeSoggettiVirtuali(IDServizio idServizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getPorteApplicativeSoggettiVirtuali(idServizio);
    }

    public List<String> portaApplicativaRuoliList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.portaApplicativaRuoliList(idPA, ricerca);
    }

    public List<String> portaApplicativaRuoliTokenList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.portaApplicativaRuoliTokenList(idPA, ricerca);
    }

    public List<String> portaApplicativaScopeList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.portaApplicativaScopeList(idPA, ricerca);
    }

    public List<IDPortaApplicativa> porteApplicativeWithApplicativoErogatore(IDServizioApplicativo idSA) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.porteApplicativeWithApplicativoErogatore(idSA);
    }

    public List<TrasformazioneRegola> porteApplicativeTrasformazioniList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteApplicativeTrasformazioniList(idPA, ricerca);
    }

    public boolean azioneUsataInTrasformazioniPortaApplicativa(String azione) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.azioneUsataInTrasformazioniPortaApplicativa(azione);
    }

    public TrasformazioneRegola getPortaApplicativaTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, List<TrasformazioneRegolaApplicabilitaSoggetto> soggetti, List<TrasformazioneRegolaApplicabilitaServizioApplicativo> applicativi, boolean interpretaNullList) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaApplicativaTrasformazione(idPorta, azioni, pattern, contentType, connettori, soggetti, applicativi, interpretaNullList);
    }

    public TrasformazioneRegola getPortaApplicativaTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaApplicativaTrasformazione(idPorta, nome);
    }

    public boolean existsPortaApplicativaTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaApplicativaTrasformazione(idPorta, azioni, pattern, contentType, connettori);
    }

    public boolean existsPortaApplicativaTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaApplicativaTrasformazione(idPorta, nome);
    }

    public List<TrasformazioneRegolaRisposta> porteApplicativeTrasformazioniRispostaList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteApplicativeTrasformazioniRispostaList(idPA, idTrasformazione, ricerca);
    }

    public TrasformazioneRegolaRisposta getPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
    }

    public TrasformazioneRegolaRisposta getPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, nome);
    }

    public boolean existsPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
    }

    public boolean existsPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, nome);
    }

    public List<TrasformazioneRegolaApplicabilitaServizioApplicativo> porteApplicativeTrasformazioniServiziApplicativiList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteApplicativeTrasformazioniServiziApplicativiList(idPA, idTrasformazione, ricerca);
    }

    public List<TrasformazioneRegolaApplicabilitaSoggetto> porteApplicativeTrasformazioniSoggettiList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteApplicativeTrasformazioniSoggettiList(idPA, idTrasformazione, ricerca);
    }

    public List<TrasformazioneRegolaParametro> porteApplicativeTrasformazioniRispostaHeaderList(long idPA, long idTrasformazione, long idTrasformazioneRisposta, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteApplicativeTrasformazioniRispostaHeaderList(idPA, idTrasformazione, idTrasformazioneRisposta, ricerca);
    }

    public boolean existsPortaApplicativaTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaApplicativaTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
    }

    public boolean existsPortaDelegataTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaDelegataTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
    }

    public TrasformazioneRegolaParametro getPortaApplicativaTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaApplicativaTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
    }

    public TrasformazioneRegolaParametro getPortaDelegataTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaDelegataTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
    }

    public List<TrasformazioneRegolaParametro> porteApplicativeTrasformazioniRichiestaHeaderList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteApplicativeTrasformazioniRichiestaHeaderList(idPA, idTrasformazione, ricerca);
    }

    public boolean existsPortaApplicativaTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaApplicativaTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public TrasformazioneRegolaParametro getPortaApplicativaTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaApplicativaTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public List<TrasformazioneRegolaParametro> porteApplicativeTrasformazioniRichiestaUrlParameterList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.porteApplicativeTrasformazioniRichiestaUrlParameterList(idPA, idTrasformazione, ricerca);
    }

    public boolean existsPortaApplicativaTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.existsPortaApplicativaTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public TrasformazioneRegolaParametro getPortaApplicativaTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        return this.porteTrasformazioniDriver.getPortaApplicativaTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
    }

    public List<ResponseCachingConfigurazioneRegola> portaApplicativaResponseCachingConfigurazioneRegolaList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteDriver.portaApplicativaResponseCachingConfigurazioneRegolaList(idPA, ricerca);
    }

    public boolean existsPortaApplicativaResponseCachingConfigurazioneRegola(long idPA, Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        return this.porteDriver.existsPortaApplicativaResponseCachingConfigurazioneRegola(idPA, statusMin, statusMax, fault);
    }

    public List<PortaApplicativa> porteAppList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppList(idSoggetto, ricerca);
    }

    public List<PortaApplicativa> porteAppList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppList(superuser, ricerca);
    }

    public List<Proprieta> porteAppPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppPropList(idPortaApplicativa, ricerca);
    }

    public List<String> nomiProprietaPA(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoServiziProtocollo) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.nomiProprietaPA(filterSoggettoTipo, filterSoggettoNome, tipoServiziProtocollo);
    }

    public List<Proprieta> porteApplicativeAutenticazioneCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeAutenticazioneCustomPropList(idPortaApplicativa, ricerca);
    }

    public List<Proprieta> porteApplicativeAutorizzazioneCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeAutorizzazioneCustomPropList(idPortaApplicativa, ricerca);
    }

    public List<String> porteApplicativeRateLimitingValoriUnivoci(String pName) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.porteApplicativeRateLimitingValoriUnivoci(pName);
    }

    public List<Proprieta> porteApplicativeAutorizzazioneContenutoCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeAutorizzazioneContenutoCustomPropList(idPortaApplicativa, ricerca);
    }

    public List<PortaApplicativaAzione> porteAppAzioneList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppAzioneList(idPortaApplicativa, ricerca);
    }

    public List<ServizioApplicativo> porteAppServizioApplicativoList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppServizioApplicativoList(idPortaApplicativa, ricerca);
    }

    public List<PortaApplicativaAutorizzazioneSoggetto> porteAppSoggettoList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppSoggettoList(idPortaApplicativa, ricerca);
    }

    public List<PortaApplicativaAutorizzazioneServizioApplicativo> porteAppServiziApplicativiAutorizzatiList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppServiziApplicativiAutorizzatiList(idPortaApplicativa, ricerca);
    }

    public List<PortaApplicativaAutorizzazioneServizioApplicativo> porteAppServiziApplicativiAutorizzatiTokenList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppServiziApplicativiAutorizzatiTokenList(idPortaApplicativa, ricerca);
    }

    public List<MessageSecurityFlowParameter> porteAppMessageSecurityRequestList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppMessageSecurityRequestList(idPortaApplicativa, ricerca);
    }

    public List<MessageSecurityFlowParameter> porteAppMessageSecurityResponseList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteAppMessageSecurityResponseList(idPortaApplicativa, ricerca);
    }

    public List<PortaApplicativa> porteAppWithServizio(long idSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.porteAppWithServizio(idSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio);
    }

    public List<PortaApplicativa> porteAppWithIdServizio(long idServizio) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.porteAppWithIdServizio(idServizio);
    }

    public List<CorrelazioneApplicativaElemento> porteApplicativeCorrelazioneApplicativaList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeCorrelazioneApplicativaList(idPortaApplicativa, ricerca);
    }

    public List<CorrelazioneApplicativaRispostaElemento> porteApplicativeCorrelazioneApplicativaRispostaList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeCorrelazioneApplicativaRispostaList(idPortaApplicativa, ricerca);
    }

    @Override
    public boolean existsPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.existsPortaApplicativa(idPA);
    }

    public List<PortaApplicativa> getPorteApplicativeWithServizio(Long idServizio, String tiposervizio, String nomeservizio, Integer versioneServizio, Long idSoggetto, String tiposoggetto, String nomesoggetto) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.getPorteApplicativeWithServizio(idServizio, tiposervizio, nomeservizio, versioneServizio, idSoggetto, tiposoggetto, nomesoggetto);
    }

    public PortaApplicativa getPortaApplicativaWithSoggettoAndServizio(String nome, Long idSoggetto, Long idServizio, String tipoServizio, String nomeServizio, Integer versioneServizio) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.getPortaApplicativaWithSoggettoAndServizio(nome, idSoggetto, idServizio, tipoServizio, nomeServizio, versioneServizio);
    }

    public List<IDPortaApplicativa> getPortaApplicativaAzione(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getPortaApplicativaAzione(nome);
    }

    public boolean existsPortaApplicativaAzione(String nome) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.existsPortaApplicativaAzione(nome);
    }

    public List<PortaApplicativa> serviziPorteAppList(String tipoServizio, String nomeServizio, Integer versioneServizio, long idServizio, long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.serviziPorteAppList(tipoServizio, nomeServizio, versioneServizio, idServizio, idSoggettoErogatore, ricerca);
    }

    public List<PortaApplicativa> getPorteApplicativaByIdProprietario(long idProprietario) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.getPorteApplicativaByIdProprietario(idProprietario);
    }

    public List<PortaApplicativa> getPorteApplicative(IDServizio idSE) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.getPorteApplicative(idSE);
    }

    public List<PortaApplicativa> getPorteApplicativeBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.getPorteApplicativeBySoggetto(idSoggetto);
    }

    public List<PortaApplicativa> getPorteApplicativeBySoggettoVirtuale(IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.getPorteApplicativeBySoggettoVirtuale(soggettoVirtuale);
    }

    @Override
    public List<IDPortaApplicativa> getAllIdPorteApplicative(FiltroRicercaPorteApplicative filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getAllIdPorteApplicative(filtroRicerca);
    }

    @Override
    public List<IDConnettore> getConnettoriConsegnaNotifichePrioritarie(String queueName) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getConnettoriConsegnaNotifichePrioritarie(queueName);
    }

    public int resetConnettoriConsegnaNotifichePrioritarie(String queueName) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.resetConnettoriConsegnaNotifichePrioritarie(queueName);
    }

    public List<MtomProcessorFlowParameter> porteApplicativeMTOMRequestList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeMTOMRequestList(idPortaApplicativa, ricerca);
    }

    public List<MtomProcessorFlowParameter> porteApplicativeMTOMResponseList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeMTOMResponseList(idPortaApplicativa, ricerca);
    }

    public List<PortaApplicativa> getPorteApplicativeByPolicyGestioneToken(String nome) throws DriverConfigurazioneException {
        return this.porteApplicativeDriver.getPorteApplicativeByPolicyGestioneToken(nome);
    }

    public List<Proprieta> porteApplicativeConnettoriMultipliConfigPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeConnettoriMultipliConfigPropList(idPortaApplicativa, ricerca);
    }

    public List<Proprieta> porteApplicativeConnettoriMultipliPropList(long idPaSa, ISearch ricerca) throws DriverConfigurazioneException {
        return this.porteApplicativeSearchDriver.porteApplicativeConnettoriMultipliPropList(idPaSa, ricerca);
    }

    public MappingErogazionePortaApplicativa getMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getMappingErogazione(idServizio, idPortaApplicativa);
    }

    public static List<String> normalizeConnettoriMultpliById(List<String> sa, PortaApplicativa pa) {
        return DriverConfigurazioneDB_porteApplicativeDriver.normalizeConnettoriMultpliById(sa, pa);
    }

    public ProprietaOggetto getProprietaOggetto(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.porteApplicativeDriver.getProprietaOggetto(idPA);
    }

    public void updateProprietaOggetto(IDPortaApplicativa idPA, String user) throws DriverConfigurazioneException {
        this.porteApplicativeDriver.updateProprietaOggetto(idPA, user);
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativo(idServizioApplicativo);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiBasic(String aUser, String aPassword, CryptConfig config) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiBasic(aUser, aPassword, config);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiBasic(String aUser, String aPassword, CryptConfig config, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiBasic(aUser, aPassword, config, tipiSoggetto);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiApiKey(String aUser, String aPassword, boolean appId, CryptConfig config) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiApiKey(aUser, aPassword, appId, config);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiApiKey(String aUser, String aPassword, boolean appId, CryptConfig config, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiApiKey(aUser, aPassword, appId, config, tipiSoggetto);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiToken(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiToken(tokenPolicy, tokenClientId, tokenWithHttpsEnabled);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiToken(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiToken(tokenPolicy, tokenClientId, tokenWithHttpsEnabled, tipiSoggetto);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String aSubject, String aIssuer) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiSsl(aSubject, aIssuer);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String aSubject, String aIssuer, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiSsl(aSubject, aIssuer, tipiSoggetto);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String aSubject, String aIssuer, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiSsl(aSubject, aIssuer, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiSsl(certificate, strictVerifier);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiSsl(certificate, strictVerifier, tipiSoggetto);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiSsl(certificate, strictVerifier, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiPrincipal(String principal) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiPrincipal(principal);
    }

    public ServizioApplicativo getServizioApplicativoByCredenzialiPrincipal(String principal, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativoByCredenzialiPrincipal(principal, tipiSoggetto);
    }

    public ServizioApplicativo getServizioApplicativo(long idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getServizioApplicativo(idServizioApplicativo);
    }

    @Override
    public void createServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        this.serviziApplicativiDriver.createServizioApplicativo(aSA);
    }

    @Override
    public void updateServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        this.serviziApplicativiDriver.updateServizioApplicativo(aSA);
    }

    @Override
    public void deleteServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        this.serviziApplicativiDriver.deleteServizioApplicativo(aSA);
    }

    public List<ServizioApplicativo> servizioApplicativoList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.servizioApplicativoList(ricerca);
    }

    public List<ServizioApplicativo> servizioApplicativoList(IDSoggetto idSO, ISearch ricerca) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.servizioApplicativoList(idSO, ricerca);
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiBasicList(String utente, String password, boolean checkPassword) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.servizioApplicativoWithCredenzialiBasicList(utente, password, checkPassword);
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiApiKeyList(String utente, boolean appId) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.servizioApplicativoWithCredenzialiApiKeyList(utente, appId);
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiSslList(String subject, String issuer, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.servizioApplicativoWithCredenzialiSslList(subject, issuer, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiSslList(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.servizioApplicativoWithCredenzialiSslList(certificate, strictVerifier, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiPrincipalList(String principal) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.servizioApplicativoWithCredenzialiPrincipalList(principal);
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiTokenList(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.servizioApplicativoWithCredenzialiTokenList(tokenPolicy, tokenClientId, tokenWithHttpsEnabled);
    }

    public String[] soggettiServizioApplicativoList(long idSoggetto) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.soggettiServizioApplicativoList(idSoggetto);
    }

    public List<IDServizioApplicativoDB> soggettiServizioApplicativoList(IDSoggetto idSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, String tipoSA, boolean bothSslAndToken, String tokenPolicy) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.soggettiServizioApplicativoList(idSoggetto, superuser, credenziale, appId, tipoSA, bothSslAndToken, tokenPolicy);
    }

    public List<IDServizioApplicativoDB> soggettiServizioApplicativoList(IDSoggetto idSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, String tipoSA, boolean bothSslAndToken, String tokenPolicy, boolean tokenPolicyOR) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.soggettiServizioApplicativoList(idSoggetto, superuser, credenziale, appId, tipoSA, bothSslAndToken, tokenPolicy, tokenPolicyOR);
    }

    public List<ServizioApplicativo> soggettiServizioApplicativoList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.soggettiServizioApplicativoList(superuser, ricerca);
    }

    public List<ServizioApplicativo> soggettiServizioApplicativoList(Long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.soggettiServizioApplicativoList(idSoggetto, ricerca);
    }

    public List<String> servizioApplicativoRuoliList(long idSA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.servizioApplicativoRuoliList(idSA, ricerca);
    }

    public List<Proprieta> serviziApplicativiProprietaList(int idSA, ISearch ricerca) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.serviziApplicativiProprietaList(idSA, ricerca);
    }

    public List<String> nomiProprietaSA(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoSoggettiProtocollo) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.nomiProprietaSA(filterSoggettoTipo, filterSoggettoNome, tipoSoggettiProtocollo);
    }

    public List<IDServizioApplicativoDB> getIdServiziApplicativiWithIdErogatore(Long idErogatore, String tipo, boolean checkIM, boolean checkConnettoreAbilitato) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.getIdServiziApplicativiWithIdErogatore(idErogatore, tipo, checkIM, checkConnettoreAbilitato);
    }

    @Override
    public boolean existsServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.existsServizioApplicativo(idServizioApplicativo);
    }

    public long getIdServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.getIdServizioApplicativo(idSoggetto, nomeServizioApplicativo);
    }

    public boolean existsServizioApplicativoSoggetto(Long idSoggetto) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.existsServizioApplicativoSoggetto(idSoggetto);
    }

    public boolean isServizioApplicativoInUsoComeErogatore(ServizioApplicativo sa, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.isServizioApplicativoInUsoComeErogatore(sa, whereIsInUso);
    }

    public int countTipologieServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieServiziApplicativi(filters);
    }

    public int countTipologieServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieServiziApplicativi(proprietario, filters);
    }

    public int countTipologieFruizioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(filters);
    }

    public int countTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(filters, checkAssociazionePorta);
    }

    public int countTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(filters, checkAssociazionePorta, isBound);
    }

    public int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(fruizione, filters);
    }

    public int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(fruizione, filters, checkAssociazionePorta);
    }

    public int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(fruizione, filters, checkAssociazionePorta, isBound);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(proprietario, filters);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(proprietario, filters, checkAssociazionePorta);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(proprietario, filters, checkAssociazionePorta, isBound);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(proprietario, fruizione, filters);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(proprietario, fruizione, filters, checkAssociazionePorta);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieFruizioneServiziApplicativi(proprietario, fruizione, filters, checkAssociazionePorta, isBound);
    }

    public int countTipologieErogazioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(filters);
    }

    public int countTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(filters, checkAssociazionePorta);
    }

    public int countTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(filters, checkAssociazionePorta, isBound);
    }

    public int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(erogazione, filters);
    }

    public int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(erogazione, filters, checkAssociazionePorta);
    }

    public int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(erogazione, filters, checkAssociazionePorta, isBound);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(proprietario, erogazione, filters);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(proprietario, erogazione, filters, checkAssociazionePorta);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(proprietario, erogazione, filters, checkAssociazionePorta, isBound);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(proprietario, filters);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(proprietario, filters, checkAssociazionePorta);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.countTipologieErogazioneServiziApplicativi(proprietario, filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieServiziApplicativi(filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieServiziApplicativi(proprietario, filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(fruizione, filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(fruizione, filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(fruizione, filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(proprietario, filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(proprietario, filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(proprietario, filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(proprietario, fruizione, filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(proprietario, fruizione, filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieFruizioneServiziApplicativi(proprietario, fruizione, filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(erogazione, filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(erogazione, filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(erogazione, filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(proprietario, erogazione, filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(proprietario, erogazione, filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(proprietario, erogazione, filters, checkAssociazionePorta, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(proprietario, filters);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(proprietario, filters, checkAssociazionePorta);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.getTipologieErogazioneServiziApplicativi(proprietario, filters, checkAssociazionePorta, isBound);
    }

    public List<IDServizioApplicativo> serviziApplicativiList(ISearch filters, IDSoggetto proprietario, TipologiaErogazione ... erogazione) throws DriverConfigurazioneException {
        return this.serviziApplicativiSearchDriver.serviziApplicativiList(filters, proprietario, erogazione);
    }

    public List<ServizioApplicativo> getServiziApplicativiBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.getServiziApplicativiBySoggetto(idSoggetto);
    }

    @Override
    public List<IDServizioApplicativo> getAllIdServiziApplicativi(FiltroRicercaServiziApplicativi filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getAllIdServiziApplicativi(filtroRicerca);
    }

    public long getIdServizioApplicativoByConnettore(long idConnettore) throws DriverConfigurazioneException {
        return this.serviziApplicativiDriver.getIdServizioApplicativoByConnettore(idConnettore);
    }

    public IDServizio getLabelNomeServizioApplicativo(String nomeServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getLabelNomeServizioApplicativo(nomeServizioApplicativo);
    }

    public ProprietaOggetto getProprietaOggetto(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.serviziApplicativiDriver.getProprietaOggetto(idServizioApplicativo);
    }

    public void updateProprietaOggetto(IDServizioApplicativo idServizioApplicativo, String user) throws DriverConfigurazioneException {
        this.serviziApplicativiDriver.updateProprietaOggetto(idServizioApplicativo, user);
    }

    public boolean existsProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome) throws DriverConfigurazioneException {
        return this.protocolPropertiesDriver.existsProtocolProperty(proprietarioProtocolProperty, idProprietario, nome);
    }

    public ProtocolProperty getProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome) throws DriverConfigurazioneException {
        return this.protocolPropertiesDriver.getProtocolProperty(proprietarioProtocolProperty, idProprietario, nome);
    }

    public ProtocolProperty getProtocolProperty(long idProtocolProperty) throws DriverConfigurazioneException {
        return this.protocolPropertiesDriver.getProtocolProperty(idProtocolProperty);
    }

    @Override
    public RoutingTable getRoutingTable() throws DriverConfigurazioneException {
        return this.routingTableDriver.getRoutingTable();
    }

    @Override
    public void createRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        this.routingTableDriver.createRoutingTable(routingTable);
    }

    @Override
    public void updateRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        this.routingTableDriver.updateRoutingTable(routingTable);
    }

    @Override
    public void deleteRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        this.routingTableDriver.deleteRoutingTable(routingTable);
    }

    public List<RoutingTableDestinazione> routingList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.routingTableDriver.routingList(ricerca);
    }

    @Override
    public AccessoRegistro getAccessoRegistro() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoRegistro();
    }

    @Override
    public void createAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        this.configDriver.createAccessoRegistro(registro);
    }

    @Override
    public void updateAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        this.configDriver.updateAccessoRegistro(registro);
    }

    @Override
    public void deleteAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        this.configDriver.deleteAccessoRegistro(registro);
    }

    public void createAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        this.configDriver.createAccessoRegistro(registro);
    }

    public void updateAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        this.configDriver.updateAccessoRegistro(registro);
    }

    public void deleteAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        this.configDriver.deleteAccessoRegistro(registro);
    }

    public List<AccessoRegistroRegistro> registriList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.configSearchDriver.registriList(ricerca);
    }

    @Override
    public AccessoConfigurazione getAccessoConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoConfigurazione();
    }

    public void createAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        this.configDriver.createAccessoConfigurazione(accessoConfigurazione);
    }

    public void updateAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        this.configDriver.updateAccessoConfigurazione(accessoConfigurazione);
    }

    public void deleteAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        this.configDriver.deleteAccessoConfigurazione(accessoConfigurazione);
    }

    @Override
    public AccessoDatiAutorizzazione getAccessoDatiAutorizzazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoDatiAutorizzazione();
    }

    public void createAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        this.configDriver.createAccessoDatiAutorizzazione(accessoDatiAutorizzazione);
    }

    public void updateAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        this.configDriver.updateAccessoDatiAutorizzazione(accessoDatiAutorizzazione);
    }

    public void deleteAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        this.configDriver.deleteAccessoDatiAutorizzazione(accessoDatiAutorizzazione);
    }

    @Override
    public AccessoDatiAutenticazione getAccessoDatiAutenticazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoDatiAutenticazione();
    }

    @Override
    public AccessoDatiGestioneToken getAccessoDatiGestioneToken() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoDatiGestioneToken();
    }

    @Override
    public AccessoDatiAttributeAuthority getAccessoDatiAttributeAuthority() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoDatiAttributeAuthority();
    }

    @Override
    public AccessoDatiKeystore getAccessoDatiKeystore() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoDatiKeystore();
    }

    @Override
    public AccessoDatiConsegnaApplicativi getAccessoDatiConsegnaApplicativi() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoDatiConsegnaApplicativi();
    }

    @Override
    public AccessoDatiRichieste getAccessoDatiRichieste() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getAccessoDatiRichieste();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteCooperazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.gestioneErroreDriver.getGestioneErroreComponenteCooperazione();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteIntegrazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.gestioneErroreDriver.getGestioneErroreComponenteIntegrazione();
    }

    @Override
    public void createGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        this.gestioneErroreDriver.createGestioneErroreComponenteCooperazione(gestione);
    }

    @Override
    public void updateGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        this.gestioneErroreDriver.updateGestioneErroreComponenteCooperazione(gestione);
    }

    @Override
    public void deleteGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        this.gestioneErroreDriver.deleteGestioneErroreComponenteCooperazione(gestione);
    }

    @Override
    public void createGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        this.gestioneErroreDriver.createGestioneErroreComponenteIntegrazione(gestione);
    }

    @Override
    public void updateGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        this.gestioneErroreDriver.updateGestioneErroreComponenteIntegrazione(gestione);
    }

    @Override
    public void deleteGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        this.gestioneErroreDriver.deleteGestioneErroreComponenteIntegrazione(gestione);
    }

    @Override
    public StatoServiziPdd getStatoServiziPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getStatoServiziPdD();
    }

    @Override
    public void createStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        this.configDriver.createStatoServiziPdD(servizi);
    }

    @Override
    public void updateStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        this.configDriver.updateStatoServiziPdD(servizi);
    }

    @Override
    public void deleteStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        this.configDriver.deleteStatoServiziPdD(servizi);
    }

    public List<Property> systemPropertyList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.configSearchDriver.systemPropertyList(ricerca);
    }

    @Override
    public SystemProperties getSystemPropertiesPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getSystemPropertiesPdD();
    }

    public SystemProperties getSystemPropertiesPdDWithoutBIOK() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getSystemPropertiesPdDWithoutBIOK();
    }

    @Override
    public List<String> getEncryptedSystemPropertiesPdD() throws DriverConfigurazioneException {
        return this.configDriver.getEncryptedSystemPropertiesPdD();
    }

    @Override
    public void createSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        this.configDriver.createSystemPropertiesPdD(systemProperties);
    }

    @Override
    public void updateSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        this.configDriver.updateSystemPropertiesPdD(systemProperties);
    }

    @Override
    public void deleteSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        this.configDriver.deleteSystemPropertiesPdD(systemProperties);
    }

    @Override
    public ConfigurazioneUrlInvocazioneRegola getUrlInvocazioneRegola(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getUrlInvocazioneRegola(nome);
    }

    public boolean existsUrlInvocazioneRegola(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.existsUrlInvocazioneRegola(nome);
    }

    @Override
    public void createUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        this.configDriver.createUrlInvocazioneRegola(regola);
    }

    @Override
    public void updateUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        this.configDriver.updateUrlInvocazioneRegola(regola);
    }

    @Override
    public void deleteUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        this.configDriver.deleteUrlInvocazioneRegola(regola);
    }

    public List<ConfigurazioneUrlInvocazioneRegola> proxyPassConfigurazioneRegolaList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.configSearchDriver.proxyPassConfigurazioneRegolaList(ricerca);
    }

    public boolean existsProxyPassConfigurazioneRegola(String nome) throws DriverConfigurazioneException {
        return this.configDriver.existsProxyPassConfigurazioneRegola(nome);
    }

    public List<ResponseCachingConfigurazioneRegola> responseCachingConfigurazioneRegolaList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.configSearchDriver.responseCachingConfigurazioneRegolaList(ricerca);
    }

    public boolean existsResponseCachingConfigurazioneRegola(Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        return this.configDriver.existsResponseCachingConfigurazioneRegola(statusMin, statusMax, fault);
    }

    public List<CanaleConfigurazione> canaleConfigurazioneList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.configSearchDriver.canaleConfigurazioneList(ricerca);
    }

    public boolean existsCanale(String nome) throws DriverConfigurazioneException {
        return this.configDriver.existsCanale(nome);
    }

    public List<CanaleConfigurazioneNodo> canaleNodoConfigurazioneList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.configSearchDriver.canaleNodoConfigurazioneList(ricerca);
    }

    public boolean existsCanaleNodo(String nome) throws DriverConfigurazioneException {
        return this.configDriver.existsCanaleNodo(nome);
    }

    @Override
    public CanaliConfigurazione getCanaliConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getCanaliConfigurazione();
    }

    public CanaliConfigurazione getCanaliConfigurazione(boolean readNodi) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getCanaliConfigurazione(readNodi);
    }

    public boolean existsFaseTracciamentoDBRequestIn(boolean erogazioni, boolean fruizioni) throws DriverConfigurazioneException {
        return this.configSearchDriver.existsFaseTracciamentoDBRequestIn(erogazioni, fruizioni);
    }

    public boolean existsFaseTracciamentoDBRequestOut(boolean erogazioni, boolean fruizioni) throws DriverConfigurazioneException {
        return this.configSearchDriver.existsFaseTracciamentoDBRequestOut(erogazioni, fruizioni);
    }

    public boolean existsFaseTracciamentoDBResponseOut(boolean erogazioni, boolean fruizioni) throws DriverConfigurazioneException {
        return this.configSearchDriver.existsFaseTracciamentoDBResponseOut(erogazioni, fruizioni);
    }

    @Override
    public Configurazione getConfigurazioneGenerale() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getConfigurazioneGenerale();
    }

    public Object getConfigurazioneExtended(Configurazione config, String idExtendedConfiguration) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.configDriver.getConfigurazioneExtended(config, idExtendedConfiguration);
    }

    @Override
    public void createConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        this.configDriver.createConfigurazione(configurazione);
    }

    @Override
    public void updateConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        this.configDriver.updateConfigurazione(configurazione);
    }

    @Override
    public void deleteConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        this.configDriver.deleteConfigurazione(configurazione);
    }

    @Override
    public List<GenericProperties> getGenericProperties() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.genericPropertiesDriver.getGenericProperties();
    }

    @Override
    public List<GenericProperties> getGenericProperties(String tipologia) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.genericPropertiesDriver.getGenericProperties(tipologia);
    }

    @Override
    public GenericProperties getGenericProperties(String tipologia, String name) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.genericPropertiesDriver.getGenericProperties(tipologia, name);
    }

    public List<GenericProperties> getGenericProperties(List<String> tipologia, Integer idLista, ISearch ricerca, boolean throwNotFoundException) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.genericPropertiesDriver.getGenericProperties(tipologia, idLista, ricerca, throwNotFoundException);
    }

    public GenericProperties getGenericProperties(long idGenericProperties) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.genericPropertiesDriver.getGenericProperties(idGenericProperties);
    }

    @Override
    public void createGenericProperties(GenericProperties genericProperties) throws DriverConfigurazioneException {
        this.genericPropertiesDriver.createGenericProperties(genericProperties);
    }

    @Override
    public void updateGenericProperties(GenericProperties genericProperties) throws DriverConfigurazioneException {
        this.genericPropertiesDriver.updateGenericProperties(genericProperties);
    }

    @Override
    public void deleteGenericProperties(GenericProperties genericProperties) throws DriverConfigurazioneException {
        this.genericPropertiesDriver.deleteGenericProperties(genericProperties);
    }

    @Override
    public RegistroPlugins getRegistroPlugins() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getRegistroPlugins();
    }

    @Override
    public RegistroPlugin getRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getRegistroPlugin(nome);
    }

    @Override
    public RegistroPlugin getDatiRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getDatiRegistroPlugin(nome);
    }

    public RegistroPlugin getRegistroPlugin(Connection conParam, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getRegistroPlugin(conParam, nome);
    }

    public RegistroPlugin getDatiRegistroPlugin(Connection conParam, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getDatiRegistroPlugin(conParam, nome);
    }

    public RegistroPlugin getRegistroPluginFromPosizione(int posizione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getRegistroPluginFromPosizione(posizione);
    }

    public RegistroPlugin getDatiRegistroPluginFromPosizione(int posizione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getDatiRegistroPluginFromPosizione(posizione);
    }

    public boolean existsRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.existsRegistroPlugin(nome);
    }

    public int getMaxPosizioneRegistroPlugin() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getMaxPosizioneRegistroPlugin();
    }

    public int getNumeroArchiviJarRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getNumeroArchiviJarRegistroPlugin(nome);
    }

    @Override
    public void createRegistroPlugin(RegistroPlugin plugin) throws DriverConfigurazioneException {
        this.pluginsDriver.createRegistroPlugin(plugin);
    }

    @Override
    public void updateRegistroPlugin(RegistroPlugin plugin) throws DriverConfigurazioneException {
        this.pluginsDriver.updateRegistroPlugin(plugin);
    }

    @Override
    public void deleteRegistroPlugin(RegistroPlugin plugin) throws DriverConfigurazioneException {
        this.pluginsDriver.deleteRegistroPlugin(plugin);
    }

    @Override
    public void updateDatiRegistroPlugin(String nomePlugin, RegistroPlugin plugin) throws DriverConfigurazioneException {
        this.pluginsDriver.updateDatiRegistroPlugin(nomePlugin, plugin);
    }

    @Override
    public RegistroPluginArchivio getRegistroPluginArchivio(String nomePlugin, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.getRegistroPluginArchivio(nomePlugin, nome);
    }

    public boolean existsRegistroPluginArchivio(String nomePlugin, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.existsRegistroPluginArchivio(nomePlugin, nome);
    }

    public boolean existsRegistroPluginArchivio(String nomePlugin, PluginSorgenteArchivio tipoSorgente, String sorgente) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.pluginsDriver.existsRegistroPluginArchivio(nomePlugin, tipoSorgente, sorgente);
    }

    @Override
    public void createRegistroPluginArchivio(String nomePlugin, RegistroPluginArchivio plugin) throws DriverConfigurazioneException {
        this.pluginsDriver.createRegistroPluginArchivio(nomePlugin, plugin);
    }

    @Override
    public void updateRegistroPluginArchivio(String nomePlugin, RegistroPluginArchivio plugin) throws DriverConfigurazioneException {
        this.pluginsDriver.updateRegistroPluginArchivio(nomePlugin, plugin);
    }

    @Override
    public void deleteRegistroPluginArchivio(String nomePlugin, RegistroPluginArchivio plugin) throws DriverConfigurazioneException {
        this.pluginsDriver.deleteRegistroPluginArchivio(nomePlugin, plugin);
    }

    public List<RegistroPlugin> pluginsArchiviList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.pluginsDriver.pluginsArchiviList(ricerca);
    }

    public List<RegistroPluginArchivio> pluginsArchiviJarList(String nome, ISearch ricerca) throws DriverConfigurazioneException {
        return this.pluginsDriver.pluginsArchiviJarList(nome, ricerca);
    }

    public long countAllarmi(String tipologiaRicerca, Boolean enabled, StatoAllarme stato, Boolean acknowledged, String nomeAllarme, List<IDSoggetto> listSoggettiProprietariAbilitati, List<IDServizio> listIDServizioAbilitati, List<String> tipoSoggettiByProtocollo, List<String> tipoServiziByProtocollo, IDSoggetto idSoggettoProprietario, List<IDServizio> listIDServizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.allarmiDriver.countAllarmi(tipologiaRicerca, enabled, stato, acknowledged, nomeAllarme, listSoggettiProprietariAbilitati, listIDServizioAbilitati, tipoSoggettiByProtocollo, tipoServiziByProtocollo, idSoggettoProprietario, listIDServizio);
    }

    public List<Allarme> findAllAllarmi(String tipologiaRicerca, Boolean enabled, StatoAllarme stato, Boolean acknowledged, String nomeAllarme, List<IDSoggetto> listSoggettiProprietariAbilitati, List<IDServizio> listIDServizioAbilitati, List<String> tipoSoggettiByProtocollo, List<String> tipoServiziByProtocollo, IDSoggetto idSoggettoProprietario, List<IDServizio> listIDServizio, Integer offset, Integer limit) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.allarmiDriver.findAllAllarmi(tipologiaRicerca, enabled, stato, acknowledged, nomeAllarme, listSoggettiProprietariAbilitati, listIDServizioAbilitati, tipoSoggettiByProtocollo, tipoServiziByProtocollo, idSoggettoProprietario, listIDServizio, offset, limit);
    }

    @Override
    public void reset() throws DriverConfigurazioneException {
        this.utilsDriver.reset();
    }

    @Override
    public void reset(boolean resetConfigurazione) throws DriverConfigurazioneException {
        this.utilsDriver.reset(resetConfigurazione);
    }

    public void resetCtrlstat() throws DriverConfigurazioneException {
        this.utilsDriver.resetCtrlstat();
    }

    @Override
    public void isAlive() throws CoreException {
        this.utilsDriver.isAlive();
    }

    @Override
    public Openspcoop2 getImmagineCompletaConfigurazionePdD() throws DriverConfigurazioneException {
        Openspcoop2 openspcoop = new Openspcoop2();
        Configurazione conf = null;
        try {
            conf = this.getConfigurazioneGenerale();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (conf != null) {
            try {
                conf.setAccessoRegistro(this.getAccessoRegistro());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            try {
                conf.setAccessoConfigurazione(this.getAccessoConfigurazione());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            try {
                conf.setAccessoDatiAutorizzazione(this.getAccessoDatiAutorizzazione());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            conf.setRoutingTable(this.getRoutingTable());
            GestioneErrore compIntegrazione = null;
            try {
                compIntegrazione = this.getGestioneErroreComponenteIntegrazione();
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            GestioneErrore compCooperazione = null;
            try {
                compCooperazione = this.getGestioneErroreComponenteCooperazione();
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            if (compIntegrazione != null && compCooperazione != null) {
                ConfigurazioneGestioneErrore gee = new ConfigurazioneGestioneErrore();
                if (compIntegrazione != null) {
                    gee.setComponenteIntegrazione(compIntegrazione);
                }
                if (compCooperazione != null) {
                    gee.setComponenteCooperazione(compCooperazione);
                }
                conf.setGestioneErrore(gee);
            }
            openspcoop.setConfigurazione(conf);
        }
        List<Soggetto> soggetti = this.getAllSoggetti();
        while (!soggetti.isEmpty()) {
            Soggetto soggetto = soggetti.remove(0);
            while (soggetto.sizePortaDelegataList() > 0) {
                soggetto.removePortaDelegata(0);
            }
            while (soggetto.sizePortaApplicativaList() > 0) {
                soggetto.removePortaApplicativa(0);
            }
            while (soggetto.sizeServizioApplicativoList() > 0) {
                soggetto.removeServizioApplicativo(0);
            }
            List<PortaDelegata> pd = this.getPorteDelegateBySoggetto(soggetto.getId());
            while (!pd.isEmpty()) {
                soggetto.addPortaDelegata(pd.remove(0));
            }
            List<PortaApplicativa> pa = this.getPorteApplicativeBySoggetto(soggetto.getId());
            while (!pa.isEmpty()) {
                soggetto.addPortaApplicativa(pa.remove(0));
            }
            List<ServizioApplicativo> sa = this.getServiziApplicativiBySoggetto(soggetto.getId());
            while (!sa.isEmpty()) {
                soggetto.addServizioApplicativo(sa.remove(0));
            }
            openspcoop.addSoggetto(soggetto);
        }
        return openspcoop;
    }
}

